/*
 * Decompiled with CFR 0.152.
 */
package io.joern.ghidra2cpg;

import better.files.File$;
import ghidra.GhidraJarApplicationLayout;
import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.util.importer.AutoImporter;
import ghidra.app.util.importer.MessageLog;
import ghidra.app.util.opinion.LoadResults;
import ghidra.framework.Application;
import ghidra.framework.ApplicationConfiguration;
import ghidra.framework.HeadlessGhidraApplicationConfiguration;
import ghidra.framework.model.Project;
import ghidra.framework.model.ProjectLocator;
import ghidra.framework.project.DefaultProject;
import ghidra.framework.project.DefaultProjectManager;
import ghidra.framework.protocol.ghidra.GhidraURLConnection;
import ghidra.framework.protocol.ghidra.Handler;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Function;
import ghidra.program.model.listing.Program;
import ghidra.program.util.DefinedDataIterator;
import ghidra.program.util.GhidraProgramUtilities;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.TaskMonitor;
import io.joern.ghidra2cpg.CommandLineConfig$;
import io.joern.ghidra2cpg.Config;
import io.joern.ghidra2cpg.Types$;
import io.joern.ghidra2cpg.passes.JumpPass;
import io.joern.ghidra2cpg.passes.LiteralPass;
import io.joern.ghidra2cpg.passes.NamespacePass;
import io.joern.ghidra2cpg.passes.arm.ArmFunctionPass;
import io.joern.ghidra2cpg.passes.mips.LoHiPass;
import io.joern.ghidra2cpg.passes.mips.MipsFunctionPass;
import io.joern.ghidra2cpg.passes.x86.ReturnEdgesPass;
import io.joern.ghidra2cpg.passes.x86.X86FunctionPass;
import io.joern.ghidra2cpg.utils.Decompiler;
import io.joern.ghidra2cpg.utils.Decompiler$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgFrontend;
import io.joern.x2cpg.passes.frontend.MetaDataPass;
import io.joern.x2cpg.passes.frontend.MetaDataPass$;
import io.joern.x2cpg.passes.frontend.TypeNodePass$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import java.io.File;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Function2;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.jdk.CollectionConverters$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.Try;
import utilities.util.FileUtilities;
import utility.application.ApplicationLayout;

public class Ghidra2Cpg
implements X2CpgFrontend<Config> {
    public Try<Cpg> createCpg(Config config) {
        File inputFile = new File(config.inputPath());
        if (!inputFile.isDirectory() && !inputFile.isFile()) {
            throw new InvalidInputException(inputFile + " is not a valid directory or file.");
        }
        return X2Cpg$.MODULE$.withNewEmptyCpg(config.outputPath(), (X2CpgConfig)config, (Function2)(JProcedure2 & Serializable)(cpg, _$1) -> File$.MODULE$.usingTemporaryDirectory("ghidra2cpg_tmp", File$.MODULE$.usingTemporaryDirectory$default$2(), File$.MODULE$.usingTemporaryDirectory$default$3(), (Function1)(JProcedure1 & Serializable)tempWorkingDir -> {
            this.initGhidra();
            ProjectLocator locator = new ProjectLocator(tempWorkingDir.path().toAbsolutePath().toString(), CommandLineConfig$.MODULE$.projectName());
            Program program = null;
            Project project = null;
            try {
                try {
                    HeadlessGhidraProjectManager projectManager = new HeadlessGhidraProjectManager();
                    project = projectManager.createProject(locator, null, false);
                    LoadResults programResults = AutoImporter.importByUsingBestGuess((File)inputFile, null, (String)tempWorkingDir.path().toAbsolutePath().toString(), (Object)this, (MessageLog)new MessageLog(), (TaskMonitor)TaskMonitor.DUMMY);
                    if (programResults != null && programResults.size() > 0) {
                        program = (Program)programResults.getPrimary().getDomainObject();
                        this.addProgramToCpg(program, inputFile.getCanonicalPath(), (Cpg)cpg);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            finally {
                if (program != null) {
                    AutoAnalysisManager.getAnalysisManager(program).dispose();
                    program.release((Object)this);
                }
                project.close();
                FileUtilities.deleteDir((File)locator.getProjectDir());
                locator.getMarkerFile().delete();
            }
        }));
    }

    private void initGhidra() {
        Handler.registerHandler();
        if (!Application.isInitialized()) {
            HeadlessGhidraApplicationConfiguration configuration = new HeadlessGhidraApplicationConfiguration();
            configuration.setInitializeLogging(false);
            Application.initializeApplication((ApplicationLayout)new GhidraJarApplicationLayout(), (ApplicationConfiguration)configuration);
            return;
        }
    }

    private void addProgramToCpg(Program program, String fileAbsolutePath, Cpg cpg) {
        AutoAnalysisManager autoAnalysisManager = AutoAnalysisManager.getAnalysisManager((Program)program);
        int transactionId = program.startTransaction("Analysis");
        try {
            try {
                autoAnalysisManager.initializeOptions();
                autoAnalysisManager.reAnalyzeAll(null);
                autoAnalysisManager.startAnalysis(TaskMonitor.DUMMY);
                GhidraProgramUtilities.markProgramAnalyzed((Program)program);
                this.handleProgram(program, fileAbsolutePath, cpg);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        finally {
            program.endTransaction(transactionId, true);
        }
    }

    /*
     * Unable to fully structure code
     */
    public void handleProgram(Program program, String fileAbsolutePath, Cpg cpg) {
        block5: {
            flatProgramAPI = new FlatProgramAPI(program);
            decompiler = (Decompiler)Decompiler$.MODULE$.apply(program).get();
            listing = program.getListing();
            functionIterator = listing.getFunctions(true);
            functions = CollectionConverters$.MODULE$.IteratorHasAsScala(functionIterator.iterator()).asScala().toList();
            address2Literals = CollectionConverters$.MODULE$.IteratorHasAsScala(DefinedDataIterator.definedStrings((Program)program).iterator()).asScala().toList().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(ghidra.program.model.listing.Data ), (Lghidra/program/model/listing/Data;)Lscala/Tuple2;)()).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            new MetaDataPass(cpg, "GHIDRA", fileAbsolutePath, MetaDataPass$.MODULE$.$lessinit$greater$default$4()).createAndApply();
            Option$.MODULE$.apply((Object)flatProgramAPI.getProgramFile()).foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, handleProgram$$anonfun$1(io.shiftleft.codepropertygraph.generated.Cpg java.io.File ), (Ljava/io/File;)V)((Cpg)cpg));
            var10_10 = program.getLanguage().getLanguageDescription().getProcessor().toString();
            switch (var10_10 == null ? 0 : var10_10.hashCode()) {
                case -503112427: {
                    if ("AARCH64".equals(var10_10)) break;
                    ** break;
                }
                case 65084: {
                    if ("ARM".equals(var10_10)) break;
                    ** break;
                }
                case 2366623: {
                    if (!"MIPS".equals(var10_10)) ** break;
                    new MipsFunctionPass(program, (Map<Object, String>)address2Literals, fileAbsolutePath, (List<Function>)functions, cpg, decompiler).createAndApply();
                    new LoHiPass(cpg).createAndApply();
                    break block5;
                }
            }
            new ArmFunctionPass(program, fileAbsolutePath, (List<Function>)functions, cpg, decompiler).createAndApply();
            break block5;
lbl24:
            // 4 sources

            new X86FunctionPass(program, fileAbsolutePath, (List<Function>)functions, cpg, decompiler).createAndApply();
            new ReturnEdgesPass(cpg).createAndApply();
        }
        TypeNodePass$.MODULE$.withRegisteredTypes(Types$.MODULE$.types().toList(), cpg).createAndApply();
        new JumpPass(cpg).createAndApply();
        new LiteralPass(cpg, flatProgramAPI).createAndApply();
    }

    private static final /* synthetic */ Tuple2 $anonfun$1(Data x) {
        Long l = (Long)Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)x.getAddress().getOffset()));
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)l, (Object)x.getValue().toString());
    }

    private static final /* synthetic */ void handleProgram$$anonfun$1(Cpg cpg$2, File programFile) {
        new NamespacePass(cpg$2, programFile).createAndApply();
    }

    public class HeadlessGhidraProjectManager
    extends DefaultProjectManager {
    }

    public class HeadlessProjectConnection
    extends DefaultProject {
        public HeadlessProjectConnection(HeadlessGhidraProjectManager projectManager, GhidraURLConnection connection) {
            super((DefaultProjectManager)projectManager, connection);
        }
    }
}

