/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.jartypereader;

import io.joern.javasrc2cpg.jartypereader.descriptorparser.DescriptorParser$;
import io.joern.javasrc2cpg.jartypereader.model.ClassSignature;
import io.joern.javasrc2cpg.jartypereader.model.ClassTypeSignature;
import io.joern.javasrc2cpg.jartypereader.model.MethodSignature;
import io.joern.javasrc2cpg.jartypereader.model.NameWithTypeArgs;
import io.joern.javasrc2cpg.jartypereader.model.ReferenceTypeSignature;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedMethod;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedTypeDecl;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedTypeDecl$;
import io.joern.javasrc2cpg.jartypereader.model.ResolvedVariableType;
import io.joern.javasrc2cpg.jartypereader.model.TypeArgument;
import io.joern.javasrc2cpg.jartypereader.model.TypeParameter;
import java.io.Serializable;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.ClassFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public final class JarTypeReader$ {
    public static final JarTypeReader$ MODULE$ = new JarTypeReader$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final ClassTypeSignature ObjectTypeSignature;

    static {
        Some packageSpecifier = new Some((Object)"java.lang");
        NameWithTypeArgs signature = new NameWithTypeArgs("Object", (List<TypeArgument>)package$.MODULE$.Nil());
        ObjectTypeSignature = new ClassTypeSignature((Option<String>)packageSpecifier, signature, (List<NameWithTypeArgs>)package$.MODULE$.Nil());
    }

    private Logger logger() {
        return logger;
    }

    public ClassTypeSignature ObjectTypeSignature() {
        return ObjectTypeSignature;
    }

    public List<ResolvedTypeDecl> getTypes(String jarPath) {
        ClassPool cp = new ClassPool();
        cp.insertClassPath(jarPath);
        JarFile jarFile = new JarFile(jarPath);
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(jarFile.entries()).asScala().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)JarTypeReader$.$anonfun$getTypes$1(x$1))).map((Function1 & Serializable)entry -> StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(entry.getRealName().replace("/", ".")), 6)).flatMap((Function1 & Serializable)x$2 -> MODULE$.getTypeDeclForEntry(cp, (String)x$2)).toList();
    }

    public ResolvedMethod getTypeEntryForMethod(CtMethod method, ResolvedTypeDecl parentDecl) {
        String name = method.getName();
        String signatureDescriptor = (String)Option$.MODULE$.apply((Object)method.getGenericSignature()).getOrElse((Function0 & Serializable)() -> method.getSignature());
        MethodSignature signature = DescriptorParser$.MODULE$.parseMethodSignature(signatureDescriptor);
        boolean isAbstract = method.isEmpty();
        return new ResolvedMethod(name, parentDecl, signature, isAbstract);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private ClassTypeSignature classTypeSignatureFromString(String signature) {
        List list = Predef$.MODULE$.wrapRefArray((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(signature), '.')).toList();
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            this.logger().warn(new StringBuilder(31).append(signature).append(" is not a valid class signature").toString());
            return new ClassTypeSignature((Option<String>)None$.MODULE$, new NameWithTypeArgs("", (List<TypeArgument>)package$.MODULE$.Nil()), (List<NameWithTypeArgs>)package$.MODULE$.Nil());
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            String name = (String)colon2.head();
            List list3 = colon2.next$access$1();
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (nil$2 == null) {
                if (list4 == null) return new ClassTypeSignature((Option<String>)None$.MODULE$, new NameWithTypeArgs(name, (List<TypeArgument>)package$.MODULE$.Nil()), (List<NameWithTypeArgs>)package$.MODULE$.Nil());
            } else if (nil$2.equals(list4)) {
                return new ClassTypeSignature((Option<String>)None$.MODULE$, new NameWithTypeArgs(name, (List<TypeArgument>)package$.MODULE$.Nil()), (List<NameWithTypeArgs>)package$.MODULE$.Nil());
            }
        }
        String packagePrefix = ((IterableOnceOps)list.init()).mkString(".");
        String name = (String)list.last();
        return new ClassTypeSignature((Option<String>)new Some((Object)packagePrefix), new NameWithTypeArgs(name, (List<TypeArgument>)package$.MODULE$.Nil()), (List<NameWithTypeArgs>)package$.MODULE$.Nil());
    }

    private ClassSignature getCtClassSignature(CtClass ctClass) {
        ClassFile classFile = ctClass.getClassFile2();
        Nil$ typeParameters = package$.MODULE$.Nil();
        Option superclassSignature = Option$.MODULE$.unless(classFile.isInterface(), (Function0 & Serializable)() -> MODULE$.classTypeSignatureFromString(classFile.getSuperclass()));
        List interfacesSignatures = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])classFile.getInterfaces()), (Function1 & Serializable)signature -> MODULE$.classTypeSignatureFromString((String)signature), ClassTag$.MODULE$.apply(ClassTypeSignature.class))).toList();
        return new ClassSignature((List<TypeParameter>)typeParameters, (Option<ClassTypeSignature>)superclassSignature, (List<ClassTypeSignature>)interfacesSignatures);
    }

    private ResolvedVariableType getResolvedField(CtField ctField) {
        String name = ctField.getName();
        String signatureDescriptor = (String)Option$.MODULE$.apply((Object)ctField.getGenericSignature()).getOrElse((Function0 & Serializable)() -> ctField.getSignature());
        ReferenceTypeSignature signature = DescriptorParser$.MODULE$.parseFieldSignature(signatureDescriptor);
        return new ResolvedVariableType(name, signature);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<ResolvedTypeDecl> getTypeDeclForEntry(ClassPool cp, String name) {
        boolean bl = false;
        Failure failure = null;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> cp.get(name));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            CtClass ctClass = (CtClass)success.value();
            String name2 = ctClass.getSimpleName();
            String packageSpecifier = ctClass.getPackageName();
            ClassSignature signature = (ClassSignature)Option$.MODULE$.apply((Object)ctClass.getGenericSignature()).map((Function1 & Serializable)descriptor -> DescriptorParser$.MODULE$.parseClassSignature((String)descriptor)).getOrElse((Function0 & Serializable)() -> MODULE$.getCtClassSignature(ctClass));
            boolean isInterface = ctClass.isInterface();
            boolean isAbstract = !isInterface && ctClass.getClassFile2().isAbstract();
            List fields = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ctClass.getFields()), (Function1 & Serializable)ctField -> MODULE$.getResolvedField((CtField)ctField), ClassTag$.MODULE$.apply(ResolvedVariableType.class))).toList();
            ResolvedTypeDecl typeDecl = ResolvedTypeDecl$.MODULE$.apply(name2, (Option<String>)new Some((Object)packageSpecifier), signature, isInterface, isAbstract, (List<ResolvedVariableType>)fields, ResolvedTypeDecl$.MODULE$.apply$default$7());
            List methods = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])ctClass.getMethods()), (Function1 & Serializable)x$3 -> MODULE$.getTypeEntryForMethod((CtMethod)x$3, typeDecl), ClassTag$.MODULE$.apply(ResolvedMethod.class))).toList();
            typeDecl.addMethods((List<ResolvedMethod>)methods);
            return new Some((Object)typeDecl);
        }
        if (try_ instanceof Failure) {
            bl = true;
            failure = (Failure)try_;
            if (failure.exception() instanceof NotFoundException) {
                return None$.MODULE$;
            }
        }
        if (!bl) throw new MatchError((Object)try_);
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$getTypes$1(JarEntry x$1) {
        return x$1.getName().endsWith(".class");
    }

    private JarTypeReader$() {
    }
}

