/*
 * Decompiled with CFR 0.152.
 */
package io.joern.javasrc2cpg.typesolvers;

import com.github.javaparser.resolution.TypeSolver;
import com.github.javaparser.resolution.UnsolvedSymbolException;
import com.github.javaparser.resolution.declarations.ResolvedReferenceTypeDeclaration;
import com.github.javaparser.resolution.model.SymbolReference;
import com.github.javaparser.symbolsolver.cache.GuavaCache;
import com.google.common.cache.CacheBuilder;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Some;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.jdk.OptionConverters;
import scala.jdk.OptionConverters$;
import scala.runtime.ScalaRunTime$;

public class SimpleCombinedTypeSolver
implements TypeSolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private TypeSolver parent;
    private final ArrayBuffer<TypeSolver> cachingTypeSolvers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeSolver[0]));
    private final ArrayBuffer<TypeSolver> nonCachingTypeSolvers = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TypeSolver[0]));
    private final GuavaCache<String, SymbolReference<ResolvedReferenceTypeDeclaration>> typeCache = new GuavaCache(CacheBuilder.newBuilder().build());

    public void addCachingTypeSolver(TypeSolver typeSolver) {
        this.cachingTypeSolvers.append((Object)typeSolver);
        typeSolver.setParent((TypeSolver)this);
    }

    public void addNonCachingTypeSolver(TypeSolver typeSolver) {
        this.nonCachingTypeSolvers.prepend((Object)typeSolver);
        typeSolver.setParent((TypeSolver)this);
    }

    public SymbolReference<ResolvedReferenceTypeDeclaration> tryToSolveType(String name) {
        Optional optional = OptionConverters$.MODULE$.RichOptional(this.typeCache.get((Object)name));
        Option option = OptionConverters.RichOptional$.MODULE$.toScala$extension(optional);
        if (option instanceof Some) {
            SymbolReference result = (SymbolReference)((Some)option).value();
            return result;
        }
        if (None$.MODULE$.equals(option)) {
            return (SymbolReference)this.findSolvedTypeWithSolvers(this.cachingTypeSolvers, name).getOrElse(() -> this.tryToSolveType$$anonfun$1(name));
        }
        throw new MatchError((Object)option);
    }

    private Option<SymbolReference<ResolvedReferenceTypeDeclaration>> findSolvedTypeWithSolvers(ArrayBuffer<TypeSolver> typeSolvers, String className) {
        return typeSolvers.iterator().map((Function1 & Serializable)typeSolver -> {
            None$ none$;
            try {
                SymbolReference result = typeSolver.tryToSolveType(className);
                none$ = Option$.MODULE$.when(result.isSolved(), () -> SimpleCombinedTypeSolver.findSolvedTypeWithSolvers$$anonfun$1$$anonfun$1(result));
            }
            catch (UnsolvedSymbolException unsolvedSymbolException) {
                none$ = None$.MODULE$;
            }
            catch (StackOverflowError stackOverflowError) {
                none$ = None$.MODULE$;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                none$ = None$.MODULE$;
            }
            catch (Throwable unhandled) {
                this.logger.warn("Caught unhandled exception", unhandled);
                none$ = None$.MODULE$;
            }
            return none$;
        }).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Option x) {
                Option option = x;
                if (option instanceof Some) {
                    SymbolReference symbolReference = (SymbolReference)((Some)option).value();
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Option x, Function1 function1) {
                Option option = x;
                if (option instanceof Some) {
                    SymbolReference symbolReference = (SymbolReference)((Some)option).value();
                    return symbolReference;
                }
                return function1.apply((Object)x);
            }
        });
    }

    public ResolvedReferenceTypeDeclaration solveType(String name) {
        SymbolReference<ResolvedReferenceTypeDeclaration> result = this.tryToSolveType(name);
        if (result.isSolved()) {
            return (ResolvedReferenceTypeDeclaration)result.getCorrespondingDeclaration();
        }
        throw new UnsolvedSymbolException(name);
    }

    public TypeSolver getParent() {
        return this.parent;
    }

    public void setParent(TypeSolver parent) {
        if (parent == null) {
            this.logger.warn("Cannot set parent of type solver to null. setParent will be ignored.");
            return;
        }
        if (this.parent != null) {
            this.logger.warn("Attempting to re-set type solver parent. setParent will be ignored.");
            return;
        }
        TypeSolver typeSolver = parent;
        SimpleCombinedTypeSolver simpleCombinedTypeSolver = this;
        if (!(typeSolver != null ? !typeSolver.equals(simpleCombinedTypeSolver) : simpleCombinedTypeSolver != null)) {
            this.logger.warn("Parent of TypeSolver cannot be itself. setParent will be ignored.");
            return;
        }
        this.parent = parent;
    }

    private static final SymbolReference $anonfun$1() {
        return SymbolReference.unsolved();
    }

    private final SymbolReference tryToSolveType$$anonfun$1(String name$1) {
        SymbolReference result = (SymbolReference)this.findSolvedTypeWithSolvers(this.nonCachingTypeSolvers, name$1).getOrElse(SimpleCombinedTypeSolver::$anonfun$1);
        this.typeCache.put((Object)name$1, (Object)result);
        return result;
    }

    private static final SymbolReference findSolvedTypeWithSolvers$$anonfun$1$$anonfun$1(SymbolReference result$1) {
        return result$1;
    }
}

