/*
 * Decompiled with CFR 0.152.
 */
package io.joern.joerncli;

import better.files.Dsl$;
import better.files.File$;
import io.joern.dataflowengineoss.DefaultSemantics$;
import io.joern.dataflowengineoss.layers.dataflows.Cpg14DumpOptions;
import io.joern.dataflowengineoss.layers.dataflows.DdgDumpOptions;
import io.joern.dataflowengineoss.layers.dataflows.DumpCpg14;
import io.joern.dataflowengineoss.layers.dataflows.DumpCpg14$;
import io.joern.dataflowengineoss.layers.dataflows.DumpDdg;
import io.joern.dataflowengineoss.layers.dataflows.DumpDdg$;
import io.joern.dataflowengineoss.layers.dataflows.DumpPdg;
import io.joern.dataflowengineoss.layers.dataflows.DumpPdg$;
import io.joern.dataflowengineoss.layers.dataflows.PdgDumpOptions;
import io.joern.dataflowengineoss.semanticsloader.Semantics;
import io.joern.joerncli.CpgBasedTool$;
import io.joern.joerncli.JoernExport;
import io.joern.joerncli.JoernExport$Config$;
import io.joern.joerncli.JoernExport$Format$;
import io.joern.joerncli.JoernExport$Representation$;
import io.joern.x2cpg.layers.AstDumpOptions;
import io.joern.x2cpg.layers.CdgDumpOptions;
import io.joern.x2cpg.layers.CfgDumpOptions;
import io.joern.x2cpg.layers.DumpAst;
import io.joern.x2cpg.layers.DumpCdg;
import io.joern.x2cpg.layers.DumpCfg;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.AstNode;
import io.shiftleft.semanticcpg.language.nodemethods.AstNodeMethods$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Path;
import java.nio.file.Paths;
import overflowdb.Node;
import overflowdb.formats.ExportResult;
import overflowdb.formats.Exporter;
import overflowdb.formats.dot.DotExporter$;
import overflowdb.formats.graphml.GraphMLExporter$;
import overflowdb.formats.graphson.GraphSONExporter$;
import overflowdb.formats.neo4jcsv.Neo4jCsvExporter$;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.NotImplementedError;
import scala.Option;
import scala.Predef$;
import scala.Tuple3;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.math.Ordering;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ScalaRunTime$;
import scala.util.Properties$;
import scala.util.Using;
import scala.util.Using$;
import scopt.OptionParser;
import scopt.Read$;

public final class JoernExport$ {
    public static final JoernExport$ MODULE$ = new JoernExport$();

    public void main(String[] args) {
        this.parseConfig(args).foreach((Function1 & Serializable)config -> {
            JoernExport$.$anonfun$main$1(config);
            return BoxedUnit.UNIT;
        });
    }

    private Option<JoernExport.Config> parseConfig(String[] args) {
        return new OptionParser<JoernExport.Config>(){
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Dump intermediate graph representations (or entire graph) of code in a given export format"}));
                this.help("help");
                this.arg("cpg", Read$.MODULE$.stringRead()).text("input CPG file name - defaults to `cpg.bin`").optional().action((Function2 & Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4()));
                this.opt('o', "out", Read$.MODULE$.stringRead()).text("output directory - will be created and must not yet exist").action((Function2 & Serializable)(x, c) -> {
                    String x$1 = x;
                    String x$2 = c.copy$default$1();
                    Enumeration.Value x$3 = c.copy$default$3();
                    Enumeration.Value x$4 = c.copy$default$4();
                    return c.copy(x$2, x$1, x$3, x$4);
                });
                this.opt("repr", Read$.MODULE$.stringRead()).text(new StringBuilder(46).append("representation to extract: [").append(((IterableOnceOps)((SeqOps)JoernExport$Representation$.MODULE$.values().toSeq().map((Function1 & Serializable)x$1 -> x$1.toString().toLowerCase())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("|")).append("] - defaults to `").append(JoernExport$Representation$.MODULE$.Cpg14()).append("`").toString()).action((Function2 & Serializable)(x, c) -> {
                    Enumeration.Value x$5 = JoernExport$Representation$.MODULE$.withNameIgnoreCase((String)x);
                    String x$6 = c.copy$default$1();
                    String x$7 = c.copy$default$2();
                    Enumeration.Value x$8 = c.copy$default$4();
                    return c.copy(x$6, x$7, x$5, x$8);
                });
                this.opt("format", Read$.MODULE$.stringRead()).action((Function2 & Serializable)(x, c) -> {
                    Enumeration.Value x$9 = JoernExport$Format$.MODULE$.withNameIgnoreCase((String)x);
                    String x$10 = c.copy$default$1();
                    String x$11 = c.copy$default$2();
                    Enumeration.Value x$12 = c.copy$default$3();
                    return c.copy(x$10, x$11, x$12, x$9);
                }).text(new StringBuilder(41).append("export format, one of [").append(((IterableOnceOps)((SeqOps)JoernExport$Format$.MODULE$.values().toSeq().map((Function1 & Serializable)x$2 -> x$2.toString().toLowerCase())).sorted((Ordering)Ordering.String$.MODULE$)).mkString("|")).append("] - defaults to `").append(JoernExport$Format$.MODULE$.Dot()).append("`").toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String io.joern.joerncli.JoernExport$Config ), $anonfun$new$2(java.lang.String io.joern.joerncli.JoernExport$Config ), $anonfun$new$3(scala.Enumeration$Value ), $anonfun$new$4(java.lang.String io.joern.joerncli.JoernExport$Config ), $anonfun$new$5(java.lang.String io.joern.joerncli.JoernExport$Config ), $anonfun$new$6(scala.Enumeration$Value )}, serializedLambda);
            }
        }.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)new JoernExport.Config(JoernExport$Config$.MODULE$.apply$default$1(), JoernExport$Config$.MODULE$.apply$default$2(), JoernExport$Config$.MODULE$.apply$default$3(), JoernExport$Config$.MODULE$.apply$default$4()));
    }

    /*
     * Enabled aggressive block sorting
     */
    public void exportCpg(Cpg cpg, Enumeration.Value representation, Enumeration.Value format, Path outDir) {
        Enumeration.Value value;
        boolean bl;
        LayerCreatorContext context;
        block11: {
            block12: {
                Semantics semantics = DefaultSemantics$.MODULE$.apply();
                if (semantics.elements().isEmpty()) {
                    System.err.println("Warning: semantics are empty.");
                }
                CpgBasedTool$.MODULE$.addDataFlowOverlayIfNonExistent(cpg, semantics);
                context = new LayerCreatorContext(cpg, LayerCreatorContext$.MODULE$.$lessinit$greater$default$2());
                bl = false;
                Enumeration.Value value2 = null;
                value = format;
                Enumeration.Value value3 = JoernExport$Format$.MODULE$.Dot();
                Enumeration.Value value4 = value;
                if (value3 != null ? !value3.equals(value4) : value4 != null) break block11;
                bl = true;
                value2 = value;
                Enumeration.Value value5 = representation;
                Enumeration.Value value6 = JoernExport$Representation$.MODULE$.All();
                if (!(value5 == null ? value6 != null : !value5.equals(value6))) break block12;
                Enumeration.Value value7 = representation;
                Enumeration.Value value8 = JoernExport$Representation$.MODULE$.Cpg();
                if (value7 != null ? !value7.equals(value8) : value8 != null) break block11;
            }
            this.exportWithOdbFormat(cpg, representation, outDir, (Exporter)DotExporter$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        if (bl) {
            this.exportDot(representation, outDir, context);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Enumeration.Value value9 = JoernExport$Format$.MODULE$.Neo4jCsv();
        Enumeration.Value value10 = value;
        if (!(value9 != null ? !value9.equals(value10) : value10 != null)) {
            this.exportWithOdbFormat(cpg, representation, outDir, (Exporter)Neo4jCsvExporter$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Enumeration.Value value11 = JoernExport$Format$.MODULE$.Graphml();
        Enumeration.Value value12 = value;
        if (!(value11 != null ? !value11.equals(value12) : value12 != null)) {
            this.exportWithOdbFormat(cpg, representation, outDir, (Exporter)GraphMLExporter$.MODULE$);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
            return;
        }
        Enumeration.Value value13 = JoernExport$Format$.MODULE$.Graphson();
        Enumeration.Value value14 = value;
        if (value13 == null) {
            if (value14 != null) {
                throw new NotImplementedError(new StringBuilder(35).append("repr=").append(representation).append(" not yet supported for format=").append(format).toString());
            }
        } else if (!value13.equals(value14)) throw new NotImplementedError(new StringBuilder(35).append("repr=").append(representation).append(" not yet supported for format=").append(format).toString());
        this.exportWithOdbFormat(cpg, representation, outDir, (Exporter)GraphSONExporter$.MODULE$);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    private void exportDot(Enumeration.Value repr, Path outDir, LayerCreatorContext context) {
        String outDirStr = ((Object)outDir).toString();
        Enumeration.Value value = repr;
        Enumeration.Value value2 = JoernExport$Representation$.MODULE$.Ast();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            DumpAst qual$1 = new DumpAst(new AstDumpOptions(outDirStr));
            LayerCreatorContext x$1 = context;
            boolean x$2 = qual$1.create$default$2();
            qual$1.create(x$1, x$2);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            Enumeration.Value value4 = JoernExport$Representation$.MODULE$.Cfg();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                DumpCfg qual$2 = new DumpCfg(new CfgDumpOptions(outDirStr));
                LayerCreatorContext x$3 = context;
                boolean x$4 = qual$2.create$default$2();
                qual$2.create(x$3, x$4);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                Enumeration.Value value6 = JoernExport$Representation$.MODULE$.Ddg();
                Enumeration.Value value7 = value;
                if (!(value6 != null ? !value6.equals(value7) : value7 != null)) {
                    DdgDumpOptions x$5 = new DdgDumpOptions(outDirStr);
                    Semantics x$6 = DumpDdg$.MODULE$.$lessinit$greater$default$2(x$5);
                    DumpDdg qual$3 = new DumpDdg(x$5, x$6);
                    LayerCreatorContext x$7 = context;
                    boolean x$8 = qual$3.create$default$2();
                    qual$3.create(x$7, x$8);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    Enumeration.Value value8 = JoernExport$Representation$.MODULE$.Cdg();
                    Enumeration.Value value9 = value;
                    if (!(value8 != null ? !value8.equals(value9) : value9 != null)) {
                        DumpCdg qual$4 = new DumpCdg(new CdgDumpOptions(outDirStr));
                        LayerCreatorContext x$9 = context;
                        boolean x$10 = qual$4.create$default$2();
                        qual$4.create(x$9, x$10);
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Enumeration.Value value10 = JoernExport$Representation$.MODULE$.Pdg();
                        Enumeration.Value value11 = value;
                        if (!(value10 != null ? !value10.equals(value11) : value11 != null)) {
                            PdgDumpOptions x$11 = new PdgDumpOptions(outDirStr);
                            Semantics x$12 = DumpPdg$.MODULE$.$lessinit$greater$default$2(x$11);
                            DumpPdg qual$5 = new DumpPdg(x$11, x$12);
                            LayerCreatorContext x$13 = context;
                            boolean x$14 = qual$5.create$default$2();
                            qual$5.create(x$13, x$14);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Enumeration.Value value12 = JoernExport$Representation$.MODULE$.Cpg14();
                            Enumeration.Value value13 = value;
                            if (!(value12 != null ? !value12.equals(value13) : value13 != null)) {
                                Cpg14DumpOptions x$15 = new Cpg14DumpOptions(outDirStr);
                                Semantics x$16 = DumpCpg14$.MODULE$.$lessinit$greater$default$2(x$15);
                                DumpCpg14 qual$6 = new DumpCpg14(x$15, x$16);
                                LayerCreatorContext x$17 = context;
                                boolean x$18 = qual$6.create$default$2();
                                qual$6.create(x$17, x$18);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                throw new NotImplementedError(new StringBuilder(39).append("repr=").append(repr).append(" not yet supported for this format").toString());
                            }
                        }
                    }
                }
            }
        }
    }

    private void exportWithOdbFormat(Cpg cpg, Enumeration.Value repr, Path outDir, Exporter exporter) {
        ExportResult exportResult;
        Enumeration.Value value = repr;
        Enumeration.Value value2 = JoernExport$Representation$.MODULE$.All();
        Enumeration.Value value3 = value;
        if (!(value2 != null ? !value2.equals(value3) : value3 != null)) {
            exportResult = exporter.runExport(cpg.graph(), outDir);
        } else {
            Enumeration.Value value4 = JoernExport$Representation$.MODULE$.Cpg();
            Enumeration.Value value5 = value;
            if (!(value4 != null ? !value4.equals(value5) : value5 != null)) {
                Set windowsFilenameDeduplicationHelper = (Set)Set$.MODULE$.empty();
                exportResult = (ExportResult)this.splitByMethod(cpg).iterator().map((Function1 & Serializable)x0$1 -> {
                    JoernExport.MethodSubGraph methodSubGraph = x0$1;
                    if (methodSubGraph == null) {
                        throw new MatchError((Object)methodSubGraph);
                    }
                    String methodName = methodSubGraph.methodName();
                    String methodFilename = methodSubGraph.methodFilename();
                    scala.collection.immutable.Set<Node> nodes = methodSubGraph.nodes();
                    String relativeFilename = MODULE$.sanitizedFileName(methodName, methodFilename, exporter.defaultFileExtension(), (Set<String>)windowsFilenameDeduplicationHelper);
                    Path outFileName = outDir.resolve(relativeFilename);
                    ExportResult exportResult = exporter.runExport(nodes, methodSubGraph.edges(), outFileName);
                    return exportResult;
                }).reduce((Function2 & Serializable)(resultA, resultB) -> MODULE$.plus((ExportResult)resultA, (ExportResult)resultB));
            } else {
                throw new NotImplementedError(new StringBuilder(39).append("repr=").append(repr).append(" not yet supported for this format").toString());
            }
        }
        ExportResult exportResult2 = exportResult;
        if (exportResult2 == null) {
            throw new MatchError((Object)exportResult2);
        }
        int nodeCount = exportResult2.nodeCount();
        int edgeCount = exportResult2.edgeCount();
        Option additionalInfo = exportResult2.additionalInfo();
        Tuple3 tuple3 = new Tuple3((Object)BoxesRunTime.boxToInteger((int)nodeCount), (Object)BoxesRunTime.boxToInteger((int)edgeCount), (Object)additionalInfo);
        Tuple3 tuple32 = tuple3;
        int nodeCount2 = BoxesRunTime.unboxToInt((Object)tuple32._1());
        int edgeCount2 = BoxesRunTime.unboxToInt((Object)tuple32._2());
        Option additionalInfo2 = (Option)tuple32._3();
        Predef$.MODULE$.println((Object)new StringBuilder(29).append("exported ").append(nodeCount2).append(" nodes, ").append(edgeCount2).append(" edges into ").append(outDir).toString());
        additionalInfo2.foreach((Function1 & Serializable)x -> {
            Predef$.MODULE$.println(x);
            return BoxedUnit.UNIT;
        });
    }

    private IterableOnce<JoernExport.MethodSubGraph> splitByMethod(Cpg cpg) {
        return package$.MODULE$.toNodeTypeStarters(cpg).method().map((Function1 & Serializable)method -> new JoernExport.MethodSubGraph(method.name(), method.filename(), (scala.collection.immutable.Set<Node>)AstNodeMethods$.MODULE$.ast$extension(package$.MODULE$.toAstNodeMethods((AstNode)method)).toSet()));
    }

    private String sanitizedFileName(String methodName, String methodFilename, String fileExtension, Set<String> windowsFilenameDeduplicationHelper) {
        String string;
        String sanitizedMethodName = methodName.replaceAll("[^a-zA-Z0-9-_\\.]", "_");
        if (Properties$.MODULE$.isWin()) {
            if (windowsFilenameDeduplicationHelper.contains((Object)sanitizedMethodName)) {
                string = this.sanitizedFileName(new StringBuilder(1).append(methodName).append("_").toString(), methodFilename, fileExtension, windowsFilenameDeduplicationHelper);
            } else {
                windowsFilenameDeduplicationHelper.add((Object)sanitizedMethodName);
                string = sanitizedMethodName;
            }
        } else {
            String sanitizedPath = methodFilename.startsWith("/") ? new StringBuilder(7).append("_root_/").append(methodFilename).toString() : methodFilename;
            string = new StringBuilder(1).append(sanitizedPath).append("/").append(sanitizedMethodName).toString();
        }
        String sanitizedFilename = string;
        return new StringBuilder(1).append(sanitizedFilename).append(".").append(fileExtension).toString();
    }

    private ExportResult plus(ExportResult resultA, ExportResult resultB) {
        return new ExportResult(resultA.nodeCount() + resultB.nodeCount(), resultA.edgeCount() + resultB.edgeCount(), (scala.collection.immutable.Seq)resultA.files().$plus$plus((IterableOnce)resultB.files()), resultA.additionalInfo());
    }

    public static final /* synthetic */ void $anonfun$main$1(JoernExport.Config config) {
        String outDir = config.outDir();
        CpgBasedTool$.MODULE$.exitIfInvalid(outDir, config.cpgFileName());
        Dsl$.MODULE$.mkdir(File$.MODULE$.apply(outDir, (scala.collection.immutable.Seq)Nil$.MODULE$));
        Using$.MODULE$.resource((Object)CpgBasedTool$.MODULE$.loadFromOdb(config.cpgFileName()), (Function1 & Serializable)cpg -> {
            JoernExport$.MODULE$.exportCpg(cpg, config.repr(), config.format(), Paths.get(outDir, new String[0]).toAbsolutePath());
            return BoxedUnit.UNIT;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private JoernExport$() {
    }
}

