/*
 * Decompiled with CFR 0.152.
 */
package io.joern.joerncli;

import better.files.File;
import better.files.File$;
import io.joern.console.FrontendConfig$;
import io.joern.console.InstallConfig;
import io.joern.console.InstallConfig$;
import io.joern.console.cpgcreation.CpgGenerator;
import io.joern.joerncli.CpgBasedTool$;
import io.joern.joerncli.DefaultOverlays$;
import io.joern.joerncli.JoernParse;
import io.joern.joerncli.JoernParse$;
import io.joern.joerncli.JoernParse$ParserConfig$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.Languages;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.PartialFunction;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.StringBuilder;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scopt.OptionParser;
import scopt.Read$;

public final class JoernParse$ {
    public static final JoernParse$ MODULE$ = new JoernParse$();
    private static final String ArgsDelimitor = "--frontend-args";
    private static final String DefaultCpgOutFile = "cpg.bin";
    private static CpgGenerator generator;
    private static final OptionParser<JoernParse.ParserConfig> optionParser;

    static {
        optionParser = new OptionParser<JoernParse.ParserConfig>(){

            public static final /* synthetic */ JoernParse.ParserConfig $anonfun$new$9(int x, JoernParse.ParserConfig c) {
                int x$49 = x;
                String x$50 = c.copy$default$1();
                String x$51 = c.copy$default$2();
                scala.collection.immutable.Seq<String> x$52 = c.copy$default$3();
                boolean x$53 = c.copy$default$4();
                boolean x$54 = c.copy$default$5();
                String x$55 = c.copy$default$6();
                boolean x$56 = c.copy$default$7();
                return c.copy(x$50, x$51, x$52, x$53, x$54, x$55, x$56, x$49);
            }
            {
                this.arg("input", Read$.MODULE$.stringRead()).optional().text("source file or directory containing source files").action((Function2 & Serializable)(x, c) -> c.copy((String)x, c.copy$default$2(), c.copy$default$3(), c.copy$default$4(), c.copy$default$5(), c.copy$default$6(), c.copy$default$7(), c.copy$default$8()));
                this.opt('o', "output", Read$.MODULE$.stringRead()).text("output filename").action((Function2 & Serializable)(x, c) -> {
                    String x$1 = x;
                    String x$2 = c.copy$default$1();
                    scala.collection.immutable.Seq<String> x$3 = c.copy$default$3();
                    boolean x$4 = c.copy$default$4();
                    boolean x$5 = c.copy$default$5();
                    String x$6 = c.copy$default$6();
                    boolean x$7 = c.copy$default$7();
                    int x$8 = c.copy$default$8();
                    return c.copy(x$2, x$1, x$3, x$4, x$5, x$6, x$7, x$8);
                });
                this.opt("language", Read$.MODULE$.stringRead()).text("source language").action((Function2 & Serializable)(x, c) -> {
                    String x$9 = x;
                    String x$10 = c.copy$default$1();
                    String x$11 = c.copy$default$2();
                    scala.collection.immutable.Seq<String> x$12 = c.copy$default$3();
                    boolean x$13 = c.copy$default$4();
                    boolean x$14 = c.copy$default$5();
                    boolean x$15 = c.copy$default$7();
                    int x$16 = c.copy$default$8();
                    return c.copy(x$10, x$11, x$12, x$13, x$14, x$9, x$15, x$16);
                });
                this.opt("list-languages", Read$.MODULE$.unitRead()).text("list available language options").action((Function2 & Serializable)(x$2, c) -> {
                    boolean x$17 = true;
                    String x$18 = c.copy$default$1();
                    String x$19 = c.copy$default$2();
                    scala.collection.immutable.Seq<String> x$20 = c.copy$default$3();
                    boolean x$21 = c.copy$default$4();
                    boolean x$22 = c.copy$default$5();
                    String x$23 = c.copy$default$6();
                    int x$24 = c.copy$default$8();
                    return c.copy(x$18, x$19, x$20, x$21, x$22, x$23, true, x$24);
                });
                this.opt("namespaces", Read$.MODULE$.stringRead()).text("namespaces to include: comma separated string").action((Function2 & Serializable)(x, c) -> {
                    scala.collection.immutable.Seq x$25 = ArrayOps$.MODULE$.toSeq$extension(Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.refArrayOps((Object[])x.split(",")), (Function1 & Serializable)x$3 -> x$3.trim(), ClassTag$.MODULE$.apply(String.class))));
                    String x$26 = c.copy$default$1();
                    String x$27 = c.copy$default$2();
                    boolean x$28 = c.copy$default$4();
                    boolean x$29 = c.copy$default$5();
                    String x$30 = c.copy$default$6();
                    boolean x$31 = c.copy$default$7();
                    int x$32 = c.copy$default$8();
                    return c.copy(x$26, x$27, (scala.collection.immutable.Seq<String>)x$25, x$28, x$29, x$30, x$31, x$32);
                });
                this.note("Overlay application stage");
                this.opt("nooverlays", Read$.MODULE$.unitRead()).text("do not apply default overlays").action((Function2 & Serializable)(x$4, c) -> {
                    boolean x$33 = false;
                    String x$34 = c.copy$default$1();
                    String x$35 = c.copy$default$2();
                    scala.collection.immutable.Seq<String> x$36 = c.copy$default$3();
                    boolean x$37 = c.copy$default$5();
                    String x$38 = c.copy$default$6();
                    boolean x$39 = c.copy$default$7();
                    int x$40 = c.copy$default$8();
                    return c.copy(x$34, x$35, x$36, false, x$37, x$38, x$39, x$40);
                });
                this.opt("overlaysonly", Read$.MODULE$.unitRead()).text("Only apply default overlays").action((Function2 & Serializable)(x$5, c) -> {
                    boolean x$41 = true;
                    String x$42 = c.copy$default$1();
                    String x$43 = c.copy$default$2();
                    scala.collection.immutable.Seq<String> x$44 = c.copy$default$3();
                    boolean x$45 = c.copy$default$4();
                    String x$46 = c.copy$default$6();
                    boolean x$47 = c.copy$default$7();
                    int x$48 = c.copy$default$8();
                    return c.copy(x$42, x$43, x$44, x$45, true, x$46, x$47, x$48);
                });
                this.opt("max-num-def", Read$.MODULE$.intRead()).text("Maximum number of definitions in per-method data flow calculation").action((Function2 & Serializable)(x, c) -> anon.1.$anonfun$new$9(BoxesRunTime.unboxToInt((Object)x), c));
                this.note("Misc");
                this.help("help").text("display this help message");
                this.note(new java.lang.StringBuilder(76).append("Args specified after the ").append(JoernParse$.MODULE$.ArgsDelimitor()).append(" separator will be passed to the front-end verbatim").toString());
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$new$1(java.lang.String io.joern.joerncli.JoernParse$ParserConfig ), $anonfun$new$2(java.lang.String io.joern.joerncli.JoernParse$ParserConfig ), $anonfun$new$3(java.lang.String io.joern.joerncli.JoernParse$ParserConfig ), $anonfun$new$4(scala.runtime.BoxedUnit io.joern.joerncli.JoernParse$ParserConfig ), $anonfun$new$5(java.lang.String io.joern.joerncli.JoernParse$ParserConfig ), $anonfun$new$6(java.lang.String ), $anonfun$new$7(scala.runtime.BoxedUnit io.joern.joerncli.JoernParse$ParserConfig ), $anonfun$new$8(scala.runtime.BoxedUnit io.joern.joerncli.JoernParse$ParserConfig ), $anonfun$new$9$adapted(java.lang.Object io.joern.joerncli.JoernParse$ParserConfig )}, serializedLambda);
            }
        };
    }

    public String ArgsDelimitor() {
        return ArgsDelimitor;
    }

    public String DefaultCpgOutFile() {
        return DefaultCpgOutFile;
    }

    public CpgGenerator generator() {
        return generator;
    }

    public void generator_$eq(CpgGenerator x$1) {
        generator = x$1;
    }

    public void main(String[] args) {
        Try<String> try_ = this.run(args);
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            String msg = (String)success.value();
            Predef$.MODULE$.println((Object)msg);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable err = failure.exception();
            err.printStackTrace();
            System.exit(1);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            throw new MatchError(try_);
        }
    }

    public OptionParser<JoernParse.ParserConfig> optionParser() {
        return optionParser;
    }

    private Try<String> run(String[] args) {
        Tuple2<List<String>, List<String>> tuple2 = CpgBasedTool$.MODULE$.splitArgs(args);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        List parserArgs = (List)tuple2._1();
        List frontendArgs = (List)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)parserArgs, (Object)frontendArgs);
        Tuple2 tuple23 = tuple22;
        List parserArgs2 = (List)tuple23._1();
        List frontendArgs2 = (List)tuple23._2();
        InstallConfig installConfig = new InstallConfig(InstallConfig$.MODULE$.$lessinit$greater$default$1());
        return this.parseConfig((scala.collection.immutable.Seq<String>)parserArgs2).flatMap((Function1 & Serializable)config -> config.listLanguages() ? Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.buildLanguageList()) : MODULE$.run((JoernParse.ParserConfig)config, (List<String>)frontendArgs2, installConfig));
    }

    public Try<String> run(JoernParse.ParserConfig config, List<String> frontendArgs, InstallConfig installConfig) {
        return this.checkInputPath(config).flatMap((Function1 & Serializable)x$9 -> {
            BoxedUnit boxedUnit = x$9;
            Try try_ = MODULE$.getLanguage(config).flatMap((Function1 & Serializable)language -> MODULE$.generateCpg(installConfig, (scala.collection.immutable.Seq<String>)frontendArgs, config, (String)language).flatMap((Function1 & Serializable)x$8 -> {
                String string = x$8;
                Try try_ = MODULE$.applyDefaultOverlays(config).map((Function1 & Serializable)x$7 -> {
                    String string = x$7;
                    String string2 = CpgBasedTool$.MODULE$.newCpgCreatedString(config.outputCpgFile());
                    return string2;
                });
                return try_;
            }));
            return try_;
        });
    }

    public List<String> run$default$2() {
        return package$.MODULE$.List().empty();
    }

    public InstallConfig run$default$3() {
        return InstallConfig$.MODULE$.apply();
    }

    private Try<BoxedUnit> checkInputPath(JoernParse.ParserConfig config) {
        return Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> {
            scala.collection.immutable.Seq x$1;
            String string = config.inputPath();
            String string2 = "";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                Predef$.MODULE$.println((Object)MODULE$.optionParser().usage());
                throw new AssertionError((Object)"Input path required");
            }
            File qual$1 = File$.MODULE$.apply(config.inputPath(), (scala.collection.immutable.Seq)Nil$.MODULE$);
            if (!qual$1.exists(x$1 = qual$1.exists$default$1())) {
                throw new AssertionError((Object)new java.lang.StringBuilder(41).append("Input path does not exist at `").append(config.inputPath()).append("`, exiting.").toString());
            }
        });
    }

    private String buildLanguageList() {
        StringBuilder s = new StringBuilder();
        s.$plus$plus$eq("Available languages (case insensitive):\n");
        s.$plus$plus$eq(((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala(Languages.ALL).asScala().map((Function1 & Serializable)lang -> new java.lang.StringBuilder(2).append("- ").append(lang.toLowerCase()).toString())).mkString("\n"));
        return s.toString();
    }

    private Try<String> getLanguage(JoernParse.ParserConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(config.language())) ? config.language() : (String)io.joern.console.cpgcreation.package$.MODULE$.guessLanguage(config.inputPath()).getOrElse((Function0 & Serializable)() -> {
            throw new AssertionError((Object)new java.lang.StringBuilder(97).append("Could not guess language from input path ").append(config.inputPath()).append(". Please specify a language using the --language option.").toString());
        }));
    }

    private Try<String> generateCpg(InstallConfig installConfig, scala.collection.immutable.Seq<String> frontendArgs, JoernParse.ParserConfig config, String language) {
        Success success;
        if (config.enhanceOnly()) {
            success = new Success((Object)"No generation required");
        } else {
            Predef$.MODULE$.println((Object)new java.lang.StringBuilder(32).append("Parsing code at: ").append(config.inputPath()).append(" - language: `").append(language).append("`").toString());
            Predef$.MODULE$.println((Object)"[+] Running language frontend");
            success = Try$.MODULE$.apply((Function0 & Serializable)() -> (CpgGenerator)io.joern.console.cpgcreation.package$.MODULE$.cpgGeneratorForLanguage(language.toUpperCase(), FrontendConfig$.MODULE$.apply(), installConfig.rootPath().path(), frontendArgs.toList()).get()).flatMap((Function1 & Serializable)newGenerator -> {
                MODULE$.generator_$eq((CpgGenerator)newGenerator);
                return MODULE$.generator().generate(config.inputPath(), config.outputCpgFile()).recover((PartialFunction)new Serializable(language, config){
                    private static final long serialVersionUID = 0L;
                    private final String language$1;
                    private final JoernParse.ParserConfig config$4;

                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        A1 A1 = x1;
                        throw new RuntimeException(new java.lang.StringBuilder(52).append("Could not generate CPG with language = ").append(this.language$1).append(" and input = ").append(this.config$4.inputPath()).toString(), A1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        boolean bl = true;
                        return bl;
                    }
                    {
                        this.language$1 = language$1;
                        this.config$4 = config$4;
                    }
                });
            });
        }
        return success;
    }

    private Try<String> applyDefaultOverlays(JoernParse.ParserConfig config) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> {
            block0: {
                Predef$.MODULE$.println((Object)"[+] Applying default overlays");
                if (!config.enhance()) break block0;
                Cpg cpg = DefaultOverlays$.MODULE$.create(config.outputCpgFile(), config.maxNumDef());
                MODULE$.generator().applyPostProcessingPasses(cpg);
                cpg.close();
            }
            return "Code property graph generation successful";
        });
    }

    private Try<JoernParse.ParserConfig> parseConfig(scala.collection.immutable.Seq<String> parserArgs) {
        return Try$.MODULE$.apply((Function0 & Serializable)() -> (JoernParse.ParserConfig)MODULE$.optionParser().parse((Seq)parserArgs, (Object)new JoernParse.ParserConfig(JoernParse$ParserConfig$.MODULE$.apply$default$1(), JoernParse$ParserConfig$.MODULE$.apply$default$2(), JoernParse$ParserConfig$.MODULE$.apply$default$3(), JoernParse$ParserConfig$.MODULE$.apply$default$4(), JoernParse$ParserConfig$.MODULE$.apply$default$5(), JoernParse$ParserConfig$.MODULE$.apply$default$6(), JoernParse$ParserConfig$.MODULE$.apply$default$7(), JoernParse$ParserConfig$.MODULE$.apply$default$8())).getOrElse((Function0 & Serializable)() -> {
            throw new RuntimeException(new java.lang.StringBuilder(48).append("Error while not parsing command line options: `").append(parserArgs.mkString(",")).append("`").toString());
        }));
    }

    private JoernParse$() {
    }
}

