/*
 * Decompiled with CFR 0.152.
 */
package io.joern.joerncli;

import io.joern.dataflowengineoss.layers.dataflows.OssDataFlow;
import io.joern.dataflowengineoss.layers.dataflows.OssDataFlow$;
import io.joern.dataflowengineoss.layers.dataflows.OssDataFlowOptions;
import io.joern.dataflowengineoss.layers.dataflows.OssDataFlowOptions$;
import io.joern.dataflowengineoss.slicing.DataFlowSlicing$;
import io.joern.dataflowengineoss.slicing.UsageSlicing$;
import io.joern.dataflowengineoss.slicing.package;
import io.joern.joerncli.CpgBasedTool$;
import io.joern.joerncli.JoernParse$;
import io.joern.joerncli.JoernParse$ParserConfig$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.layers.Base$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyOverlays$;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext;
import io.shiftleft.semanticcpg.layers.LayerCreatorContext$;
import io.shiftleft.semanticcpg.utils.FileUtil;
import io.shiftleft.semanticcpg.utils.FileUtil$;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.util.Either;
import scala.util.Try;
import scala.util.Using;
import scala.util.Using$;
import scopt.OptionDef;
import scopt.OptionParser;
import scopt.Read$;

public final class JoernSlice$
implements Serializable {
    private static final OptionParser<package.BaseConfig<?>> configParser;
    public static final JoernSlice$ MODULE$;

    private JoernSlice$() {
    }

    static {
        MODULE$ = new JoernSlice$();
        configParser = new OptionParser<package.BaseConfig<?>>(){
            {
                this.head((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"Extract various slices from the CPG."}));
                this.help("help");
                this.arg("cpg", Read$.MODULE$.stringRead()).text("input CPG file name, or source code - defaults to `cpg.bin`").optional().action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$1).validate((Function1 & Serializable)x -> {
                    Path path = Paths.get(x, new String[0]);
                    if (Files.isRegularFile(path, new LinkOption[0]) || Files.isDirectory(path, new LinkOption[0])) {
                        return this.success();
                    }
                    return this.failure("File at '" + x + "' not found or not regular, e.g. a directory or source file.");
                });
                this.opt('o', "out", Read$.MODULE$.stringRead()).text("the output file to write slices to - defaults to `slices`. The file is suffixed based on the mode.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$3);
                this.opt("dummy-types", Read$.MODULE$.unitRead()).text("for generating CPGs that use type recovery, enables the use of dummy types - defaults to false.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$4);
                this.opt("file-filter", Read$.MODULE$.stringRead()).text("the name of the source file to generate slices from.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$5);
                this.opt("method-name-filter", Read$.MODULE$.stringRead()).text("filters in slices that go through specific methods by names. Uses regex.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$6);
                this.opt("method-parameter-filter", Read$.MODULE$.stringRead()).text("filters in slices that go through methods with specific types on the method parameters. Uses regex.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$7);
                this.opt("method-annotation-filter", Read$.MODULE$.stringRead()).text("filters in slices that go through methods with specific annotations on the methods. Uses regex.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$8);
                this.opt('p', "parallelism", Read$.MODULE$.intRead()).text("the number of threads the executor pool should be specified with.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1).validate((Function1 & Serializable)x -> this.$init$$$anonfun$10(BoxesRunTime.unboxToInt((Object)x)));
                this.cmd("data-flow").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$11).children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionDef[]{this.opt("slice-depth", Read$.MODULE$.intRead()).text("the max depth to traverse the DDG for the data-flow slice - defaults to 20.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$3), this.opt("sink-filter", Read$.MODULE$.stringRead()).text("filters on the sink's `code` property. Uses regex.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$13), this.opt("end-at-external-method", Read$.MODULE$.unitRead()).text("all slices must end at a call to an external method - defaults to false.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$14)}));
                this.cmd("usages").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$15).children((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new OptionDef[]{this.opt("min-num-calls", Read$.MODULE$.intRead()).text("the minimum number of calls required for a usage slice - defaults to 1.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$4), this.opt("exclude-operators", Read$.MODULE$.unitRead()).text("excludes operator calls in the slices - defaults to false.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$17), this.opt("exclude-source", Read$.MODULE$.unitRead()).text("excludes method source code in the slices - defaults to false.").action(JoernSlice$::io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$18)}));
            }

            private final /* synthetic */ Either $init$$$anonfun$10(int x) {
                if (x <= 0) {
                    return this.failure("Parallelism should be greater than 0");
                }
                return this.success();
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$1(java.lang.String io.joern.dataflowengineoss.slicing.package$BaseConfig ), $init$$$anonfun$2(java.lang.String ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$3(java.lang.String io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$4(scala.runtime.BoxedUnit io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$5(java.lang.String io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$6(java.lang.String io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$7(java.lang.String io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$8(java.lang.String io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1(java.lang.Object java.lang.Object ), $init$$$anonfun$adapted$2(java.lang.Object ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$11(scala.runtime.BoxedUnit io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$3(java.lang.Object java.lang.Object ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$13(java.lang.String io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$14(scala.runtime.BoxedUnit io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$15(scala.runtime.BoxedUnit io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$4(java.lang.Object java.lang.Object ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$17(scala.runtime.BoxedUnit io.joern.dataflowengineoss.slicing.package$BaseConfig ), io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$18(scala.runtime.BoxedUnit io.joern.dataflowengineoss.slicing.package$BaseConfig )}, serializedLambda);
            }
        };
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(JoernSlice$.class);
    }

    public void main(String[] args) {
        this.parseConfig(args).foreach((Function1)(JProcedure1 & Serializable)config -> {
            if (config instanceof package.DefaultSliceConfig) {
                configParser.reportError("No command specified! Use --help for more information.");
                return;
            }
            String inputCpgPath = Files.isDirectory(config.inputPath(), new LinkOption[0]) || !FileUtil$.MODULE$.PathExt(config.inputPath()).extension(false).exists((Function1 & Serializable)_$9 -> _$9.matches("(bin|cpg)")) ? (String)MODULE$.generateTempCpg((package.BaseConfig<?>)config).get() : config.inputPath().toString();
            Using$.MODULE$.resource((Object)CpgBasedTool$.MODULE$.loadFromFile(inputCpgPath), (Function1)(JProcedure1 & Serializable)cpg -> {
                Object object;
                None$ none$;
                None$ none$2;
                MODULE$.checkAndApplyOverlays((Cpg)cpg);
                package.BaseConfig baseConfig = config;
                if (baseConfig instanceof package.DataFlowConfig) {
                    package.DataFlowConfig x = (package.DataFlowConfig)baseConfig;
                    none$2 = DataFlowSlicing$.MODULE$.calculateDataFlowSlice(cpg, x);
                } else if (baseConfig instanceof package.UsagesConfig) {
                    package.UsagesConfig x = (package.UsagesConfig)baseConfig;
                    none$2 = Option$.MODULE$.apply((Object)UsageSlicing$.MODULE$.calculateUsageSlice(cpg, x));
                } else {
                    none$2 = none$ = None$.MODULE$;
                }
                if (none$ instanceof Some && (object = ((Some)none$).value()) instanceof package.ProgramSlice) {
                    package.ProgramSlice programSlice = (package.ProgramSlice)object;
                    MODULE$.saveSlice(config.outputSliceFile(), programSlice);
                    return;
                }
                if (None$.MODULE$.equals(none$)) {
                    Predef$.MODULE$.println((Object)"Empty slice, no file generated.");
                    return;
                }
                throw new MatchError((Object)none$);
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        });
    }

    private void checkAndApplyOverlays(Cpg cpg) {
        Iterator iterator;
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyOverlaysTraversal((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg).metaData());
        if (!TraversalPropertyOverlays$.MODULE$.overlays$extension(iterator2).contains((Object)Base$.MODULE$.overlayName())) {
            Predef$.MODULE$.println((Object)"Default overlays are not detected, applying defaults now");
            X2Cpg$.MODULE$.applyDefaultOverlays(cpg);
        }
        if (!TraversalPropertyOverlays$.MODULE$.overlays$extension(iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.accessPropertyOverlaysTraversal((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toGeneratedNodeStarters(cpg).metaData())).contains((Object)OssDataFlow$.MODULE$.overlayName())) {
            Predef$.MODULE$.println((Object)"Data-flow overlay is not detected, applying now");
            OssDataFlowOptions ossDataFlowOptions = new OssDataFlowOptions(OssDataFlowOptions$.MODULE$.$lessinit$greater$default$1(), OssDataFlowOptions$.MODULE$.$lessinit$greater$default$2());
            new OssDataFlow(ossDataFlowOptions, OssDataFlow$.MODULE$.$lessinit$greater$default$2(ossDataFlowOptions)).run(new LayerCreatorContext(cpg, LayerCreatorContext$.MODULE$.$lessinit$greater$default$2()));
            return;
        }
    }

    private Try<String> generateTempCpg(package.BaseConfig<?> config) {
        Path tmpFile = FileUtil$.MODULE$.newTemporaryFile("joern-slice", ".bin", FileUtil$.MODULE$.newTemporaryFile$default$3());
        Predef$.MODULE$.println((Object)("Generating CPG from code at " + config.inputPath().toString()));
        return JoernParse$.MODULE$.run(JoernParse$ParserConfig$.MODULE$.apply(config.inputPath().toString(), tmpFile.toString(), JoernParse$ParserConfig$.MODULE$.$lessinit$greater$default$3(), JoernParse$ParserConfig$.MODULE$.$lessinit$greater$default$4(), JoernParse$ParserConfig$.MODULE$.$lessinit$greater$default$5(), JoernParse$ParserConfig$.MODULE$.$lessinit$greater$default$6(), JoernParse$ParserConfig$.MODULE$.$lessinit$greater$default$7(), JoernParse$ParserConfig$.MODULE$.$lessinit$greater$default$8()), (List<String>)(config.dummyTypesEnabled() ? package$.MODULE$.List().empty() : (List)new .colon.colon((Object)"--no-dummyTypes", (List)Nil$.MODULE$)), JoernParse$.MODULE$.run$default$3()).map((Function1 & Serializable)_$10 -> {
            Predef$.MODULE$.println((Object)("Temporary CPG has been successfully generated at " + tmpFile.toString()));
            FileUtil$.MODULE$.deleteOnExit(tmpFile, true, FileUtil$.MODULE$.deleteOnExit$default$3());
            return tmpFile.toString();
        });
    }

    private Option<package.BaseConfig<?>> parseConfig(String[] args) {
        return configParser.parse((Seq)Predef$.MODULE$.wrapRefArray((Object[])args), (Object)package.DefaultSliceConfig$.MODULE$.apply());
    }

    private void saveSlice(Path outFile, package.ProgramSlice programSlice) {
        FileUtil.PathExt pathExt = FileUtil$.MODULE$.PathExt(Paths.get(this.normalizePath$1(outFile.toString(), ".json"), new String[0]));
        Path finalOutputPath = pathExt.createWithParentsIfNotExists(pathExt.createWithParentsIfNotExists$default$1(), pathExt.createWithParentsIfNotExists$default$2());
        Files.writeString(finalOutputPath, (CharSequence)programSlice.toJsonPretty(), new OpenOption[0]);
        finalOutputPath.toString();
        Predef$.MODULE$.println((Object)("Slices have been successfully generated and written to " + finalOutputPath));
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$1(String x, package.BaseConfig c) {
        return c.withInputPath(Paths.get(x, new String[0]));
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$3(String x, package.BaseConfig c) {
        return c.withOutputSliceFile(Paths.get(x, new String[0]));
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$4(BoxedUnit _$1, package.BaseConfig c) {
        return c.withDummyTypesEnabled(true);
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$5(String x, package.BaseConfig c) {
        return c.withFileFilter(Option$.MODULE$.apply((Object)x));
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$6(String x, package.BaseConfig c) {
        return c.withMethodNameFilter(Option$.MODULE$.apply((Object)x));
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$7(String x, package.BaseConfig c) {
        return c.withMethodParamTypeFilter(Option$.MODULE$.apply((Object)x));
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$8(String x, package.BaseConfig c) {
        return c.withMethodAnnotationFilter(Option$.MODULE$.apply((Object)x));
    }

    public static /* bridge */ /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$1(Object x, Object c) {
        return ((package.BaseConfig)c).withParallelism(BoxesRunTime.unboxToInt((Object)x));
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$11(BoxedUnit _$2, package.BaseConfig _$3) {
        return package.DataFlowConfig$.MODULE$.apply(package.DataFlowConfig$.MODULE$.$lessinit$greater$default$1(), package.DataFlowConfig$.MODULE$.$lessinit$greater$default$2(), package.DataFlowConfig$.MODULE$.$lessinit$greater$default$3());
    }

    private static final /* synthetic */ package.BaseConfig $init$$$anonfun$12(int x, package.BaseConfig c) {
        package.BaseConfig baseConfig = c;
        if (baseConfig instanceof package.DataFlowConfig) {
            package.DataFlowConfig c2 = (package.DataFlowConfig)baseConfig;
            return c2.copy(c2.copy$default$1(), c2.copy$default$2(), x);
        }
        return c;
    }

    public static /* bridge */ /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$3(Object x, Object c) {
        return JoernSlice$.$init$$$anonfun$12(BoxesRunTime.unboxToInt((Object)x), (package.BaseConfig)c);
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$13(String x, package.BaseConfig c) {
        package.BaseConfig baseConfig = c;
        if (baseConfig instanceof package.DataFlowConfig) {
            package.DataFlowConfig c2 = (package.DataFlowConfig)baseConfig;
            return c2.copy(Option$.MODULE$.apply((Object)x), c2.copy$default$2(), c2.copy$default$3());
        }
        return c;
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$14(BoxedUnit _$4, package.BaseConfig c) {
        package.BaseConfig baseConfig = c;
        if (baseConfig instanceof package.DataFlowConfig) {
            package.DataFlowConfig c2 = (package.DataFlowConfig)baseConfig;
            return c2.copy(c2.copy$default$1(), true, c2.copy$default$3());
        }
        return c;
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$15(BoxedUnit _$5, package.BaseConfig _$6) {
        return package.UsagesConfig$.MODULE$.apply(package.UsagesConfig$.MODULE$.$lessinit$greater$default$1(), package.UsagesConfig$.MODULE$.$lessinit$greater$default$2(), package.UsagesConfig$.MODULE$.$lessinit$greater$default$3());
    }

    private static final /* synthetic */ package.BaseConfig $init$$$anonfun$16(int x, package.BaseConfig c) {
        package.BaseConfig baseConfig = c;
        if (baseConfig instanceof package.UsagesConfig) {
            package.UsagesConfig c2 = (package.UsagesConfig)baseConfig;
            return c2.copy(x, c2.copy$default$2(), c2.copy$default$3());
        }
        return c;
    }

    public static /* bridge */ /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$adapted$4(Object x, Object c) {
        return JoernSlice$.$init$$$anonfun$16(BoxesRunTime.unboxToInt((Object)x), (package.BaseConfig)c);
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$17(BoxedUnit _$7, package.BaseConfig c) {
        package.BaseConfig baseConfig = c;
        if (baseConfig instanceof package.UsagesConfig) {
            package.UsagesConfig c2 = (package.UsagesConfig)baseConfig;
            return c2.copy(c2.copy$default$1(), true, c2.copy$default$3());
        }
        return c;
    }

    public static final /* synthetic */ package.BaseConfig io$joern$joerncli$JoernSlice$$anon$1$$_$$lessinit$greater$$anonfun$18(BoxedUnit _$8, package.BaseConfig c) {
        package.BaseConfig baseConfig = c;
        if (baseConfig instanceof package.UsagesConfig) {
            package.UsagesConfig c2 = (package.UsagesConfig)baseConfig;
            return c2.copy(c2.copy$default$1(), c2.copy$default$2(), true);
        }
        return c;
    }

    private final String normalizePath$1(String path, String ext) {
        if (path.endsWith(ext)) {
            return path;
        }
        return path + ext;
    }
}

