/*
 * Decompiled with CFR 0.152.
 */
package io.joern.kotlin2cpg;

import better.files.File;
import better.files.File$;
import io.joern.kotlin2cpg.Config;
import io.joern.kotlin2cpg.DefaultContentRootJarPath;
import io.joern.kotlin2cpg.DefaultContentRootJarPath$;
import io.joern.kotlin2cpg.FileContentAtPath;
import io.joern.kotlin2cpg.FileContentAtPath$;
import io.joern.kotlin2cpg.Kotlin2Cpg$;
import io.joern.kotlin2cpg.KtFileWithMeta;
import io.joern.kotlin2cpg.KtFileWithMeta$;
import io.joern.kotlin2cpg.compiler.CompilerAPI$;
import io.joern.kotlin2cpg.compiler.ErrorLoggingMessageCollector;
import io.joern.kotlin2cpg.files.SourceFilesPicker$;
import io.joern.kotlin2cpg.interop.JavaSrcInterop$;
import io.joern.kotlin2cpg.jar4import.Service;
import io.joern.kotlin2cpg.jar4import.UsesService;
import io.joern.kotlin2cpg.passes.AstCreationPass;
import io.joern.kotlin2cpg.passes.ConfigPass;
import io.joern.kotlin2cpg.passes.DependenciesFromMavenCoordinatesPass;
import io.joern.kotlin2cpg.types.ContentSourcesPicker$;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgFrontend;
import io.joern.x2cpg.passes.frontend.MetaDataPass;
import io.joern.x2cpg.passes.frontend.MetaDataPass$;
import io.joern.x2cpg.passes.frontend.TypeNodePass$;
import io.joern.x2cpg.utils.dependency.DependencyResolver$;
import io.joern.x2cpg.utils.dependency.DependencyResolverParams;
import io.joern.x2cpg.utils.dependency.DependencyResolverParams$;
import io.joern.x2cpg.utils.dependency.GradleConfigKeys$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import java.util.Collection;
import org.jetbrains.kotlin.analyzer.AnalysisResult;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinToJVMBytecodeCompiler;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.MapOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure2;
import scala.util.Try;
import scala.util.Try$;

public class Kotlin2Cpg
implements X2CpgFrontend<Config>,
UsesService {
    private Logger io$joern$kotlin2cpg$jar4import$UsesService$$logger;

    public static void postProcessingPass(Cpg cpg) {
        Kotlin2Cpg$.MODULE$.postProcessingPass(cpg);
    }

    public Kotlin2Cpg() {
        UsesService.$init$(this);
        Statics.releaseFence();
    }

    @Override
    public Logger io$joern$kotlin2cpg$jar4import$UsesService$$logger() {
        return this.io$joern$kotlin2cpg$jar4import$UsesService$$logger;
    }

    @Override
    public void io$joern$kotlin2cpg$jar4import$UsesService$_setter_$io$joern$kotlin2cpg$jar4import$UsesService$$logger_$eq(Logger x$0) {
        this.io$joern$kotlin2cpg$jar4import$UsesService$$logger = x$0;
    }

    private void checkSourceDir(String sourceDir) {
        if (!Files.exists(Paths.get(sourceDir, new String[0]), new LinkOption[0])) {
            Predef$.MODULE$.println((Object)("The specified input path `" + sourceDir + "` is not a file that exists. Exiting."));
            System.exit(1);
        }
        if (!Files.isDirectory(Paths.get(sourceDir, new String[0]), new LinkOption[0])) {
            Predef$.MODULE$.println((Object)("The specified input path `" + sourceDir + "` is not a directory. Exiting."));
            System.exit(1);
            return;
        }
    }

    private void logMaxHeapSize() {
        long maxHeapSize = Runtime.getRuntime().maxMemory();
        String formattedMaxHeapSize = String.format("%,.2f", BoxesRunTime.boxToDouble((double)((double)maxHeapSize / 1.073741824E9)));
        Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Max heap size currently set to `" + formattedMaxHeapSize + "GB`.");
    }

    private List<String> gatherFilesWithKtExtension(String sourceDir, Config config) {
        Set set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".kt"}));
        Option option = Option$.MODULE$.apply((Object)config.ignoredFilesRegex());
        Option option2 = Option$.MODULE$.apply((Object)config.ignoredFiles());
        Option option3 = SourceFiles$.MODULE$.determine$default$3();
        List filesWithKtExtension = SourceFiles$.MODULE$.determine(sourceDir, set, option3, option, option2, SourceFiles$.MODULE$.determine$default$6(sourceDir, set, option3, option, option2));
        if (filesWithKtExtension.isEmpty()) {
            Predef$.MODULE$.println((Object)("The provided input directory does not contain files ending in '.kt' `" + sourceDir + "`. Exiting."));
            System.exit(1);
        }
        return filesWithKtExtension;
    }

    private List<String> gatherFilesWithJavaExtension(String sourceDir, Config config) {
        Set set = (Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".java"}));
        Option option = Option$.MODULE$.apply((Object)config.ignoredFilesRegex());
        Option option2 = Option$.MODULE$.apply((Object)config.ignoredFiles());
        Option option3 = SourceFiles$.MODULE$.determine$default$3();
        List filesWithJavaExtension = SourceFiles$.MODULE$.determine(sourceDir, set, option3, option, option2, SourceFiles$.MODULE$.determine$default$6(sourceDir, set, option3, option, option2));
        if (filesWithJavaExtension.nonEmpty()) {
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Found " + filesWithJavaExtension.size() + " files with the `.java` extension.");
        }
        return filesWithJavaExtension;
    }

    private scala.collection.immutable.Seq<String> gatherDependenciesPaths(String sourceDir, Config config, List<String> filesWithJavaExtension) {
        Option jar4ImportServiceOpt = config.jar4importServiceUrl().flatMap((Function1 & Serializable)serviceUrl -> this.reachableServiceMaybe((String)serviceUrl));
        if (jar4ImportServiceOpt.isDefined()) {
            List<String> filesWithKtExtension = this.gatherFilesWithKtExtension(sourceDir, config);
            scala.collection.immutable.Seq<String> importNames = this.importNamesForFilesAtPaths((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)filesWithKtExtension.$plus$plus(filesWithJavaExtension)));
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.trace("Found imports: `" + importNames + "`");
            return this.dependenciesFromService((Service)jar4ImportServiceOpt.get(), (scala.collection.immutable.Seq)importNames);
        }
        if (config.downloadDependencies()) {
            return this.downloadDependencies(sourceDir, config);
        }
        Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Not downloading any dependencies.");
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private scala.collection.immutable.Seq<String> gatherMavenCoordinates(String sourceDir, Config config) {
        if (config.generateNodesForDependencies()) {
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Fetching maven coordinates.");
            return this.fetchMavenCoordinates(sourceDir, config);
        }
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }

    private scala.collection.immutable.Seq<String> gatherJarsAtConfigClassPath(Config config) {
        scala.collection.immutable.Seq<String> jarsAtConfigClassPath = this.findJarsIn(config.classpath());
        if (config.classpath().nonEmpty()) {
            if (jarsAtConfigClassPath.nonEmpty()) {
                Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Found " + jarsAtConfigClassPath.size() + " jars in the specified classpath.");
            } else {
                Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.warn("No jars found in the specified classpath.");
            }
        }
        return jarsAtConfigClassPath;
    }

    private scala.collection.immutable.Seq<DefaultContentRootJarPath> gatherDefaultContentRootJars(String sourceDir, Config config, List<String> filesWithJavaExtension) {
        scala.collection.immutable.Seq stdlibJars = config.withStdlibJarsInClassPath() ? Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$defaultKotlinStdlibContentRootJarPaths : (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        scala.collection.immutable.Seq<String> jarsAtConfigClassPath = this.gatherJarsAtConfigClassPath(config);
        scala.collection.immutable.Seq<String> dependenciesPaths = this.gatherDependenciesPaths(sourceDir, config, filesWithJavaExtension);
        scala.collection.immutable.Seq defaultContentRootJars = (scala.collection.immutable.Seq)((IterableOps)stdlibJars.$plus$plus((IterableOnce)jarsAtConfigClassPath.map((Function1 & Serializable)path -> DefaultContentRootJarPath$.MODULE$.apply((String)path, false)))).$plus$plus((IterableOnce)dependenciesPaths.map((Function1 & Serializable)path -> DefaultContentRootJarPath$.MODULE$.apply((String)path, false)));
        return defaultContentRootJars;
    }

    private scala.collection.immutable.Seq<String> gatherDirsForSourcesToCompile(String sourceDir) {
        scala.collection.immutable.Seq<String> dirsForSourcesToCompile = ContentSourcesPicker$.MODULE$.dirsForRoot(sourceDir);
        if (dirsForSourcesToCompile.isEmpty()) {
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.warn("The list of directories to analyze is empty.");
        }
        return dirsForSourcesToCompile;
    }

    private Iterable<KtFileWithMeta> gatherSourceFiles(String sourceDir, Config config, KotlinCoreEnvironment environment) {
        Iterable<KtFileWithMeta> sourceEntries = this.entriesForSources((Iterable<KtFile>)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)environment.getSourceFiles()).asScala(), sourceDir);
        Iterable sourceFiles = (Iterable)sourceEntries.filter((Function1 & Serializable)entry -> {
            String string = config.inputPath();
            Option option = Option$.MODULE$.apply((Object)config.ignoredFilesRegex());
            Option option2 = Option$.MODULE$.apply((Object)config.ignoredFiles());
            Option option3 = SourceFiles$.MODULE$.filterFile$default$3();
            return SourceFiles$.MODULE$.filterFile(entry.filename(), string, option3, option, option2);
        });
        return sourceFiles;
    }

    private void runJavaSrcInterop(Cpg cpg, Config config, List<String> filesWithJavaExtension, List<String> kotlinAstCreatorTypes) {
        if (config.includeJavaSourceFiles() && filesWithJavaExtension.nonEmpty()) {
            io.joern.javasrc2cpg.passes.AstCreationPass javaAstCreator = JavaSrcInterop$.MODULE$.astCreationPass(config.inputPath(), filesWithJavaExtension, cpg);
            javaAstCreator.createAndApply();
            List javaAstCreatorTypes = CollectionConverters$.MODULE$.EnumerationHasAsScala(javaAstCreator.global().usedTypes().keys()).asScala().toList();
            javaAstCreator.sourceParser().cleanupDelombokOutput();
            javaAstCreator.clearJavaParserCaches();
            TypeNodePass$.MODULE$.withRegisteredTypes(javaAstCreatorTypes.toSet().$minus$minus((IterableOnce)kotlinAstCreatorTypes.toSet()).toList(), cpg).createAndApply();
            return;
        }
    }

    public Try<Cpg> createCpg(Config config2) {
        return X2Cpg$.MODULE$.withNewEmptyCpg(config2.outputPath(), (X2CpgConfig)config2, (Function2)(JProcedure2 & Serializable)(cpg, config) -> {
            String sourceDir = config.inputPath();
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Starting CPG generation for input directory `" + sourceDir + "`.");
            this.checkSourceDir(sourceDir);
            this.logMaxHeapSize();
            List<String> filesWithJavaExtension = this.gatherFilesWithJavaExtension(sourceDir, (Config)config);
            scala.collection.immutable.Seq<String> mavenCoordinates = this.gatherMavenCoordinates(sourceDir, (Config)config);
            scala.collection.immutable.Seq<DefaultContentRootJarPath> defaultContentRootJars = this.gatherDefaultContentRootJars(sourceDir, (Config)config, filesWithJavaExtension);
            scala.collection.immutable.Seq<String> dirsForSourcesToCompile = this.gatherDirsForSourcesToCompile(sourceDir);
            KotlinCoreEnvironment environment = CompilerAPI$.MODULE$.makeEnvironment(dirsForSourcesToCompile, (scala.collection.immutable.Seq<String>)filesWithJavaExtension, defaultContentRootJars, new ErrorLoggingMessageCollector());
            Iterable<KtFileWithMeta> sourceFiles = this.gatherSourceFiles(sourceDir, (Config)config, environment);
            scala.collection.immutable.Seq<FileContentAtPath> configFiles = this.entriesForConfigFiles(SourceFilesPicker$.MODULE$.configFiles(sourceDir), sourceDir);
            new MetaDataPass(cpg, "KOTLIN", config.inputPath(), MetaDataPass$.MODULE$.$lessinit$greater$default$4()).createAndApply();
            BindingContext bindingContext = this.createBindingContext(environment);
            AstCreationPass astCreator = new AstCreationPass(sourceFiles, bindingContext, (Cpg)cpg, config.schemaValidation());
            astCreator.createAndApply();
            Disposer.dispose((Disposable)environment.getProjectEnvironment().getParentDisposable());
            List<String> kotlinAstCreatorTypes = astCreator.usedTypes();
            TypeNodePass$.MODULE$.withRegisteredTypes(kotlinAstCreatorTypes, cpg).createAndApply();
            this.runJavaSrcInterop((Cpg)cpg, (Config)config, filesWithJavaExtension, kotlinAstCreatorTypes);
            new ConfigPass((Iterable<FileContentAtPath>)configFiles, (Cpg)cpg).createAndApply();
            new DependenciesFromMavenCoordinatesPass(mavenCoordinates, (Cpg)cpg).createAndApply();
        });
    }

    private scala.collection.immutable.Seq<String> importNamesForFilesAtPaths(scala.collection.immutable.Seq<String> paths) {
        return (scala.collection.immutable.Seq)((IterableOps)paths.flatMap((Function1 & Serializable)_$2 -> {
            File file = File$.MODULE$.apply(_$2, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            return ((IterableOnceOps)file.lines(file.lines$default$1()).filter((Function1 & Serializable)_$3 -> _$3.startsWith("import"))).toSeq();
        })).map((Function1 & Serializable)_$4 -> Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$ImportPattern.replaceAllIn((CharSequence)_$4, "$1").trim());
    }

    private Map<Enumeration.Value, String> gatherGradleParams(Config config) {
        Object[] objectArray = new Tuple2[2];
        Enumeration.Value value = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)GradleConfigKeys$.MODULE$.ProjectName());
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value, config.gradleProjectName());
        Enumeration.Value value2 = (Enumeration.Value)Predef$.MODULE$.ArrowAssoc((Object)GradleConfigKeys$.MODULE$.ConfigurationName());
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)value2, config.gradleConfigurationName());
        return (Map)((MapOps)Predef$.MODULE$.Map().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Tuple2 x) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    Enumeration.Value key = (Enumeration.Value)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Tuple2 x, Function1 function1) {
                Tuple2 tuple2 = x;
                if (tuple2 != null) {
                    Option option = (Option)tuple2._2();
                    Enumeration.Value key = (Enumeration.Value)tuple2._1();
                    if (option instanceof Some) {
                        String value = (String)((Some)option).value();
                        return Tuple2$.MODULE$.apply((Object)key, (Object)value);
                    }
                }
                return function1.apply((Object)x);
            }
        });
    }

    private scala.collection.immutable.Seq<String> downloadDependencies(String sourceDir, Config config) {
        Map<Enumeration.Value, String> gradleParams = this.gatherGradleParams(config);
        DependencyResolverParams resolverParams = DependencyResolverParams$.MODULE$.apply(Predef$.MODULE$.Map().empty(), gradleParams);
        Option option = DependencyResolver$.MODULE$.getDependencies(Paths.get(sourceDir, new String[0]), resolverParams);
        if (option instanceof Some) {
            scala.collection.immutable.Seq deps = (scala.collection.immutable.Seq)((Some)option).value();
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Using " + deps.size() + " dependency jars.");
            return deps;
        }
        if (None$.MODULE$.equals(option)) {
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.warn("Could not fetch dependencies for project at path " + sourceDir);
            Predef$.MODULE$.println((Object)"Could not fetch dependencies when explicitly asked to.");
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        throw new MatchError((Object)option);
    }

    private scala.collection.immutable.Seq<String> fetchMavenCoordinates(String sourceDir, Config config) {
        Map<Enumeration.Value, String> gradleParams = this.gatherGradleParams(config);
        DependencyResolverParams resolverParams = DependencyResolverParams$.MODULE$.apply(Predef$.MODULE$.Map().empty(), gradleParams);
        Option option = DependencyResolver$.MODULE$.getCoordinates(Paths.get(sourceDir, new String[0]), resolverParams);
        if (option instanceof Some) {
            Seq coordinates = (Seq)((Some)option).value();
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Found " + coordinates.size() + " maven coordinates.");
            return coordinates.toSeq();
        }
        if (None$.MODULE$.equals(option)) {
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.warn("Could not fetch coordinates for project at path " + sourceDir);
            Predef$.MODULE$.println((Object)"Could not fetch coordinates when explicitly asked to.");
            return (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        }
        throw new MatchError((Object)option);
    }

    private scala.collection.immutable.Seq<String> findJarsIn(Set<String> dirs) {
        return (scala.collection.immutable.Seq)dirs.foldLeft((Object)((SeqOps)Nil$.MODULE$), (Function2 & Serializable)(acc, classpathEntry) -> {
            File f = File$.MODULE$.apply(classpathEntry, (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
            SeqOps files = f.isDirectory(f.isDirectory$default$1()) ? f.listRecursively(f.listRecursively$default$1()).filter((Function1 & Serializable)_$5 -> {
                Object object = _$5.extension().getOrElse(Kotlin2Cpg::$anonfun$5$$anonfun$1);
                String string = Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$JarExtension;
                return !(object != null ? !object.equals(string) : string != null);
            }).map((Function1 & Serializable)_$6 -> _$6.toString()) : package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
            return (scala.collection.immutable.Seq)acc.$plus$plus((IterableOnce)files);
        });
    }

    private Iterable<KtFileWithMeta> entriesForSources(Iterable<KtFile> files, String relativeTo) {
        Iterable filesWithMeta = (Iterable)files.flatMap((Function1 & Serializable)file -> Try$.MODULE$.apply(() -> Kotlin2Cpg.$anonfun$7$$anonfun$1(file, relativeTo)).toOption().map((Function1 & Serializable)relPath -> KtFileWithMeta$.MODULE$.apply((KtFile)file, (String)relPath, file.getVirtualFilePath())));
        return (Iterable)filesWithMeta.filterNot((Function1 & Serializable)fwp -> {
            boolean willFilter = SourceFilesPicker$.MODULE$.shouldFilter(fwp.relativizedPath());
            if (willFilter) {
                Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.debug("Filtered file at `" + fwp.f().getVirtualFilePath() + "`.");
            }
            return willFilter;
        });
    }

    private scala.collection.immutable.Seq<FileContentAtPath> entriesForConfigFiles(scala.collection.immutable.Seq<String> paths, String sourceDir) {
        return (scala.collection.immutable.Seq)paths.flatMap((Function1 & Serializable)fileName -> Try$.MODULE$.apply(() -> Kotlin2Cpg.entriesForConfigFiles$$anonfun$1$$anonfun$1(fileName, sourceDir)).toOption().flatMap((Function1 & Serializable)relPath -> Try$.MODULE$.apply(() -> Kotlin2Cpg.entriesForConfigFiles$$anonfun$1$$anonfun$2$$anonfun$1(fileName)).toOption().map((Function1 & Serializable)fileContents -> FileContentAtPath$.MODULE$.apply((String)fileContents, (String)relPath, (String)fileName))));
    }

    private BindingContext createBindingContext(KotlinCoreEnvironment environment) {
        BindingContext bindingContext;
        try {
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Running Kotlin compiler analysis...");
            long t0 = System.nanoTime();
            AnalysisResult analysisResult = KotlinToJVMBytecodeCompiler.INSTANCE.analyze(environment);
            long t1 = System.nanoTime();
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.info("Kotlin compiler analysis finished in `" + (t1 - t0) / 1000000L + "` ms.");
            bindingContext = analysisResult.getBindingContext();
        }
        catch (Exception exc) {
            Kotlin2Cpg$.io$joern$kotlin2cpg$Kotlin2Cpg$$$logger.error("Kotlin compiler analysis failed with exception `" + exc.toString() + "`:`" + exc.getMessage() + "`.", (Throwable)exc);
            bindingContext = BindingContext.EMPTY;
        }
        return bindingContext;
    }

    private static final String $anonfun$5$$anonfun$1() {
        return "";
    }

    private static final String $anonfun$7$$anonfun$1(KtFile file$1, String relativeTo$1) {
        return SourceFiles$.MODULE$.toRelativePath(file$1.getVirtualFilePath(), relativeTo$1);
    }

    private static final String entriesForConfigFiles$$anonfun$1$$anonfun$1(String fileName$1, String sourceDir$1) {
        return SourceFiles$.MODULE$.toRelativePath(fileName$1, sourceDir$1);
    }

    private static final String entriesForConfigFiles$$anonfun$1$$anonfun$2$$anonfun$1(String fileName$3) {
        return IOUtils$.MODULE$.readEntireFile(Paths.get(fileName$3, new String[0]));
    }
}

