/*
 * Decompiled with CFR 0.152.
 */
package io.joern.kotlin2cpg.compiler;

import io.joern.kotlin2cpg.DefaultContentRootJarPath;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import org.jetbrains.kotlin.cli.common.CLIConfigurationKeys;
import org.jetbrains.kotlin.cli.common.config.KotlinSourceRoot;
import org.jetbrains.kotlin.cli.common.messages.MessageCollector;
import org.jetbrains.kotlin.cli.jvm.compiler.EnvironmentConfigFiles;
import org.jetbrains.kotlin.cli.jvm.compiler.KotlinCoreEnvironment;
import org.jetbrains.kotlin.cli.jvm.config.JavaSourceRoot;
import org.jetbrains.kotlin.cli.jvm.config.JvmClasspathRoot;
import org.jetbrains.kotlin.com.intellij.openapi.Disposable;
import org.jetbrains.kotlin.com.intellij.openapi.util.Disposer;
import org.jetbrains.kotlin.config.CommonConfigurationKeys;
import org.jetbrains.kotlin.config.CompilerConfiguration;
import org.jetbrains.kotlin.config.JVMConfigurationKeys;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public final class CompilerAPI$
implements Serializable {
    private static final Logger logger;
    public static final CompilerAPI$ MODULE$;

    private CompilerAPI$() {
    }

    static {
        MODULE$ = new CompilerAPI$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(CompilerAPI$.class);
    }

    public KotlinCoreEnvironment makeEnvironment(Seq<String> forDirectories, Seq<String> javaSourceRoots, Seq<DefaultContentRootJarPath> defaultContentRootJarPaths, MessageCollector messageCollector) {
        CompilerConfiguration config = new CompilerConfiguration();
        config.put(CLIConfigurationKeys.MESSAGE_COLLECTOR_KEY, (Object)messageCollector);
        forDirectories.foreach((Function1)(JProcedure1 & Serializable)p -> config.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new KotlinSourceRoot(p, true, null)));
        File javaHome = new File(System.getProperty("java.home"));
        config.put(JVMConfigurationKeys.JDK_HOME, (Object)javaHome);
        defaultContentRootJarPaths.foreach((Function1)(JProcedure1 & Serializable)path -> {
            if (!path.isResource()) {
                File f = new File(path.path());
                if (f.exists()) {
                    config.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new JvmClasspathRoot(f));
                    logger.debug("Added dependency from path `" + path.path() + "`.");
                    return;
                }
                logger.warn("Path to dependency does not point to existing file `" + path.path() + "`.");
                return;
            }
            InputStream resourceStream = MODULE$.getClass().getClassLoader().getResourceAsStream(path.path());
            if (resourceStream != null) {
                File tempFile = File.createTempFile("kotlin2cpgDependencies", "");
                tempFile.deleteOnExit();
                FileOutputStream outStream = new FileOutputStream(tempFile);
                byte[] buffer = new byte[4096];
                while (resourceStream.available() > 0) {
                    int readBytes = resourceStream.read(buffer);
                    outStream.write(buffer, 0, readBytes);
                }
                outStream.flush();
                outStream.close();
                config.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new JvmClasspathRoot(tempFile));
                logger.debug("Added dependency from resources `" + path.path() + "`.");
                return;
            }
            logger.warn("Path to default dependency does not point to existing resource `" + path.path() + "`.");
        });
        javaSourceRoots.foreach((Function1)(JProcedure1 & Serializable)source -> {
            File f = new File((String)source);
            config.add(CLIConfigurationKeys.CONTENT_ROOTS, (Object)new JavaSourceRoot(f, ""));
        });
        config.put(CommonConfigurationKeys.MODULE_NAME, (Object)"main");
        EnvironmentConfigFiles configFiles = EnvironmentConfigFiles.JVM_CONFIG_FILES;
        Disposable disposable = Disposer.newDisposable();
        KotlinCoreEnvironment environment = KotlinCoreEnvironment.createForProduction((Disposable)disposable, (CompilerConfiguration)config, (EnvironmentConfigFiles)configFiles);
        return environment;
    }

    public Seq<DefaultContentRootJarPath> makeEnvironment$default$3() {
        return (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
    }
}

