/*
 * Decompiled with CFR 0.152.
 */
package io.joern.kotlin2cpg.files;

import io.joern.x2cpg.SourceFiles$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class SourceFilesPicker$
implements Serializable {
    private static final Logger logger;
    private static final List<String> SubstringsToFilterFor;
    public static final SourceFilesPicker$ MODULE$;

    private SourceFilesPicker$() {
    }

    static {
        MODULE$ = new SourceFilesPicker$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        SubstringsToFilterFor = (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".idea", "target", "build", "integrationTest", "integrationtest", "androidTest", "sharedTest", "fixtures", "commonTest", "jvmTest", "test"}));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(SourceFilesPicker$.class);
    }

    public boolean shouldFilter(String fileName) {
        boolean containsUnwantedSubstring = SubstringsToFilterFor.exists((Function1 & Serializable)x$0 -> fileName.contains((CharSequence)x$0));
        boolean isAndroidLayoutXml = fileName.endsWith("xml") && (fileName.contains("drawable") || fileName.contains("layout"));
        boolean containsSrcTest = fileName.contains("src/test");
        boolean isSettingsXml = fileName.endsWith("strings.xml");
        boolean containsBenchmarks = fileName.contains("benchmarks");
        boolean isBuildGradle = fileName.endsWith("build.gradle") || fileName.endsWith("build.gradle.kts");
        return containsUnwantedSubstring && !isBuildGradle || isSettingsXml || containsSrcTest || isAndroidLayoutXml || containsBenchmarks;
    }

    private boolean isConfigFile(String fileName) {
        return this.isXmlFile(fileName) || this.isGradleFile(fileName) || this.isKotlinScript(fileName);
    }

    private boolean isXmlFile(String fileName) {
        Seq xmlFileExtensions = (Seq)((SeqOps)new .colon.colon((Object)".xml", (List)Nil$.MODULE$));
        return xmlFileExtensions.exists((Function1 & Serializable)x$0 -> fileName.endsWith((String)x$0));
    }

    private boolean isGradleFile(String fileName) {
        Seq gradleRelatedFiles = (Seq)((SeqOps)new .colon.colon((Object)"build.gradle", (List)new .colon.colon((Object)"settings.gradle", (List)new .colon.colon((Object)"gradle.properties", (List)new .colon.colon((Object)"build.gradle.kts", (List)Nil$.MODULE$)))));
        return gradleRelatedFiles.exists((Function1 & Serializable)x$0 -> fileName.endsWith((String)x$0));
    }

    private boolean isKotlinScript(String fileName) {
        Seq ktsExtensions = (Seq)((SeqOps)new .colon.colon((Object)".kts", (List)Nil$.MODULE$));
        return ktsExtensions.exists((Function1 & Serializable)x$0 -> fileName.endsWith((String)x$0));
    }

    public Seq<String> configFiles(String forDir) {
        Set sourceFileExtensions = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".xml", ".gradle", ".properties", ".kts"}));
        Option option = SourceFiles$.MODULE$.determine$default$3();
        Option option2 = SourceFiles$.MODULE$.determine$default$4();
        Option option3 = SourceFiles$.MODULE$.determine$default$5();
        List sourceFileNames = SourceFiles$.MODULE$.determine(forDir, sourceFileExtensions, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(forDir, sourceFileExtensions, option, option2, option3));
        return sourceFileNames.filter((Function1 & Serializable)fileName -> MODULE$.isConfigFile((String)fileName)).filterNot((Function1 & Serializable)fileName -> {
            String relativized = SourceFiles$.MODULE$.toRelativePath(fileName, forDir);
            boolean willFilter = MODULE$.shouldFilter(relativized);
            if (willFilter) {
                logger.debug("Filtered file at `" + fileName + "`.");
            }
            return willFilter;
        });
    }
}

