/*
 * Decompiled with CFR 0.152.
 */
package io.joern.php2cpg.astcreation;

import io.joern.php2cpg.astcreation.AstCreator$;
import io.joern.php2cpg.astcreation.AstCreator$NameConstants$;
import io.joern.php2cpg.astcreation.AstCreator$TypeConstants$;
import io.joern.php2cpg.astcreation.PhpBuiltins$;
import io.joern.php2cpg.datastructures.ArrayIndexTracker;
import io.joern.php2cpg.datastructures.Scope;
import io.joern.php2cpg.parser.Domain;
import io.joern.php2cpg.parser.Domain$ClassLikeTypes$;
import io.joern.php2cpg.parser.Domain$PhpArg$;
import io.joern.php2cpg.parser.Domain$PhpArrayDimFetchExpr$;
import io.joern.php2cpg.parser.Domain$PhpEncapsed$;
import io.joern.php2cpg.parser.Domain$PhpEncapsedPart$;
import io.joern.php2cpg.parser.Domain$PhpFloat$;
import io.joern.php2cpg.parser.Domain$PhpIfStmt$;
import io.joern.php2cpg.parser.Domain$PhpInt$;
import io.joern.php2cpg.parser.Domain$PhpMethodDecl$;
import io.joern.php2cpg.parser.Domain$PhpNameExpr$;
import io.joern.php2cpg.parser.Domain$PhpOperators$;
import io.joern.php2cpg.parser.Domain$PhpString$;
import io.joern.php2cpg.parser.Domain$PhpUseType$Constant$;
import io.joern.php2cpg.parser.Domain$PhpUseType$Function$;
import io.joern.php2cpg.parser.Domain$PhpVariable$;
import io.joern.x2cpg.Ast;
import io.joern.x2cpg.Ast$;
import io.joern.x2cpg.AstCreatorBase;
import io.joern.x2cpg.Defines$;
import io.joern.x2cpg.datastructures.Global;
import io.joern.x2cpg.utils.NodeBuilders$;
import io.shiftleft.codepropertygraph.generated.nodes.AstNodeNew;
import io.shiftleft.codepropertygraph.generated.nodes.Call;
import io.shiftleft.codepropertygraph.generated.nodes.ExpressionBase;
import io.shiftleft.codepropertygraph.generated.nodes.ExpressionNew;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewCall;
import io.shiftleft.codepropertygraph.generated.nodes.NewCall$;
import io.shiftleft.codepropertygraph.generated.nodes.NewClosureBinding;
import io.shiftleft.codepropertygraph.generated.nodes.NewClosureBinding$;
import io.shiftleft.codepropertygraph.generated.nodes.NewControlStructure;
import io.shiftleft.codepropertygraph.generated.nodes.NewControlStructure$;
import io.shiftleft.codepropertygraph.generated.nodes.NewFieldIdentifier;
import io.shiftleft.codepropertygraph.generated.nodes.NewIdentifier;
import io.shiftleft.codepropertygraph.generated.nodes.NewIdentifier$;
import io.shiftleft.codepropertygraph.generated.nodes.NewImport;
import io.shiftleft.codepropertygraph.generated.nodes.NewImport$;
import io.shiftleft.codepropertygraph.generated.nodes.NewJumpLabel;
import io.shiftleft.codepropertygraph.generated.nodes.NewJumpLabel$;
import io.shiftleft.codepropertygraph.generated.nodes.NewJumpTarget;
import io.shiftleft.codepropertygraph.generated.nodes.NewJumpTarget$;
import io.shiftleft.codepropertygraph.generated.nodes.NewLiteral$;
import io.shiftleft.codepropertygraph.generated.nodes.NewLocal;
import io.shiftleft.codepropertygraph.generated.nodes.NewLocal$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMember;
import io.shiftleft.codepropertygraph.generated.nodes.NewMember$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodParameterIn;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodParameterIn$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodRef;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodRef$;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethodReturn$;
import io.shiftleft.codepropertygraph.generated.nodes.NewNamespaceBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewNamespaceBlock$;
import io.shiftleft.codepropertygraph.generated.nodes.NewNode;
import io.shiftleft.codepropertygraph.generated.nodes.NewReturn;
import io.shiftleft.codepropertygraph.generated.nodes.NewReturn$;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeDecl;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeDecl$;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeRef;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeRef$;
import io.shiftleft.passes.IntervalKeyPool;
import io.shiftleft.semanticcpg.language.types.structure.NamespaceTraversal$;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import overflowdb.DetachedNodeData;
import overflowdb.NodeOrDetachedNode;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.NotImplementedError;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SetOps;
import scala.collection.StrictOptimizedIterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class AstCreator
extends AstCreatorBase {
    private final String filename;
    private final Domain.PhpFile phpAst;
    private final Global global;
    private final Logger logger;
    private final Scope scope;
    private final IntervalKeyPool tmpKeyPool;

    public static Map<String, String> operatorSymbols() {
        return AstCreator$.MODULE$.operatorSymbols();
    }

    public AstCreator(String filename, Domain.PhpFile phpAst, Global global) {
        this.filename = filename;
        this.phpAst = phpAst;
        this.global = global;
        super(filename);
        this.logger = LoggerFactory.getLogger(AstCreator$.MODULE$.getClass());
        this.scope = new Scope();
        this.tmpKeyPool = new IntervalKeyPool(0L, Long.MAX_VALUE);
    }

    private String getNewTmpName(String prefix) {
        return new StringBuilder(0).append(prefix).append(BoxesRunTime.boxToLong((long)this.tmpKeyPool.next()).toString()).toString();
    }

    private String getNewTmpName$default$1() {
        return "tmp";
    }

    public BatchedUpdate.DiffGraphBuilder createAst() {
        Ast ast = this.astForPhpFile(this.phpAst);
        Ast$.MODULE$.storeInDiffGraph(ast, this.diffGraph());
        return this.diffGraph();
    }

    private Ast expectSingle(List<Ast> asts) {
        List<Ast> list = asts;
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Ast> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            this.logger.warn(new StringBuilder(51).append("expectSingle found no asts. Returning emtpy AST in ").append(this.filename).toString());
            return Ast$.MODULE$.apply();
        }
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            Ast ast = (Ast)colon2.head();
            List list3 = colon2.next$access$1();
            Ast single = ast;
            Nil$ nil$2 = package$.MODULE$.Nil();
            List list4 = list3;
            if (!(nil$2 != null ? !nil$2.equals(list4) : list4 != null)) {
                return single;
            }
            Ast head = ast;
            this.logger.warn(new StringBuilder(54).append("expectSingle found multiple astas. Returning first in ").append(this.filename).toString());
            return head;
        }
        throw new MatchError(list);
    }

    private String registerType(String typ) {
        this.global.usedTypes().putIfAbsent(typ, BoxesRunTime.boxToBoolean((boolean)true));
        return typ;
    }

    private Ast astForPhpFile(Domain.PhpFile file) {
        NewNamespaceBlock namespaceBlock = this.globalNamespaceBlock().filename(this.absolutePath(this.filename));
        this.scope.pushNewScope((NewNode)namespaceBlock);
        NewTypeDecl globalTypeDecl = NewTypeDecl$.MODULE$.apply().name(namespaceBlock.name()).fullName(namespaceBlock.name()).astParentFullName(namespaceBlock.fullName()).code(namespaceBlock.code()).filename(this.filename);
        this.scope.pushNewScope((NewNode)globalTypeDecl);
        NewMethod globalMethod = NewMethod$.MODULE$.apply().name(globalTypeDecl.name()).fullName(globalTypeDecl.fullName()).astParentFullName(globalTypeDecl.fullName()).code(globalTypeDecl.code());
        this.scope.pushNewScope((NewNode)globalMethod);
        Tuple2 tuple2 = file.children().partition((Function1 & Serializable)_$1 -> _$1 instanceof Domain.PhpConstStmt);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Seq fileConsts = (Seq)tuple2._1();
        Seq otherStmts = (Seq)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)fileConsts, (Object)otherStmts);
        Seq fileConsts2 = (Seq)tuple22._1();
        Seq otherStmts2 = (Seq)tuple22._2();
        Seq constAsts = (Seq)fileConsts2.flatMap((Function1 & Serializable)fc -> this.astsForConstStmt((Domain.PhpConstStmt)fc));
        Seq methodChildren = (Seq)otherStmts2.map((Function1 & Serializable)stmt -> this.astForStmt((Domain.PhpStmt)stmt));
        Option<Ast> clinitAst = this.astForStaticAndConstInits();
        List<Ast> closureMethodAsts = this.scope.getAndClearAnonymousMethods();
        this.scope.popScope();
        this.scope.popScope();
        this.scope.popScope();
        Ast globalMethodAst = Ast$.MODULE$.apply((NewNode)globalMethod).withChild(Ast$.MODULE$.apply((NewNode)NewBlock$.MODULE$.apply()).withChildren((scala.collection.Seq)methodChildren)).withChild(Ast$.MODULE$.apply((NewNode)NewMethodReturn$.MODULE$.apply()));
        Ast globalTypeDeclAst = Ast$.MODULE$.apply((NewNode)globalTypeDecl).withChildren((scala.collection.Seq)constAsts).withChildren((scala.collection.Seq)clinitAst.toList()).withChildren(closureMethodAsts).withChild(globalMethodAst);
        return Ast$.MODULE$.apply((NewNode)namespaceBlock).withChild(globalTypeDeclAst);
    }

    private Ast astForStmt(Domain.PhpStmt stmt) {
        Domain.PhpStmt phpStmt = stmt;
        if (phpStmt instanceof Domain.PhpEchoStmt) {
            Domain.PhpEchoStmt echoStmt = (Domain.PhpEchoStmt)phpStmt;
            return this.astForEchoStmt(echoStmt);
        }
        if (phpStmt instanceof Domain.PhpMethodDecl) {
            Domain.PhpMethodDecl methodDecl = (Domain.PhpMethodDecl)phpStmt;
            return this.astForMethodDecl(methodDecl, this.astForMethodDecl$default$2(), this.astForMethodDecl$default$3());
        }
        if (phpStmt instanceof Domain.PhpExpr) {
            Domain.PhpExpr expr = (Domain.PhpExpr)phpStmt;
            return this.astForExpr(expr);
        }
        if (phpStmt instanceof Domain.PhpBreakStmt) {
            Domain.PhpBreakStmt breakStmt = (Domain.PhpBreakStmt)phpStmt;
            return this.astForBreakStmt(breakStmt);
        }
        if (phpStmt instanceof Domain.PhpContinueStmt) {
            Domain.PhpContinueStmt contStmt = (Domain.PhpContinueStmt)phpStmt;
            return this.astForContinueStmt(contStmt);
        }
        if (phpStmt instanceof Domain.PhpWhileStmt) {
            Domain.PhpWhileStmt whileStmt = (Domain.PhpWhileStmt)phpStmt;
            return this.astForWhileStmt(whileStmt);
        }
        if (phpStmt instanceof Domain.PhpDoStmt) {
            Domain.PhpDoStmt doStmt = (Domain.PhpDoStmt)phpStmt;
            return this.astForDoStmt(doStmt);
        }
        if (phpStmt instanceof Domain.PhpForStmt) {
            Domain.PhpForStmt forStmt = (Domain.PhpForStmt)phpStmt;
            return this.astForForStmt(forStmt);
        }
        if (phpStmt instanceof Domain.PhpIfStmt) {
            Domain.PhpIfStmt ifStmt = (Domain.PhpIfStmt)phpStmt;
            return this.astForIfStmt(ifStmt);
        }
        if (phpStmt instanceof Domain.PhpSwitchStmt) {
            Domain.PhpSwitchStmt switchStmt = (Domain.PhpSwitchStmt)phpStmt;
            return this.astForSwitchStmt(switchStmt);
        }
        if (phpStmt instanceof Domain.PhpTryStmt) {
            Domain.PhpTryStmt tryStmt = (Domain.PhpTryStmt)phpStmt;
            return this.astForTryStmt(tryStmt);
        }
        if (phpStmt instanceof Domain.PhpReturnStmt) {
            Domain.PhpReturnStmt returnStmt = (Domain.PhpReturnStmt)phpStmt;
            return this.astForReturnStmt(returnStmt);
        }
        if (phpStmt instanceof Domain.PhpClassLikeStmt) {
            Domain.PhpClassLikeStmt classLikeStmt = (Domain.PhpClassLikeStmt)phpStmt;
            return this.astForClassLikeStmt(classLikeStmt);
        }
        if (phpStmt instanceof Domain.PhpGotoStmt) {
            Domain.PhpGotoStmt gotoStmt = (Domain.PhpGotoStmt)phpStmt;
            return this.astForGotoStmt(gotoStmt);
        }
        if (phpStmt instanceof Domain.PhpLabelStmt) {
            Domain.PhpLabelStmt labelStmt = (Domain.PhpLabelStmt)phpStmt;
            return this.astForLabelStmt(labelStmt);
        }
        if (phpStmt instanceof Domain.PhpNamespaceStmt) {
            Domain.PhpNamespaceStmt namespace = (Domain.PhpNamespaceStmt)phpStmt;
            return this.astForNamespaceStmt(namespace);
        }
        if (phpStmt instanceof Domain.PhpDeclareStmt) {
            Domain.PhpDeclareStmt declareStmt = (Domain.PhpDeclareStmt)phpStmt;
            return this.astForDeclareStmt(declareStmt);
        }
        if (phpStmt instanceof Domain.NopStmt) {
            return Ast$.MODULE$.apply();
        }
        if (phpStmt instanceof Domain.PhpHaltCompilerStmt) {
            Domain.PhpHaltCompilerStmt haltStmt = (Domain.PhpHaltCompilerStmt)phpStmt;
            return this.astForHaltCompilerStmt(haltStmt);
        }
        if (phpStmt instanceof Domain.PhpUnsetStmt) {
            Domain.PhpUnsetStmt unsetStmt = (Domain.PhpUnsetStmt)phpStmt;
            return this.astForUnsetStmt(unsetStmt);
        }
        if (phpStmt instanceof Domain.PhpGlobalStmt) {
            Domain.PhpGlobalStmt globalStmt = (Domain.PhpGlobalStmt)phpStmt;
            return this.astForGlobalStmt(globalStmt);
        }
        if (phpStmt instanceof Domain.PhpUseStmt) {
            Domain.PhpUseStmt useStmt = (Domain.PhpUseStmt)phpStmt;
            return this.astForUseStmt(useStmt);
        }
        if (phpStmt instanceof Domain.PhpGroupUseStmt) {
            Domain.PhpGroupUseStmt groupUseStmt = (Domain.PhpGroupUseStmt)phpStmt;
            return this.astForGroupUseStmt(groupUseStmt);
        }
        if (phpStmt instanceof Domain.PhpForeachStmt) {
            Domain.PhpForeachStmt foreachStmt = (Domain.PhpForeachStmt)phpStmt;
            return this.astForForeachStmt(foreachStmt);
        }
        if (phpStmt instanceof Domain.PhpTraitUseStmt) {
            Domain.PhpTraitUseStmt traitUseStmt = (Domain.PhpTraitUseStmt)phpStmt;
            return this.astforTraitUseStmt(traitUseStmt);
        }
        if (phpStmt instanceof Domain.PhpStaticStmt) {
            Domain.PhpStaticStmt staticStmt = (Domain.PhpStaticStmt)phpStmt;
            return Ast$.MODULE$.apply().withChildren(this.astsForStaticStmt(staticStmt));
        }
        Domain.PhpStmt unhandled = phpStmt;
        this.logger.error(new StringBuilder(19).append("Unhandled stmt ").append(unhandled).append(" in ").append(this.filename).toString());
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private Ast astForEchoStmt(Domain.PhpEchoStmt echoStmt) {
        Seq args = (Seq)echoStmt.exprs().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        String code = new StringBuilder(5).append("echo ").append(((IterableOnceOps)args.map((Function1 & Serializable)_$2 -> this.rootCode((Ast)_$2, this.rootCode$default$2()))).mkString(",")).toString();
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(echoStmt);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode("echo", code, option2, option, option3);
        return this.callAst(callNode, args, this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast thisParamAstForMethod(Option<Integer> lineNumber) {
        String typeFullName = (String)this.scope.getEnclosingTypeDeclType().getOrElse(AstCreator::$anonfun$6);
        NewMethodParameterIn thisNode = NewMethodParameterIn$.MODULE$.apply().name(AstCreator$NameConstants$.MODULE$.This()).code(AstCreator$NameConstants$.MODULE$.This()).evaluationStrategy("BY_SHARING").typeFullName(typeFullName).dynamicTypeHintFullName((IterableOnce)package$.MODULE$.Nil().$colon$colon((Object)typeFullName)).lineNumber(lineNumber).index(0);
        this.scope.addToScope(AstCreator$NameConstants$.MODULE$.This(), (NewNode)thisNode);
        return Ast$.MODULE$.apply((NewNode)thisNode);
    }

    private NewIdentifier thisIdentifier(Option<Integer> lineNumber) {
        Option<String> typ = this.scope.getEnclosingTypeDeclType();
        String string = AstCreator$NameConstants$.MODULE$.This();
        List list = typ.toList();
        Option option = NodeBuilders$.MODULE$.identifierNode$default$4();
        return NodeBuilders$.MODULE$.identifierNode(string, typ, lineNumber, option, (Seq)list).code(new StringBuilder(1).append("$").append(AstCreator$NameConstants$.MODULE$.This()).toString());
    }

    private Seq<Ast> setParamIndices(Seq<Ast> asts) {
        ((IterableOnceOps)((IterableOps)asts.map((Function1 & Serializable)_$3 -> _$3.root())).zipWithIndex()).foreach((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                NewNode newNode;
                Option option = (Option)tuple2._1();
                if (option instanceof Some && (newNode = (NewNode)((Some)option).value()) instanceof NewMethodParameterIn) {
                    NewMethodParameterIn root = (NewMethodParameterIn)newNode;
                    int idx = BoxesRunTime.unboxToInt((Object)tuple2._2());
                    return root.index(idx + 1);
                }
                Option root = option;
                this.logger.warn(new StringBuilder(41).append("Trying to set index for unsupported node ").append(root).toString());
                return BoxedUnit.UNIT;
            }
            throw new MatchError((Object)tuple2);
        });
        return asts;
    }

    private Ast astForMethodDecl(Domain.PhpMethodDecl decl, List<Ast> bodyPrefixAsts, Option<String> fullNameOverride) {
        String string;
        String namespacePrefix = this.getNamespacePrefixForName();
        String signature = new StringBuilder(2).append(Defines$.MODULE$.UnresolvedSignature()).append("(").append(decl.params().size()).append(")").toString();
        String fullName = (String)fullNameOverride.getOrElse(() -> AstCreator.$anonfun$7(decl, namespacePrefix, signature));
        List modifiers = decl.modifiers().map((Function1 & Serializable)modifierType -> NodeBuilders$.MODULE$.modifierNode(modifierType));
        None$ thisParam = decl.isClassMethod() && !modifiers.exists((Function1 & Serializable)_$4 -> {
            String string = _$4.modifierType();
            String string2 = "STATIC";
            return !(string != null ? !string.equals(string2) : string2 != null);
        }) ? Some$.MODULE$.apply((Object)this.thisParamAstForMethod(this.io$joern$php2cpg$astcreation$AstCreator$$line(decl))) : None$.MODULE$;
        List parameters = (List)thisParam.toList().$plus$plus(this.setParamIndices((Seq<Ast>)((Seq)decl.params().map((Function1 & Serializable)param -> this.astForParam((Domain.PhpParam)param)))));
        List<String> list = decl.modifiers();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<String> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            string = "";
        } else {
            List<String> modifiers2 = list;
            string = new StringBuilder(1).append(modifiers2.mkString(" ")).append(" ").toString();
        }
        String modifierString = string;
        String methodCode = new StringBuilder(11).append(modifierString).append("function ").append(decl.name().name()).append("(").append(parameters.map((Function1 & Serializable)_$5 -> this.rootCode((Ast)_$5, this.rootCode$default$2())).mkString(",")).append(")").toString();
        NewMethod methodNode = NewMethod$.MODULE$.apply().name(decl.name().name()).fullName(fullName).signature(signature).code(methodCode).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(decl)).isExternal(false);
        this.scope.pushNewScope((NewNode)methodNode);
        String returnType = (String)decl.returnType().map((Function1 & Serializable)_$6 -> _$6.name()).getOrElse(AstCreator::$anonfun$13);
        List methodBodyStmts = (List)bodyPrefixAsts.$plus$plus((IterableOnce)decl.stmts().flatMap((Function1 & Serializable)x$1 -> {
            Domain.PhpStmt phpStmt = x$1;
            if (phpStmt instanceof Domain.PhpStaticStmt) {
                Domain.PhpStaticStmt staticStmt = (Domain.PhpStaticStmt)phpStmt;
                return this.astsForStaticStmt(staticStmt);
            }
            Domain.PhpStmt stmt = phpStmt;
            Ast ast = this.astForStmt(stmt);
            return package$.MODULE$.Nil().$colon$colon((Object)ast);
        }));
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(decl);
        None$ none$ = None$.MODULE$;
        Option option2 = this.methodReturnNode$default$2();
        NewMethodReturn methodReturn = this.methodReturnNode(returnType, option2, option, (Option)none$).code("RET");
        List declLocals = this.scope.getLocalsInScope().map((Function1 & Serializable)_$7 -> Ast$.MODULE$.apply((NewNode)_$7));
        Ast methodBody = this.blockAst(NewBlock$.MODULE$.apply(), (List)declLocals.$plus$plus((IterableOnce)methodBodyStmts));
        this.scope.popScope();
        return this.methodAstWithAnnotations(methodNode, (Seq)parameters, methodBody, methodReturn, (Seq)modifiers, this.methodAstWithAnnotations$default$6());
    }

    private List<Ast> astForMethodDecl$default$2() {
        return package$.MODULE$.Nil();
    }

    private Option<String> astForMethodDecl$default$3() {
        return None$.MODULE$;
    }

    private Ast stmtBlockAst(Seq<Domain.PhpStmt> stmts, Option<Integer> lineNumber) {
        NewBlock bodyBlock = NewBlock$.MODULE$.apply().lineNumber(lineNumber);
        Seq bodyStmtAsts = (Seq)stmts.map((Function1 & Serializable)stmt -> this.astForStmt((Domain.PhpStmt)stmt));
        return Ast$.MODULE$.apply((NewNode)bodyBlock).withChildren((scala.collection.Seq)bodyStmtAsts);
    }

    private Ast astForParam(Domain.PhpParam param) {
        String evaluationStrategy = param.byRef() ? "BY_REFERENCE" : "BY_VALUE";
        String typeFullName = (String)param.paramType().map((Function1 & Serializable)_$8 -> _$8.name()).getOrElse(AstCreator::$anonfun$18);
        String byRefCodePrefix = param.byRef() ? "&" : "";
        String code = new StringBuilder(1).append(byRefCodePrefix).append("$").append(param.name()).toString();
        NewMethodParameterIn paramNode = NewMethodParameterIn$.MODULE$.apply().name(param.name()).code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(param)).isVariadic(param.isVariadic()).evaluationStrategy(evaluationStrategy).typeFullName(typeFullName);
        this.scope.addToScope(param.name(), (NewNode)paramNode);
        return Ast$.MODULE$.apply((NewNode)paramNode);
    }

    private Ast astForExpr(Domain.PhpExpr expr) {
        Domain.PhpExpr phpExpr = expr;
        if (phpExpr instanceof Domain.PhpCallExpr) {
            Domain.PhpCallExpr funcCallExpr = (Domain.PhpCallExpr)phpExpr;
            return this.astForCall(funcCallExpr);
        }
        if (phpExpr instanceof Domain.PhpVariable) {
            Domain.PhpVariable variableExpr = (Domain.PhpVariable)phpExpr;
            return this.astForVariableExpr(variableExpr);
        }
        if (phpExpr instanceof Domain.PhpNameExpr) {
            Domain.PhpNameExpr nameExpr = (Domain.PhpNameExpr)phpExpr;
            return this.astForNameExpr(nameExpr);
        }
        if (phpExpr instanceof Domain.PhpAssignment) {
            Domain.PhpAssignment assignExpr = (Domain.PhpAssignment)phpExpr;
            return this.astForAssignment(assignExpr);
        }
        if (phpExpr instanceof Domain.PhpScalar) {
            Domain.PhpScalar scalarExpr = (Domain.PhpScalar)phpExpr;
            return this.astForScalar(scalarExpr);
        }
        if (phpExpr instanceof Domain.PhpBinaryOp) {
            Domain.PhpBinaryOp binaryOp = (Domain.PhpBinaryOp)phpExpr;
            return this.astForBinOp(binaryOp);
        }
        if (phpExpr instanceof Domain.PhpUnaryOp) {
            Domain.PhpUnaryOp unaryOp = (Domain.PhpUnaryOp)phpExpr;
            return this.astForUnaryOp(unaryOp);
        }
        if (phpExpr instanceof Domain.PhpCast) {
            Domain.PhpCast castExpr = (Domain.PhpCast)phpExpr;
            return this.astForCastExpr(castExpr);
        }
        if (phpExpr instanceof Domain.PhpIsset) {
            Domain.PhpIsset issetExpr = (Domain.PhpIsset)phpExpr;
            return this.astForIssetExpr(issetExpr);
        }
        if (phpExpr instanceof Domain.PhpPrint) {
            Domain.PhpPrint printExpr = (Domain.PhpPrint)phpExpr;
            return this.astForPrintExpr(printExpr);
        }
        if (phpExpr instanceof Domain.PhpTernaryOp) {
            Domain.PhpTernaryOp ternaryOp = (Domain.PhpTernaryOp)phpExpr;
            return this.astForTernaryOp(ternaryOp);
        }
        if (phpExpr instanceof Domain.PhpThrowExpr) {
            Domain.PhpThrowExpr throwExpr = (Domain.PhpThrowExpr)phpExpr;
            return this.astForThrow(throwExpr);
        }
        if (phpExpr instanceof Domain.PhpCloneExpr) {
            Domain.PhpCloneExpr cloneExpr = (Domain.PhpCloneExpr)phpExpr;
            return this.astForClone(cloneExpr);
        }
        if (phpExpr instanceof Domain.PhpEmptyExpr) {
            Domain.PhpEmptyExpr emptyExpr = (Domain.PhpEmptyExpr)phpExpr;
            return this.astForEmpty(emptyExpr);
        }
        if (phpExpr instanceof Domain.PhpEvalExpr) {
            Domain.PhpEvalExpr evalExpr = (Domain.PhpEvalExpr)phpExpr;
            return this.astForEval(evalExpr);
        }
        if (phpExpr instanceof Domain.PhpExitExpr) {
            Domain.PhpExitExpr exitExpr = (Domain.PhpExitExpr)phpExpr;
            return this.astForExit(exitExpr);
        }
        if (phpExpr instanceof Domain.PhpArrayExpr) {
            Domain.PhpArrayExpr arrayExpr = (Domain.PhpArrayExpr)phpExpr;
            return this.astForArrayExpr(arrayExpr);
        }
        if (phpExpr instanceof Domain.PhpListExpr) {
            Domain.PhpListExpr listExpr = (Domain.PhpListExpr)phpExpr;
            return this.astForListExpr(listExpr);
        }
        if (phpExpr instanceof Domain.PhpNewExpr) {
            Domain.PhpNewExpr newExpr = (Domain.PhpNewExpr)phpExpr;
            return this.astForNewExpr(newExpr);
        }
        if (phpExpr instanceof Domain.PhpMatchExpr) {
            Domain.PhpMatchExpr matchExpr = (Domain.PhpMatchExpr)phpExpr;
            return this.astForMatchExpr(matchExpr);
        }
        if (phpExpr instanceof Domain.PhpYieldExpr) {
            Domain.PhpYieldExpr yieldExpr = (Domain.PhpYieldExpr)phpExpr;
            return this.astForYieldExpr(yieldExpr);
        }
        if (phpExpr instanceof Domain.PhpClosureExpr) {
            Domain.PhpClosureExpr closure = (Domain.PhpClosureExpr)phpExpr;
            return this.astForClosureExpr(closure);
        }
        if (phpExpr instanceof Domain.PhpYieldFromExpr) {
            Domain.PhpYieldFromExpr yieldFromExpr = (Domain.PhpYieldFromExpr)phpExpr;
            return this.astForYieldFromExpr(yieldFromExpr);
        }
        if (phpExpr instanceof Domain.PhpClassConstFetchExpr) {
            Domain.PhpClassConstFetchExpr classConstFetchExpr = (Domain.PhpClassConstFetchExpr)phpExpr;
            return this.astForClassConstFetchExpr(classConstFetchExpr);
        }
        if (phpExpr instanceof Domain.PhpConstFetchExpr) {
            Domain.PhpConstFetchExpr constFetchExpr = (Domain.PhpConstFetchExpr)phpExpr;
            return this.astForConstFetchExpr(constFetchExpr);
        }
        if (phpExpr instanceof Domain.PhpArrayDimFetchExpr) {
            Domain.PhpArrayDimFetchExpr arrayDimFetchExpr = (Domain.PhpArrayDimFetchExpr)phpExpr;
            return this.astForArrayDimFetchExpr(arrayDimFetchExpr);
        }
        if (phpExpr instanceof Domain.PhpErrorSuppressExpr) {
            Domain.PhpErrorSuppressExpr errorSuppressExpr = (Domain.PhpErrorSuppressExpr)phpExpr;
            return this.astForErrorSuppressExpr(errorSuppressExpr);
        }
        if (phpExpr instanceof Domain.PhpInstanceOfExpr) {
            Domain.PhpInstanceOfExpr instanceOfExpr = (Domain.PhpInstanceOfExpr)phpExpr;
            return this.astForInstanceOfExpr(instanceOfExpr);
        }
        if (phpExpr instanceof Domain.PhpPropertyFetchExpr) {
            Domain.PhpPropertyFetchExpr propertyFetchExpr = (Domain.PhpPropertyFetchExpr)phpExpr;
            return this.astForPropertyFetchExpr(propertyFetchExpr);
        }
        if (phpExpr instanceof Domain.PhpIncludeExpr) {
            Domain.PhpIncludeExpr includeExpr = (Domain.PhpIncludeExpr)phpExpr;
            return this.astForIncludeExpr(includeExpr);
        }
        if (phpExpr instanceof Domain.PhpShellExecExpr) {
            Domain.PhpShellExecExpr shellExecExpr = (Domain.PhpShellExecExpr)phpExpr;
            return this.astForShellExecExpr(shellExecExpr);
        }
        if (phpExpr == null) {
            this.logger.warn("expr was null");
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        Domain.PhpExpr other = phpExpr;
        throw new NotImplementedError(new StringBuilder(32).append("unexpected expession '").append(other).append("' of type ").append(other.getClass()).toString());
    }

    private Ast intToLiteralAst(int num) {
        return Ast$.MODULE$.apply((NewNode)NewLiteral$.MODULE$.apply().code(BoxesRunTime.boxToInteger((int)num).toString()).typeFullName(AstCreator$TypeConstants$.MODULE$.Int()));
    }

    private Ast astForBreakStmt(Domain.PhpBreakStmt breakStmt) {
        String code = (String)breakStmt.num().map((Function1 & Serializable)num -> AstCreator.$anonfun$19(BoxesRunTime.unboxToInt((Object)num))).getOrElse(AstCreator::$anonfun$20);
        NewControlStructure breakNode = NewControlStructure$.MODULE$.apply().controlStructureType("BREAK").code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(breakStmt));
        Option argument = breakStmt.num().map((Function1 & Serializable)num -> this.$anonfun$21(BoxesRunTime.unboxToInt((Object)num)));
        return this.controlStructureAst(breakNode, (Option)None$.MODULE$, argument.toList(), this.controlStructureAst$default$4());
    }

    private Ast astForContinueStmt(Domain.PhpContinueStmt continueStmt) {
        String code = (String)continueStmt.num().map((Function1 & Serializable)num -> AstCreator.$anonfun$22(BoxesRunTime.unboxToInt((Object)num))).getOrElse(AstCreator::$anonfun$23);
        NewControlStructure continueNode = NewControlStructure$.MODULE$.apply().controlStructureType("CONTINUE").code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(continueStmt));
        Option argument = continueStmt.num().map((Function1 & Serializable)num -> this.$anonfun$24(BoxesRunTime.unboxToInt((Object)num)));
        return this.controlStructureAst(continueNode, (Option)None$.MODULE$, argument.toList(), this.controlStructureAst$default$4());
    }

    private Ast astForWhileStmt(Domain.PhpWhileStmt whileStmt) {
        Ast condition = this.astForExpr(whileStmt.cond());
        NewControlStructure whileNode = NewControlStructure$.MODULE$.apply().controlStructureType("WHILE").code(new StringBuilder(8).append("while (").append(this.rootCode(condition, this.rootCode$default$2())).append(")").toString()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(whileStmt));
        Ast body = this.stmtBlockAst((Seq<Domain.PhpStmt>)whileStmt.stmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line(whileStmt));
        return this.controlStructureAst(whileNode, (Option)Some$.MODULE$.apply((Object)condition), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[]{body})), this.controlStructureAst$default$4());
    }

    private Ast astForDoStmt(Domain.PhpDoStmt doStmt) {
        Ast condition = this.astForExpr(doStmt.cond());
        NewControlStructure whileNode = NewControlStructure$.MODULE$.apply().controlStructureType("DO").code(new StringBuilder(17).append("do {...} while (").append(this.rootCode(condition, this.rootCode$default$2())).append(")").toString()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(doStmt));
        Ast body = this.stmtBlockAst((Seq<Domain.PhpStmt>)doStmt.stmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line(doStmt));
        return this.controlStructureAst(whileNode, (Option)Some$.MODULE$.apply((Object)condition), (List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[]{body})), true);
    }

    private Ast astForForStmt(Domain.PhpForStmt stmt) {
        Option<Integer> lineNumber = this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt);
        List initAsts = stmt.inits().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        List conditionAsts = stmt.conditions().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        List loopExprAsts = stmt.loopExprs().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        Ast bodyAst = this.stmtBlockAst((Seq<Domain.PhpStmt>)stmt.bodyStmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        String initCode = initAsts.map((Function1 & Serializable)_$9 -> this.rootCode((Ast)_$9, this.rootCode$default$2())).mkString(",");
        String conditionCode = conditionAsts.map((Function1 & Serializable)_$10 -> this.rootCode((Ast)_$10, this.rootCode$default$2())).mkString(",");
        String loopExprCode = loopExprAsts.map((Function1 & Serializable)_$11 -> this.rootCode((Ast)_$11, this.rootCode$default$2())).mkString(",");
        String forCode = new StringBuilder(8).append("for (").append(initCode).append(";").append(conditionCode).append(";").append(loopExprCode).append(")").toString();
        NewControlStructure forNode = NewControlStructure$.MODULE$.apply().controlStructureType("FOR").lineNumber(lineNumber).code(forCode);
        return this.forAst(forNode, (Seq)package$.MODULE$.Nil(), (Seq)initAsts, (Seq)conditionAsts, (Seq)loopExprAsts, bodyAst);
    }

    private Ast astForIfStmt(Domain.PhpIfStmt ifStmt) {
        List list;
        Ast condition = this.astForExpr(ifStmt.cond());
        Ast thenAst = this.stmtBlockAst((Seq<Domain.PhpStmt>)ifStmt.stmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line(ifStmt));
        List<Domain.PhpElseIfStmt> list2 = ifStmt.elseIfs();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Domain.PhpElseIfStmt> list3 = list2;
        if (!(nil$ != null ? !nil$.equals(list3) : list3 != null)) {
            list = ifStmt.elseStmt().map((Function1 & Serializable)els -> this.stmtBlockAst((Seq<Domain.PhpStmt>)els.stmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line((Domain.PhpNode)els))).toList();
        } else if (list2 instanceof .colon.colon) {
            List wrappedAst;
            .colon.colon colon2 = (.colon.colon)list2;
            List list4 = colon2.next$access$1();
            Domain.PhpElseIfStmt elseIf = (Domain.PhpElseIfStmt)colon2.head();
            List rest = list4;
            Domain.PhpIfStmt newIfStmt = Domain$PhpIfStmt$.MODULE$.apply(elseIf.cond(), elseIf.stmts(), (List<Domain.PhpElseIfStmt>)rest, ifStmt.elseStmt(), elseIf.attributes());
            NewBlock wrappingBlock = NewBlock$.MODULE$.apply().lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(elseIf));
            Ast ast = Ast$.MODULE$.apply((NewNode)wrappingBlock).withChild(this.astForIfStmt(newIfStmt));
            list = wrappedAst = package$.MODULE$.Nil().$colon$colon((Object)ast);
        } else {
            throw new MatchError(list2);
        }
        List elseAst = list;
        String conditionCode = this.rootCode(condition, this.rootCode$default$2());
        NewControlStructure ifNode = NewControlStructure$.MODULE$.apply().controlStructureType("IF").code(new StringBuilder(5).append("if (").append(conditionCode).append(")").toString()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(ifStmt));
        return this.controlStructureAst(ifNode, (Option)Some$.MODULE$.apply((Object)condition), elseAst.$colon$colon((Object)thenAst), this.controlStructureAst$default$4());
    }

    private Ast astForSwitchStmt(Domain.PhpSwitchStmt stmt) {
        Ast conditionAst = this.astForExpr(stmt.condition());
        NewControlStructure switchNode = NewControlStructure$.MODULE$.apply().controlStructureType("SWITCH").code(new StringBuilder(9).append("switch (").append(this.rootCode(conditionAst, this.rootCode$default$2())).append(")").toString()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        NewBlock switchBodyBlock = NewBlock$.MODULE$.apply().lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        List entryAsts = stmt.cases().flatMap((Function1 & Serializable)caseStmt -> this.astsForSwitchCase((Domain.PhpCaseStmt)caseStmt));
        Ast switchBody = Ast$.MODULE$.apply((NewNode)switchBodyBlock).withChildren((scala.collection.Seq)entryAsts);
        return this.controlStructureAst(switchNode, (Option)Some$.MODULE$.apply((Object)conditionAst), package$.MODULE$.Nil().$colon$colon((Object)switchBody), this.controlStructureAst$default$4());
    }

    private Ast astForTryStmt(Domain.PhpTryStmt stmt2) {
        Ast tryBody = this.stmtBlockAst((Seq<Domain.PhpStmt>)stmt2.stmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt2));
        List catches = stmt2.catches().map((Function1 & Serializable)stmt -> this.astForCatchStmt((Domain.PhpCatchStmt)stmt));
        Option finallyBody = stmt2.finallyStmt().map((Function1 & Serializable)fin -> this.stmtBlockAst((Seq<Domain.PhpStmt>)fin.stmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line((Domain.PhpNode)fin)));
        NewControlStructure tryNode = NewControlStructure$.MODULE$.apply().controlStructureType("TRY").code("TODO").lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt2));
        return this.tryCatchAst(tryNode, tryBody, (Seq)catches, finallyBody);
    }

    private Ast astForReturnStmt(Domain.PhpReturnStmt stmt) {
        Option maybeExprAst = stmt.expr().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        String code = new StringBuilder(7).append("return ").append(maybeExprAst.map((Function1 & Serializable)_$12 -> this.rootCode((Ast)_$12, this.rootCode$default$2())).getOrElse(AstCreator::$anonfun$37)).toString();
        NewReturn returnNode = NewReturn$.MODULE$.apply().code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        return this.returnAst(returnNode, (Seq)maybeExprAst.toList());
    }

    private Ast astForClassLikeStmt(Domain.PhpClassLikeStmt stmt) {
        Option<Domain.PhpNameExpr> option = stmt.name();
        if (None$.MODULE$.equals(option)) {
            return this.astForAnonymousClass(stmt);
        }
        if (option instanceof Some) {
            Domain.PhpNameExpr name = (Domain.PhpNameExpr)((Some)option).value();
            return this.astForNamedClass(stmt, name);
        }
        throw new MatchError(option);
    }

    private Ast astForGotoStmt(Domain.PhpGotoStmt stmt) {
        String label = stmt.label().name();
        String code = new StringBuilder(5).append("goto ").append(label).toString();
        NewControlStructure gotoNode = NewControlStructure$.MODULE$.apply().controlStructureType("GOTO").code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        NewJumpLabel jumpLabel = NewJumpLabel$.MODULE$.apply().name(label).code(label).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        Ast ast = Ast$.MODULE$.apply((NewNode)jumpLabel);
        return this.controlStructureAst(gotoNode, (Option)None$.MODULE$, package$.MODULE$.Nil().$colon$colon((Object)ast), this.controlStructureAst$default$4());
    }

    private Ast astForLabelStmt(Domain.PhpLabelStmt stmt) {
        String label = stmt.label().name();
        NewJumpTarget jumpTarget = NewJumpTarget$.MODULE$.apply().name(label).code(label).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        return Ast$.MODULE$.apply((NewNode)jumpTarget);
    }

    private Ast astForNamespaceStmt(Domain.PhpNamespaceStmt stmt) {
        String name = (String)stmt.name().map((Function1 & Serializable)_$13 -> _$13.name()).getOrElse(AstCreator::$anonfun$39);
        String fullName = new StringBuilder(1).append(this.filename).append(":").append(name).toString();
        NewNamespaceBlock namespaceBlock = NewNamespaceBlock$.MODULE$.apply().name(name).fullName(fullName);
        this.scope.pushNewScope((NewNode)namespaceBlock);
        List<Ast> bodyStmts = this.astsForClassLikeBody(stmt.stmts(), false);
        this.scope.popScope();
        return Ast$.MODULE$.apply((NewNode)namespaceBlock).withChildren(bodyStmts);
    }

    private Ast astForDeclareStmt(Domain.PhpDeclareStmt stmt2) {
        Seq declareAssignAsts = (Seq)stmt2.declares().map((Function1 & Serializable)item -> this.astForDeclareItem((Domain.PhpDeclareItem)item));
        String declareCode = new StringBuilder(2).append(Domain$PhpOperators$.MODULE$.declareFunc()).append("(").append(((IterableOnceOps)declareAssignAsts.map((Function1 & Serializable)_$14 -> this.rootCode((Ast)_$14, this.rootCode$default$2()))).mkString(",")).append(")").toString();
        String string = Domain$PhpOperators$.MODULE$.declareFunc();
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt2);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall declareNode = NodeBuilders$.MODULE$.operatorCallNode(string, declareCode, option2, option, option3);
        Ast declareAst = this.callAst(declareNode, declareAssignAsts, this.callAst$default$3(), this.callAst$default$4());
        Option<List<Domain.PhpStmt>> option4 = stmt2.stmts();
        if (option4 instanceof Some) {
            List stmtList = (List)((Some)option4).value();
            List stmtAsts = stmtList.map((Function1 & Serializable)stmt -> this.astForStmt((Domain.PhpStmt)stmt));
            return Ast$.MODULE$.apply((NewNode)NewBlock$.MODULE$.apply().lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt2))).withChild(declareAst).withChildren((scala.collection.Seq)stmtAsts);
        }
        if (None$.MODULE$.equals(option4)) {
            return declareAst;
        }
        throw new MatchError(option4);
    }

    private Ast astForDeclareItem(Domain.PhpDeclareItem item) {
        NewIdentifier key = NodeBuilders$.MODULE$.identifierNode(item.key().name(), (Option)None$.MODULE$, this.io$joern$php2cpg$astcreation$AstCreator$$line(item), NodeBuilders$.MODULE$.identifierNode$default$4(), NodeBuilders$.MODULE$.identifierNode$default$5());
        Ast value = this.astForExpr(item.value());
        String code = new StringBuilder(1).append(key.name()).append("=").append(this.rootCode(value, this.rootCode$default$2())).toString();
        String string = "<operator>.assignment";
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(item);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall declareAssignment = NodeBuilders$.MODULE$.operatorCallNode(string, code, option2, option, option3);
        Ast ast = Ast$.MODULE$.apply((NewNode)key);
        return this.callAst(declareAssignment, (Seq)package$.MODULE$.Nil().$colon$colon((Object)value).$colon$colon((Object)ast), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForHaltCompilerStmt(Domain.PhpHaltCompilerStmt stmt) {
        NewCall callNode = NewCall$.MODULE$.apply().name(AstCreator$NameConstants$.MODULE$.HaltCompiler()).methodFullName(AstCreator$NameConstants$.MODULE$.HaltCompiler()).code(new StringBuilder(2).append(AstCreator$NameConstants$.MODULE$.HaltCompiler()).append("()").toString()).dispatchType("STATIC_DISPATCH").typeFullName(AstCreator$TypeConstants$.MODULE$.Void()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        return Ast$.MODULE$.apply((NewNode)callNode);
    }

    private String stripBuiltinPrefix(String name) {
        return name.replaceAll(new StringBuilder(1).append(PhpBuiltins$.MODULE$.Prefix()).append(".").toString(), "");
    }

    private Ast astForUnsetStmt(Domain.PhpUnsetStmt stmt) {
        String name = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.unset());
        List args = stmt.vars().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        String code = new StringBuilder(2).append(name).append("(").append(args.map((Function1 & Serializable)_$15 -> this.rootCode((Ast)_$15, this.rootCode$default$2())).mkString(", ")).append(")").toString();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(name, code, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Void()), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt), NodeBuilders$.MODULE$.operatorCallNode$default$5()).methodFullName(Domain$PhpOperators$.MODULE$.unset());
        return this.callAst(callNode, (Seq)args, this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForGlobalStmt(Domain.PhpGlobalStmt stmt) {
        List varsAsts = stmt.vars().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        String code = new StringBuilder(1).append(Domain$PhpOperators$.MODULE$.global()).append(" ").append(varsAsts.map((Function1 & Serializable)_$16 -> this.rootCode((Ast)_$16, this.rootCode$default$2())).mkString(", ")).toString();
        NewCall globalCallNode = NodeBuilders$.MODULE$.operatorCallNode(Domain$PhpOperators$.MODULE$.global(), code, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Void()), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt), NodeBuilders$.MODULE$.operatorCallNode$default$5());
        return this.callAst(globalCallNode, (Seq)varsAsts, this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForUseStmt(Domain.PhpUseStmt stmt) {
        List imports = stmt.uses().map((Function1 & Serializable)_$17 -> this.astForUseUse((Domain.PhpUseUse)_$17, this.astForUseUse$default$2()));
        return this.wrapMultipleInBlock((Seq)imports, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
    }

    private Ast astForGroupUseStmt(Domain.PhpGroupUseStmt stmt) {
        String groupPrefix = new StringBuilder(1).append(stmt.prefix().name()).append("\\").toString();
        List imports = stmt.uses().map((Function1 & Serializable)_$18 -> this.astForUseUse((Domain.PhpUseUse)_$18, groupPrefix));
        return this.wrapMultipleInBlock((Seq)imports, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
    }

    private Ast astForKeyValPair(Domain.PhpExpr key, Domain.PhpExpr value, Option<Integer> lineNo) {
        Ast keyAst = this.astForExpr(key);
        Ast valueAst = this.astForExpr(value);
        String code = new StringBuilder(4).append(this.rootCode(keyAst, this.rootCode$default$2())).append(" => ").append(this.rootCode(valueAst, this.rootCode$default$2())).toString();
        String string = Domain$PhpOperators$.MODULE$.doubleArrow();
        Option option = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(string, code, option, lineNo, option2);
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)valueAst).$colon$colon((Object)keyAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForForeachStmt(Domain.PhpForeachStmt stmt) {
        Ast ast;
        NewNode newNode;
        Ast ast2;
        Ast iteratorAst = this.astForExpr(stmt.iterExpr());
        NewLocal iteratorLocal = this.getTmpLocal((Option<String>)None$.MODULE$, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt), "iter_");
        Option<Domain.PhpExpr> option = stmt.keyVar();
        if (option instanceof Some) {
            Domain.PhpExpr key = (Domain.PhpExpr)((Some)option).value();
            ast2 = this.astForKeyValPair(key, stmt.valueVar(), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        } else if (None$.MODULE$.equals(option)) {
            ast2 = this.astForExpr(stmt.valueVar());
        } else {
            throw new MatchError(option);
        }
        Ast assignItemTargetAst = ast2;
        Ast iterIdent = this.identifierAstFromLocal(iteratorLocal, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        Ast iterValue = this.astForExpr(stmt.iterExpr());
        Ast iteratorAssignAst = this.simpleAssignAst(iterIdent, iterValue, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        Ast itemInitAst = this.getItemAssignAstForForeach(stmt, assignItemTargetAst, iteratorLocal);
        String isNullName = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.isNull());
        Ast valueAst = this.astForExpr(stmt.valueVar());
        String isNullCode = new StringBuilder(2).append(isNullName).append("(").append(this.rootCode(valueAst, this.rootCode$default$2())).append(")").toString();
        NewCall isNullCall = NodeBuilders$.MODULE$.operatorCallNode(isNullName, isNullCode, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Bool()), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt), NodeBuilders$.MODULE$.operatorCallNode$default$5()).methodFullName(Domain$PhpOperators$.MODULE$.isNull());
        String string = "<operator>.logicalNot";
        String string2 = new StringBuilder(1).append("!").append(isNullCode).toString();
        Option<Integer> option2 = this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt);
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option4 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall notIsNull = NodeBuilders$.MODULE$.operatorCallNode(string, string2, option3, option2, option4);
        Ast isNullAst = this.callAst(isNullCall, (Seq)package$.MODULE$.Nil().$colon$colon((Object)valueAst), this.callAst$default$3(), this.callAst$default$4());
        Ast conditionAst = this.callAst(notIsNull, (Seq)package$.MODULE$.Nil().$colon$colon((Object)isNullAst), this.callAst$default$3(), this.callAst$default$4());
        Ast nextIterIdent = this.identifierAstFromLocal(iteratorLocal, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        String nextSignature = "void()";
        NewCall nextCallNode = NewCall$.MODULE$.apply().name("next").methodFullName(new StringBuilder(14).append("Iterator.next:").append(nextSignature).toString()).signature(nextSignature).code(new StringBuilder(8).append(this.rootCode(nextIterIdent, this.rootCode$default$2())).append("->next()").toString()).dispatchType("DYNAMIC_DISPATCH").lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        Some some = Some$.MODULE$.apply((Object)nextIterIdent);
        Seq seq = this.callAst$default$2();
        boolean bl = this.callAst$default$4();
        Ast nextCallAst = this.callAst(nextCallNode, seq, (Option)some, bl);
        Option option5 = itemInitAst.root();
        if (option5 instanceof Some && (newNode = (NewNode)((Some)option5).value()) instanceof AstNodeNew) {
            AstNodeNew initRoot = (AstNodeNew)newNode;
            ast = itemInitAst.subTreeCopy(initRoot, itemInitAst.subTreeCopy$default$2());
        } else {
            this.logger.warn(new StringBuilder(35).append("Could not copy foreach init ast in ").append(this.filename).toString());
            ast = Ast$.MODULE$.apply();
        }
        Ast itemUpdateAst = ast;
        Ast bodyAst = this.stmtBlockAst((Seq<Domain.PhpStmt>)stmt.stmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        String ampPrefix = stmt.assignByRef() ? "&" : "";
        String foreachCode = new StringBuilder(14).append("foreach (").append(this.rootCode(iteratorAst, this.rootCode$default$2())).append(" as ").append(ampPrefix).append(this.rootCode(assignItemTargetAst, this.rootCode$default$2())).append(")").toString();
        NewControlStructure foreachNode = NewControlStructure$.MODULE$.apply().controlStructureType("FOR").code(foreachCode);
        return Ast$.MODULE$.apply((NewNode)foreachNode).withChild(this.wrapMultipleInBlock((Seq)package$.MODULE$.Nil().$colon$colon((Object)itemInitAst).$colon$colon((Object)iteratorAssignAst), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt))).withChild(conditionAst).withChild(this.wrapMultipleInBlock((Seq)package$.MODULE$.Nil().$colon$colon((Object)itemUpdateAst).$colon$colon((Object)nextCallAst), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt))).withChild(bodyAst).withConditionEdges((NewNode)foreachNode, conditionAst.root().toList());
    }

    private Ast getItemAssignAstForForeach(Domain.PhpForeachStmt stmt, Ast assignItemTargetAst, NewLocal iteratorLocal) {
        Ast ast;
        Ast iteratorIdentifierAst = this.identifierAstFromLocal(iteratorLocal, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        String currentCallSignature = new StringBuilder(3).append(Defines$.MODULE$.UnresolvedSignature()).append("(0)").toString();
        NewCall currentCallNode = NewCall$.MODULE$.apply().name("current").methodFullName(new StringBuilder(17).append("Iterator.current:").append(currentCallSignature).toString()).signature(currentCallSignature).code(new StringBuilder(11).append(this.rootCode(iteratorIdentifierAst, this.rootCode$default$2())).append("->current()").toString()).dispatchType("DYNAMIC_DISPATCH").lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        Some some = Some$.MODULE$.apply((Object)iteratorIdentifierAst);
        Seq seq = this.callAst$default$2();
        boolean bl = this.callAst$default$4();
        Ast currentCallAst = this.callAst(currentCallNode, seq, (Option)some, bl);
        if (stmt.assignByRef()) {
            String addressOfCode = new StringBuilder(1).append("&").append(this.rootCode(currentCallAst, this.rootCode$default$2())).toString();
            String string = "<operator>.addressOf";
            Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt);
            Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
            Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
            NewCall addressOfCall = NodeBuilders$.MODULE$.operatorCallNode(string, addressOfCode, option2, option, option3);
            ast = this.callAst(addressOfCall, (Seq)package$.MODULE$.Nil().$colon$colon((Object)currentCallAst), this.callAst$default$3(), this.callAst$default$4());
        } else {
            ast = currentCallAst;
        }
        Ast valueAst = ast;
        return this.simpleAssignAst(assignItemTargetAst, valueAst, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
    }

    private Ast simpleAssignAst(Ast target, Ast source, Option<Integer> lineNo) {
        String code = new StringBuilder(3).append(this.rootCode(target, this.rootCode$default$2())).append(" = ").append(this.rootCode(source, this.rootCode$default$2())).toString();
        String string = "<operator>.assignment";
        Option option = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(string, code, option, lineNo, option2);
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)source).$colon$colon((Object)target), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astforTraitUseStmt(Domain.PhpTraitUseStmt stmt) {
        return Ast$.MODULE$.apply();
    }

    private Ast astForUseUse(Domain.PhpUseUse stmt, String namePrefix) {
        String originalName = new StringBuilder(0).append(namePrefix).append(stmt.originalName().name()).toString();
        String aliasCode = (String)stmt.alias().map((Function1 & Serializable)alias -> new StringBuilder(4).append(" as ").append(alias.name()).toString()).getOrElse(AstCreator::$anonfun$50);
        Domain.PhpUseType.PhpUseType phpUseType = stmt.useType();
        String typeCode = Domain$PhpUseType$Function$.MODULE$.equals(phpUseType) ? "function " : (Domain$PhpUseType$Constant$.MODULE$.equals(phpUseType) ? "const " : "");
        String code = new StringBuilder(4).append("use ").append(typeCode).append(originalName).append(aliasCode).toString();
        NewImport importNode = NewImport$.MODULE$.apply().importedEntity(originalName).importedAs(stmt.alias().map((Function1 & Serializable)_$19 -> _$19.name())).isExplicit(Predef$.MODULE$.boolean2Boolean(true)).code(code);
        return Ast$.MODULE$.apply((NewNode)importNode);
    }

    private String astForUseUse$default$2() {
        return "";
    }

    private List<Ast> astsForStaticStmt(Domain.PhpStaticStmt stmt) {
        return stmt.vars().flatMap((Function1 & Serializable)staticVarDecl -> {
            String string;
            NewNode newNode;
            Ast variableAst = this.astForVariableExpr(staticVarDecl.variable());
            Option maybeValueAst = staticVarDecl.defaultValue().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
            String code = this.rootCode(variableAst, AstCreator$NameConstants$.MODULE$.Unknown());
            Option option = variableAst.root();
            if (option instanceof Some && (newNode = (NewNode)((Some)option).value()) instanceof NewIdentifier) {
                NewIdentifier identifier = (NewIdentifier)newNode;
                string = identifier.name();
            } else {
                string = code;
            }
            String name = string;
            this.scope.lookupVariable(name).collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(NewNode x) {
                    NewNode newNode = x;
                    if (newNode instanceof NewLocal) {
                        NewLocal local = (NewLocal)newNode;
                        return true;
                    }
                    return false;
                }

                public final Object applyOrElse(NewNode x, Function1 function1) {
                    NewNode newNode = x;
                    if (newNode instanceof NewLocal) {
                        NewLocal local = (NewLocal)newNode;
                        return local;
                    }
                    return function1.apply((Object)x);
                }
            }).foreach((Function1 & Serializable)local -> {
                local.code(new StringBuilder(7).append("static ").append(local.code()).toString());
                return local.lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
            });
            Option defaultAssignAst = maybeValueAst.map((Function1 & Serializable)valueAst -> {
                String valueCode = new StringBuilder(10).append("static ").append(code).append(" = ").append(this.rootCode((Ast)valueAst, this.rootCode$default$2())).toString();
                String string = "<operator>.assignment";
                Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt);
                Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
                Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
                NewCall assignNode = NodeBuilders$.MODULE$.operatorCallNode(string, valueCode, option2, option, option3);
                return this.callAst(assignNode, (Seq)package$.MODULE$.Nil().$colon$colon(valueAst).$colon$colon((Object)variableAst), this.callAst$default$3(), this.callAst$default$4());
            });
            return defaultAssignAst.toList();
        });
    }

    private Ast astForAnonymousClass(Domain.PhpClassLikeStmt stmt) {
        return Ast$.MODULE$.apply();
    }

    public String codeForClassStmt(Domain.PhpClassLikeStmt stmt, Domain.PhpNameExpr name) {
        String string;
        List<Domain.PhpNameExpr> list = stmt.extendsNames();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Domain.PhpNameExpr> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            string = "";
        } else {
            List<Domain.PhpNameExpr> names = list;
            string = new StringBuilder(9).append(" extends ").append(names.map((Function1 & Serializable)_$20 -> _$20.name()).mkString(", ")).toString();
        }
        String extendsString = string;
        String implementsString = stmt.implementedInterfaces().isEmpty() ? "" : new StringBuilder(12).append(" implements ").append(stmt.implementedInterfaces().map((Function1 & Serializable)_$21 -> _$21.name()).mkString(", ")).toString();
        return new StringBuilder(1).append(stmt.classLikeType()).append(" ").append(name.name()).append(extendsString).append(implementsString).toString();
    }

    private Ast astForNamedClass(Domain.PhpClassLikeStmt stmt, Domain.PhpNameExpr name2) {
        List inheritsFrom = ((List)stmt.extendsNames().$plus$plus(stmt.implementedInterfaces())).map((Function1 & Serializable)_$22 -> _$22.name());
        String code = this.codeForClassStmt(stmt, name2);
        String namespacePrefix = (String)this.scope.getEnclosingNamespaceName().filterNot((Function1 & Serializable)name -> name.contains(NamespaceTraversal$.MODULE$.globalNamespaceName())).map((Function1 & Serializable)_$23 -> new StringBuilder(1).append((String)_$23).append(".").toString()).getOrElse(AstCreator::$anonfun$59);
        String fullName = new StringBuilder(0).append(namespacePrefix).append(name2.name()).toString();
        NewTypeDecl typeDeclNode = NewTypeDecl$.MODULE$.apply().name(name2.name()).fullName(fullName).code(code).inheritsFromTypeFullName((IterableOnce)inheritsFrom).filename(this.filename).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
        String string = stmt.classLikeType();
        String string2 = Domain$ClassLikeTypes$.MODULE$.Class();
        boolean createDefaultConstructor = !(string != null ? !string.equals(string2) : string2 != null);
        this.scope.pushNewScope((NewNode)typeDeclNode);
        List<Ast> bodyStmts = this.astsForClassLikeBody(stmt.stmts(), createDefaultConstructor);
        List modifiers = stmt.modifiers().map((Function1 & Serializable)modifierType -> NodeBuilders$.MODULE$.modifierNode(modifierType)).map((Function1 & Serializable)_$24 -> Ast$.MODULE$.apply((NewNode)_$24));
        this.scope.popScope();
        return Ast$.MODULE$.apply((NewNode)typeDeclNode).withChildren((scala.collection.Seq)modifiers).withChildren(bodyStmts);
    }

    private Option<Ast> astForStaticAndConstInits() {
        List<Ast> list = this.scope.getConstAndStaticInits();
        Nil$ nil$ = package$.MODULE$.Nil();
        List<Ast> list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            return None$.MODULE$;
        }
        List<Ast> inits = list;
        String namespacePrefix = this.getNamespacePrefixForName();
        String signature = new StringBuilder(2).append(AstCreator$TypeConstants$.MODULE$.Void()).append("()").toString();
        String fullName = new StringBuilder(1).append(namespacePrefix).append(Defines$.MODULE$.StaticInitMethodName()).append(":").append(signature).toString();
        Ast ast = this.staticInitMethodAst(inits, fullName, (Option)Some$.MODULE$.apply((Object)signature), AstCreator$TypeConstants$.MODULE$.Void());
        return Some$.MODULE$.apply((Object)ast);
    }

    private List<Ast> astsForClassLikeBody(List<Domain.PhpStmt> bodyStmts, boolean createDefaultConstructor) {
        List classConsts = bodyStmts.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Domain.PhpStmt x) {
                Domain.PhpStmt phpStmt = x;
                if (phpStmt instanceof Domain.PhpConstStmt) {
                    Domain.PhpConstStmt cs = (Domain.PhpConstStmt)phpStmt;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Domain.PhpStmt x, Function1 function1) {
                Domain.PhpStmt phpStmt = x;
                if (phpStmt instanceof Domain.PhpConstStmt) {
                    Domain.PhpConstStmt cs = (Domain.PhpConstStmt)phpStmt;
                    return cs;
                }
                return function1.apply((Object)x);
            }
        }).flatMap((Function1 & Serializable)stmt -> this.astsForConstStmt((Domain.PhpConstStmt)stmt));
        List properties = bodyStmts.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Domain.PhpStmt x) {
                Domain.PhpStmt phpStmt = x;
                if (phpStmt instanceof Domain.PhpPropertyStmt) {
                    Domain.PhpPropertyStmt cp = (Domain.PhpPropertyStmt)phpStmt;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Domain.PhpStmt x, Function1 function1) {
                Domain.PhpStmt phpStmt = x;
                if (phpStmt instanceof Domain.PhpPropertyStmt) {
                    Domain.PhpPropertyStmt cp = (Domain.PhpPropertyStmt)phpStmt;
                    return cp;
                }
                return function1.apply((Object)x);
            }
        }).flatMap((Function1 & Serializable)stmt -> this.astsForPropertyStmt((Domain.PhpPropertyStmt)stmt));
        Option constructorDecl = bodyStmts.collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Domain.PhpStmt x) {
                Domain.PhpStmt phpStmt = x;
                if (phpStmt instanceof Domain.PhpMethodDecl) {
                    Domain.PhpMethodDecl m = (Domain.PhpMethodDecl)phpStmt;
                    String string = m.name().name();
                    String string2 = Defines$.MODULE$.ConstructorMethodName();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return true;
                    }
                }
                return false;
            }

            public final Object applyOrElse(Domain.PhpStmt x, Function1 function1) {
                Domain.PhpStmt phpStmt = x;
                if (phpStmt instanceof Domain.PhpMethodDecl) {
                    Domain.PhpMethodDecl m = (Domain.PhpMethodDecl)phpStmt;
                    String string = m.name().name();
                    String string2 = Defines$.MODULE$.ConstructorMethodName();
                    if (!(string != null ? !string.equals(string2) : string2 != null)) {
                        return m;
                    }
                }
                return function1.apply((Object)x);
            }
        });
        List constructorAst = this.astForConstructor((Option<Domain.PhpMethodDecl>)constructorDecl, createDefaultConstructor).toList();
        List otherBodyStmts = bodyStmts.flatMap((Function1 & Serializable)x$1 -> {
            Domain.PhpStmt phpStmt = x$1;
            if (phpStmt instanceof Domain.PhpConstStmt) {
                return None$.MODULE$;
            }
            if (phpStmt instanceof Domain.PhpPropertyStmt) {
                return None$.MODULE$;
            }
            if (phpStmt instanceof Domain.PhpMethodDecl) {
                Domain.PhpMethodDecl phpMethodDecl;
                Domain.PhpMethodDecl method = phpMethodDecl = (Domain.PhpMethodDecl)phpStmt;
                String string = method.name().name();
                String string2 = Defines$.MODULE$.ConstructorMethodName();
                if (!(string != null ? !string.equals(string2) : string2 != null)) {
                    return None$.MODULE$;
                }
                Domain.PhpMethodDecl method2 = phpMethodDecl;
                return Some$.MODULE$.apply((Object)this.astForMethodDecl(method2, this.astForMethodDecl$default$2(), this.astForMethodDecl$default$3()));
            }
            if (phpStmt instanceof Domain.PhpClassLikeStmt) {
                Domain.PhpClassLikeStmt classLikeStmt = (Domain.PhpClassLikeStmt)phpStmt;
                return Some$.MODULE$.apply((Object)this.astForClassLikeStmt(classLikeStmt));
            }
            if (phpStmt instanceof Domain.PhpEnumCaseStmt) {
                Domain.PhpEnumCaseStmt enumCase = (Domain.PhpEnumCaseStmt)phpStmt;
                return Some$.MODULE$.apply((Object)this.astForEnumCase(enumCase));
            }
            if (phpStmt instanceof Domain.PhpExpr) {
                Domain.PhpExpr expr = (Domain.PhpExpr)phpStmt;
                return Some$.MODULE$.apply((Object)this.astForExpr(expr));
            }
            Domain.PhpStmt other = phpStmt;
            this.logger.warn(new StringBuilder(32).append("Found unhandled class body stmt ").append(other).toString());
            return Some$.MODULE$.apply((Object)this.astForStmt(other));
        });
        Option<Ast> clinitAst = this.astForStaticAndConstInits();
        List<Ast> anonymousMethodAsts = this.scope.getAndClearAnonymousMethods();
        return (List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{classConsts, properties, clinitAst, constructorAst, anonymousMethodAsts, otherBodyStmts}))).flatten(Predef$.MODULE$.$conforms());
    }

    private Option<Ast> astForConstructor(Option<Domain.PhpMethodDecl> maybeDecl, boolean createDefaultConstructor) {
        Option<Domain.PhpMethodDecl> option = maybeDecl;
        if (None$.MODULE$.equals(option) && createDefaultConstructor) {
            return Some$.MODULE$.apply((Object)this.defaultConstructorAst());
        }
        if (option instanceof Some) {
            Domain.PhpMethodDecl constructorDecl = (Domain.PhpMethodDecl)((Some)option).value();
            List<Ast> fieldInits = this.scope.getFieldInits();
            return Some$.MODULE$.apply((Object)this.astForMethodDecl(constructorDecl, fieldInits, this.astForMethodDecl$default$3()));
        }
        return None$.MODULE$;
    }

    private String getNamespacePrefixForName() {
        return (String)this.scope.getEnclosingTypeDeclType().filterNot((Function1 & Serializable)_$25 -> {
            String string = _$25;
            String string2 = NamespaceTraversal$.MODULE$.globalNamespaceName();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)typeName -> new StringBuilder(1).append((String)typeName).append(".").toString()).getOrElse(AstCreator::getNamespacePrefixForName$$anonfun$3);
    }

    private Ast defaultConstructorAst() {
        String namespacePrefix = this.getNamespacePrefixForName();
        String signature = new StringBuilder(3).append(Defines$.MODULE$.UnresolvedSignature()).append("(0)").toString();
        String fullName = new StringBuilder(1).append(namespacePrefix).append(Defines$.MODULE$.ConstructorMethodName()).append(":").append(signature).toString();
        List modifiers = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"VIRTUAL", "PUBLIC", "CONSTRUCTOR"}))).map((Function1 & Serializable)modifierType -> NodeBuilders$.MODULE$.modifierNode(modifierType));
        Ast thisParam = this.thisParamAstForMethod((Option<Integer>)None$.MODULE$);
        NewMethod methodNode = NewMethod$.MODULE$.apply().name(Defines$.MODULE$.ConstructorMethodName()).fullName(fullName).signature(signature).isExternal(false).code(fullName);
        Ast methodBody = this.blockAst(NewBlock$.MODULE$.apply(), this.scope.getFieldInits());
        NewMethodReturn methodReturn = NewMethodReturn$.MODULE$.apply().typeFullName(AstCreator$TypeConstants$.MODULE$.Any()).code("RET");
        return this.methodAstWithAnnotations(methodNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)thisParam), methodBody, methodReturn, (Seq)modifiers, this.methodAstWithAnnotations$default$6());
    }

    private Ast astForMemberAssignment(NewMember memberNode, Domain.PhpExpr valueExpr, boolean isField) {
        Ast ast;
        if (isField) {
            String code = new StringBuilder(7).append("$this->").append(memberNode.name()).toString();
            String string = "<operator>.fieldAccess";
            Option option = memberNode.lineNumber();
            Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
            Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
            NewCall fieldAccessNode = NodeBuilders$.MODULE$.operatorCallNode(string, code, option2, option, option3);
            NewIdentifier identifier = this.thisIdentifier((Option<Integer>)memberNode.lineNumber());
            Option thisParam = this.scope.lookupVariable(AstCreator$NameConstants$.MODULE$.This());
            NewFieldIdentifier fieldIdentifier = NodeBuilders$.MODULE$.fieldIdentifierNode(memberNode.name(), memberNode.lineNumber(), NodeBuilders$.MODULE$.fieldIdentifierNode$default$3());
            ast = this.callAst(fieldAccessNode, (Seq)((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ExpressionBase[]{identifier, fieldIdentifier}))).map((Function1 & Serializable)_$26 -> Ast$.MODULE$.apply((NewNode)_$26)), this.callAst$default$3(), this.callAst$default$4()).withRefEdges((NewNode)identifier, thisParam.toList());
        } else {
            String identifierCode = memberNode.code().replaceAll("const ", "").replaceAll("case ", "");
            NewIdentifier identifier = NodeBuilders$.MODULE$.identifierNode(memberNode.name(), (Option)Some$.MODULE$.apply((Object)memberNode.typeFullName()), memberNode.lineNumber(), NodeBuilders$.MODULE$.identifierNode$default$4(), NodeBuilders$.MODULE$.identifierNode$default$5()).code(identifierCode);
            ast = Ast$.MODULE$.apply((NewNode)identifier).withRefEdge((NewNode)identifier, (NewNode)memberNode);
        }
        Ast targetAst = ast;
        Ast value = this.astForExpr(valueExpr);
        String assignmentCode = new StringBuilder(3).append(this.rootCode(targetAst, this.rootCode$default$2())).append(" = ").append(this.rootCode(value, this.rootCode$default$2())).toString();
        String string = "<operator>.assignment";
        Option option = memberNode.lineNumber();
        Option option4 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option5 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(string, assignmentCode, option4, option, option5);
        return this.callAst(callNode, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[]{targetAst, value})), this.callAst$default$3(), this.callAst$default$4());
    }

    private List<Ast> astsForConstStmt(Domain.PhpConstStmt stmt) {
        return stmt.consts().map((Function1 & Serializable)constDecl -> {
            Ast finalModifier = Ast$.MODULE$.apply((NewNode)NodeBuilders$.MODULE$.modifierNode("FINAL"));
            List modifierAsts = stmt.modifiers().map((Function1 & Serializable)modifierType -> NodeBuilders$.MODULE$.modifierNode(modifierType)).map((Function1 & Serializable)_$27 -> Ast$.MODULE$.apply((NewNode)_$27)).$colon$colon((Object)finalModifier);
            String name = constDecl.name().name();
            String code = new StringBuilder(6).append("const ").append(name).toString();
            Some someValue = Some$.MODULE$.apply((Object)constDecl.value());
            return this.astForConstOrFieldValue(name, code, (Option<Domain.PhpExpr>)someValue, this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt), (Function1<Ast, BoxedUnit>)(JProcedure1 & Serializable)ast -> this.scope.addConstOrStaticInitToScope((Ast)ast), false).withChildren((scala.collection.Seq)modifierAsts);
        });
    }

    private Ast astForEnumCase(Domain.PhpEnumCaseStmt stmt) {
        Ast finalModifier = Ast$.MODULE$.apply((NewNode)NodeBuilders$.MODULE$.modifierNode("FINAL"));
        String name = stmt.name().name();
        String code = new StringBuilder(5).append("case ").append(name).toString();
        return this.astForConstOrFieldValue(name, code, stmt.expr(), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt), (Function1<Ast, BoxedUnit>)(JProcedure1 & Serializable)ast -> this.scope.addConstOrStaticInitToScope((Ast)ast), false).withChild(finalModifier);
    }

    private List<Ast> astsForPropertyStmt(Domain.PhpPropertyStmt stmt) {
        return stmt.variables().map((Function1 & Serializable)varDecl -> {
            List modifierAsts = stmt.modifiers().map((Function1 & Serializable)modifierType -> NodeBuilders$.MODULE$.modifierNode(modifierType)).map((Function1 & Serializable)_$28 -> Ast$.MODULE$.apply((NewNode)_$28));
            String name = varDecl.name().name();
            return this.astForConstOrFieldValue(name, new StringBuilder(1).append("$").append(name).toString(), varDecl.defaultValue(), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt), (Function1<Ast, BoxedUnit>)(JProcedure1 & Serializable)ast -> this.scope.addFieldInitToScope((Ast)ast), true).withChildren((scala.collection.Seq)modifierAsts);
        });
    }

    private Ast astForConstOrFieldValue(String name, String code, Option<Domain.PhpExpr> value, Option<Integer> lineNumber, Function1<Ast, BoxedUnit> addToScope, boolean isField) {
        NewMember memberNode = NewMember$.MODULE$.apply().name(name).code(code).typeFullName(AstCreator$TypeConstants$.MODULE$.Any()).lineNumber(lineNumber);
        Option<Domain.PhpExpr> option = value;
        if (option instanceof Some) {
            Domain.PhpExpr value2 = (Domain.PhpExpr)((Some)option).value();
            Ast assignAst = this.astForMemberAssignment(memberNode, value2, isField);
            addToScope.apply((Object)assignAst);
        } else if (!None$.MODULE$.equals(option)) {
            throw new MatchError(option);
        }
        return Ast$.MODULE$.apply((NewNode)memberNode);
    }

    private Ast astForCatchStmt(Domain.PhpCatchStmt stmt) {
        return this.stmtBlockAst((Seq<Domain.PhpStmt>)stmt.stmts(), this.io$joern$php2cpg$astcreation$AstCreator$$line(stmt));
    }

    private List<Ast> astsForSwitchCase(Domain.PhpCaseStmt caseStmt) {
        NewJumpTarget newJumpTarget;
        Option maybeConditionAst = caseStmt.condition().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        Option option = maybeConditionAst;
        if (option instanceof Some) {
            Ast conditionAst = (Ast)((Some)option).value();
            newJumpTarget = NewJumpTarget$.MODULE$.apply().name("case").code(new StringBuilder(5).append("case ").append(this.rootCode(conditionAst, this.rootCode$default$2())).toString());
        } else if (None$.MODULE$.equals(option)) {
            newJumpTarget = NewJumpTarget$.MODULE$.apply().name("default").code("default");
        } else {
            throw new MatchError((Object)option);
        }
        NewJumpTarget jumpTarget = newJumpTarget;
        jumpTarget.lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(caseStmt));
        List stmtAsts = caseStmt.stmts().map((Function1 & Serializable)stmt -> this.astForStmt((Domain.PhpStmt)stmt));
        Ast ast = Ast$.MODULE$.apply((NewNode)jumpTarget);
        return stmtAsts.$colon$colon((Object)ast);
    }

    private String codeForMethodCall(Domain.PhpCallExpr call, Ast targetAst, String name) {
        String callOperator = call.isNullSafe() ? "?->" : "->";
        return new StringBuilder(0).append(this.rootCode(targetAst, this.rootCode$default$2())).append(callOperator).append(name).toString();
    }

    private String codeForStaticMethodCall(Domain.PhpCallExpr call, String name) {
        String className = (String)call.target().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr)).map((Function1 & Serializable)_$29 -> this.rootCode((Ast)_$29, Defines$.MODULE$.UnresolvedNamespace())).getOrElse(AstCreator::$anonfun$75);
        return new StringBuilder(2).append(className).append("::").append(name).toString();
    }

    /*
     * Unable to fully structure code
     */
    private Ast astForCall(Domain.PhpCallExpr call) {
        block18: {
            block16: {
                block17: {
                    block15: {
                        block14: {
                            arguments = (Seq)call.args().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$76(io.joern.php2cpg.parser.Domain$PhpArgument ), (Lio/joern/php2cpg/parser/Domain$PhpArgument;)Lio/joern/x2cpg/Ast;)((AstCreator)this));
                            isMethodCall = call.target().isDefined() != false && call.isStatic() == false;
                            targetAst = Option$.MODULE$.when(isMethodCall, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$77(io.joern.php2cpg.parser.Domain$PhpCallExpr ), ()Lscala/Option;)((AstCreator)this, (Domain.PhpCallExpr)call)).flatten((.less.colon.less)$less$colon$less$.MODULE$.refl());
                            nameAst = Option$.MODULE$.unless(call.methodName() instanceof Domain.PhpNameExpr, (Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$78(io.joern.php2cpg.parser.Domain$PhpCallExpr ), ()Lio/joern/x2cpg/Ast;)((AstCreator)this, (Domain.PhpCallExpr)call));
                            name = (String)nameAst.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$79(io.joern.x2cpg.Ast ), (Lio/joern/x2cpg/Ast;)Ljava/lang/String;)((AstCreator)this)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$80(io.joern.php2cpg.parser.Domain$PhpCallExpr ), ()Ljava/lang/String;)((AstCreator)this, (Domain.PhpCallExpr)call));
                            argsCode = ((IterableOnceOps)arguments.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$81(io.joern.x2cpg.Ast ), (Lio/joern/x2cpg/Ast;)Ljava/lang/String;)((AstCreator)this))).mkString(",");
                            codePrefix = isMethodCall != false && targetAst.isDefined() != false ? this.codeForMethodCall(call, (Ast)targetAst.get(), name) : (call.isStatic() != false ? this.codeForStaticMethodCall(call, name) : name);
                            code = new StringBuilder(2).append(codePrefix).append("(").append(argsCode).append(")").toString();
                            dispatchType = call.isStatic() != false || call.target().isEmpty() != false ? "STATIC_DISPATCH" : "DYNAMIC_DISPATCH";
                            var12_11 = call.target();
                            if (!(var12_11 instanceof Some) || !((var13_12 = (Domain.PhpExpr)((Some)var12_11).value()) instanceof Domain.PhpNameExpr)) break block14;
                            nameExpr = (Domain.PhpNameExpr)var13_12;
                            if (!call.isStatic()) break block14;
                            v0 = new StringBuilder(4).append(nameExpr.name()).append(".").append(name).append(":").append(Defines$.MODULE$.UnresolvedSignature()).append("(").append(arguments.size()).append(")").toString();
                            break block15;
                        }
                        if (!None$.MODULE$.equals(var12_11)) ** GOTO lbl-1000
                        if (PhpBuiltins$.MODULE$.FuncNames().contains((Object)name)) {
                            v0 = new StringBuilder(1).append(PhpBuiltins$.MODULE$.Prefix()).append(".").append(name).toString();
                        } else if (!PhpBuiltins$.MODULE$.FuncNames().contains((Object)name)) {
                            var16_14 = this.scope.getEnclosingNamespaceName();
                            if (var16_14 instanceof Some) {
                                var17_15 = (String)((Some)var16_14).value();
                                v1 = NamespaceTraversal$.MODULE$.globalNamespaceName();
                                var18_16 = var17_15;
                                if (!(v1 != null ? v1.equals(var18_16) == false : var18_16 != null)) {
                                    v2 = "";
                                } else {
                                    name = var17_15;
                                    v2 = new StringBuilder(1).append(name).append(".").toString();
                                }
                            } else if (None$.MODULE$.equals(var16_14)) {
                                v2 = Defines$.MODULE$.UnresolvedNamespace();
                            } else {
                                throw new MatchError(var16_14);
                            }
                            namespacePrefix = v2;
                            v0 = new StringBuilder(3).append(namespacePrefix).append(name).append(":").append(Defines$.MODULE$.UnresolvedSignature()).append("(").append(arguments.size()).append(")").toString();
                        } else lbl-1000:
                        // 2 sources

                        {
                            v0 = Call.PropertyDefaults$.MODULE$.MethodFullName();
                        }
                    }
                    fullName = v0;
                    callNode = NewCall$.MODULE$.apply().name(name).methodFullName(fullName).code(code).dispatchType(dispatchType).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(call));
                    var22_21 = Tuple2$.MODULE$.apply((Object)targetAst, (Object)nameAst);
                    if (var22_21 == null) ** GOTO lbl-1000
                    var23_22 = (Option)var22_21._1();
                    var24_23 = (Option)var22_21._2();
                    if (!(var23_22 instanceof Some)) break block16;
                    target = var25_24 = (Ast)((Some)var23_22).value();
                    if (!(var24_23 instanceof Some)) break block17;
                    name = (Ast)((Some)var24_23).value();
                    var29_27 = "<operator>.fieldAccess";
                    var30_28 = this.io$joern$php2cpg$astcreation$AstCreator$$line(call);
                    var31_29 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
                    var32_30 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
                    fieldAccess = NodeBuilders$.MODULE$.operatorCallNode(var29_27, codePrefix, var31_29, var30_28, var32_30);
                    v3 = Some$.MODULE$.apply((Object)this.callAst(fieldAccess, (Seq)package$.MODULE$.Nil().$colon$colon((Object)name).$colon$colon((Object)target), this.callAst$default$3(), this.callAst$default$4()));
                    break block18;
                }
                target = var25_24;
                if (!None$.MODULE$.equals(var24_23)) break block16;
                v3 = Some$.MODULE$.apply((Object)target);
                break block18;
            }
            if (!None$.MODULE$.equals(var23_22)) ** GOTO lbl-1000
            if (var24_23 instanceof Some) {
                name = (Ast)((Some)var24_23).value();
                v3 = Some$.MODULE$.apply((Object)name);
            } else if (None$.MODULE$.equals(var24_23)) {
                v3 = None$.MODULE$;
            } else lbl-1000:
            // 3 sources

            {
                throw new MatchError((Object)var22_21);
            }
        }
        receiverAst = v3;
        return this.callAst(callNode, arguments, (Option)receiverAst, this.callAst$default$4());
    }

    private Ast astForCallArg(Domain.PhpArgument arg) {
        Domain.PhpArgument phpArgument = arg;
        if (phpArgument instanceof Domain.PhpArg) {
            Domain.PhpArg phpArg = Domain$PhpArg$.MODULE$.unapply((Domain.PhpArg)phpArgument);
            Domain.PhpExpr phpExpr = phpArg._1();
            Option<String> option = phpArg._2();
            boolean bl = phpArg._3();
            boolean bl2 = phpArg._4();
            Domain.PhpAttributes phpAttributes = phpArg._5();
            Domain.PhpExpr expr = phpExpr;
            return this.astForExpr(expr);
        }
        if (phpArgument instanceof Domain.PhpVariadicPlaceholder) {
            NewIdentifier identifier = NewIdentifier$.MODULE$.apply().name("...").lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(arg)).code("...").typeFullName("PhpVariadicPlaceholder");
            return Ast$.MODULE$.apply((NewNode)identifier);
        }
        throw new MatchError((Object)phpArgument);
    }

    private Ast astForVariableExpr(Domain.PhpVariable variable) {
        Ast valueAst = this.astForExpr(variable.value());
        valueAst.root().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(NewNode x) {
                NewNode newNode = x;
                if (newNode instanceof ExpressionNew) {
                    ExpressionNew root = (ExpressionNew)newNode;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(NewNode x, Function1 function1) {
                NewNode newNode = x;
                if (newNode instanceof ExpressionNew) {
                    ExpressionNew root = (ExpressionNew)newNode;
                    root.code_$eq(new StringBuilder(1).append("$").append(root.code()).toString());
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x);
            }
        });
        valueAst.root().collect((PartialFunction)new Serializable(variable, this){
            private final Domain.PhpVariable variable$1;
            private final /* synthetic */ AstCreator $outer;
            {
                this.variable$1 = variable$2;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(NewNode x) {
                NewNode newNode = x;
                if (newNode instanceof NewIdentifier) {
                    NewIdentifier root = (NewIdentifier)newNode;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(NewNode x, Function1 function1) {
                NewNode newNode = x;
                if (newNode instanceof NewIdentifier) {
                    NewIdentifier root = (NewIdentifier)newNode;
                    root.lineNumber_$eq(this.$outer.io$joern$php2cpg$astcreation$AstCreator$$line(this.variable$1));
                    return BoxedUnit.UNIT;
                }
                return function1.apply((Object)x);
            }
        });
        return valueAst;
    }

    private Ast astForNameExpr(Domain.PhpNameExpr expr) {
        BatchedUpdate.DiffGraphBuilder diffGraphBuilder;
        NewIdentifier identifier = NewIdentifier$.MODULE$.apply().name(expr.name()).code(expr.name()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        Option option = this.scope.lookupVariable(identifier.name());
        if (option instanceof Some) {
            NewNode declaringNode = (NewNode)((Some)option).value();
            diffGraphBuilder = this.diffGraph().addEdge((NodeOrDetachedNode)identifier, (NodeOrDetachedNode)declaringNode, "REF");
        } else if (None$.MODULE$.equals(option)) {
            NewLocal local = NewLocal$.MODULE$.apply().name(identifier.name()).code(new StringBuilder(1).append("$").append(identifier.code()).toString()).typeFullName(identifier.typeFullName());
            this.scope.addToScope(local.name(), (NewNode)local);
            diffGraphBuilder = this.diffGraph().addEdge((NodeOrDetachedNode)identifier, (NodeOrDetachedNode)local, "REF");
        } else {
            throw new MatchError((Object)option);
        }
        return Ast$.MODULE$.apply((NewNode)identifier);
    }

    private Ast astForAssignment(Domain.PhpAssignment assignment) {
        String operatorName = assignment.assignOp();
        Ast targetAst = this.astForExpr(assignment.target());
        Ast sourceAst = this.astForExpr(assignment.source());
        String refSymbol = assignment.isRefAssign() ? "&" : "";
        String symbol = (String)AstCreator$.MODULE$.operatorSymbols().getOrElse((Object)assignment.assignOp(), () -> AstCreator.$anonfun$82(assignment));
        String code = new StringBuilder(2).append(this.rootCode(targetAst, this.rootCode$default$2())).append(" ").append(symbol).append(" ").append(refSymbol).append(this.rootCode(sourceAst, this.rootCode$default$2())).toString();
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(assignment);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(operatorName, code, option2, option, option3);
        return this.callAst(callNode, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[]{targetAst, sourceAst})), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForScalar(Domain.PhpScalar scalar) {
        Domain.PhpScalar phpScalar = scalar;
        if (phpScalar instanceof Domain.PhpString) {
            Domain.PhpString phpString = Domain$PhpString$.MODULE$.unapply((Domain.PhpString)phpScalar);
            String string = phpString._1();
            Domain.PhpAttributes phpAttributes = phpString._2();
            String value = string;
            return Ast$.MODULE$.apply((NewNode)NewLiteral$.MODULE$.apply().code(value).typeFullName(AstCreator$TypeConstants$.MODULE$.String()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(scalar)));
        }
        if (phpScalar instanceof Domain.PhpInt) {
            Domain.PhpInt phpInt = Domain$PhpInt$.MODULE$.unapply((Domain.PhpInt)phpScalar);
            String string = phpInt._1();
            Domain.PhpAttributes phpAttributes = phpInt._2();
            String value = string;
            return Ast$.MODULE$.apply((NewNode)NewLiteral$.MODULE$.apply().code(value).typeFullName(AstCreator$TypeConstants$.MODULE$.Int()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(scalar)));
        }
        if (phpScalar instanceof Domain.PhpFloat) {
            Domain.PhpFloat phpFloat = Domain$PhpFloat$.MODULE$.unapply((Domain.PhpFloat)phpScalar);
            String string = phpFloat._1();
            Domain.PhpAttributes phpAttributes = phpFloat._2();
            String value = string;
            return Ast$.MODULE$.apply((NewNode)NewLiteral$.MODULE$.apply().code(value).typeFullName(AstCreator$TypeConstants$.MODULE$.Float()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(scalar)));
        }
        if (phpScalar instanceof Domain.PhpEncapsed) {
            Domain.PhpEncapsed phpEncapsed = Domain$PhpEncapsed$.MODULE$.unapply((Domain.PhpEncapsed)phpScalar);
            Seq<Domain.PhpExpr> seq = phpEncapsed._1();
            Domain.PhpAttributes phpAttributes = phpEncapsed._2();
            Seq<Domain.PhpExpr> parts = seq;
            String string = Domain$PhpOperators$.MODULE$.encaps();
            String string2 = Domain$PhpOperators$.MODULE$.encaps();
            Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(scalar);
            Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
            Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
            NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(string, string2, option2, option, option3);
            Seq args = (Seq)parts.map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
            return this.callAst(callNode, args, this.callAst$default$3(), this.callAst$default$4());
        }
        if (phpScalar instanceof Domain.PhpEncapsedPart) {
            Domain.PhpEncapsedPart phpEncapsedPart = Domain$PhpEncapsedPart$.MODULE$.unapply((Domain.PhpEncapsedPart)phpScalar);
            String string = phpEncapsedPart._1();
            Domain.PhpAttributes phpAttributes = phpEncapsedPart._2();
            String value = string;
            return Ast$.MODULE$.apply((NewNode)NewLiteral$.MODULE$.apply().code(value).typeFullName(AstCreator$TypeConstants$.MODULE$.String()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(scalar)));
        }
        if (phpScalar == null) {
            this.logger.warn("scalar was null");
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }
        throw new MatchError((Object)phpScalar);
    }

    private Ast astForBinOp(Domain.PhpBinaryOp binOp) {
        Ast leftAst = this.astForExpr(binOp.left());
        Ast rightAst = this.astForExpr(binOp.right());
        String symbol = (String)AstCreator$.MODULE$.operatorSymbols().getOrElse((Object)binOp.operator(), () -> AstCreator.$anonfun$84(binOp));
        String code = new StringBuilder(2).append(this.rootCode(leftAst, this.rootCode$default$2())).append(" ").append(symbol).append(" ").append(this.rootCode(rightAst, this.rootCode$default$2())).toString();
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(binOp);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(binOp.operator(), code, option2, option, option3);
        return this.callAst(callNode, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[]{leftAst, rightAst})), this.callAst$default$3(), this.callAst$default$4());
    }

    private boolean isPostfixOperator(String operator) {
        return ((SetOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"<operator>.postDecrement", "<operator>.postIncrement"}))).contains((Object)operator);
    }

    private Ast astForUnaryOp(Domain.PhpUnaryOp unaryOp) {
        Ast exprAst = this.astForExpr(unaryOp.expr());
        String symbol = (String)AstCreator$.MODULE$.operatorSymbols().getOrElse((Object)unaryOp.operator(), () -> AstCreator.$anonfun$85(unaryOp));
        String code = this.isPostfixOperator(unaryOp.operator()) ? new StringBuilder(0).append(this.rootCode(exprAst, this.rootCode$default$2())).append(symbol).toString() : new StringBuilder(0).append(symbol).append(this.rootCode(exprAst, this.rootCode$default$2())).toString();
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(unaryOp);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(unaryOp.operator(), code, option2, option, option3);
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)exprAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private String rootCode(Ast ast, String string) {
        return (String)ast.root().flatMap((Function1 & Serializable)_$32 -> _$32.properties().get((Object)"CODE").map((Function1 & Serializable)_$33 -> _$33.toString())).getOrElse(() -> AstCreator.rootCode$$anonfun$2(string));
    }

    private String rootCode$default$2() {
        return "";
    }

    private Option<String> rootType(Ast ast) {
        return ast.root().flatMap((Function1 & Serializable)_$34 -> _$34.properties().get((Object)"TYPE_FULL_NAME").map((Function1 & Serializable)_$35 -> _$35.toString()));
    }

    private Ast astForCastExpr(Domain.PhpCast castExpr) {
        NewTypeRef typ = NewTypeRef$.MODULE$.apply().typeFullName(this.registerType(castExpr.typ())).code(castExpr.typ()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(castExpr));
        Ast expr = this.astForExpr(castExpr.expr());
        String codeStr = new StringBuilder(3).append("(").append(castExpr.typ()).append(") ").append(this.rootCode(expr, this.rootCode$default$2())).toString();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode("<operator>.cast", codeStr, (Option)Some$.MODULE$.apply((Object)castExpr.typ()), this.io$joern$php2cpg$astcreation$AstCreator$$line(castExpr), NodeBuilders$.MODULE$.operatorCallNode$default$5());
        Ast ast = Ast$.MODULE$.apply((NewNode)typ);
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)expr).$colon$colon((Object)ast), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForIssetExpr(Domain.PhpIsset issetExpr) {
        String name = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.issetFunc());
        Seq args = (Seq)issetExpr.vars().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        String code = new StringBuilder(2).append(name).append("(").append(args.map((Function1 & Serializable)_$36 -> StringOps$.MODULE$.mkString$extension(Predef$.MODULE$.augmentString(this.rootCode((Ast)_$36, this.rootCode$default$2())), ","))).append(")").toString();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(name, code, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Bool()), this.io$joern$php2cpg$astcreation$AstCreator$$line(issetExpr), NodeBuilders$.MODULE$.operatorCallNode$default$5()).methodFullName(Domain$PhpOperators$.MODULE$.issetFunc());
        return this.callAst(callNode, args, this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForPrintExpr(Domain.PhpPrint printExpr) {
        String name = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.printFunc());
        Ast arg = this.astForExpr(printExpr.expr());
        String code = new StringBuilder(2).append(name).append("(").append(this.rootCode(arg, this.rootCode$default$2())).append(")").toString();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(name, code, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Int()), this.io$joern$php2cpg$astcreation$AstCreator$$line(printExpr), NodeBuilders$.MODULE$.operatorCallNode$default$5()).methodFullName(Domain$PhpOperators$.MODULE$.printFunc());
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)arg), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForTernaryOp(Domain.PhpTernaryOp ternaryOp) {
        String string;
        Ast conditionAst = this.astForExpr(ternaryOp.condition());
        Option maybeThenAst = ternaryOp.thenExpr().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        Ast elseAst = this.astForExpr(ternaryOp.elseExpr());
        String operatorName = maybeThenAst.isDefined() ? "<operator>.conditional" : Domain$PhpOperators$.MODULE$.elvisOp();
        Option option = maybeThenAst;
        if (option instanceof Some) {
            Ast thenAst = (Ast)((Some)option).value();
            string = new StringBuilder(6).append(this.rootCode(conditionAst, this.rootCode$default$2())).append(" ? ").append(this.rootCode(thenAst, this.rootCode$default$2())).append(" : ").append(this.rootCode(elseAst, this.rootCode$default$2())).toString();
        } else if (None$.MODULE$.equals(option)) {
            string = new StringBuilder(4).append(this.rootCode(conditionAst, this.rootCode$default$2())).append(" ?: ").append(this.rootCode(elseAst, this.rootCode$default$2())).toString();
        } else {
            throw new MatchError((Object)option);
        }
        String code = string;
        Option<Integer> option2 = this.io$joern$php2cpg$astcreation$AstCreator$$line(ternaryOp);
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option4 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(operatorName, code, option3, option2, option4);
        List args = (List)((StrictOptimizedIterableOps)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{Some$.MODULE$.apply((Object)conditionAst), maybeThenAst, Some$.MODULE$.apply((Object)elseAst)}))).flatten(Predef$.MODULE$.$conforms());
        return this.callAst(callNode, (Seq)args, this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForThrow(Domain.PhpThrowExpr expr) {
        Ast thrownExpr = this.astForExpr(expr.expr());
        String code = new StringBuilder(6).append("throw ").append(this.rootCode(thrownExpr, this.rootCode$default$2())).toString();
        NewControlStructure throwNode = NewControlStructure$.MODULE$.apply().controlStructureType("THROW").code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        return Ast$.MODULE$.apply((NewNode)throwNode).withChild(thrownExpr);
    }

    private Ast astForClone(Domain.PhpCloneExpr expr) {
        String name = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.cloneFunc());
        Ast argAst = this.astForExpr(expr.expr());
        Option<String> argType = this.rootType(argAst);
        String code = new StringBuilder(1).append(name).append(" ").append(this.rootCode(argAst, this.rootCode$default$2())).toString();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(name, code, argType, this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.operatorCallNode$default$5()).methodFullName(Domain$PhpOperators$.MODULE$.cloneFunc());
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)argAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForEmpty(Domain.PhpEmptyExpr expr) {
        String name = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.emptyFunc());
        Ast argAst = this.astForExpr(expr.expr());
        String code = new StringBuilder(2).append(name).append("(").append(this.rootCode(argAst, this.rootCode$default$2())).append(")").toString();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(name, code, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Bool()), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.operatorCallNode$default$5()).methodFullName(Domain$PhpOperators$.MODULE$.emptyFunc());
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)argAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForEval(Domain.PhpEvalExpr expr) {
        String name = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.evalFunc());
        Ast argAst = this.astForExpr(expr.expr());
        String code = new StringBuilder(2).append(name).append("(").append(this.rootCode(argAst, this.rootCode$default$2())).append(")").toString();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(name, code, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Bool()), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.operatorCallNode$default$5()).methodFullName(Domain$PhpOperators$.MODULE$.evalFunc());
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)argAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForExit(Domain.PhpExitExpr expr2) {
        String name = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.exitFunc());
        Option args = expr2.expr().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        String code = new StringBuilder(2).append(name).append("(").append(args.map((Function1 & Serializable)_$37 -> this.rootCode((Ast)_$37, this.rootCode$default$2())).getOrElse(AstCreator::$anonfun$91)).append(")").toString();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(name, code, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Void()), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr2), NodeBuilders$.MODULE$.operatorCallNode$default$5()).methodFullName(Domain$PhpOperators$.MODULE$.exitFunc());
        return this.callAst(callNode, (Seq)args.toList(), this.callAst$default$3(), this.callAst$default$4());
    }

    private NewLocal getTmpLocal(Option<String> typeFullName, Option<Integer> lineNumber, String prefix) {
        String name = new StringBuilder(0).append(prefix).append(this.getNewTmpName(this.getNewTmpName$default$1())).toString();
        NewLocal local = NewLocal$.MODULE$.apply().name(name).code(new StringBuilder(1).append("$").append(name).toString()).lineNumber(lineNumber);
        typeFullName.foreach((Function1 & Serializable)_$38 -> local.typeFullName(_$38));
        this.scope.addToScope(name, (NewNode)local);
        return local;
    }

    private String getTmpLocal$default$3() {
        return "";
    }

    private Ast identifierAstFromLocal(NewLocal local, Option<Integer> lineNumber) {
        NewIdentifier identifier = NodeBuilders$.MODULE$.identifierNode(local.name(), (Option)Some$.MODULE$.apply((Object)local.typeFullName()), lineNumber, NodeBuilders$.MODULE$.identifierNode$default$4(), NodeBuilders$.MODULE$.identifierNode$default$5()).code(new StringBuilder(1).append("$").append(local.name()).toString());
        return Ast$.MODULE$.apply((NewNode)identifier).withRefEdge((NewNode)identifier, (NewNode)local);
    }

    private Option<Integer> identifierAstFromLocal$default$2() {
        return None$.MODULE$;
    }

    private Ast astForArrayExpr(Domain.PhpArrayExpr expr) {
        ArrayIndexTracker idxTracker = new ArrayIndexTracker();
        NewLocal tmpLocal = this.getTmpLocal((Option<String>)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Array()), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), this.getTmpLocal$default$3());
        List itemAssignments = expr.items().flatMap((Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Domain.PhpArrayItem item = (Domain.PhpArrayItem)((Some)option).value();
                return Some$.MODULE$.apply((Object)this.assignForArrayItem(item, tmpLocal, idxTracker));
            }
            if (None$.MODULE$.equals(option)) {
                idxTracker.next();
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
        NewBlock arrayBlock = NewBlock$.MODULE$.apply().lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        return Ast$.MODULE$.apply((NewNode)arrayBlock).withChild(Ast$.MODULE$.apply((NewNode)tmpLocal)).withChildren((scala.collection.Seq)itemAssignments).withChild(this.identifierAstFromLocal(tmpLocal, this.identifierAstFromLocal$default$2()));
    }

    private Ast astForListExpr(Domain.PhpListExpr expr) {
        String name = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.listFunc());
        List args = ((List)expr.items().flatten(Predef$.MODULE$.$conforms())).map((Function1 & Serializable)item -> this.astForExpr(item.value()));
        String listCode = new StringBuilder(2).append(name).append("(").append(args.map((Function1 & Serializable)_$39 -> this.rootCode((Ast)_$39, this.rootCode$default$2())).mkString(",")).append(")").toString();
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall listNode = NodeBuilders$.MODULE$.operatorCallNode(name, listCode, option2, option, option3).methodFullName(Domain$PhpOperators$.MODULE$.listFunc());
        return this.callAst(listNode, (Seq)args, this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForNewExpr(Domain.PhpNewExpr expr) {
        Domain.PhpNode phpNode = expr.className();
        if (phpNode instanceof Domain.PhpClassLikeStmt) {
            Domain.PhpClassLikeStmt classLikeStmt = (Domain.PhpClassLikeStmt)phpNode;
            return this.astForAnonymousClassInstantiation(expr, classLikeStmt);
        }
        if (phpNode instanceof Domain.PhpExpr) {
            Domain.PhpExpr classNameExpr = (Domain.PhpExpr)phpNode;
            return this.astForSimpleNewExpr(expr, classNameExpr);
        }
        Domain.PhpNode other = phpNode;
        throw new NotImplementedError(new StringBuilder(32).append("unexpected expession '").append(other).append("' of type ").append(other.getClass()).toString());
    }

    private Ast astForMatchExpr(Domain.PhpMatchExpr expr) {
        Ast conditionAst = this.astForExpr(expr.condition());
        NewControlStructure matchNode = NewControlStructure$.MODULE$.apply().controlStructureType("MATCH").code(new StringBuilder(8).append("match (").append(this.rootCode(conditionAst, this.rootCode$default$2())).append(")").toString()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        NewBlock matchBodyBlock = NewBlock$.MODULE$.apply().lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        List armsAsts = expr.matchArms().flatMap((Function1 & Serializable)matchArm -> this.astsForMatchArm((Domain.PhpMatchArm)matchArm));
        Ast matchBody = Ast$.MODULE$.apply((NewNode)matchBodyBlock).withChildren((scala.collection.Seq)armsAsts);
        return this.controlStructureAst(matchNode, (Option)Some$.MODULE$.apply((Object)conditionAst), package$.MODULE$.Nil().$colon$colon((Object)matchBody), this.controlStructureAst$default$4());
    }

    private List<Ast> astsForMatchArm(Domain.PhpMatchArm matchArm) {
        List targets = matchArm.conditions().map((Function1 & Serializable)condition -> {
            Ast conditionAst = this.astForExpr((Domain.PhpExpr)condition);
            String code = new StringBuilder(5).append("case ").append(this.rootCode(conditionAst, AstCreator$NameConstants$.MODULE$.Unknown())).toString();
            return NewJumpTarget$.MODULE$.apply().name(code).code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line((Domain.PhpNode)condition));
        });
        Option defaultLabel = Option$.MODULE$.when(matchArm.isDefault(), () -> this.$anonfun$97(matchArm));
        List targetAsts = ((List)targets.$plus$plus((IterableOnce)defaultLabel.toList())).map((Function1 & Serializable)_$40 -> Ast$.MODULE$.apply((NewNode)_$40));
        Ast bodyAst = this.astForExpr(matchArm.body());
        return (List)targetAsts.$colon$plus((Object)bodyAst);
    }

    /*
     * Unable to fully structure code
     */
    private Ast astForYieldExpr(Domain.PhpYieldExpr expr) {
        maybeKey = expr.key().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$99(io.joern.php2cpg.parser.Domain$PhpExpr ), (Lio/joern/php2cpg/parser/Domain$PhpExpr;)Lio/joern/x2cpg/Ast;)((AstCreator)this));
        var5_4 = Tuple2$.MODULE$.apply((Object)maybeKey, (Object)(maybeVal = expr.value().map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$100(io.joern.php2cpg.parser.Domain$PhpExpr ), (Lio/joern/php2cpg/parser/Domain$PhpExpr;)Lio/joern/x2cpg/Ast;)((AstCreator)this))));
        if (var5_4 == null) ** GOTO lbl-1000
        var6_5 = (Option)var5_4._1();
        var7_6 = (Option)var5_4._2();
        if (!(var6_5 instanceof Some)) ** GOTO lbl-1000
        key = (Ast)((Some)var6_5).value();
        if (var7_6 instanceof Some) {
            value = (Ast)((Some)var7_6).value();
            v0 = new StringBuilder(10).append("yield ").append(this.rootCode(key, this.rootCode$default$2())).append(" => ").append(this.rootCode(value, this.rootCode$default$2())).toString();
        } else lbl-1000:
        // 3 sources

        {
            v0 = new StringBuilder(6).append("yield ").append(maybeKey.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$101(io.joern.x2cpg.Ast ), (Lio/joern/x2cpg/Ast;)Ljava/lang/String;)((AstCreator)this)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$102(), ()Ljava/lang/String;)())).append(maybeVal.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$103(io.joern.x2cpg.Ast ), (Lio/joern/x2cpg/Ast;)Ljava/lang/String;)((AstCreator)this)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$104(), ()Ljava/lang/String;)())).toString().trim();
        }
        code = v0;
        yieldNode = NewControlStructure$.MODULE$.apply().controlStructureType("YIELD").code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        return Ast$.MODULE$.apply((NewNode)yieldNode).withChildren((scala.collection.Seq)maybeKey.toList()).withChildren((scala.collection.Seq)maybeVal.toList());
    }

    private Ast astForClosureExpr(Domain.PhpClosureExpr expr) {
        String string;
        String methodName = this.getNewTmpName("__closure");
        String typePrefix = this.getNamespacePrefixForName();
        String methodFullName = new StringBuilder(3).append(typePrefix).append(methodName).append(":").append(Defines$.MODULE$.UnresolvedSignature()).append("(").append(expr.params().size()).append(")").toString();
        NewMethodRef methodRef = NewMethodRef$.MODULE$.apply().methodFullName(methodFullName).code(methodFullName).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        List localsForUses = expr.uses().flatMap((Function1 & Serializable)closureUse -> {
            Ast variableAst = this.astForExpr(closureUse.variable());
            String codePref = closureUse.byRef() ? "&" : "";
            Option option = variableAst.root();
            if (option instanceof Some) {
                NewNode newNode = (NewNode)((Some)option).value();
                if (newNode instanceof NewIdentifier) {
                    NewIdentifier identifier = (NewIdentifier)newNode;
                    return Some$.MODULE$.apply((Object)NewLocal$.MODULE$.apply().name(identifier.name()).code(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(codePref), identifier.code())));
                }
                if (newNode instanceof ExpressionNew) {
                    ExpressionNew expr = (ExpressionNew)newNode;
                    return Some$.MODULE$.apply((Object)NewLocal$.MODULE$.apply().name(expr.code()).code(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(codePref), expr.code())));
                }
            }
            if (None$.MODULE$.equals(option)) {
                this.logger.warn(new StringBuilder(35).append("Found empty ast for closure use in ").append(this.filename).toString());
                return None$.MODULE$;
            }
            throw new MatchError((Object)option);
        });
        localsForUses.foreach((Function1 & Serializable)local -> this.scope.lookupVariable(local.name()).map((Function1 & Serializable)capturedNode -> {
            String closureBindingId = new StringBuilder(2).append(this.filename).append(":").append(methodName).append(":").append(local.name()).toString();
            NewClosureBinding closureBindingNode = NewClosureBinding$.MODULE$.apply().closureBindingId(closureBindingId).closureOriginalName(local.name()).evaluationStrategy("BY_SHARING");
            local.closureBindingId(closureBindingId);
            this.diffGraph().addNode((DetachedNodeData)closureBindingNode);
            this.diffGraph().addEdge((NodeOrDetachedNode)closureBindingNode, (NodeOrDetachedNode)capturedNode, "REF");
            return this.diffGraph().addEdge((NodeOrDetachedNode)methodRef, (NodeOrDetachedNode)closureBindingNode, "CAPTURE");
        }));
        Domain.PhpNameExpr name = Domain$PhpNameExpr$.MODULE$.apply(methodName, expr.attributes());
        Nil$ modifiers = package$.MODULE$.Nil();
        Domain.PhpMethodDecl methodDecl = Domain$PhpMethodDecl$.MODULE$.apply(name, (Seq<Domain.PhpParam>)expr.params(), (List<String>)modifiers, expr.returnType(), (Seq<Domain.PhpStmt>)expr.stmts(), expr.returnByRef(), (Option<Domain.PhpNameExpr>)None$.MODULE$, expr.isStatic(), expr.attributes());
        Ast methodAst = this.astForMethodDecl(methodDecl, (List<Ast>)localsForUses.map((Function1 & Serializable)_$43 -> Ast$.MODULE$.apply((NewNode)_$43)), (Option<String>)Some$.MODULE$.apply((Object)methodFullName));
        List list = localsForUses;
        Nil$ nil$ = package$.MODULE$.Nil();
        List list2 = list;
        if (!(nil$ != null ? !nil$.equals(list2) : list2 != null)) {
            string = "";
        } else {
            List locals = list;
            string = new StringBuilder(6).append(" use(").append(locals.map((Function1 & Serializable)_$44 -> _$44.code()).mkString(", ")).append(")").toString();
        }
        String usesCode = string;
        methodAst.root().collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(NewNode x) {
                NewNode newNode = x;
                if (newNode instanceof NewMethod) {
                    NewMethod method = (NewMethod)newNode;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(NewNode x, Function1 function1) {
                NewNode newNode = x;
                if (newNode instanceof NewMethod) {
                    NewMethod method = (NewMethod)newNode;
                    return method;
                }
                return function1.apply((Object)x);
            }
        }).foreach((Function1 & Serializable)methodNode -> methodNode.code(StringOps$.MODULE$.$plus$plus$extension(Predef$.MODULE$.augmentString(methodNode.code()), usesCode)));
        this.scope.addAnonymousMethod(methodAst);
        return Ast$.MODULE$.apply((NewNode)methodRef);
    }

    private Ast astForYieldFromExpr(Domain.PhpYieldFromExpr expr) {
        Ast exprAst = this.astForExpr(expr.expr());
        String code = new StringBuilder(11).append("yield from ").append(this.rootCode(exprAst, this.rootCode$default$2())).toString();
        NewControlStructure yieldNode = NewControlStructure$.MODULE$.apply().controlStructureType("YIELD").code(code).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        return Ast$.MODULE$.apply((NewNode)yieldNode).withChild(exprAst);
    }

    private Ast astForAnonymousClassInstantiation(Domain.PhpNewExpr expr, Domain.PhpClassLikeStmt classLikeStmt) {
        return Ast$.MODULE$.apply();
    }

    private Ast astForSimpleNewExpr(Domain.PhpNewExpr expr, Domain.PhpExpr classNameExpr) {
        Tuple2 tuple2;
        Domain.PhpExpr phpExpr = classNameExpr;
        if (phpExpr instanceof Domain.PhpNameExpr) {
            Domain.PhpNameExpr nameExpr = (Domain.PhpNameExpr)phpExpr;
            tuple2 = Tuple2$.MODULE$.apply((Object)None$.MODULE$, (Object)nameExpr.name());
        } else if (phpExpr != null) {
            Domain.PhpExpr expr2 = phpExpr;
            Ast ast = this.astForExpr(expr2);
            String name = this.rootCode(ast, AstCreator$NameConstants$.MODULE$.Unknown());
            tuple2 = Tuple2$.MODULE$.apply((Object)Some$.MODULE$.apply((Object)ast), (Object)name);
        } else {
            throw new MatchError((Object)phpExpr);
        }
        Tuple2 tuple22 = tuple2;
        Option maybeNameAst = (Option)tuple22._1();
        String className = (String)tuple22._2();
        NewLocal tmpLocal = this.getTmpLocal((Option<String>)Some$.MODULE$.apply((Object)className), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), this.getTmpLocal$default$3());
        String allocCode = new StringBuilder(10).append(className).append(".<alloc>()").toString();
        NewCall allocNode = NodeBuilders$.MODULE$.operatorCallNode("<operator>.alloc", allocCode, (Option)Some$.MODULE$.apply((Object)className), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.operatorCallNode$default$5());
        Ast allocAst = this.callAst(allocNode, this.callAst$default$2(), maybeNameAst, this.callAst$default$4());
        String allocAssignCode = new StringBuilder(3).append(tmpLocal.code()).append(" = ").append(this.rootCode(allocAst, this.rootCode$default$2())).toString();
        NewCall allocAssignNode = NodeBuilders$.MODULE$.operatorCallNode("<operator>.assignment", allocAssignCode, (Option)Some$.MODULE$.apply((Object)className), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.operatorCallNode$default$5());
        Ast allocAssignIdentifier = this.identifierAstFromLocal(tmpLocal, this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        Ast allocAssignAst = this.callAst(allocAssignNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)allocAst).$colon$colon((Object)allocAssignIdentifier), this.callAst$default$3(), this.callAst$default$4());
        List initArgs = expr.args().map((Function1 & Serializable)arg -> this.astForCallArg((Domain.PhpArgument)arg));
        String initSignature = new StringBuilder(2).append(Defines$.MODULE$.UnresolvedSignature()).append("(").append(initArgs.size()).append(")").toString();
        String initNamePrefix = new StringBuilder(1).append(className).append(".").append(Defines$.MODULE$.ConstructorMethodName()).toString();
        String initFullName = new StringBuilder(1).append(initNamePrefix).append(":").append(initSignature).toString();
        String initCode = new StringBuilder(2).append(initNamePrefix).append("(").append(initArgs.map((Function1 & Serializable)_$45 -> this.rootCode((Ast)_$45, this.rootCode$default$2())).mkString(",")).append(")").toString();
        NewCall initCallNode = NewCall$.MODULE$.apply().name(Defines$.MODULE$.ConstructorMethodName()).methodFullName(initFullName).signature(initSignature).code(initCode).dispatchType("DYNAMIC_DISPATCH").lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        Ast initReceiver = this.identifierAstFromLocal(tmpLocal, this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        Ast initCallAst = this.callAst(initCallNode, (Seq)initArgs, (Option)Some$.MODULE$.apply((Object)initReceiver), this.callAst$default$4());
        Ast returnIdentifierAst = this.identifierAstFromLocal(tmpLocal, this.io$joern$php2cpg$astcreation$AstCreator$$line(expr));
        return Ast$.MODULE$.apply((NewNode)NewBlock$.MODULE$.apply().lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(expr))).withChild(Ast$.MODULE$.apply((NewNode)tmpLocal)).withChild(allocAssignAst).withChild(initCallAst).withChild(returnIdentifierAst);
    }

    private Domain.PhpExpr dimensionFromSimpleScalar(Domain.PhpSimpleScalar scalar, ArrayIndexTracker idxTracker) {
        Option maybeIntValue;
        Option option;
        Domain.PhpSimpleScalar phpSimpleScalar = scalar;
        if (phpSimpleScalar instanceof Domain.PhpString) {
            Domain.PhpString string = (Domain.PhpString)phpSimpleScalar;
            option = StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(StringOps$.MODULE$.drop$extension(Predef$.MODULE$.augmentString(string.value()), 1)), 1)));
        } else {
            Domain.PhpSimpleScalar number = phpSimpleScalar;
            option = StringOps$.MODULE$.toIntOption$extension(Predef$.MODULE$.augmentString(number.value()));
        }
        Option option2 = maybeIntValue = option;
        if (option2 instanceof Some) {
            int intValue = BoxesRunTime.unboxToInt((Object)((Some)option2).value());
            idxTracker.updateValue(intValue);
            return Domain$PhpInt$.MODULE$.apply(BoxesRunTime.boxToInteger((int)intValue).toString(), scalar.attributes());
        }
        if (None$.MODULE$.equals(option2)) {
            return scalar;
        }
        throw new MatchError((Object)option2);
    }

    private Ast assignForArrayItem(Domain.PhpArrayItem item, NewLocal arrayLocal, ArrayIndexTracker idxTracker) {
        Domain.PhpExpr phpExpr;
        Domain.PhpVariable variable = Domain$PhpVariable$.MODULE$.apply(Domain$PhpNameExpr$.MODULE$.apply(arrayLocal.name(), item.attributes()), item.attributes());
        Option<Domain.PhpExpr> option = item.key();
        if (option instanceof Some) {
            Domain.PhpExpr phpExpr2 = (Domain.PhpExpr)((Some)option).value();
            if (phpExpr2 instanceof Domain.PhpSimpleScalar) {
                Domain.PhpSimpleScalar key = (Domain.PhpSimpleScalar)phpExpr2;
                phpExpr = this.dimensionFromSimpleScalar(key, idxTracker);
            } else {
                Domain.PhpExpr key = phpExpr2;
                phpExpr = key;
            }
        } else if (None$.MODULE$.equals(option)) {
            phpExpr = Domain$PhpInt$.MODULE$.apply(idxTracker.next(), item.attributes());
        } else {
            throw new MatchError(option);
        }
        Domain.PhpExpr dimension = phpExpr;
        Domain.PhpArrayDimFetchExpr dimFetchNode = Domain$PhpArrayDimFetchExpr$.MODULE$.apply(variable, (Option<Domain.PhpExpr>)Some$.MODULE$.apply((Object)dimension), item.attributes());
        Ast dimFetchAst = this.astForArrayDimFetchExpr(dimFetchNode);
        Ast valueAst = this.astForArrayItemValue(item);
        String assignCode = new StringBuilder(3).append(this.rootCode(dimFetchAst, this.rootCode$default$2())).append(" = ").append(this.rootCode(valueAst, this.rootCode$default$2())).toString();
        String string = "<operator>.assignment";
        Option<Integer> option2 = this.io$joern$php2cpg$astcreation$AstCreator$$line(item);
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option4 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall assignNode = NodeBuilders$.MODULE$.operatorCallNode(string, assignCode, option3, option2, option4);
        return this.callAst(assignNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)valueAst).$colon$colon((Object)dimFetchAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForArrayItemValue(Domain.PhpArrayItem item) {
        Ast exprAst = this.astForExpr(item.value());
        String valueCode = this.rootCode(exprAst, this.rootCode$default$2());
        if (item.byRef()) {
            String string = "<operator>.addressOf";
            String string2 = new StringBuilder(1).append("&").append(valueCode).toString();
            Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(item);
            Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
            Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
            NewCall parentCall = NodeBuilders$.MODULE$.operatorCallNode(string, string2, option2, option, option3);
            return this.callAst(parentCall, (Seq)package$.MODULE$.Nil().$colon$colon((Object)exprAst), this.callAst$default$3(), this.callAst$default$4());
        }
        if (item.unpack()) {
            String string = Domain$PhpOperators$.MODULE$.unpack();
            String string3 = new StringBuilder(3).append("...").append(valueCode).toString();
            Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(item);
            Option option4 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
            Option option5 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
            NewCall parentCall = NodeBuilders$.MODULE$.operatorCallNode(string, string3, option4, option, option5);
            return this.callAst(parentCall, (Seq)package$.MODULE$.Nil().$colon$colon((Object)exprAst), this.callAst$default$3(), this.callAst$default$4());
        }
        return exprAst;
    }

    private Ast astForArrayDimFetchExpr(Domain.PhpArrayDimFetchExpr expr) {
        Ast variableAst = this.astForExpr(expr.variable());
        String variableCode = this.rootCode(variableAst, this.rootCode$default$2());
        Option<Domain.PhpExpr> option = expr.dimension();
        if (option instanceof Some) {
            Domain.PhpExpr dimension = (Domain.PhpExpr)((Some)option).value();
            Ast dimensionAst = this.astForExpr(dimension);
            String code = new StringBuilder(2).append(variableCode).append("[").append(this.rootCode(dimensionAst, this.rootCode$default$2())).append("]").toString();
            String string = "<operator>.indexAccess";
            Option<Integer> option2 = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr);
            Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
            Option option4 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
            NewCall accessNode = NodeBuilders$.MODULE$.operatorCallNode(string, code, option3, option2, option4);
            return this.callAst(accessNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)dimensionAst).$colon$colon((Object)variableAst), this.callAst$default$3(), this.callAst$default$4());
        }
        if (None$.MODULE$.equals(option)) {
            String string = Domain$PhpOperators$.MODULE$.emptyArrayIdx();
            String string2 = new StringBuilder(2).append(variableCode).append("[]").toString();
            Option<Integer> option5 = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr);
            Option option6 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
            Option option7 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
            NewCall accessNode = NodeBuilders$.MODULE$.operatorCallNode(string, string2, option6, option5, option7);
            return this.callAst(accessNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)variableAst), this.callAst$default$3(), this.callAst$default$4());
        }
        throw new MatchError(option);
    }

    private Ast astForErrorSuppressExpr(Domain.PhpErrorSuppressExpr expr) {
        Ast childAst = this.astForExpr(expr.expr());
        String code = new StringBuilder(1).append("@").append(this.rootCode(childAst, this.rootCode$default$2())).toString();
        String string = Domain$PhpOperators$.MODULE$.errorSuppress();
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall suppressNode = NodeBuilders$.MODULE$.operatorCallNode(string, code, option2, option, option3);
        this.rootType(childAst).foreach((Function1 & Serializable)_$46 -> suppressNode.typeFullName(_$46));
        return this.callAst(suppressNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)childAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForInstanceOfExpr(Domain.PhpInstanceOfExpr expr) {
        Ast exprAst = this.astForExpr(expr.expr());
        Ast classAst = this.astForExpr(expr.className());
        String code = new StringBuilder(12).append(this.rootCode(exprAst, this.rootCode$default$2())).append(" instanceof ").append(this.rootCode(classAst, this.rootCode$default$2())).toString();
        NewCall instanceOfNode = NodeBuilders$.MODULE$.operatorCallNode("<operator>.instanceOf", code, (Option)Some$.MODULE$.apply((Object)AstCreator$TypeConstants$.MODULE$.Bool()), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.operatorCallNode$default$5());
        return this.callAst(instanceOfNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)classAst).$colon$colon((Object)exprAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForPropertyFetchExpr(Domain.PhpPropertyFetchExpr expr) {
        Ast fieldAst;
        Ast ast;
        Ast objExprAst = this.astForExpr(expr.expr());
        Domain.PhpExpr phpExpr = expr.name();
        if (phpExpr instanceof Domain.PhpNameExpr) {
            Domain.PhpNameExpr name = (Domain.PhpNameExpr)phpExpr;
            ast = Ast$.MODULE$.apply((NewNode)NodeBuilders$.MODULE$.fieldIdentifierNode(name.name(), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.fieldIdentifierNode$default$3()));
        } else {
            Domain.PhpExpr other = phpExpr;
            ast = fieldAst = this.astForExpr(other);
        }
        String accessSymbol = expr.isStatic() ? "::" : (expr.isNullsafe() ? "?->" : "->");
        String code = new StringBuilder(0).append(this.rootCode(objExprAst, this.rootCode$default$2())).append(accessSymbol).append(this.rootCode(fieldAst, this.rootCode$default$2())).toString();
        String string = "<operator>.fieldAccess";
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall fieldAccessNode = NodeBuilders$.MODULE$.operatorCallNode(string, code, option2, option, option3);
        return this.callAst(fieldAccessNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)fieldAst).$colon$colon((Object)objExprAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForIncludeExpr(Domain.PhpIncludeExpr expr) {
        Ast exprAst = this.astForExpr(expr.expr());
        String code = new StringBuilder(1).append(expr.includeType()).append(" ").append(this.rootCode(exprAst, this.rootCode$default$2())).toString();
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(expr.includeType(), code, option2, option, option3);
        return this.callAst(callNode, (Seq)package$.MODULE$.Nil().$colon$colon((Object)exprAst), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForShellExecExpr(Domain.PhpShellExecExpr expr2) {
        List args = expr2.parts().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
        String code = new StringBuilder(2).append("`").append(args.map((Function1 & Serializable)_$47 -> this.rootCode((Ast)_$47, this.rootCode$default$2())).mkString("").replaceAll("\"", "")).append("`").toString();
        String string = this.stripBuiltinPrefix(Domain$PhpOperators$.MODULE$.shellExec());
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr2);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall callNode = NodeBuilders$.MODULE$.operatorCallNode(string, code, option2, option, option3).methodFullName(Domain$PhpOperators$.MODULE$.shellExec());
        return this.callAst(callNode, (Seq)args, this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForClassConstFetchExpr(Domain.PhpClassConstFetchExpr expr) {
        Ast target = this.astForExpr(expr.className());
        String fieldIdentifierName = (String)expr.constantName().map((Function1 & Serializable)_$48 -> _$48.name()).getOrElse(AstCreator::$anonfun$113);
        NewFieldIdentifier fieldIdentifier = NodeBuilders$.MODULE$.fieldIdentifierNode(fieldIdentifierName, this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.fieldIdentifierNode$default$3());
        String fieldAccessCode = new StringBuilder(2).append(this.rootCode(target, this.rootCode$default$2())).append("::").append(fieldIdentifier.code()).toString();
        String string = "<operator>.fieldAccess";
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall fieldAccessCall = NodeBuilders$.MODULE$.operatorCallNode(string, fieldAccessCode, option2, option, option3);
        return this.callAst(fieldAccessCall, (Seq)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[]{target, Ast$.MODULE$.apply((NewNode)fieldIdentifier)})), this.callAst$default$3(), this.callAst$default$4());
    }

    private Ast astForConstFetchExpr(Domain.PhpConstFetchExpr expr) {
        NewIdentifier identifier = NodeBuilders$.MODULE$.identifierNode(NamespaceTraversal$.MODULE$.globalNamespaceName(), (Option)None$.MODULE$, this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.identifierNode$default$4(), NodeBuilders$.MODULE$.identifierNode$default$5());
        NewFieldIdentifier fieldIdentifier = NodeBuilders$.MODULE$.fieldIdentifierNode(expr.name().name(), this.io$joern$php2cpg$astcreation$AstCreator$$line(expr), NodeBuilders$.MODULE$.fieldIdentifierNode$default$3());
        String string = "<operator>.fieldAccess";
        Option<Integer> option = this.io$joern$php2cpg$astcreation$AstCreator$$line(expr);
        Option option2 = NodeBuilders$.MODULE$.operatorCallNode$default$3();
        Option option3 = NodeBuilders$.MODULE$.operatorCallNode$default$5();
        NewCall fieldAccessNode = NodeBuilders$.MODULE$.operatorCallNode(string, expr.name().name(), option2, option, option3);
        List args = ((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new ExpressionBase[]{identifier, fieldIdentifier}))).map((Function1 & Serializable)_$49 -> Ast$.MODULE$.apply((NewNode)_$49));
        return this.callAst(fieldAccessNode, (Seq)args, this.callAst$default$3(), this.callAst$default$4());
    }

    public Option<Integer> io$joern$php2cpg$astcreation$AstCreator$$line(Domain.PhpNode phpNode) {
        return phpNode.attributes().lineNumber();
    }

    private static final String $anonfun$6() {
        return AstCreator$TypeConstants$.MODULE$.Any();
    }

    private static final String $anonfun$7(Domain.PhpMethodDecl decl$1, String namespacePrefix$1, String signature$1) {
        return new StringBuilder(1).append(namespacePrefix$1).append(decl$1.name().name()).append(":").append(signature$1).toString();
    }

    private static final String $anonfun$13() {
        return AstCreator$TypeConstants$.MODULE$.Any();
    }

    private static final String $anonfun$18() {
        return AstCreator$TypeConstants$.MODULE$.Any();
    }

    private static final /* synthetic */ String $anonfun$19(int num) {
        return new StringBuilder(7).append("break(").append(num).append(")").toString();
    }

    private static final String $anonfun$20() {
        return "break";
    }

    private final /* synthetic */ Ast $anonfun$21(int num) {
        return this.intToLiteralAst(num);
    }

    private static final /* synthetic */ String $anonfun$22(int num) {
        return new StringBuilder(10).append("continue(").append(num).append(")").toString();
    }

    private static final String $anonfun$23() {
        return "continue";
    }

    private final /* synthetic */ Ast $anonfun$24(int num) {
        return this.intToLiteralAst(num);
    }

    private static final String $anonfun$37() {
        return "";
    }

    private static final String $anonfun$39() {
        return AstCreator$NameConstants$.MODULE$.Unknown();
    }

    private static final String $anonfun$50() {
        return "";
    }

    private static final String $anonfun$59() {
        return "";
    }

    private static final String getNamespacePrefixForName$$anonfun$3() {
        return "";
    }

    private static final String $anonfun$75() {
        return Defines$.MODULE$.UnresolvedNamespace();
    }

    private final /* synthetic */ Ast $anonfun$76(Domain.PhpArgument arg) {
        return this.astForCallArg(arg);
    }

    private final Option $anonfun$77(Domain.PhpCallExpr call$1) {
        return call$1.target().map((Function1 & Serializable)expr -> this.astForExpr((Domain.PhpExpr)expr));
    }

    private final Ast $anonfun$78(Domain.PhpCallExpr call$2) {
        return this.astForExpr(call$2.methodName());
    }

    private final /* synthetic */ String $anonfun$79(Ast _$30) {
        return this.rootCode(_$30, this.rootCode$default$2());
    }

    private final String $anonfun$80(Domain.PhpCallExpr call$3) {
        Domain.PhpExpr phpExpr = call$3.methodName();
        if (phpExpr instanceof Domain.PhpNameExpr) {
            Domain.PhpNameExpr nameExpr = (Domain.PhpNameExpr)phpExpr;
            return nameExpr.name();
        }
        Domain.PhpExpr other = phpExpr;
        this.logger.error(new StringBuilder(75).append("Found unexpected call target type: Crash for now to handle properly later: ").append(other).toString());
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private final /* synthetic */ String $anonfun$81(Ast _$31) {
        return this.rootCode(_$31, this.rootCode$default$2());
    }

    private static final String $anonfun$82(Domain.PhpAssignment assignment$1) {
        return assignment$1.assignOp();
    }

    private static final String $anonfun$84(Domain.PhpBinaryOp binOp$1) {
        return binOp$1.operator();
    }

    private static final String $anonfun$85(Domain.PhpUnaryOp unaryOp$1) {
        return unaryOp$1.operator();
    }

    private static final String rootCode$$anonfun$2(String default$1) {
        return default$1;
    }

    private static final String $anonfun$91() {
        return "";
    }

    private final NewJumpTarget $anonfun$97(Domain.PhpMatchArm matchArm$1) {
        return NewJumpTarget$.MODULE$.apply().name(AstCreator$NameConstants$.MODULE$.Default()).code(AstCreator$NameConstants$.MODULE$.Default()).lineNumber(this.io$joern$php2cpg$astcreation$AstCreator$$line(matchArm$1));
    }

    private final /* synthetic */ Ast $anonfun$99(Domain.PhpExpr expr) {
        return this.astForExpr(expr);
    }

    private final /* synthetic */ Ast $anonfun$100(Domain.PhpExpr expr) {
        return this.astForExpr(expr);
    }

    private final /* synthetic */ String $anonfun$101(Ast _$41) {
        return this.rootCode(_$41, this.rootCode$default$2());
    }

    private static final String $anonfun$102() {
        return "";
    }

    private final /* synthetic */ String $anonfun$103(Ast _$42) {
        return this.rootCode(_$42, this.rootCode$default$2());
    }

    private static final String $anonfun$104() {
        return "";
    }

    private static final String $anonfun$113() {
        return AstCreator$NameConstants$.MODULE$.Unknown();
    }
}

