/*
 * Decompiled with CFR 0.152.
 */
package io.joern.php2cpg.datastructures;

import io.joern.x2cpg.Ast;
import io.shiftleft.codepropertygraph.generated.nodes.NewLocal;
import io.shiftleft.codepropertygraph.generated.nodes.NewMethod;
import io.shiftleft.codepropertygraph.generated.nodes.NewNamespaceBlock;
import io.shiftleft.codepropertygraph.generated.nodes.NewNode;
import io.shiftleft.codepropertygraph.generated.nodes.NewTypeDecl;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

public class Scope
extends io.joern.x2cpg.datastructures.Scope<String, NewNode, NewNode> {
    private final Logger logger = LoggerFactory.getLogger((Class)this.getClass());
    private List<ArrayBuffer<NewLocal>> localStack = package$.MODULE$.Nil();
    private List<ArrayBuffer<Ast>> constAndStaticInits = package$.MODULE$.Nil();
    private List<ArrayBuffer<Ast>> fieldInits = package$.MODULE$.Nil();
    private final ArrayBuffer<Ast> anonymousMethods = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[0]));

    public void pushNewScope(NewNode scopeNode) {
        NewNode newNode = scopeNode;
        if (newNode instanceof NewMethod) {
            ArrayBuffer arrayBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new NewLocal[0]));
            this.localStack = this.localStack.$colon$colon((Object)arrayBuffer);
            super.pushNewScope((Object)scopeNode);
            return;
        }
        if (newNode instanceof NewTypeDecl) {
            ArrayBuffer arrayBuffer = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[0]));
            this.constAndStaticInits = this.constAndStaticInits.$colon$colon((Object)arrayBuffer);
            ArrayBuffer arrayBuffer2 = (ArrayBuffer)ArrayBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Ast[0]));
            this.fieldInits = this.fieldInits.$colon$colon((Object)arrayBuffer2);
            super.pushNewScope((Object)scopeNode);
            return;
        }
        if (newNode instanceof NewNamespaceBlock) {
            super.pushNewScope((Object)scopeNode);
            return;
        }
        NewNode invalid = newNode;
        this.logger.warn(new StringBuilder(49).append("pushNewScope called with invalid node ").append(invalid).append(". Ignoring!").toString());
    }

    public Option<NewNode> popScope() {
        Option poppedScope;
        block0: {
            NewNode newNode;
            block1: {
                poppedScope = super.popScope();
                Option option = poppedScope;
                if (!(option instanceof Some)) break block0;
                newNode = (NewNode)((Some)option).value();
                if (!(newNode instanceof NewMethod)) break block1;
                this.localStack = (List)this.localStack.tail();
                break block0;
            }
            if (!(newNode instanceof NewTypeDecl)) break block0;
            this.constAndStaticInits = (List)this.constAndStaticInits.tail();
            this.fieldInits = (List)this.fieldInits.tail();
        }
        return poppedScope;
    }

    public NewNode addToScope(String identifier, NewNode variable) {
        BoxedUnit boxedUnit;
        NewNode newNode = variable;
        if (newNode instanceof NewLocal) {
            NewLocal local = (NewLocal)newNode;
            boxedUnit = ((ArrayBuffer)this.localStack.head()).addOne((Object)local);
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return (NewNode)super.addToScope((Object)identifier, (Object)variable);
    }

    public void addAnonymousMethod(Ast methodAst) {
        this.anonymousMethods.addOne((Object)methodAst);
    }

    public List<Ast> getAndClearAnonymousMethods() {
        List methods = this.anonymousMethods.toList();
        this.anonymousMethods.clear();
        return methods;
    }

    public Option<String> getEnclosingNamespaceName() {
        return this.stack().map((Function1 & Serializable)_$1 -> (NewNode)_$1.scopeNode()).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(NewNode x) {
                NewNode newNode = x;
                if (newNode instanceof NewNamespaceBlock) {
                    NewNamespaceBlock ns = (NewNamespaceBlock)newNode;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(NewNode x, Function1 function1) {
                NewNode newNode = x;
                if (newNode instanceof NewNamespaceBlock) {
                    NewNamespaceBlock ns = (NewNamespaceBlock)newNode;
                    return ns;
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)_$2 -> _$2.name());
    }

    public Option<String> getEnclosingTypeDeclType() {
        return this.stack().map((Function1 & Serializable)_$3 -> (NewNode)_$3.scopeNode()).collectFirst((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(NewNode x) {
                NewNode newNode = x;
                if (newNode instanceof NewTypeDecl) {
                    NewTypeDecl td = (NewTypeDecl)newNode;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(NewNode x, Function1 function1) {
                NewNode newNode = x;
                if (newNode instanceof NewTypeDecl) {
                    NewTypeDecl td = (NewTypeDecl)newNode;
                    return td;
                }
                return function1.apply((Object)x);
            }
        }).map((Function1 & Serializable)_$4 -> _$4.fullName());
    }

    public List<NewLocal> getLocalsInScope() {
        return (List)this.localStack.headOption().map((Function1 & Serializable)_$5 -> _$5.toList()).toList().flatten(Predef$.MODULE$.$conforms());
    }

    public void addConstOrStaticInitToScope(Ast ast) {
        this.addInitToScope(ast, this.constAndStaticInits);
    }

    public List<Ast> getConstAndStaticInits() {
        return this.getInits(this.constAndStaticInits);
    }

    public void addFieldInitToScope(Ast ast) {
        this.addInitToScope(ast, this.fieldInits);
    }

    public List<Ast> getFieldInits() {
        return this.getInits(this.fieldInits);
    }

    private void addInitToScope(Ast ast, List<ArrayBuffer<Ast>> initList) {
        ((ArrayBuffer)initList.head()).addOne((Object)ast);
    }

    private List<Ast> getInits(List<ArrayBuffer<Ast>> initList) {
        List ret = ((IterableOnceOps)initList.head()).toList();
        ((ArrayBuffer)initList.head()).clear();
        return ret;
    }
}

