/*
 * Decompiled with CFR 0.152.
 */
package io.joern.php2cpg;

import io.joern.php2cpg.Config;
import io.joern.php2cpg.Php2Cpg$;
import io.joern.php2cpg.parser.PhpParser;
import io.joern.php2cpg.parser.PhpParser$;
import io.joern.php2cpg.passes.AnyTypePass;
import io.joern.php2cpg.passes.AstCreationPass;
import io.joern.php2cpg.passes.AstParentInfoPass;
import io.joern.php2cpg.passes.ClosureRefPass;
import io.joern.php2cpg.passes.LocalCreationPass$;
import io.joern.x2cpg.X2Cpg$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.X2CpgFrontend;
import io.joern.x2cpg.passes.frontend.MetaDataPass;
import io.joern.x2cpg.passes.frontend.MetaDataPass$;
import io.joern.x2cpg.passes.frontend.TypeNodePass$;
import io.joern.x2cpg.utils.ExternalCommand$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.passes.CpgPassBase;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.matching.Regex;

public class Php2Cpg
implements X2CpgFrontend<Config> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Regex PhpVersionRegex = new Regex("^PHP ([78]\\.[1-9]\\.[0-9]|[9-9]\\d\\.\\d\\.\\d)", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));

    public static List<CpgPassBase> postProcessingPasses(Cpg cpg, Option<Config> option) {
        return Php2Cpg$.MODULE$.postProcessingPasses(cpg, option);
    }

    public static Option<Config> postProcessingPasses$default$2() {
        return Php2Cpg$.MODULE$.postProcessingPasses$default$2();
    }

    private boolean isPhpVersionSupported() {
        Try result = ExternalCommand$.MODULE$.run("php --version", ".", ExternalCommand$.MODULE$.run$default$3());
        Try try_ = result;
        if (try_ instanceof Success) {
            Seq listString = (Seq)((Success)try_).value();
            String phpVersionStr = (String)listString.headOption().getOrElse(Php2Cpg::$anonfun$1);
            this.logger.info("Checking PHP installation: " + phpVersionStr);
            Option matchResult = this.PhpVersionRegex.findFirstIn((CharSequence)phpVersionStr);
            return matchResult.isDefined();
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.error("Failed to run php --version: " + exception.getMessage());
            return false;
        }
        throw new MatchError((Object)try_);
    }

    public Try<Cpg> createCpg(Config config2) {
        ListBuffer errorMessages = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        Option<PhpParser> parser = PhpParser$.MODULE$.getParser(config2);
        if (parser.isEmpty()) {
            errorMessages.append((Object)"Could not initialize PhpParser");
        }
        if (!this.isPhpVersionSupported()) {
            errorMessages.append((Object)"PHP version not supported. Is PHP 7.1.0 or above installed and available on your path?");
        }
        if (errorMessages.isEmpty()) {
            return X2Cpg$.MODULE$.withNewEmptyCpg(config2.outputPath(), (X2CpgConfig)config2, (Function2)(JProcedure2 & Serializable)(cpg, config) -> {
                new MetaDataPass(cpg, "PHP", config.inputPath(), MetaDataPass$.MODULE$.$lessinit$greater$default$4()).createAndApply();
                new AstCreationPass((Config)config, (Cpg)cpg, (PhpParser)parser.get(), config.schemaValidation()).createAndApply();
                new AstParentInfoPass((Cpg)cpg).createAndApply();
                new AnyTypePass((Cpg)cpg).createAndApply();
                TypeNodePass$.MODULE$.withTypesFromCpg(cpg, TypeNodePass$.MODULE$.withTypesFromCpg$default$2()).createAndApply();
                LocalCreationPass$.MODULE$.allLocalCreationPasses((Cpg)cpg).foreach((Function1)(JProcedure1 & Serializable)_$1 -> _$1.createAndApply());
                new ClosureRefPass((Cpg)cpg).createAndApply();
            });
        }
        String errorOutput = errorMessages.toList().$colon$colon((Object)"Skipping AST creation as php/php-parser could not be executed.").mkString("\n- ");
        this.logger.error(errorOutput);
        return Failure$.MODULE$.apply((Throwable)new RuntimeException("php not found or version not supported"));
    }

    private static final String $anonfun$1() {
        return "";
    }
}

