/*
 * Decompiled with CFR 0.152.
 */
package io.joern.php2cpg.parser;

import better.files.File$;
import io.joern.php2cpg.Config;
import io.joern.php2cpg.parser.PhpParser;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.io.Codec$;
import scala.io.Source$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class PhpParser$
implements Serializable {
    private static final Logger logger;
    private static final String PhpParserBinEnvVar;
    public static final PhpParser$ MODULE$;

    private PhpParser$() {
    }

    static {
        MODULE$ = new PhpParser$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        PhpParserBinEnvVar = "PHP_PARSER_BIN";
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(PhpParser$.class);
    }

    private String defaultPhpIni() {
        String iniContents = Source$.MODULE$.fromResource("php.ini", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString(System.lineSeparator());
        String string = File$.MODULE$.newTemporaryFile$default$1();
        Option option = File$.MODULE$.newTemporaryFile$default$3();
        better.files.File file = File$.MODULE$.newTemporaryFile(string, "-php.ini", option, File$.MODULE$.newTemporaryFile$default$4(string, "-php.ini", option));
        better.files.File tmpIni = file.deleteOnExit(file.deleteOnExit$default$1(), file.deleteOnExit$default$2());
        tmpIni.writeText(iniContents, tmpIni.writeText$default$2(iniContents), tmpIni.writeText$default$3(iniContents));
        return tmpIni.canonicalPath();
    }

    private String defaultPhpParserBin() {
        String dir = Paths.get(this.getClass().getProtectionDomain().getCodeSource().getLocation().toURI()).toAbsolutePath().toString();
        String fixedDir = new File(dir.substring(0, dir.indexOf("php2cpg"))).toString();
        return Paths.get(fixedDir, "php2cpg", "bin", "php-parser", "php-parser.php").toAbsolutePath().toString();
    }

    private Option<String> configOverrideOrDefaultPath(String identifier, Option<String> maybeOverride, Function0<String> defaultValue) {
        better.files.File file;
        String string;
        String overridePath;
        Option<String> option = maybeOverride;
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(overridePath = (String)((Some)option).value()))) {
            logger.debug("Using override path for " + identifier + ": " + overridePath);
            string = overridePath;
        } else {
            logger.debug(identifier + " path not overridden. Using default: " + defaultValue.apply());
            string = (String)defaultValue.apply();
        }
        String pathString = string;
        better.files.File file2 = file = File$.MODULE$.apply(pathString, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (file2.exists(file2.exists$default$1()) && file2.isRegularFile(file2.isRegularFile$default$1())) {
            return Some$.MODULE$.apply((Object)file2.canonicalPath());
        }
        logger.error("Invalid path for " + identifier + ": " + pathString);
        return None$.MODULE$;
    }

    private Option<String> maybePhpParserPath(Config config) {
        Option phpParserPathOverride = config.phpParserBin().orElse(this::$anonfun$2);
        return this.configOverrideOrDefaultPath("PhpParserBin", (Option<String>)phpParserPathOverride, (Function0<String>)((Function0 & Serializable)this::maybePhpParserPath$$anonfun$1));
    }

    private Option<String> maybePhpIniPath(Config config) {
        return this.configOverrideOrDefaultPath("PhpIni", config.phpIni(), (Function0<String>)((Function0 & Serializable)this::maybePhpIniPath$$anonfun$1));
    }

    public Option<PhpParser> getParser(Config config) {
        return this.maybePhpParserPath(config).flatMap((Function1 & Serializable)phpParserPath -> this.maybePhpIniPath(config).map((Function1 & Serializable)phpIniPath -> new PhpParser((String)phpParserPath, (String)phpIniPath)));
    }

    private final Option $anonfun$2() {
        return Option$.MODULE$.apply((Object)System.getenv(PhpParserBinEnvVar));
    }

    private final String maybePhpParserPath$$anonfun$1() {
        return this.defaultPhpParserBin();
    }

    private final String maybePhpIniPath$$anonfun$1() {
        return this.defaultPhpIni();
    }
}

