/*
 * Decompiled with CFR 0.152.
 */
package io.joern.php2cpg.parser;

import better.files.File;
import better.files.File$;
import io.joern.php2cpg.Config;
import io.joern.php2cpg.parser.Domain;
import io.joern.php2cpg.parser.Domain$;
import io.joern.php2cpg.parser.PhpParser$;
import io.joern.x2cpg.utils.ExternalCommand$;
import java.io.Serializable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Some$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import ujson.Readable;
import ujson.Readable$;
import ujson.Value;
import ujson.package$;

public class PhpParser {
    private final String phpParserPath;
    private final String phpIniPath;
    private final Logger logger;

    public static Option<PhpParser> getParser(Config config) {
        return PhpParser$.MODULE$.getParser(config);
    }

    public PhpParser(String phpParserPath, String phpIniPath) {
        this.phpParserPath = phpParserPath;
        this.phpIniPath = phpIniPath;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    private String phpParseCommand(String filename) {
        String phpParserCommands = "--with-recovery --resolve-names --json-dump";
        return "php --php-ini " + this.phpIniPath + " " + this.phpParserPath + " " + phpParserCommands + " " + filename;
    }

    public Option<Domain.PhpFile> parseFile(String inputPath) {
        File inputFile = File$.MODULE$.apply(inputPath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        String inputFilePath = inputFile.canonicalPath();
        String inputDirectory = inputFile.parent().canonicalPath();
        String command = this.phpParseCommand(inputFilePath);
        Try try_ = ExternalCommand$.MODULE$.run(command, inputDirectory, ExternalCommand$.MODULE$.run$default$3());
        if (try_ instanceof Success) {
            Seq output = (Seq)((Success)try_).value();
            return this.processParserOutput((Seq<String>)output, inputFilePath);
        }
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.error("Failure running php-parser with " + command, (Object)exception.getMessage());
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private Option<Domain.PhpFile> processParserOutput(Seq<String> output, String filename) {
        Option<Value> maybeJson = this.linesToJsonValue(output, filename);
        return maybeJson.flatMap((Function1 & Serializable)_$1 -> this.jsonValueToPhpFile((Value)_$1, filename));
    }

    private Option<Value> linesToJsonValue(Seq<String> lines, String filename) {
        if (lines.exists((Function1 & Serializable)_$2 -> _$2.startsWith("["))) {
            String jsonString = ((IterableOnceOps)lines.dropWhile((Function1 & Serializable)_$3 -> _$3.charAt(0) != '[')).mkString();
            Try try_ = Try$.MODULE$.apply(() -> PhpParser.linesToJsonValue$$anonfun$2(jsonString));
            if (try_ instanceof Success) {
                Option option = (Option)((Success)try_).value();
                if (option instanceof Some) {
                    Value value = (Value)((Some)option).value();
                    return Some$.MODULE$.apply((Object)value);
                }
                if (None$.MODULE$.equals(option)) {
                    this.logger.error("Parsing json string for " + filename + " resulted in null return value");
                    return None$.MODULE$;
                }
            }
            if (try_ instanceof Failure) {
                Throwable exception = ((Failure)try_).exception();
                this.logger.error("Parsing json string for " + filename + " failed with exception", exception);
                return None$.MODULE$;
            }
            throw new MatchError((Object)try_);
        }
        this.logger.warn("No JSON output for " + filename);
        return None$.MODULE$;
    }

    private Option<Domain.PhpFile> jsonValueToPhpFile(Value json, String filename) {
        Try try_ = Try$.MODULE$.apply(() -> PhpParser.jsonValueToPhpFile$$anonfun$1(json));
        if (try_ instanceof Success) {
            Domain.PhpFile phpFile = (Domain.PhpFile)((Success)try_).value();
            return Some$.MODULE$.apply((Object)phpFile);
        }
        if (try_ instanceof Failure) {
            Throwable e = ((Failure)try_).exception();
            this.logger.error("Failed to generate intermediate AST for " + filename, e);
            return None$.MODULE$;
        }
        throw new MatchError((Object)try_);
    }

    private static final Option linesToJsonValue$$anonfun$2(String jsonString$1) {
        return Option$.MODULE$.apply((Object)package$.MODULE$.read((Readable)Readable$.MODULE$.fromString(jsonString$1), package$.MODULE$.read$default$2()));
    }

    private static final Domain.PhpFile jsonValueToPhpFile$$anonfun$1(Value json$1) {
        return Domain$.MODULE$.fromJson(json$1);
    }
}

