/*
 * Decompiled with CFR 0.152.
 */
package io.shiftleft.py2cpg;

import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Factories$;
import io.shiftleft.py2cpg.Py2Cpg;
import io.shiftleft.py2cpg.Py2CpgOnFileSystem$;
import io.shiftleft.py2cpg.Py2CpgOnFileSystemConfig;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.Config;
import overflowdb.Graph;
import scala.Function0;
import scala.Function1;
import scala.Option$;
import scala.collection.Iterable;
import scala.collection.IterableFactory;
import scala.collection.IterableFactory$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;

public final class Py2CpgOnFileSystem$ {
    public static final Py2CpgOnFileSystem$ MODULE$ = new Py2CpgOnFileSystem$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());

    private Logger logger() {
        return logger;
    }

    public void buildCpg(Py2CpgOnFileSystemConfig config) {
        this.logConfiguration(config);
        Cpg cpg = this.initCpg(config.outputFile());
        Iterable<Path> inputFiles = this.collectInputFiles(config.inputDir(), (Iterable<Path>)((Iterable)Option$.MODULE$.option2Iterable(config.ignoreVenvDir()).to(IterableFactory$.MODULE$.toFactory((IterableFactory)package$.MODULE$.Iterable()))));
        Iterable inputProviders = (Iterable)inputFiles.map((Function1 & Serializable)inputFile -> (Function0 & Serializable)() -> {
            byte[] content = Files.readAllBytes(inputFile);
            String contentStr = new String(content, StandardCharsets.UTF_8);
            return new Py2Cpg.InputPair(contentStr, ((Object)config.inputDir().relativize((Path)inputFile)).toString());
        });
        Py2Cpg py2Cpg = new Py2Cpg((Iterable<Function0<Py2Cpg.InputPair>>)inputProviders, cpg);
        py2Cpg.buildCpg();
        cpg.close();
    }

    private Cpg initCpg(Path outputFile) {
        if (Files.exists(outputFile, new LinkOption[0])) {
            Files.delete(outputFile);
        }
        Config odbConfig = Config.withDefaults().withStorageLocation(((Object)outputFile).toString());
        Graph graph = Graph.open((Config)odbConfig, (List)Factories$.MODULE$.allAsJava(), (List)io.shiftleft.codepropertygraph.generated.edges.Factories$.MODULE$.allAsJava());
        return new Cpg(graph);
    }

    /*
     * WARNING - void declaration
     */
    private Iterable<Path> collectInputFiles(Path inputDir, Iterable<Path> ignorePrefixes) {
        void var3_3;
        if (!Files.exists(inputDir, new LinkOption[0])) {
            this.logger().error(new StringBuilder(12).append("Cannot find ").append(inputDir).toString());
            return (Iterable)package$.MODULE$.Iterable().empty();
        }
        ArrayBuffer inputFiles = ArrayBuffer$.MODULE$.empty();
        Files.walkFileTree(inputDir, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(inputDir, ignorePrefixes, inputFiles){
            private final Path inputDir$1;
            private final Iterable ignorePrefixes$1;
            private final ArrayBuffer inputFiles$1;

            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                Path relativeFile = this.inputDir$1.relativize(file);
                String relativeFileStr = ((Object)relativeFile).toString();
                Object object = relativeFileStr.endsWith(".py") && !this.ignorePrefixes$1.exists((Function1 & Serializable)prefix -> BoxesRunTime.boxToBoolean((boolean)anon.1.$anonfun$visitFile$1(relativeFile, prefix))) ? this.inputFiles$1.append((Object)file) : BoxedUnit.UNIT;
                return FileVisitResult.CONTINUE;
            }

            public static final /* synthetic */ boolean $anonfun$visitFile$1(Path relativeFile$1, Path prefix) {
                return relativeFile$1.startsWith(prefix);
            }
            {
                this.inputDir$1 = inputDir$1;
                this.ignorePrefixes$1 = ignorePrefixes$1;
                this.inputFiles$1 = inputFiles$1;
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$visitFile$1$adapted(java.nio.file.Path java.nio.file.Path )}, serializedLambda);
            }
        });
        return var3_3;
    }

    private void logConfiguration(Py2CpgOnFileSystemConfig config) {
        this.logger().info(new StringBuilder(13).append("Output file: ").append(config.outputFile()).toString());
        this.logger().info(new StringBuilder(17).append("Input directory: ").append(config.inputDir()).toString());
        config.ignoreVenvDir().foreach((Function1 & Serializable)dir -> {
            Py2CpgOnFileSystem$.$anonfun$logConfiguration$1(dir);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$logConfiguration$1(Path dir) {
        MODULE$.logger().info(new StringBuilder(39).append("Ignored virtual environment directory: ").append(dir).toString());
    }

    private Py2CpgOnFileSystem$() {
    }
}

