/*
 * Decompiled with CFR 0.152.
 */
package io.joern.scanners.android;

import io.joern.console.CodeExamples;
import io.joern.console.CodeSnippet;
import io.joern.console.MultiFileCodeExamples;
import io.joern.console.Query;
import io.joern.console.Query$;
import io.joern.console.QueryBundle;
import io.joern.console.TraversalWithStrRep;
import io.joern.console.q;
import io.joern.dataflowengineoss.language.ExtendedCfgNode$;
import io.joern.dataflowengineoss.queryengine.EngineContext;
import io.joern.scanners.Crew$;
import io.joern.scanners.QueryTags$;
import io.joern.semanticcpg.utils.SecureXmlParsing$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.ConfigFile;
import io.shiftleft.codepropertygraph.generated.traversal.CallTraversalExtGen$;
import io.shiftleft.codepropertygraph.generated.traversal.ConfigFileTraversalExtGen$;
import java.io.Serializable;
import overflowdb.traversal.Traversal;
import overflowdb.traversal.Traversal$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;
import scala.xml.Elem;
import scala.xml.Node;

public final class Misconfigurations$
implements QueryBundle {
    public static final Misconfigurations$ MODULE$ = new Misconfigurations$();

    @q
    public Query manifestXmlBackupEnabled() {
        return Query$.MODULE$.make("manifest-backup-enabled", Crew$.MODULE$.claudiu(), "Backups enabled in Android Manifest File", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Backup flag is set to true in AndroidManifest.xml which means that the application data can be retrieved via adb.\n          |")), 3.0, new TraversalWithStrRep((Function1 & Serializable)cpg -> {
            String androidUri = "http://schemas.android.com/apk/res/android";
            return ((Traversal)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(cpg).configFile().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Misconfigurations$.$anonfun$manifestXmlBackupEnabled$2(x$1)))).where((Function1 & Serializable)config -> (Traversal)((IterableOps)((IterableOps)((IterableOps)((IterableOps)ConfigFileTraversalExtGen$.MODULE$.content$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.toConfigFileTraversalExtGen((IterableOnce)config)).flatMap((Function1 & Serializable)content -> SecureXmlParsing$.MODULE$.parseXml(content))).filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)Misconfigurations$.$anonfun$manifestXmlBackupEnabled$5(x$2)))).flatMap((Function1 & Serializable)x$3 -> x$3.child())).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)Misconfigurations$.$anonfun$manifestXmlBackupEnabled$7(x$4)))).filter((Function1 & Serializable)node -> BoxesRunTime.boxToBoolean((boolean)Misconfigurations$.$anonfun$manifestXmlBackupEnabled$8(androidUri, node))));
        }, "cpg =>\n        import io.joern.semanticcpg.utils.SecureXmlParsing\n\n        val androidUri = \"http://schemas.android.com/apk/res/android\"\n        cpg.configFile\n          .filter(_.name.endsWith(\"AndroidManifest.xml\"))\n          .where { config =>\n            config.content\n              .flatMap(SecureXmlParsing.parseXml)\n              .filter(_.label == \"manifest\")\n              .flatMap(_.child)\n              .filter(_.label == \"application\")\n              .filter { node =>\n                val isAllowBackup = node.attribute(androidUri, \"allowBackup\")\n                isAllowBackup match {\n                  case Some(n) => n.toString == \"true\"\n                  case None    => false\n                }\n              }\n          }"), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{QueryTags$.MODULE$.android(), QueryTags$.MODULE$.misconfiguration()})), new CodeExamples((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<?xml version=\"1.0\" encoding=\"utf-8\"?>\n            |<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n            |    package=\"com.example.slimandroid\">\n            |\n            |    <application\n            |        android:allowBackup=\"true\"\n            |        android:label=\"SlimAndroid\"\n            |        android:supportsRtl=\"true\"\n            |        android:theme=\"@style/Theme.AppCompat\">\n            |        <activity\n            |            android:name=\".MainActivity\"\n            |            android:exported=\"true\">\n            |            <intent-filter>\n            |                <action android:name=\"android.intent.action.MAIN\" />\n            |                <category android:name=\"android.intent.category.LAUNCHER\" />\n            |            </intent-filter>\n            |        </activity>\n            |    </application>\n            |</manifest>"))})), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("|<?xml version=\"1.0\" encoding=\"utf-8\"?>\n           |<manifest xmlns:android=\"http://schemas.android.com/apk/res/android\"\n           |    package=\"com.example.slimandroid\">\n           |\n           |    <application\n           |        android:allowBackup=\"false\"\n           |        android:label=\"SlimAndroid\"\n           |        android:supportsRtl=\"true\"\n           |        android:theme=\"@style/Theme.AppCompat\">\n           |        <activity\n           |            android:name=\".MainActivity\"\n           |            android:exported=\"true\">\n           |            <intent-filter>\n           |                <action android:name=\"android.intent.action.MAIN\" />\n           |                <category android:name=\"android.intent.category.LAUNCHER\" />\n           |            </intent-filter>\n           |        </activity>\n           |    </application>\n           |</manifest>"))}))), Query$.MODULE$.make$default$9());
    }

    @q
    public Query tapJacking() {
        String x$1 = "tap-jacking";
        String x$2 = Crew$.MODULE$.claudiu();
        String x$3 = "Tap Jacking: target SDK <23 specified in `build.gradle` ";
        String x$4 = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |Android apps targeting API levels 22 and lower have the SYSTEM_ALERT_WINDOW permission enabled by default.\n          |This allows apps to draw overlays over other apps. Attackers can use this option to create an overlay that\n          |would essentially hijack user taps and use it to obtain sensitive user information."));
        double x$5 = 6.0;
        TraversalWithStrRep x$6 = new TraversalWithStrRep((Function1 & Serializable)cpg -> {
            Regex targetSdkVersionMatch = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[^t]+targetSdk[^0-9]+(\\d+)"));
            int firstSecureSdkVersion = 23;
            return (Traversal)Misconfigurations$.groovyBuildGradleFiles$1(cpg).filter((Function1 & Serializable)gradleFile -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(gradleFile.content()), '\n')), (Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)Misconfigurations$.$anonfun$tapJacking$3(targetSdkVersionMatch$1, firstSecureSdkVersion$1, line)))));
        }, "cpg =>\n        def groovyBuildGradleFiles = cpg.configFile.name(\".*build.gradle\")\n        val targetSdkVersionMatch  = \"\"\"^[^t]+targetSdk[^0-9]+(\\d+)\"\"\".r\n        val firstSecureSdkVersion  = 23\n        groovyBuildGradleFiles.filter { gradleFile =>\n          gradleFile.content\n            .split('\\n')\n            .exists { line =>\n              targetSdkVersionMatch\n                .findAllIn(line)\n                .matchData\n                .exists { m =>\n                  m.groupCount > 0 && m.group(1).toInt < firstSecureSdkVersion\n                }\n            }\n        }");
        List x$7 = (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{QueryTags$.MODULE$.android(), QueryTags$.MODULE$.misconfiguration()}));
        MultiFileCodeExamples x$8 = new MultiFileCodeExamples((List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodeSnippet[]{new CodeSnippet("fun main() = println(0xbadf00d)", "SomeActivity.kt"), new CodeSnippet(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n              |plugins {\n              |    id 'com.android.application'\n              |    id 'kotlin-android'\n              |}\n              |\n              |android {\n              |    compileSdk 22\n              |    defaultConfig {\n              |        applicationId \"com.example.slimandroid\"\n              |        minSdk 22\n              |        targetSdk 22\n              |        versionCode 1\n              |        versionName \"1.0\"\n              |    }\n              |}\n              |")), "build.gradle")}))})), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new List[]{(List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new CodeSnippet[]{new CodeSnippet("fun main() = println(0xbadf00d)", "SomeActivity.kt"), new CodeSnippet(StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n                |plugins {\n                |    id 'com.android.application'\n                |    id 'kotlin-android'\n                |}\n                |\n                |android {\n                |    compileSdk 23\n                |    defaultConfig {\n                |        applicationId \"com.example.slimandroid\"\n                |        minSdk 23\n                |        targetSdk 23\n                |        versionCode 1\n                |        versionName \"1.0\"\n                |    }\n                |}\n                |")), "build.gradle")}))})));
        CodeExamples x$9 = Query$.MODULE$.make$default$8();
        return Query$.MODULE$.make("tap-jacking", x$2, "Tap Jacking: target SDK <23 specified in `build.gradle` ", x$4, 6.0, x$6, x$7, x$9, x$8);
    }

    @q
    public Query vulnerablePRNGOnAndroidv16_18(EngineContext context) {
        return Query$.MODULE$.make("vuln-prng-android-v16_18", Crew$.MODULE$.dave(), "Vulnerable underlying PRNG used on currently set version of Android", StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |The underlying PRNG is vulnerable on Android v16-18. If the application is implemented by utilizing\n          |org.webkit package and a key exchange scheme is RSA, the PreMasterSecret of the first SSL session\n          |can be recovered using the restored PRNG states.\n          |\n          |For more information, see \"Predictability of Android OpenSSL's Pseudo random number generator\" by S.H. Kim \n          |et. al.\n          |")), 6.0, new TraversalWithStrRep((Function1 & Serializable)cpg -> {
            Regex targetSdkVersionMatch = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("^[^t]+minSdk[^0-9]+(\\d+)"));
            int insecureSdkVersionMin = 16;
            int insecureSdkVersionMax = 18;
            return (Misconfigurations$.defaultSecRand$1(cpg).nonEmpty() || ExtendedCfgNode$.MODULE$.reachableBy$extension(io.joern.dataflowengineoss.language.package$.MODULE$.toExtendedCfgNode((IterableOnce)Misconfigurations$.sink$1(cpg)), (scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Traversal[]{Misconfigurations$.source$1(cpg)}), context).nonEmpty()) && Misconfigurations$.satisfiesConfig$1(targetSdkVersionMatch, insecureSdkVersionMin, insecureSdkVersionMax, cpg).nonEmpty() ? Misconfigurations$.satisfiesConfig$1(targetSdkVersionMatch, insecureSdkVersionMin, insecureSdkVersionMax, cpg) : Traversal$.MODULE$.empty();
        }, "cpg =>\n        def groovyBuildGradleFiles = cpg.configFile.name(\".*build.gradle\")\n\n        val targetSdkVersionMatch = \"\"\"^[^t]+minSdk[^0-9]+(\\d+)\"\"\".r\n        val insecureSdkVersionMin = 16\n        val insecureSdkVersionMax = 18\n        def satisfiesConfig = groovyBuildGradleFiles.filter { gradleFile =>\n          gradleFile.content\n            .split('\\n')\n            .exists { line =>\n              targetSdkVersionMatch\n                .findAllIn(line)\n                .matchData\n                .exists { m =>\n                  m.groupCount > 0 &&\n                  m.group(1).toInt >= insecureSdkVersionMin\n                  m.group(1).toInt <= insecureSdkVersionMax\n                }\n            }\n        }\n\n        def source         = cpg.literal(\"\\\".*PRNG.*\\\"\")\n        def sink           = cpg.call.code(\".*SecureRandom.getInstance.*\")\n        def defaultSecRand = cpg.call.methodFullNameExact(\"java.security.SecureRandom.<init>:void()\")\n        if (\n          (defaultSecRand.nonEmpty || sink.reachableBy(source).nonEmpty) &&\n          satisfiesConfig.nonEmpty\n        )\n          satisfiesConfig\n        else\n          Traversal.empty"), (List)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{QueryTags$.MODULE$.android(), QueryTags$.MODULE$.cryptography(), QueryTags$.MODULE$.misconfiguration()})), Query$.MODULE$.make$default$8(), Query$.MODULE$.make$default$9());
    }

    public static final /* synthetic */ boolean $anonfun$manifestXmlBackupEnabled$2(ConfigFile x$1) {
        return x$1.name().endsWith("AndroidManifest.xml");
    }

    public static final /* synthetic */ boolean $anonfun$manifestXmlBackupEnabled$5(Elem x$2) {
        String string = x$2.label();
        String string2 = "manifest";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$manifestXmlBackupEnabled$7(Node x$4) {
        String string = x$4.label();
        String string2 = "application";
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$manifestXmlBackupEnabled$8(String androidUri$1, Node node) {
        boolean bl;
        Option isAllowBackup = node.attribute(androidUri$1, "allowBackup");
        Option option = isAllowBackup;
        if (option instanceof Some) {
            Some some = (Some)option;
            Seq n = (Seq)some.value();
            String string = n.toString();
            String string2 = "true";
            bl = !(string != null ? !string.equals(string2) : string2 != null);
        } else if (None$.MODULE$.equals(option)) {
            bl = false;
        } else {
            throw new MatchError((Object)option);
        }
        return bl;
    }

    private static final Traversal groovyBuildGradleFiles$1(Cpg cpg$1) {
        return ConfigFileTraversalExtGen$.MODULE$.name$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.toConfigFileTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(cpg$1).configFile()), ".*build.gradle");
    }

    public static final /* synthetic */ boolean $anonfun$tapJacking$4(int firstSecureSdkVersion$1, Regex.Match m) {
        return m.groupCount() > 0 && StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1))) < firstSecureSdkVersion$1;
    }

    public static final /* synthetic */ boolean $anonfun$tapJacking$3(Regex targetSdkVersionMatch$1, int firstSecureSdkVersion$1, String line) {
        return targetSdkVersionMatch$1.findAllIn((CharSequence)line).matchData().exists((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)Misconfigurations$.$anonfun$tapJacking$4(firstSecureSdkVersion$1, m)));
    }

    private static final Traversal groovyBuildGradleFiles$2(Cpg cpg$2) {
        return ConfigFileTraversalExtGen$.MODULE$.name$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.toConfigFileTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(cpg$2).configFile()), ".*build.gradle");
    }

    public static final /* synthetic */ boolean $anonfun$vulnerablePRNGOnAndroidv16_18$4(int insecureSdkVersionMin$1, int insecureSdkVersionMax$1, Regex.Match m) {
        boolean bl = m.groupCount() > 0 && StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1))) >= insecureSdkVersionMin$1;
        return StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(m.group(1))) <= insecureSdkVersionMax$1;
    }

    public static final /* synthetic */ boolean $anonfun$vulnerablePRNGOnAndroidv16_18$3(Regex targetSdkVersionMatch$2, int insecureSdkVersionMin$1, int insecureSdkVersionMax$1, String line) {
        return targetSdkVersionMatch$2.findAllIn((CharSequence)line).matchData().exists((Function1 & Serializable)m -> BoxesRunTime.boxToBoolean((boolean)Misconfigurations$.$anonfun$vulnerablePRNGOnAndroidv16_18$4(insecureSdkVersionMin$1, insecureSdkVersionMax$1, m)));
    }

    private static final Traversal satisfiesConfig$1(Regex targetSdkVersionMatch$2, int insecureSdkVersionMin$1, int insecureSdkVersionMax$1, Cpg cpg$2) {
        return (Traversal)Misconfigurations$.groovyBuildGradleFiles$2(cpg$2).filter((Function1 & Serializable)gradleFile -> BoxesRunTime.boxToBoolean((boolean)ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(gradleFile.content()), '\n')), (Function1 & Serializable)line -> BoxesRunTime.boxToBoolean((boolean)Misconfigurations$.$anonfun$vulnerablePRNGOnAndroidv16_18$3(targetSdkVersionMatch$2, insecureSdkVersionMin$1, insecureSdkVersionMax$1, line)))));
    }

    private static final Traversal source$1(Cpg cpg$2) {
        return io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(cpg$2).literal("\".*PRNG.*\"");
    }

    private static final Traversal sink$1(Cpg cpg$2) {
        return CallTraversalExtGen$.MODULE$.code$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(cpg$2).call()), ".*SecureRandom.getInstance.*");
    }

    private static final Traversal defaultSecRand$1(Cpg cpg$2) {
        return CallTraversalExtGen$.MODULE$.methodFullNameExact$extension(io.shiftleft.semanticcpg.language.package$.MODULE$.toCallTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(cpg$2).call()), "java.security.SecureRandom.<init>:void()");
    }

    private Misconfigurations$() {
    }
}

