/*
 * Decompiled with CFR 0.152.
 */
package io.joern.rubysrc2cpg.utils;

import better.files.File;
import better.files.File$;
import io.joern.rubysrc2cpg.Config;
import io.joern.rubysrc2cpg.Config$;
import io.joern.rubysrc2cpg.RubySrc2Cpg$;
import io.joern.rubysrc2cpg.astcreation.AstCreator;
import io.joern.rubysrc2cpg.datastructures.RubyProgramSummary;
import io.joern.rubysrc2cpg.datastructures.RubyProgramSummary$;
import io.joern.rubysrc2cpg.datastructures.RubyType;
import io.joern.rubysrc2cpg.parser.ResourceManagedParser;
import io.joern.rubysrc2cpg.passes.Defines$;
import io.joern.rubysrc2cpg.utils.DependencyDownloader$RubyGemLatestVersion$;
import io.joern.x2cpg.utils.ConcurrentTaskUtil$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.Dependency;
import io.shiftleft.codepropertygraph.generated.traversal.DependencyTraversalExtGen$;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.zip.GZIPInputStream;
import java.util.zip.InflaterInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.traversal.TraversalSugarExt$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;
import scala.runtime.function.JProcedure2;
import scala.runtime.java8.JFunction1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;
import ujson.Readable;
import ujson.Readable$;
import upickle.default$;

public class DependencyDownloader {
    private final Cpg cpg;
    private final RubyProgramSummary internalProgramSummary;
    private final Logger logger;
    private final String RESOLVER_BASE_URL;
    public final DependencyDownloader$RubyGemLatestVersion$ RubyGemLatestVersion$lzy1;

    public DependencyDownloader(Cpg cpg, RubyProgramSummary internalProgramSummary) {
        this.cpg = cpg;
        this.internalProgramSummary = internalProgramSummary;
        this.RubyGemLatestVersion$lzy1 = new DependencyDownloader$RubyGemLatestVersion$(this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        Iterator iterator = io.shiftleft.semanticcpg.language.package$.MODULE$.toDependencyTraversalExtGen((IterableOnce)io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(cpg).dependency());
        Iterator iterator2 = io.shiftleft.semanticcpg.language.package$.MODULE$.toDependencyTraversalExtGen((IterableOnce)DependencyTraversalExtGen$.MODULE$.name$extension(iterator, Defines$.MODULE$.Resolver()));
        Iterator iterator3 = io.shiftleft.semanticcpg.language.package$.MODULE$.toTraversalSugarExt((IterableOnce)DependencyTraversalExtGen$.MODULE$.version$extension(iterator2));
        this.RESOLVER_BASE_URL = (String)TraversalSugarExt$.MODULE$.headOption$extension(iterator3).getOrElse(DependencyDownloader::$init$$$anonfun$1);
    }

    public RubyProgramSummary download() {
        return (RubyProgramSummary)File$.MODULE$.temporaryDirectory("joern-rubysrc2cpg", File$.MODULE$.temporaryDirectory$default$2(), File$.MODULE$.temporaryDirectory$default$3()).apply((Function1 & Serializable)dir -> {
            io.shiftleft.semanticcpg.language.package$.MODULE$.toNodeTypeStarters(this.cpg).dependency().filterNot((Function1 & Serializable)_$1 -> {
                String string = _$1.name();
                String string2 = Defines$.MODULE$.Resolver();
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).foreach((Function1)(JProcedure1 & Serializable)dependency -> {
                Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    DependencyDownloader.download$$anonfun$1$$anonfun$2$$anonfun$1();
                    return BoxedUnit.UNIT;
                });
                this.downloadDependency((File)dir, (Dependency)dependency);
            });
            this.untarDependencies((File)dir);
            return this.summarizeDependencies(dir.$div("lib")).add(this.internalProgramSummary);
        });
    }

    private final DependencyDownloader$RubyGemLatestVersion$ RubyGemLatestVersion() {
        return this.RubyGemLatestVersion$lzy1;
    }

    private void downloadDependency(File targetDir, Dependency dependency) {
        Option versionOpt = dependency.version().isBlank() ? this.getVersion$1(dependency.name()) : Option$.MODULE$.apply((Object)dependency.version());
        Option option = versionOpt;
        if (option instanceof Some) {
            String version = (String)((Some)option).value();
            this.downloadPackage(targetDir, dependency, this.createUrl$1(dependency, version));
            return;
        }
        if (None$.MODULE$.equals(option)) {
            this.logger.error("Unable to determine package version for " + dependency.name() + ", skipping");
            return;
        }
        throw new MatchError((Object)option);
    }

    /*
     * Unable to fully structure code
     */
    private void downloadPackage(File targetDir, Dependency dependency, URL url) {
        block13: {
            connection = None$.MODULE$;
            try {
                try {
                    block14: {
                        connection = Option$.MODULE$.apply((Object)url.openConnection()).collect((PartialFunction)new Serializable(){

                            public final boolean isDefinedAt(URLConnection x) {
                                URLConnection uRLConnection = x;
                                if (uRLConnection instanceof HttpURLConnection) {
                                    HttpURLConnection x2 = (HttpURLConnection)uRLConnection;
                                    return true;
                                }
                                return false;
                            }

                            public final Object applyOrElse(URLConnection x, Function1 function1) {
                                URLConnection uRLConnection = x;
                                if (uRLConnection instanceof HttpURLConnection) {
                                    HttpURLConnection x2 = (HttpURLConnection)uRLConnection;
                                    return x2;
                                }
                                return function1.apply((Object)x);
                            }
                        });
                        connection.foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, downloadPackage$$anonfun$1(java.net.HttpURLConnection ), (Ljava/net/HttpURLConnection;)V)());
                        var5_5 = connection;
                        if (!(var5_5 instanceof Some) || (var6_6 = (HttpURLConnection)((Some)var5_5).value()) == null) break block14;
                        var7_7 = var6_6;
                        conn = var7_7;
                        if (conn.getResponseCode() != 200) ** GOTO lbl35
                        ext = "gem";
                        fileName = targetDir.$div(dependency.name() + "." + ext);
                        var12_11 = Option$.MODULE$.apply((Object)conn.getContentEncoding());
                        if (!(var12_11 instanceof Some)) ** GOTO lbl-1000
                        var13_12 = (String)((Some)var12_11).value();
                        encoding = var13_12;
                        if (encoding.equalsIgnoreCase("gzip")) {
                            v0 = new GZIPInputStream(conn.getInputStream());
                        } else {
                            encoding = var13_12;
                            if (encoding.equalsIgnoreCase("deflate")) {
                                v0 = new InflaterInputStream(conn.getInputStream());
                            } else lbl-1000:
                            // 2 sources

                            {
                                v0 = conn.getInputStream();
                            }
                        }
                        inputStream = v0;
                        var16_16 = Try$.MODULE$.apply((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$adapted$1(java.io.InputStream better.files.File ), ()Ljava/lang/Object;)((InputStream)inputStream, (File)fileName));
                        if (var16_16 instanceof Failure) {
                            exception = ((Failure)var16_16).exception();
                            this.logger.error("Exception occurred while downloading " + fileName + " (" + dependency.name() + ":" + dependency.version() + ")", exception);
                        } else if (var16_16 instanceof Success) {
                            this.logger.info("Successfully downloaded dependency " + dependency.name() + ":" + dependency.version());
                        } else {
                            throw new MatchError((Object)var16_16);
lbl35:
                            // 1 sources

                            conn = var7_7;
                            this.logger.error("Connection to " + url + " responded with non-200 code " + conn.getResponseCode());
                        }
                        break block13;
                    }
                    this.logger.error("Unknown URL connection made, aborting");
                }
                catch (Throwable exception) {
                    this.logger.error("Unable to download dependency " + dependency.name() + ":" + dependency.version(), exception);
                }
            }
            finally {
                connection.foreach((Function1)(JProcedure1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)V, downloadPackage$$anonfun$3(java.net.HttpURLConnection ), (Ljava/net/HttpURLConnection;)V)());
            }
        }
    }

    private void untarDependencies(File targetDir) {
        targetDir.list().foreach((Function1 & Serializable)pkg -> (File)Using$.MODULE$.resource((Object)pkg.newInputStream(pkg.newInputStream$default$1()), (Function1 & Serializable)pkgIs -> {
            TarArchiveInputStream tarGemStream = new TarArchiveInputStream(pkgIs);
            package$.MODULE$.Iterator().continually(() -> DependencyDownloader.untarDependencies$$anonfun$1$$anonfun$1$$anonfun$1(tarGemStream)).takeWhile((Function1 & Serializable)_$6 -> _$6 != null).filter((Function1 & Serializable)_$7 -> {
                String string = _$7.getName();
                String string2 = "data.tar.gz";
                return !(string != null ? !string.equals(string2) : string2 != null);
            }).foreach((Function1)(JProcedure1 & Serializable)_$8 -> {
                GZIPInputStream gzStream = new GZIPInputStream((InputStream)tarGemStream);
                TarArchiveInputStream dataTarStream = new TarArchiveInputStream((InputStream)gzStream);
                package$.MODULE$.Iterator().continually(() -> DependencyDownloader.untarDependencies$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1(dataTarStream)).takeWhile((Function1 & Serializable)_$9 -> _$9 != null).filter((Function1 & Serializable)sourceEntry -> {
                    String entryName = sourceEntry.getName();
                    return !entryName.contains("..") && entryName.startsWith("lib/") && entryName.endsWith(".rb");
                }).foreach((Function1)(JProcedure1 & Serializable)rubyFile -> {
                    try {
                        File target = targetDir.$div(rubyFile.getName());
                        boolean bl = target.createIfNotExists$default$1();
                        target.createIfNotExists(bl, true, target.createIfNotExists$default$3(bl, true), target.createIfNotExists$default$4(bl, true));
                        Using$.MODULE$.resource((Object)new FileOutputStream(target.pathAsString()), (Function1)(JProcedure1 & Serializable)fos -> {
                            byte[] buffer = new byte[4096];
                            package$.MODULE$.Iterator().continually(() -> DependencyDownloader.untarDependencies$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$4$$anonfun$1$$anonfun$1(dataTarStream, buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)_$10 -> _$10 != -1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)bytesRead -> fos.write(buffer, 0, bytesRead));
                        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    }
                    catch (Throwable exception) {
                        this.logger.error("Exception occurred while unpacking " + rubyFile.getName(), exception);
                    }
                });
            });
            return pkg.delete(true, pkg.delete$default$2());
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$));
    }

    private RubyProgramSummary summarizeDependencies(File targetDir) {
        return (RubyProgramSummary)Using$.MODULE$.resource((Object)new ResourceManagedParser(0.8), (Function1 & Serializable)parser -> {
            List astCreators = ConcurrentTaskUtil$.MODULE$.runUsingThreadPool(RubySrc2Cpg$.MODULE$.generateParserTasks((ResourceManagedParser)parser, (Config)Config$.MODULE$.apply(Config$.MODULE$.$lessinit$greater$default$1(), Config$.MODULE$.$lessinit$greater$default$2(), Config$.MODULE$.$lessinit$greater$default$3()).withInputPath(targetDir.pathAsString()), (Option<String>)Option$.MODULE$.apply((Object)targetDir.pathAsString())), ConcurrentTaskUtil$.MODULE$.runUsingThreadPool$default$2()).flatMap((Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Failure) {
                    Throwable exception = ((Failure)try_).exception();
                    this.logger.warn("Could not parse file, skipping - ", exception);
                    return None$.MODULE$;
                }
                if (try_ instanceof Success) {
                    AstCreator astCreator = (AstCreator)((Success)try_).value();
                    return Option$.MODULE$.apply((Object)astCreator);
                }
                throw new MatchError((Object)try_);
            });
            RubyProgramSummary librarySummaries = (RubyProgramSummary)ConcurrentTaskUtil$.MODULE$.runUsingThreadPool(astCreators.map((Function1 & Serializable)x -> (Function0 & Serializable)() -> DependencyDownloader.remapPaths$1(x.summarize())).iterator(), ConcurrentTaskUtil$.MODULE$.runUsingThreadPool$default$2()).flatMap((Function1 & Serializable)x$1 -> {
                Try try_ = x$1;
                if (try_ instanceof Failure) {
                    Throwable exception = ((Failure)try_).exception();
                    this.logger.warn("Unable to pre-parse Ruby file, skipping - ", exception);
                    return None$.MODULE$;
                }
                if (try_ instanceof Success) {
                    RubyProgramSummary summary = (RubyProgramSummary)((Success)try_).value();
                    return Option$.MODULE$.apply((Object)summary);
                }
                throw new MatchError((Object)try_);
            }).reduceOption((Function2 & Serializable)(a, b) -> a.add((RubyProgramSummary)b)).getOrElse(DependencyDownloader::$anonfun$6);
            return librarySummaries.add(this.internalProgramSummary);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private static final String $init$$$anonfun$1() {
        return "https://rubygems.org";
    }

    private static final void download$$anonfun$1$$anonfun$2$$anonfun$1() {
        Thread.sleep(100L);
    }

    public static final /* synthetic */ String io$joern$rubysrc2cpg$utils$DependencyDownloader$$anon$1$$_$allKeysArray$$anonfun$1(Tuple2 _$1) {
        return (String)_$1._2();
    }

    private static final boolean $anon$superArg$1$1$$anonfun$1(default$ ReadersVersionSpecific_this$3) {
        return ReadersVersionSpecific_this$3.allowUnknownKeys();
    }

    public static final boolean io$joern$rubysrc2cpg$utils$DependencyDownloader$RubyGemLatestVersion$$$_$_$$anon$superArg$1$1(default$ ReadersVersionSpecific_this$2) {
        return BoxesRunTime.unboxToBoolean((Object)package$.MODULE$.Nil().headOption().getOrElse(() -> DependencyDownloader.$anon$superArg$1$1$$anonfun$1(ReadersVersionSpecific_this$2)));
    }

    private final RubyGemLatestVersion getVersion$1$$anonfun$1$$anonfun$1(InputStream is$1) {
        return (RubyGemLatestVersion)default$.MODULE$.read((Readable)Readable$.MODULE$.fromByteArray(is$1.readAllBytes()), default$.MODULE$.read$default$2(), this.RubyGemLatestVersion().derived$ReadWriter());
    }

    private final Option getVersion$1(String packageName) {
        return (Option)Using$.MODULE$.resource((Object)new URI(this.RESOLVER_BASE_URL + "/api/v1/versions/" + packageName + "/latest.json").toURL().openStream(), (Function1 & Serializable)is -> Try$.MODULE$.apply(() -> this.getVersion$1$$anonfun$1$$anonfun$1(is)).toOption().map((Function1 & Serializable)_$2 -> _$2.version()), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private final URL createUrl$1(Dependency dependency$1, String version) {
        return new URI(this.RESOLVER_BASE_URL + "/gems/" + dependency$1.name() + "-" + version + ".gem").toURL();
    }

    private static final /* synthetic */ void downloadPackage$$anonfun$1(HttpURLConnection _$3) {
        _$3.setRequestProperty("Accept-Encoding", "gzip, deflate");
    }

    private static final FileOutputStream downloadPackage$$anonfun$2$$anonfun$1(File fileName$2) {
        return new FileOutputStream(fileName$2.pathAsString());
    }

    private static final int downloadPackage$$anonfun$2$$anonfun$2$$anonfun$1(InputStream is$2, byte[] buffer$1) {
        return is$2.read(buffer$1);
    }

    private static final void downloadPackage$$anonfun$2(InputStream inputStream$1, File fileName$1) {
        Using$.MODULE$.resources((Object)inputStream$1, () -> DependencyDownloader.downloadPackage$$anonfun$2$$anonfun$1(fileName$1), (Function2)(JProcedure2 & Serializable)(is, fos) -> {
            byte[] buffer = new byte[4096];
            package$.MODULE$.Iterator().continually(() -> DependencyDownloader.downloadPackage$$anonfun$2$$anonfun$2$$anonfun$1(is, buffer)).takeWhile((Function1)(JFunction1.mcZI.sp & Serializable)_$4 -> _$4 != -1).foreach((Function1)(JFunction1.mcVI.sp & Serializable)bytesRead -> fos.write(buffer, 0, bytesRead));
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private static /* bridge */ /* synthetic */ Object $anonfun$adapted$1(InputStream inputStream$2, File fileName$3) {
        DependencyDownloader.downloadPackage$$anonfun$2(inputStream$2, fileName$3);
        return BoxedUnit.UNIT;
    }

    private static final /* synthetic */ void downloadPackage$$anonfun$3(HttpURLConnection _$5) {
        _$5.disconnect();
    }

    private static final TarArchiveEntry untarDependencies$$anonfun$1$$anonfun$1$$anonfun$1(TarArchiveInputStream tarGemStream$1) {
        return tarGemStream$1.getNextEntry();
    }

    private static final TarArchiveEntry untarDependencies$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$1(TarArchiveInputStream dataTarStream$1) {
        return dataTarStream$1.getNextEntry();
    }

    private static final int untarDependencies$$anonfun$1$$anonfun$1$$anonfun$4$$anonfun$4$$anonfun$1$$anonfun$1(TarArchiveInputStream dataTarStream$4, byte[] buffer$3) {
        return dataTarStream$4.read(buffer$3);
    }

    private static final RubyProgramSummary remapPaths$1(RubyProgramSummary libSummary) {
        Map pathMappings = (Map)libSummary.pathToType().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String key = (String)tuple2._1();
                Set typs = (Set)tuple2._2();
                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(key), "./"));
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)typs);
            }
            throw new MatchError((Object)tuple2);
        });
        return new RubyProgramSummary(libSummary.namespaceToType(), (Map<String, Set<RubyType>>)pathMappings);
    }

    private static final RubyProgramSummary $anonfun$6() {
        return new RubyProgramSummary(RubyProgramSummary$.MODULE$.$lessinit$greater$default$1(), RubyProgramSummary$.MODULE$.$lessinit$greater$default$2());
    }

    public class RubyGemLatestVersion
    implements Product,
    Serializable {
        private final String version;
        private final /* synthetic */ DependencyDownloader $outer;
        public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(DependencyDownloader$RubyGemLatestVersion$.class.getDeclaredField("derived$ReadWriter$lzy1"));

        public RubyGemLatestVersion(DependencyDownloader $outer, String version) {
            this.version = version;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof RubyGemLatestVersion)) return false;
            if (((RubyGemLatestVersion)object).io$joern$rubysrc2cpg$utils$DependencyDownloader$RubyGemLatestVersion$$$outer() != this.$outer) return false;
            RubyGemLatestVersion rubyGemLatestVersion = (RubyGemLatestVersion)object;
            String string = this.version();
            String string2 = rubyGemLatestVersion.version();
            if (string == null) {
                if (string2 != null) {
                    return false;
                }
            } else if (!string.equals(string2)) return false;
            if (!rubyGemLatestVersion.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof RubyGemLatestVersion;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "RubyGemLatestVersion";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "version";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String version() {
            return this.version;
        }

        public RubyGemLatestVersion copy(String version) {
            return new RubyGemLatestVersion(this.$outer, version);
        }

        public String copy$default$1() {
            return this.version();
        }

        public String _1() {
            return this.version();
        }

        public final /* synthetic */ DependencyDownloader io$joern$rubysrc2cpg$utils$DependencyDownloader$RubyGemLatestVersion$$$outer() {
            return this.$outer;
        }
    }
}

