/*
 * Decompiled with CFR 0.152.
 */
package io.joern.rubysrc2cpg.parser;

import io.joern.rubysrc2cpg.Config;
import io.joern.rubysrc2cpg.parser.RubyAstGenRunner$;
import io.joern.rubysrc2cpg.parser.RubyAstGenRunner$LocalDir$;
import io.joern.rubysrc2cpg.parser.RubyAstGenRunner$TempDir$;
import io.joern.x2cpg.SourceFiles$;
import io.joern.x2cpg.X2CpgConfig;
import io.joern.x2cpg.astgen.AstGenRunner;
import io.joern.x2cpg.astgen.AstGenRunnerBase;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import org.jruby.RubyInstanceConfig;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.LocalVariableBehavior;
import org.jruby.embed.PathType;
import org.jruby.embed.ScriptingContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.StringContext$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.collection.mutable.LinkedHashMap;
import scala.collection.mutable.LinkedHashMap$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public class RubyAstGenRunner
implements AstGenRunnerBase,
AutoCloseable {
    private final X2CpgConfig io$joern$x2cpg$astgen$AstGenRunnerBase$$config;
    private Logger io$joern$x2cpg$astgen$AstGenRunnerBase$$logger;
    private String WinX86;
    private String WinArm;
    private String LinuxX86;
    private String LinuxArm;
    private String MacX86;
    private String MacArm;
    private Set SupportedBinaries;
    private final Config config;
    private final Logger logger;
    private final ExecutionEnvironment env;
    private final ScriptingContainer container;

    public RubyAstGenRunner(Config config) {
        this.config = config;
        this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config = config;
        AstGenRunnerBase.$init$((AstGenRunnerBase)this);
        this.logger = LoggerFactory.getLogger(this.getClass());
        this.env = RubyAstGenRunner$.MODULE$.io$joern$rubysrc2cpg$parser$RubyAstGenRunner$$$prepareExecutionEnvironment("ruby_ast_gen");
        String cwd = this.env.path().toAbsolutePath().toString();
        String gemPath = ((SeqOps)new .colon.colon((Object)cwd, (List)new .colon.colon((Object)"vendor", (List)new .colon.colon((Object)"bundle", (List)new .colon.colon((Object)"jruby", (List)new .colon.colon((Object)"3.1.0", (List)Nil$.MODULE$)))))).mkString(File.separator);
        ScriptingContainer container = new ScriptingContainer(LocalContextScope.THREADSAFE, LocalVariableBehavior.TRANSIENT);
        RubyInstanceConfig config2 = container.getProvider().getRubyInstanceConfig();
        container.setCompileMode(RubyInstanceConfig.CompileMode.OFF);
        container.setNativeEnabled(false);
        container.setObjectSpaceEnabled(true);
        container.setCurrentDirectory(cwd);
        config2.setLoadGemfile(true);
        Object[] objectArray = new Tuple2[2];
        String string = (String)Predef$.MODULE$.ArrowAssoc((Object)"GEM_PATH");
        objectArray[0] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)gemPath);
        String string2 = (String)Predef$.MODULE$.ArrowAssoc((Object)"GEM_FILE");
        objectArray[1] = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string2, (Object)gemPath);
        container.setEnvironment(CollectionConverters$.MODULE$.MapHasAsJava((Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray(objectArray))).asJava());
        config2.setHasShebangLine(true);
        config2.setHardExit(false);
        this.container = container;
        Statics.releaseFence();
    }

    public X2CpgConfig io$joern$x2cpg$astgen$AstGenRunnerBase$$config() {
        return this.io$joern$x2cpg$astgen$AstGenRunnerBase$$config;
    }

    public Logger io$joern$x2cpg$astgen$AstGenRunnerBase$$logger() {
        return this.io$joern$x2cpg$astgen$AstGenRunnerBase$$logger;
    }

    public String WinX86() {
        return this.WinX86;
    }

    public String WinArm() {
        return this.WinArm;
    }

    public String LinuxX86() {
        return this.LinuxX86;
    }

    public String LinuxArm() {
        return this.LinuxArm;
    }

    public String MacX86() {
        return this.MacX86;
    }

    public String MacArm() {
        return this.MacArm;
    }

    public Set SupportedBinaries() {
        return this.SupportedBinaries;
    }

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$io$joern$x2cpg$astgen$AstGenRunnerBase$$logger_$eq(Logger x$0) {
        this.io$joern$x2cpg$astgen$AstGenRunnerBase$$logger = x$0;
    }

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$WinX86_$eq(String x$0) {
        this.WinX86 = x$0;
    }

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$WinArm_$eq(String x$0) {
        this.WinArm = x$0;
    }

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$LinuxX86_$eq(String x$0) {
        this.LinuxX86 = x$0;
    }

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$LinuxArm_$eq(String x$0) {
        this.LinuxArm = x$0;
    }

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$MacX86_$eq(String x$0) {
        this.MacX86 = x$0;
    }

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$MacArm_$eq(String x$0) {
        this.MacArm = x$0;
    }

    public void io$joern$x2cpg$astgen$AstGenRunnerBase$_setter_$SupportedBinaries_$eq(Set x$0) {
        this.SupportedBinaries = x$0;
    }

    @Override
    public void close() {
        Try closeEnv;
        Try closeContainer = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$1();
            return BoxedUnit.UNIT;
        });
        if (closeContainer.isFailure()) {
            this.logger.error("Error occurred while terminating JRuby scripting container!", (Throwable)closeContainer.failed().get());
        }
        if ((closeEnv = Try$.MODULE$.apply((Function0 & Serializable)() -> {
            this.$anonfun$2();
            return BoxedUnit.UNIT;
        })).isFailure()) {
            this.logger.error("Error occurred while cleaning up JRuby execution directory!", (Throwable)closeEnv.failed().get());
            return;
        }
    }

    public boolean fileFilter(String file, Path out) {
        String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(file), ".json").replace(out.toString(), this.config.inputPath());
        String filePath = string;
        if (this.isIgnoredByUserConfig(filePath)) {
            return false;
        }
        String filePath2 = string;
        if (this.isIgnoredByDefaultRegex(filePath2)) {
            return false;
        }
        String filePath3 = string;
        return !filePath3.endsWith(".csproj");
    }

    private boolean isIgnoredByDefaultRegex(String filePath) {
        return this.config.defaultIgnoredFilesRegex().exists((Function1 & Serializable)_$1 -> _$1.matches((CharSequence)filePath));
    }

    public List<String> skippedFiles(Path in, List<String> astGenOut) {
        LinkedHashMap diagnosticMap = LinkedHashMap$.MODULE$.empty();
        astGenOut.map((Function1 & Serializable)_$2 -> _$2.strip()).foreach((Function1 & Serializable)x$1 -> {
            String string = x$1;
            if (string != null) {
                Seq seq;
                Seq seq2;
                Seq seq3;
                Seq seq4;
                Seq seq5;
                Option option = StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[WARN] ", " - ", ""})).s().unapplySeq(string);
                if (!option.isEmpty() && (seq5 = (Seq)option.get()).lengthCompare(2) == 0) {
                    String string2 = (String)seq5.apply(0);
                    String string3 = (String)seq5.apply(1);
                    String reason = string2;
                    String fileName = string3;
                    return RubyAstGenRunner.addReason$1(diagnosticMap, reason, Option$.MODULE$.apply((Object)fileName));
                }
                Option option2 = StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[ERR] '", "' - ", ""})).s().unapplySeq(string);
                if (!option2.isEmpty() && (seq4 = (Seq)option2.get()).lengthCompare(2) == 0) {
                    String string4 = (String)seq4.apply(0);
                    String string5 = (String)seq4.apply(1);
                    String fileName = string4;
                    String reason = string5;
                    return RubyAstGenRunner.addReason$1(diagnosticMap, reason, Option$.MODULE$.apply((Object)fileName));
                }
                Option option3 = StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[ERR] Failed to parse ", ": ", ""})).s().unapplySeq(string);
                if (!option3.isEmpty() && (seq3 = (Seq)option3.get()).lengthCompare(2) == 0) {
                    String string6 = (String)seq3.apply(0);
                    String string7 = (String)seq3.apply(1);
                    String fileName = string6;
                    String reason = string7;
                    return RubyAstGenRunner.addReason$1(diagnosticMap, "Failed to parse: " + reason, Option$.MODULE$.apply((Object)fileName));
                }
                Option option4 = StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[INFO] Processed: ", " -> ", ""})).s().unapplySeq(string);
                if (!option4.isEmpty() && (seq2 = (Seq)option4.get()).lengthCompare(2) == 0) {
                    String string8 = (String)seq2.apply(0);
                    String string9 = (String)seq2.apply(1);
                    String fileName = string8;
                    return diagnosticMap.put((Object)fileName, (Object)package$.MODULE$.Nil());
                }
                Option option5 = StringContext$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"[INFO] Excluding: ", ""})).s().unapplySeq(string);
                if (!option5.isEmpty() && (seq = (Seq)option5.get()).lengthCompare(1) == 0) {
                    String string10;
                    String fileName = string10 = (String)seq.apply(0);
                    return RubyAstGenRunner.addReason$1(diagnosticMap, "Skipped", Option$.MODULE$.apply((Object)fileName));
                }
            }
            return BoxedUnit.UNIT;
        });
        return ((IterableOnceOps)diagnosticMap.flatMap((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String string = (String)tuple2._1();
                Seq seq = (Seq)tuple2._2();
                String filename = string;
                Nil$ nil$ = package$.MODULE$.Nil();
                Seq seq2 = seq;
                if (!(nil$ != null ? !nil$.equals(seq2) : seq2 != null)) {
                    this.logger.debug("Successfully parsed '" + filename + "'");
                    return None$.MODULE$;
                }
                String filename2 = string;
                if (seq instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)seq;
                    List list = colon2.next();
                    if ("Skipped".equals(colon2.head())) {
                        Nil$ nil$2 = package$.MODULE$.Nil();
                        List list2 = list;
                        if (!(nil$2 != null ? !nil$2.equals(list2) : list2 != null)) {
                            this.logger.debug("Skipped '" + filename2 + "' due to file filter");
                            return Option$.MODULE$.apply((Object)filename2);
                        }
                    }
                }
                String filename3 = string;
                Seq diagnostics = seq;
                this.logger.warn("Parsed '" + filename3 + "' with the following diagnostics:\n" + ((IterableOnceOps)diagnostics.map((Function1 & Serializable)x -> " - " + x)).mkString("\n"));
                return Option$.MODULE$.apply((Object)filename3);
            }
            throw new MatchError((Object)tuple2);
        })).toList();
    }

    public Try<Seq<String>> runAstGenNative(String in, Path out, String exclude, String include, AstGenRunner.AstGenProgramMetaData metaData) {
        Try<Seq<String>> try_;
        Path scriptTarget = Files.createTempFile("ruby_driver", ".rb", new FileAttribute[0]);
        try {
            try {
                String requireFile = this.env.path().resolve("lib").resolve("ruby_ast_gen.rb").toUri().toString();
                String mainScript = StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("\n          |options = {\n          |  input: nil,\n          |  output: '.ast',\n          |  exclude: '^(tests?|vendor|spec)',\n          |  debug: false\n          |}\n          |\n          |options[:input] = \"" + in.replace("\\", "\\\\") + "\"\n          |options[:output] = \"" + out.toString().replace("\\", "\\\\") + "\"\n          |" + (String)(exclude.isEmpty() ? "" : "options[:exclude] = /" + exclude.replace("/", "\\/") + "/") + "\n          |\n          |if defined?(RubyAstGen) != 'constant' || defined?(RubyAstGen::parse) != 'method' then\n          |  require \"" + requireFile + "\"\n          |end\n          |RubyAstGen::parse(options)\n          |"));
                Files.writeString(scriptTarget, (CharSequence)mainScript, StandardOpenOption.TRUNCATE_EXISTING, StandardOpenOption.CREATE);
                try_ = this.executeWithJRuby(scriptTarget);
            }
            catch (Exception tempPathException) {
                try_ = Failure$.MODULE$.apply((Throwable)tempPathException);
            }
        }
        finally {
            scriptTarget.toFile().delete();
        }
        return try_;
    }

    public AstGenRunner.AstGenRunnerResult execute(Path out) {
        return this.execute(out, this.config);
    }

    public AstGenRunner.AstGenRunnerResult execute(Path out, Config specifiedConfig) {
        AstGenRunner.AstGenProgramMetaData metaData = specifiedConfig.astGenMetaData();
        Path in = Paths.get(this.config.inputPath(), new String[0]);
        this.logger.info("Running " + metaData.name() + " on '" + specifiedConfig.inputPath() + "'");
        String combineIgnoreRegex = specifiedConfig.ignoredFilesRegex().toString().isEmpty() && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(specifiedConfig.defaultIgnoredFilesRegex().toString())) ? specifiedConfig.defaultIgnoredFilesRegex().mkString("|") : (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(this.config.ignoredFilesRegex().toString())) && specifiedConfig.defaultIgnoredFilesRegex().toString().isEmpty() ? specifiedConfig.ignoredFilesRegex().toString() : (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(specifiedConfig.ignoredFilesRegex().toString())) && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(specifiedConfig.defaultIgnoredFilesRegex().toString())) ? "((" + specifiedConfig.ignoredFilesRegex().toString() + ")|(" + specifiedConfig.defaultIgnoredFilesRegex().mkString("|") + "))" : ""));
        Try<Seq<String>> try_ = this.runAstGenNative(specifiedConfig.inputPath(), out, combineIgnoreRegex, "", metaData);
        if (try_ instanceof Success) {
            Seq result = (Seq)((Success)try_).value();
            String string = out.toString();
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}));
            Option option = Option$.MODULE$.apply((Object)specifiedConfig.defaultIgnoredFilesRegex());
            Option option2 = Option$.MODULE$.apply((Object)specifiedConfig.ignoredFilesRegex());
            Option option3 = Option$.MODULE$.apply((Object)specifiedConfig.ignoredFiles());
            List srcFiles = SourceFiles$.MODULE$.determine(string, set, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, set, option, option2, option3));
            List parsed = this.filterFiles(srcFiles, out);
            List<String> skipped = this.skippedFiles(in, (List<String>)result.toList());
            return AstGenRunner.DefaultAstGenRunnerResult$.MODULE$.apply(parsed, skipped);
        }
        if (try_ instanceof Failure) {
            Throwable f = ((Failure)try_).exception();
            this.logger.error("\t- running " + metaData.name() + " failed!", f);
            return AstGenRunner.DefaultAstGenRunnerResult$.MODULE$.apply(AstGenRunner.DefaultAstGenRunnerResult$.MODULE$.$lessinit$greater$default$1(), AstGenRunner.DefaultAstGenRunnerResult$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(try_);
    }

    private Try<Seq<String>> executeWithJRuby(Path script) {
        return (Try)Using$.MODULE$.resources((Object)new ByteArrayOutputStream(), RubyAstGenRunner::executeWithJRuby$$anonfun$1, (Function2 & Serializable)(outStream, errStream) -> {
            this.container.setOutput(new PrintStream((OutputStream)outStream));
            this.container.setError(new PrintStream((OutputStream)errStream));
            return Try$.MODULE$.apply(() -> this.executeWithJRuby$$anonfun$2$$anonfun$1(script, outStream, errStream));
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private final void $anonfun$1() {
        this.container.terminate();
    }

    private final void $anonfun$2() {
        this.env.close();
    }

    private static final String $anonfun$3(LinkedHashMap diagnosticMap$2) {
        return (String)diagnosticMap$2.last()._1();
    }

    private static final Option addReason$1(LinkedHashMap diagnosticMap$1, String reason, Option lastFile) {
        String key = (String)lastFile.getOrElse(() -> RubyAstGenRunner.$anonfun$3(diagnosticMap$1));
        return diagnosticMap$1.updateWith((Object)key, (Function1 & Serializable)x$1 -> {
            Option option = x$1;
            if (option instanceof Some) {
                Seq x = (Seq)((Some)option).value();
                return Option$.MODULE$.apply(x.$colon$plus((Object)reason));
            }
            if (None$.MODULE$.equals(option)) {
                return Option$.MODULE$.apply((Object)package$.MODULE$.Nil().$colon$colon((Object)reason));
            }
            throw new MatchError((Object)option);
        });
    }

    private static final Option addReason$default$2$1() {
        return None$.MODULE$;
    }

    private static final ByteArrayOutputStream executeWithJRuby$$anonfun$1() {
        return new ByteArrayOutputStream();
    }

    private final IndexedSeq executeWithJRuby$$anonfun$2$$anonfun$1(Path script$2, ByteArrayOutputStream outStream$1, ByteArrayOutputStream errStream$1) {
        this.container.runScriptlet(PathType.ABSOLUTE, script$2.toString());
        Object object = Predef$.MODULE$.refArrayOps((Object[])outStream$1.toString().split("\n"));
        return (IndexedSeq)((IterableOps)ArrayOps$.MODULE$.toIndexedSeq$extension(object).$plus$plus((IterableOnce)Predef$.MODULE$.wrapRefArray((Object[])errStream$1.toString().split("\n")))).filterNot((Function1 & Serializable)_$3 -> _$3.isBlank());
    }

    public static interface ExecutionEnvironment
    extends AutoCloseable {
        public Path path();

        public static void close$(ExecutionEnvironment $this) {
            $this.close();
        }

        @Override
        default public void close() {
        }
    }

    public static class LocalDir
    implements ExecutionEnvironment,
    Product,
    Serializable {
        private final Path path;

        public static LocalDir apply(Path path) {
            return RubyAstGenRunner$LocalDir$.MODULE$.apply(path);
        }

        public static LocalDir fromProduct(Product product) {
            return RubyAstGenRunner$LocalDir$.MODULE$.fromProduct(product);
        }

        public static LocalDir unapply(LocalDir localDir) {
            return RubyAstGenRunner$LocalDir$.MODULE$.unapply(localDir);
        }

        public LocalDir(Path path) {
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof LocalDir)) return false;
            LocalDir localDir = (LocalDir)object;
            Path path = this.path();
            Path path2 = localDir.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            if (!localDir.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof LocalDir;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "LocalDir";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Path path() {
            return this.path;
        }

        public LocalDir copy(Path path) {
            return new LocalDir(path);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public Path _1() {
            return this.path();
        }
    }

    public static class TempDir
    implements ExecutionEnvironment,
    Product,
    Serializable {
        private final Path path;

        public static TempDir apply(Path path) {
            return RubyAstGenRunner$TempDir$.MODULE$.apply(path);
        }

        public static TempDir fromProduct(Product product) {
            return RubyAstGenRunner$TempDir$.MODULE$.fromProduct(product);
        }

        public static TempDir unapply(TempDir tempDir) {
            return RubyAstGenRunner$TempDir$.MODULE$.unapply(tempDir);
        }

        public TempDir(Path path) {
            this.path = path;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof TempDir)) return false;
            TempDir tempDir = (TempDir)object;
            Path path = this.path();
            Path path2 = tempDir.path();
            if (path == null) {
                if (path2 != null) {
                    return false;
                }
            } else if (!((Object)path).equals(path2)) return false;
            if (!tempDir.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof TempDir;
        }

        public int productArity() {
            return 1;
        }

        public String productPrefix() {
            return "TempDir";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "path";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        @Override
        public Path path() {
            return this.path;
        }

        @Override
        public void close() {
            this.cleanUpDir$1(this.path());
        }

        public TempDir copy(Path path) {
            return new TempDir(path);
        }

        public Path copy$default$1() {
            return this.path();
        }

        public Path _1() {
            return this.path();
        }

        private final void cleanUpDir$1(Path f2) {
            if (Files.isDirectory(f2, new LinkOption[0])) {
                CollectionConverters$.MODULE$.IteratorHasAsScala(Files.list(f2).iterator()).asScala().foreach((Function1)(JProcedure1 & Serializable)f -> this.cleanUpDir$1((Path)f));
            }
            Files.deleteIfExists(f2);
        }
    }
}

