/*
 * Decompiled with CFR 0.152.
 */
package io.joern.swiftsrc2cpg.passes;

import io.joern.swiftsrc2cpg.Config;
import io.joern.swiftsrc2cpg.astcreation.AstCreator;
import io.joern.swiftsrc2cpg.parser.SwiftJsonParser;
import io.joern.swiftsrc2cpg.parser.SwiftJsonParser$;
import io.joern.swiftsrc2cpg.passes.AstCreationPass$;
import io.joern.swiftsrc2cpg.passes.Defines$;
import io.joern.swiftsrc2cpg.utils.AstGenRunner;
import io.joern.x2cpg.ValidationMode;
import io.joern.x2cpg.datastructures.Global;
import io.joern.x2cpg.utils.Report;
import io.joern.x2cpg.utils.TimeUtils$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.passes.ConcurrentWriterCpgPass;
import io.shiftleft.passes.ConcurrentWriterCpgPass$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import overflowdb.BatchedUpdate;
import scala.Function1;
import scala.MatchError;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.collection.immutable.List;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public class AstCreationPass
extends ConcurrentWriterCpgPass<String> {
    private final AstGenRunner.AstGenRunnerResult astGenRunnerResult;
    private final Config config;
    private final Report report;
    private final ValidationMode withSchemaValidation;
    private final Logger logger;
    private final Global global;

    public static Report $lessinit$greater$default$4() {
        return AstCreationPass$.MODULE$.$lessinit$greater$default$4();
    }

    public AstCreationPass(Cpg cpg, AstGenRunner.AstGenRunnerResult astGenRunnerResult, Config config, Report report, ValidationMode withSchemaValidation) {
        this.astGenRunnerResult = astGenRunnerResult;
        this.config = config;
        this.report = report;
        this.withSchemaValidation = withSchemaValidation;
        super(cpg, ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$2(), ConcurrentWriterCpgPass$.MODULE$.$lessinit$greater$default$3());
        this.logger = LoggerFactory.getLogger(AstCreationPass.class);
        this.global = new Global();
    }

    public List<String> typesSeen() {
        return CollectionConverters$.MODULE$.EnumerationHasAsScala(this.global.usedTypes().keys()).asScala().filterNot((Function1 & Serializable)_$1 -> {
            String string = _$1;
            String string2 = Defines$.MODULE$.Any();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).toList();
    }

    public String[] generateParts() {
        return (String[])this.astGenRunnerResult.parsedFiles().toArray(ClassTag$.MODULE$.apply(String.class));
    }

    public void finish() {
        this.astGenRunnerResult.skippedFiles().foreach((Function1)(JProcedure1 & Serializable)skippedFile -> {
            Path filePath = Paths.get(skippedFile, new String[0]);
            int fileLOC = IOUtils$.MODULE$.readLinesInFile(filePath).size();
            this.report.addReportInfo(skippedFile, fileLOC, this.report.addReportInfo$default$3(), this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5());
        });
    }

    public void runOnPart(BatchedUpdate.DiffGraphBuilder diffGraph, String input) {
        Tuple2 tuple2;
        Tuple2 tuple22 = TimeUtils$.MODULE$.time(() -> this.$anonfun$1(input, diffGraph));
        if (tuple22 == null || (tuple2 = (Tuple2)tuple22._1()) == null) {
            throw new MatchError((Object)tuple22);
        }
        boolean gotCpg = BoxesRunTime.unboxToBoolean((Object)tuple2._1());
        String filename = (String)tuple2._2();
        long duration = BoxesRunTime.unboxToLong((Object)tuple22._2());
        Tuple3 tuple3 = Tuple3$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)gotCpg), (Object)filename, (Object)BoxesRunTime.boxToLong((long)duration));
        boolean gotCpg2 = BoxesRunTime.unboxToBoolean((Object)tuple3._1());
        String filename2 = (String)tuple3._2();
        long duration2 = BoxesRunTime.unboxToLong((Object)tuple3._3());
        this.report.updateReport(filename2, gotCpg2, duration2);
    }

    private final BatchedUpdate.DiffGraphBuilder $anonfun$1$$anonfun$1(SwiftJsonParser.ParseResult parseResult$1, BatchedUpdate.DiffGraphBuilder diffGraph$2) {
        BatchedUpdate.DiffGraphBuilder localDiff = new AstCreator(this.config, this.global, parseResult$1, this.withSchemaValidation).createAst();
        return diffGraph$2.absorb(localDiff);
    }

    private final Tuple2 $anonfun$1(String input$1, BatchedUpdate.DiffGraphBuilder diffGraph$1) {
        Try<SwiftJsonParser.ParseResult> try_ = SwiftJsonParser$.MODULE$.readFile(Paths.get(input$1, new String[0]));
        if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            this.logger.warn("Failed to read '" + input$1 + "'", exception);
            return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)input$1);
        }
        if (try_ instanceof Success) {
            SwiftJsonParser.ParseResult parseResult = (SwiftJsonParser.ParseResult)((Success)try_).value();
            int fileLOC = IOUtils$.MODULE$.readLinesInFile(Paths.get(parseResult.fullPath(), new String[0])).size();
            this.report.addReportInfo(parseResult.filename(), fileLOC, true, this.report.addReportInfo$default$4(), this.report.addReportInfo$default$5());
            Try try_2 = Try$.MODULE$.apply(() -> this.$anonfun$1$$anonfun$1(parseResult, diffGraph$1));
            if (try_2 instanceof Failure) {
                Throwable exception = ((Failure)try_2).exception();
                this.logger.warn("Failed to generate a CPG for: '" + parseResult.fullPath() + "'", exception);
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false), (Object)parseResult.filename());
            }
            if (try_2 instanceof Success) {
                this.logger.info("Generated a CPG for: '" + parseResult.fullPath() + "'");
                return Tuple2$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true), (Object)parseResult.filename());
            }
            throw new MatchError((Object)try_2);
        }
        throw new MatchError(try_);
    }
}

