/*
 * Decompiled with CFR 0.152.
 */
package io.joern.swiftsrc2cpg.utils;

import better.files.File;
import better.files.File$;
import io.joern.swiftsrc2cpg.Config;
import io.joern.swiftsrc2cpg.utils.AstGenRunner$;
import io.joern.swiftsrc2cpg.utils.AstGenRunner$AstGenRunnerResult$;
import io.joern.swiftsrc2cpg.utils.ExternalCommand$;
import io.joern.x2cpg.SourceFiles$;
import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Product;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.runtime.BoxesRunTime;
import scala.runtime.LazyBoolean;
import scala.runtime.LazyVals$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public class AstGenRunner {
    private final Config config;
    public static final long OFFSET$_m_2 = LazyVals$.MODULE$.getOffsetStatic(AstGenRunner$.class.getDeclaredField("astGenCommand$lzy1"));
    public static final long OFFSET$_m_1 = LazyVals$.MODULE$.getOffsetStatic(AstGenRunner$.class.getDeclaredField("executableDir$lzy1"));
    public static final long OFFSET$_m_0 = LazyVals$.MODULE$.getOffsetStatic(AstGenRunner$.class.getDeclaredField("executableName$lzy1"));

    public AstGenRunner(Config config) {
        this.config = config;
    }

    private List<String> skippedFiles(List<String> astGenOut) {
        List skipped = astGenOut.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(String x) {
                String string = x;
                String out = string;
                if (!out.startsWith("Generated")) {
                    return true;
                }
                String out2 = string;
                return true;
            }

            public final Object applyOrElse(String x, Function1 function1) {
                String string = x;
                String out = string;
                if (!out.startsWith("Generated")) {
                    String filename = out.substring(out.indexOf(": `") + 3, out.indexOf("swift`") + 5);
                    String reason = out.substring(out.indexOf("` ") + 2);
                    AstGenRunner$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$logger.warn("\t- failed to parse '" + filename + "': '" + reason + "'");
                    return Option$.MODULE$.apply((Object)filename);
                }
                String out2 = string;
                AstGenRunner$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$logger.debug("\t+ " + out2);
                return None$.MODULE$;
            }
        });
        return (List)skipped.flatten(Predef$.MODULE$.$conforms());
    }

    private boolean isIgnoredByUserConfig(String filePath) {
        LazyBoolean lazyBoolean = new LazyBoolean();
        LazyBoolean lazyBoolean2 = new LazyBoolean();
        if (this.isInIgnoredFiles$1(lazyBoolean, filePath) || this.isInIgnoredFileRegex$1(lazyBoolean2, filePath)) {
            AstGenRunner$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$logger.debug("'" + filePath + "' ignored by user configuration");
            return true;
        }
        return false;
    }

    private List<String> filterFiles(List<String> files, File out) {
        return files.filter((Function1 & Serializable)file -> {
            String string = StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(file), ".json").replace(out.pathAsString(), this.config.inputPath());
            String filePath = string;
            return !this.isIgnoredByUserConfig(filePath);
        });
    }

    private Try<Seq<String>> runAstGenNative(File in, File out) {
        return ExternalCommand$.MODULE$.run(AstGenRunner$.MODULE$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$astGenCommand() + " -o " + out, in.toString(), ExternalCommand$.MODULE$.run$default$3());
    }

    private List<String> checkParsedFiles(List<String> files, File in) {
        int numOfParsedFiles = files.size();
        AstGenRunner$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$logger.info("Parsed " + numOfParsedFiles + " files.");
        if (numOfParsedFiles == 0) {
            AstGenRunner$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$logger.warn("You may want to check the DEBUG logs for a list of files that are ignored by default.");
            String string = in.pathAsString();
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".swift"}));
            Option option = Option$.MODULE$.apply(AstGenRunner$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$AstGenDefaultIgnoreRegex);
            Option option2 = SourceFiles$.MODULE$.determine$default$4();
            Option option3 = SourceFiles$.MODULE$.determine$default$5();
            SourceFiles$.MODULE$.determine(string, set, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, set, option, option2, option3));
        }
        return files;
    }

    public AstGenRunnerResult execute(File out) {
        File in = File$.MODULE$.apply(this.config.inputPath(), (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
        AstGenRunner$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$logger.info("Running SwiftAstGen in '" + in + "' ...");
        Try<Seq<String>> try_ = this.runAstGenNative(in, out);
        if (try_ instanceof Success) {
            Seq result = (Seq)((Success)try_).value();
            String string = out.toString();
            Set set = (Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{".json"}));
            Option option = SourceFiles$.MODULE$.determine$default$3();
            Option option2 = SourceFiles$.MODULE$.determine$default$4();
            Option option3 = SourceFiles$.MODULE$.determine$default$5();
            List<String> parsed = this.checkParsedFiles(this.filterFiles((List<String>)SourceFiles$.MODULE$.determine(string, set, option, option2, option3, SourceFiles$.MODULE$.determine$default$6(string, set, option, option2, option3)), out), in);
            List<String> skipped = this.skippedFiles((List<String>)result.toList());
            return AstGenRunner$AstGenRunnerResult$.MODULE$.apply(parsed, skipped);
        }
        if (try_ instanceof Failure) {
            Throwable f = ((Failure)try_).exception();
            AstGenRunner$.io$joern$swiftsrc2cpg$utils$AstGenRunner$$$logger.error("\t- running SwiftAstGen failed!", f);
            return AstGenRunner$AstGenRunnerResult$.MODULE$.apply(AstGenRunner$AstGenRunnerResult$.MODULE$.$lessinit$greater$default$1(), AstGenRunner$AstGenRunnerResult$.MODULE$.$lessinit$greater$default$2());
        }
        throw new MatchError(try_);
    }

    private final boolean isInIgnoredFiles$lzyINIT1$1(LazyBoolean isInIgnoredFiles$lzy1$1, String filePath$1) {
        boolean bl;
        LazyBoolean lazyBoolean = isInIgnoredFiles$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isInIgnoredFiles$lzy1$1.initialized() ? isInIgnoredFiles$lzy1$1.value() : isInIgnoredFiles$lzy1$1.initialize(this.config.ignoredFiles().exists((Function1 & Serializable)x$1 -> {
                String string = x$1;
                String ignorePath = string;
                File file = File$.MODULE$.apply(ignorePath, (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[0]));
                if (file.isDirectory(file.isDirectory$default$1())) {
                    return filePath$1.startsWith(ignorePath);
                }
                String ignorePath2 = string;
                String string2 = filePath$1;
                String string3 = ignorePath2;
                return !(string2 != null ? !string2.equals(string3) : string3 != null);
            }));
        }
        return bl;
    }

    private final boolean isInIgnoredFiles$1(LazyBoolean isInIgnoredFiles$lzy1$2, String filePath$3) {
        if (isInIgnoredFiles$lzy1$2.initialized()) {
            return isInIgnoredFiles$lzy1$2.value();
        }
        return this.isInIgnoredFiles$lzyINIT1$1(isInIgnoredFiles$lzy1$2, filePath$3);
    }

    private final boolean isInIgnoredFileRegex$lzyINIT1$1(LazyBoolean isInIgnoredFileRegex$lzy1$1, String filePath$4) {
        boolean bl;
        LazyBoolean lazyBoolean = isInIgnoredFileRegex$lzy1$1;
        synchronized (lazyBoolean) {
            bl = isInIgnoredFileRegex$lzy1$1.initialized() ? isInIgnoredFileRegex$lzy1$1.value() : isInIgnoredFileRegex$lzy1$1.initialize(this.config.ignoredFilesRegex().matches((CharSequence)filePath$4));
        }
        return bl;
    }

    private final boolean isInIgnoredFileRegex$1(LazyBoolean isInIgnoredFileRegex$lzy1$2, String filePath$5) {
        if (isInIgnoredFileRegex$lzy1$2.initialized()) {
            return isInIgnoredFileRegex$lzy1$2.value();
        }
        return this.isInIgnoredFileRegex$lzyINIT1$1(isInIgnoredFileRegex$lzy1$2, filePath$5);
    }

    public static class AstGenRunnerResult
    implements Product,
    Serializable {
        private final List<String> parsedFiles;
        private final List<String> skippedFiles;

        public static AstGenRunnerResult apply(List<String> list, List<String> list2) {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.apply(list, list2);
        }

        public static AstGenRunnerResult fromProduct(Product product) {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.fromProduct(product);
        }

        public static AstGenRunnerResult unapply(AstGenRunnerResult astGenRunnerResult) {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.unapply(astGenRunnerResult);
        }

        public static List<String> $lessinit$greater$default$1() {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.$lessinit$greater$default$1();
        }

        public static List<String> $lessinit$greater$default$2() {
            return AstGenRunner$AstGenRunnerResult$.MODULE$.$lessinit$greater$default$2();
        }

        public AstGenRunnerResult(List<String> parsedFiles, List<String> skippedFiles) {
            this.parsedFiles = parsedFiles;
            this.skippedFiles = skippedFiles;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof AstGenRunnerResult)) return false;
            AstGenRunnerResult astGenRunnerResult = (AstGenRunnerResult)object;
            List<String> list = this.parsedFiles();
            List<String> list2 = astGenRunnerResult.parsedFiles();
            if (list == null) {
                if (list2 != null) {
                    return false;
                }
            } else if (!list.equals(list2)) return false;
            List<String> list3 = this.skippedFiles();
            List<String> list4 = astGenRunnerResult.skippedFiles();
            if (list3 == null) {
                if (list4 != null) {
                    return false;
                }
            } else if (!list3.equals(list4)) return false;
            if (!astGenRunnerResult.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof AstGenRunnerResult;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "AstGenRunnerResult";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "parsedFiles";
            }
            if (1 == n2) {
                return "skippedFiles";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public List<String> parsedFiles() {
            return this.parsedFiles;
        }

        public List<String> skippedFiles() {
            return this.skippedFiles;
        }

        public AstGenRunnerResult copy(List<String> parsedFiles, List<String> skippedFiles) {
            return new AstGenRunnerResult(parsedFiles, skippedFiles);
        }

        public List<String> copy$default$1() {
            return this.parsedFiles();
        }

        public List<String> copy$default$2() {
            return this.skippedFiles();
        }

        public List<String> _1() {
            return this.parsedFiles();
        }

        public List<String> _2() {
            return this.skippedFiles();
        }
    }
}

