/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.Seq;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Using;
import scala.util.Using$;

public final class HashUtil$ {
    public static final HashUtil$ MODULE$ = new HashUtil$();

    public String sha256(Path file) {
        return this.sha256((Seq<Path>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{file}))));
    }

    public String sha256(String file) {
        return this.sha256((Seq<Path>)((Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Path[]{Path.of(file, new String[0])}))));
    }

    public String sha256(Seq<Path> files) {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        byte[] buffer = new byte[4096];
        ((IterableOnceOps)files.filterNot((Function1 & Serializable)p -> BoxesRunTime.boxToBoolean((boolean)HashUtil$.MODULE$.isDirectory(p.toRealPath(new LinkOption[0]))))).foreach((Function1 & Serializable)path -> {
            Using$.MODULE$.resource((Object)new DigestInputStream(Files.newInputStream(path, new OpenOption[0]), md), (Function1 & Serializable)dis -> {
                HashUtil$.$anonfun$sha256$3(buffer$1, dis);
                return BoxedUnit.UNIT;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
            return BoxedUnit.UNIT;
        });
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(md.digest()), (Function1 & Serializable)b -> HashUtil$.$anonfun$sha256$4(BoxesRunTime.unboxToByte((Object)b)), ClassTag$.MODULE$.apply(String.class))).mkString();
    }

    private boolean isDirectory(Path path) {
        return path == null || !Files.exists(path, new LinkOption[0]) ? false : Files.isDirectory(path, new LinkOption[0]);
    }

    public static final /* synthetic */ void $anonfun$sha256$3(byte[] buffer$1, DigestInputStream dis) {
        while (dis.available() > 0) {
            dis.read(buffer$1);
        }
    }

    public static final /* synthetic */ String $anonfun$sha256$4(byte b) {
        return String.format("%02x", BoxesRunTime.boxToByte((byte)b));
    }

    private HashUtil$() {
    }
}

