/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import better.files.File$;
import io.joern.x2cpg.utils.dependency.Constants$;
import io.joern.x2cpg.utils.dependency.GradleDepsInitScript;
import io.joern.x2cpg.utils.dependency.GradleProjectInfo;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.GradleProject;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.UninitializedFieldError;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class GradleDependencies$ {
    public static final GradleDependencies$ MODULE$ = new GradleDependencies$();
    private static final Logger logger = LoggerFactory.getLogger(MODULE$.getClass());
    private static final String initScriptPrefix;
    private static final String taskNamePrefix;
    private static final String tempDirPrefix;
    private static volatile byte bitmap$init$0;

    static {
        bitmap$init$0 = (byte)(bitmap$init$0 | 1);
        initScriptPrefix = "x2cpg.init.gradle";
        bitmap$init$0 = (byte)(bitmap$init$0 | 2);
        taskNamePrefix = "x2cpgCopyDeps";
        bitmap$init$0 = (byte)(bitmap$init$0 | 4);
        tempDirPrefix = "x2cpgDependencies";
        bitmap$init$0 = (byte)(bitmap$init$0 | 8);
    }

    private Logger logger() {
        if ((byte)(bitmap$init$0 & 1) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/x2cpg/src/main/scala/io/joern/x2cpg/utils/dependency/GradleDependencies.scala: 40");
        }
        return logger;
    }

    private String initScriptPrefix() {
        if ((byte)(bitmap$init$0 & 2) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/x2cpg/src/main/scala/io/joern/x2cpg/utils/dependency/GradleDependencies.scala: 41");
        }
        return initScriptPrefix;
    }

    private String taskNamePrefix() {
        if ((byte)(bitmap$init$0 & 4) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/x2cpg/src/main/scala/io/joern/x2cpg/utils/dependency/GradleDependencies.scala: 42");
        }
        return taskNamePrefix;
    }

    private String tempDirPrefix() {
        if ((byte)(bitmap$init$0 & 8) == 0) {
            throw new UninitializedFieldError("Uninitialized field: /home/runner/work/joern/joern/joern-cli/frontends/x2cpg/src/main/scala/io/joern/x2cpg/utils/dependency/GradleDependencies.scala: 43");
        }
        return tempDirPrefix;
    }

    private String gradle5OrLaterAndroidInitScript(String taskName, String destination, String gradleProjectName, String gradleConfigurationName) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(1750).append("\n       |allprojects {\n       |  afterEvaluate { project ->\n       |    def taskName = \"").append(taskName).append("\"\n       |    def destinationDir = \"").append(destination).append("\"\n       |    def gradleProjectName = \"").append(gradleProjectName).append("\"\n       |    def gradleConfigurationName = \"").append(gradleConfigurationName).append("\"\n       |\n       |    if (project.name.equals(gradleProjectName)) {\n       |      def compileDepsCopyTaskName = taskName + \"_compileDeps\"\n       |      tasks.register(compileDepsCopyTaskName, Copy) {\n       |        def selectedConfig = project.configurations.find { it.name.equals(gradleConfigurationName) }\n       |        def componentIds = []\n       |        if (selectedConfig != null) {\n       |          componentIds = selectedConfig.incoming.resolutionResult.allDependencies.collect { it.selected.id }\n       |        }\n       |        def result = dependencies.createArtifactResolutionQuery()\n       |                                 .forComponents(componentIds)\n       |                                 .withArtifacts(JvmLibrary, SourcesArtifact)\n       |                                 .execute()\n       |        duplicatesStrategy = 'include'\n       |        into destinationDir\n       |        from result.resolvedComponents.collect { it.getArtifacts(SourcesArtifact).collect { it.file } }\n       |      }\n       |      def androidDepsCopyTaskName = taskName + \"_androidDeps\"\n       |      tasks.register(androidDepsCopyTaskName, Copy) {\n       |        duplicatesStrategy = 'include'\n       |        into destinationDir\n       |        from project.configurations.find { it.name.equals(\"androidApis\") }\n       |      }\n       |      tasks.register(taskName, Copy) {\n       |        dependsOn androidDepsCopyTaskName\n       |        dependsOn compileDepsCopyTaskName\n       |      }\n       |    }\n       |  }\n       |}\n       |").toString()));
    }

    private String gradle5OrLaterInitScript(String taskName, String destination) {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(158).append("\n     |allprojects {\n     |  apply plugin: 'java'\n     |  task ").append(taskName).append("(type: Copy) {\n     |    into \"").append(destination).append("\"\n     |    from configurations.default\n     |  }\n     |}\n     |").toString()));
    }

    private GradleDepsInitScript makeInitScript(Path destinationDir, boolean forAndroid, String gradleProjectName, String gradleConfigurationName) {
        String taskName = new StringBuilder(1).append(this.taskNamePrefix()).append("_").append(Random$.MODULE$.alphanumeric().take(8).toList().mkString()).toString();
        String content = forAndroid ? this.gradle5OrLaterAndroidInitScript(taskName, ((Object)destinationDir).toString(), gradleProjectName, gradleConfigurationName) : this.gradle5OrLaterInitScript(taskName, ((Object)destinationDir).toString());
        return new GradleDepsInitScript(content, taskName, destinationDir);
    }

    public ProjectConnection makeConnection(File projectDir) {
        return GradleConnector.newConnector().forProjectDirectory(projectDir).connect();
    }

    private Option<GradleProjectInfo> getGradleProjectInfo(Path projectDir, String projectName) {
        Option option;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.makeConnection(projectDir.toFile()));
        if (try_ instanceof Success) {
            Success success = (Success)try_;
            ProjectConnection gradleConnection = (ProjectConnection)success.value();
            option = (Option)Using$.MODULE$.resource((Object)gradleConnection, (Function1 & Serializable)connection -> {
                None$ none$;
                block9: {
                    try {
                        boolean bl;
                        BuildEnvironment buildEnv = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
                        GradleProject project = (GradleProject)connection.getModel(GradleProject.class);
                        Option<String> option = MODULE$.runGradleTask((ProjectConnection)connection, Constants$.MODULE$.gradlePropertiesTaskName());
                        if (option instanceof Some) {
                            Some some = (Some)option;
                            String out = (String)some.value();
                            bl = ArrayOps$.MODULE$.exists$extension(Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(out), '\n')), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith(Constants$.MODULE$.gradleAndroidPropertyPrefix())));
                        } else if (None$.MODULE$.equals(option)) {
                            bl = false;
                        } else {
                            throw new MatchError(option);
                        }
                        boolean hasAndroidPrefixGradleProperty = bl;
                        GradleProjectInfo info = new GradleProjectInfo(buildEnv.getGradle().getGradleVersion(), (scala.collection.immutable.Seq<String>)((IterableOnceOps)CollectionConverters$.MODULE$.SetHasAsScala((Set)project.getTasks()).asScala().map((Function1 & Serializable)x$2 -> x$2.getName())).toSeq(), hasAndroidPrefixGradleProperty);
                        if (hasAndroidPrefixGradleProperty) {
                            List validProjectNames = (List)((IterableOps)package$.MODULE$.List().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{project.getName()}))).$plus$plus((IterableOnce)CollectionConverters$.MODULE$.ListHasAsScala(project.getChildren().getAll()).asScala().map((Function1 & Serializable)x$3 -> x$3.getName()));
                            MODULE$.logger().debug(new StringBuilder(23).append("Found Gradle projects: ").append(validProjectNames.mkString(",")).toString());
                            if (!validProjectNames.contains((Object)projectName)) {
                                String validProjectNamesStr = validProjectNames.mkString(",");
                                MODULE$.logger().warn(new StringBuilder(81).append("The provided Gradle project name `").append(projectName).append("` is is not part of the valid project names: `").append(validProjectNamesStr).append("`").toString());
                                none$ = None$.MODULE$;
                            } else {
                                none$ = new Some((Object)info);
                            }
                            break block9;
                        }
                        none$ = new Some((Object)info);
                    }
                    catch (Throwable t) {
                        MODULE$.logger().warn(new StringBuilder(53).append("Caught exception while trying use Gradle connection: ").append(t.getMessage()).toString());
                        MODULE$.logger().debug("Full exception: ", t);
                        none$ = None$.MODULE$;
                    }
                }
                return none$;
            }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        } else if (try_ instanceof Failure) {
            Failure failure = (Failure)try_;
            Throwable t = failure.exception();
            this.logger().warn(new StringBuilder(64).append("Caught exception while trying fetch Gradle project information: ").append(t.getMessage()).toString());
            this.logger().debug("Full exception: ", t);
            option = None$.MODULE$;
        } else {
            throw new MatchError((Object)try_);
        }
        return option;
    }

    private Option<String> runGradleTask(ProjectConnection connection, String taskName) {
        return (Option)Using$.MODULE$.resource((Object)new ByteArrayOutputStream(), (Function1 & Serializable)out -> {
            Some some;
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ((BuildLauncher)connection.newBuild().forTasks(new String[]{taskName}).setStandardOutput((OutputStream)out)).run());
            if (try_ instanceof Success) {
                some = new Some((Object)out.toString());
            } else if (try_ instanceof Failure) {
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                MODULE$.logger().warn(new StringBuilder(54).append("Caught exception while executing Gradle task named `").append(taskName).append("`:").toString(), (Object)ex.getMessage());
                MODULE$.logger().debug("Full exception: ", ex);
                some = None$.MODULE$;
            } else {
                throw new MatchError((Object)try_);
            }
            return some;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Option<Seq<String>> runGradleTask(ProjectConnection connection, GradleDepsInitScript initScript, String initScriptPath) {
        return (Option)Using$.MODULE$.resources((Object)new ByteArrayOutputStream(), (Function0 & Serializable)() -> new ByteArrayOutputStream(), (Function2 & Serializable)(x0$1, x1$1) -> {
            Some some;
            Tuple2 tuple2 = new Tuple2(x0$1, x1$1);
            if (tuple2 == null) throw new MatchError((Object)tuple2);
            ByteArrayOutputStream stdoutStream = (ByteArrayOutputStream)tuple2._1();
            ByteArrayOutputStream stderrStream = (ByteArrayOutputStream)tuple2._2();
            MODULE$.logger().info(new StringBuilder(27).append("Executing gradle task '").append(initScript.taskName()).append("'...").toString());
            Try try_ = Try$.MODULE$.apply((Function0)(JFunction0.mcV.sp & Serializable)() -> ((BuildLauncher)connection.newBuild().forTasks(new String[]{initScript.taskName()}).withArguments(new String[]{"--init-script", initScriptPath}).setStandardOutput((OutputStream)stdoutStream).setStandardError((OutputStream)stderrStream)).run());
            if (try_ instanceof Success) {
                Buffer result = (Buffer)CollectionConverters$.MODULE$.ListHasAsScala(Files.list(initScript.destinationDir()).collect(Collectors.toList())).asScala().map((Function1 & Serializable)x$4 -> ((Object)x$4.toAbsolutePath()).toString());
                MODULE$.logger().info(new StringBuilder(29).append("Resolved `").append(result.size()).append("` dependency files.").toString());
                some = new Some((Object)result);
                return some;
            } else {
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                MODULE$.logger().warn(new StringBuilder(46).append("Caught exception while executing Gradle task: ").append(ex.getMessage()).toString());
                MODULE$.logger().debug(new StringBuilder(31).append("Gradle task execution stdout: \n").append(stdoutStream).toString());
                MODULE$.logger().debug(new StringBuilder(31).append("Gradle task execution stderr: \n").append(stderrStream).toString());
                some = None$.MODULE$;
            }
            return some;
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Option<Path> extractClassesJarFromAar(better.files.File aar) {
        None$ none$;
        better.files.File outDir;
        String newPath = ((Object)aar.path()).toString().replaceFirst(new StringBuilder(1).append(Constants$.MODULE$.aarFileExtension()).append("$").toString(), "jar");
        String aarUnzipDirSuffix = ".unzipped";
        better.files.File x$1 = outDir = File$.MODULE$.apply(new StringBuilder(0).append(((Object)aar.path()).toString()).append(aarUnzipDirSuffix).toString(), (scala.collection.immutable.Seq)Nil$.MODULE$);
        Function1 & Serializable x$2 = (Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)GradleDependencies$.$anonfun$extractClassesJarFromAar$1(x$5));
        Charset x$3 = aar.unzipTo$default$3(x$1, (Function1)x$2);
        aar.unzipTo(x$1, (Function1)x$2, x$3);
        better.files.File outFile = File$.MODULE$.apply(newPath, (scala.collection.immutable.Seq)Nil$.MODULE$);
        List classesJarEntries = outDir.listRecursively(outDir.listRecursively$default$1()).filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)GradleDependencies$.$anonfun$extractClassesJarFromAar$2(x$6))).toList();
        if (classesJarEntries.size() != 1) {
            this.logger().warn(new StringBuilder(52).append("Found aar file without `classes.jar` inside at path ").append(aar.path()).toString());
            outDir.delete(outDir.delete$default$1(), outDir.delete$default$2());
            none$ = None$.MODULE$;
        } else {
            better.files.File classesJar = (better.files.File)classesJarEntries.head();
            this.logger().trace(new StringBuilder(43).append("Copying `classes.jar` for aar at `").append(((Object)aar.path()).toString()).append("` into `").append(newPath).append("`").toString());
            better.files.File x$4 = outFile;
            boolean x$52 = classesJar.copyTo$default$2();
            scala.collection.immutable.Seq x$62 = classesJar.copyTo$default$3(x$4, x$52);
            classesJar.copyTo(x$4, x$52, x$62);
            outDir.delete(outDir.delete$default$1(), outDir.delete$default$2());
            aar.delete(aar.delete$default$1(), aar.delete$default$2());
            none$ = new Some((Object)outFile.path());
        }
        return none$;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Option<Seq<String>> get(Path projectDir, String projectName, String configurationName) {
        this.logger().info(new StringBuilder(68).append("Fetching Gradle project information at path `").append(projectDir).append("` with project name `").append(projectName).append("`.").toString());
        boolean bl = false;
        Some some = null;
        Option<GradleProjectInfo> option = this.getGradleProjectInfo(projectDir, projectName);
        if (option instanceof Some) {
            bl = true;
            some = (Some)option;
            GradleProjectInfo projectInfo = (GradleProjectInfo)some.value();
            if (projectInfo.gradleVersionMajorMinor()._1$mcI$sp() < 5) {
                this.logger().warn(new StringBuilder(29).append("Unsupported Gradle version `").append(projectInfo.gradleVersion()).append("`").toString());
                return None$.MODULE$;
            }
        }
        if (bl) {
            None$ none$;
            GradleProjectInfo projectInfo = (GradleProjectInfo)some.value();
            Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                String x$1 = MODULE$.tempDirPrefix();
                Option x$2 = File$.MODULE$.newTemporaryDirectory$default$2();
                scala.collection.immutable.Seq x$3 = File$.MODULE$.newTemporaryDirectory$default$3(x$1, x$2);
                better.files.File qual$1 = File$.MODULE$.newTemporaryDirectory(x$1, x$2, x$3);
                boolean x$4 = qual$1.deleteOnExit$default$1();
                scala.collection.immutable.Seq x$5 = qual$1.deleteOnExit$default$2();
                return qual$1.deleteOnExit(x$4, x$5);
            });
            if (try_ instanceof Success) {
                None$ none$2;
                Success success = (Success)try_;
                better.files.File destinationDir = (better.files.File)success.value();
                Try try_2 = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    String x$6 = MODULE$.initScriptPrefix();
                    String x$7 = File$.MODULE$.newTemporaryFile$default$2();
                    Option x$8 = File$.MODULE$.newTemporaryFile$default$3();
                    scala.collection.immutable.Seq x$9 = File$.MODULE$.newTemporaryFile$default$4(x$6, x$7, x$8);
                    better.files.File qual$2 = File$.MODULE$.newTemporaryFile(x$6, x$7, x$8, x$9);
                    boolean x$10 = qual$2.deleteOnExit$default$1();
                    scala.collection.immutable.Seq x$11 = qual$2.deleteOnExit$default$2();
                    return qual$2.deleteOnExit(x$10, x$11);
                });
                if (try_2 instanceof Success) {
                    Option option2;
                    Success success2 = (Success)try_2;
                    better.files.File initScriptFile = (better.files.File)success2.value();
                    GradleDepsInitScript initScript = this.makeInitScript(destinationDir.path(), projectInfo.hasAndroidSubproject(), projectName, configurationName);
                    String x$12 = initScript.contents();
                    scala.collection.immutable.Seq x$13 = initScriptFile.write$default$2(x$12);
                    Charset x$14 = initScriptFile.write$default$3(x$12);
                    initScriptFile.write(x$12, x$13, x$14);
                    this.logger().info(new StringBuilder(76).append("Downloading dependencies for configuration `").append(configurationName).append("` of project `").append(projectName).append("` at `").append(projectDir).append("` into `").append(destinationDir).append("`...").toString());
                    Try try_3 = Try$.MODULE$.apply((Function0 & Serializable)() -> MODULE$.makeConnection(projectDir.toFile()));
                    if (try_3 instanceof Success) {
                        Success success3 = (Success)try_3;
                        ProjectConnection connection = (ProjectConnection)success3.value();
                        option2 = (Option)Using$.MODULE$.resource((Object)connection, (Function1 & Serializable)c -> {
                            None$ none$;
                            Option<Seq<String>> option = MODULE$.runGradleTask((ProjectConnection)c, initScript, initScriptFile.pathAsString());
                            if (option instanceof Some) {
                                Some some = (Some)option;
                                Seq deps = (Seq)some.value();
                                none$ = new Some(deps.map((Function1 & Serializable)d -> {
                                    String string;
                                    if (!d.endsWith(Constants$.MODULE$.aarFileExtension())) {
                                        string = d;
                                    } else {
                                        String string2;
                                        Option<Path> option = MODULE$.extractClassesJarFromAar(File$.MODULE$.apply(d, (scala.collection.immutable.Seq)Nil$.MODULE$));
                                        if (option instanceof Some) {
                                            Some some = (Some)option;
                                            Path path = (Path)some.value();
                                            string2 = ((Object)path).toString();
                                        } else if (None$.MODULE$.equals(option)) {
                                            string2 = d;
                                        } else {
                                            throw new MatchError(option);
                                        }
                                        string = string2;
                                    }
                                    return string;
                                }));
                            } else if (None$.MODULE$.equals(option)) {
                                none$ = None$.MODULE$;
                            } else {
                                throw new MatchError(option);
                            }
                            return none$;
                        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                    } else {
                        if (!(try_3 instanceof Failure)) throw new MatchError((Object)try_3);
                        Failure failure = (Failure)try_3;
                        Throwable ex = failure.exception();
                        this.logger().warn(new StringBuilder(64).append("Caught exception while trying to establish a Gradle connection: ").append(ex.getMessage()).toString());
                        this.logger().debug("Full exception: ", ex);
                        option2 = None$.MODULE$;
                    }
                    none$2 = option2;
                } else {
                    if (!(try_2 instanceof Failure)) throw new MatchError((Object)try_2);
                    Failure failure = (Failure)try_2;
                    Throwable ex = failure.exception();
                    this.logger().warn(new StringBuilder(56).append("Could not create temporary file for Gradle init script: ").append(ex.getMessage()).toString());
                    this.logger().debug("Full exception: ", ex);
                    none$2 = None$.MODULE$;
                }
                none$ = none$2;
                return none$;
            } else {
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Failure failure = (Failure)try_;
                Throwable ex = failure.exception();
                this.logger().warn(new StringBuilder(66).append("Could not create temporary directory for saving dependency files: ").append(ex.getMessage()).toString());
                this.logger().debug("Full exception: ", ex);
                none$ = None$.MODULE$;
            }
            return none$;
        }
        if (!None$.MODULE$.equals(option)) throw new MatchError(option);
        this.logger().warn("Could not fetch Gradle project information");
        return None$.MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$extractClassesJarFromAar$1(ZipEntry x$5) {
        String string = x$5.getName();
        String string2 = Constants$.MODULE$.jarInsideAarFileName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$extractClassesJarFromAar$2(better.files.File x$6) {
        String string = ((Object)x$6.path().getFileName()).toString();
        String string2 = Constants$.MODULE$.jarInsideAarFileName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private GradleDependencies$() {
    }
}

