/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import better.files.File;
import better.files.File$;
import io.joern.x2cpg.utils.ExternalCommand$;
import io.joern.x2cpg.utils.dependency.DependencyResolverParams;
import io.joern.x2cpg.utils.dependency.DependencyResolverParams$;
import io.joern.x2cpg.utils.dependency.GradleConfigKeys$;
import io.joern.x2cpg.utils.dependency.GradleDependencies$;
import io.joern.x2cpg.utils.dependency.MavenCoordinates$;
import io.joern.x2cpg.utils.dependency.MavenDependencies$;
import java.io.Serializable;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.Nothing$;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

public final class DependencyResolver$
implements Serializable {
    private static final Logger logger;
    private static final int MaxSearchDepth;
    public static final DependencyResolver$ MODULE$;

    private DependencyResolver$() {
    }

    static {
        MODULE$ = new DependencyResolver$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        MaxSearchDepth = 4;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DependencyResolver$.class);
    }

    public Option<Seq<String>> getCoordinates(Path projectDir, DependencyResolverParams params) {
        List coordinates = (List)this.findSupportedBuildFiles(File$.MODULE$.apply(projectDir), this.findSupportedBuildFiles$default$2()).flatMap((Function1 & Serializable)buildFile -> {
            Nil$ nil$;
            if (MODULE$.isMavenBuildFile(File$.MODULE$.apply(buildFile))) {
                return None$.MODULE$;
            }
            if (MODULE$.isGradleBuildFile(File$.MODULE$.apply(buildFile))) {
                nil$ = MODULE$.getCoordinatesForGradleProject(buildFile.getParent(), "compileClasspath");
            } else {
                logger.warn("Found unsupported build file " + buildFile);
                nil$ = package$.MODULE$.Nil();
            }
            return (IterableOnce)nil$;
        }).flatten(Predef$.MODULE$.$conforms());
        return Option$.MODULE$.when(coordinates.nonEmpty(), () -> DependencyResolver$.getCoordinates$$anonfun$1(coordinates));
    }

    public DependencyResolverParams getCoordinates$default$2() {
        return new DependencyResolverParams(DependencyResolverParams$.MODULE$.$lessinit$greater$default$1(), DependencyResolverParams$.MODULE$.$lessinit$greater$default$2());
    }

    private Option<Seq<String>> getCoordinatesForGradleProject(Path projectDir, String configuration) {
        scala.collection.immutable.Seq seq;
        Try<scala.collection.immutable.Seq<String>> try_ = ExternalCommand$.MODULE$.run((scala.collection.immutable.Seq<String>)((scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)"gradle", (List)new .colon.colon((Object)"dependencies", (List)new .colon.colon((Object)"--configuration,", (List)new .colon.colon((Object)configuration, (List)Nil$.MODULE$)))))), projectDir.toString(), ExternalCommand$.MODULE$.run$default$3(), ExternalCommand$.MODULE$.run$default$4()).toTry();
        if (try_ instanceof Success) {
            scala.collection.immutable.Seq lines;
            seq = lines = (scala.collection.immutable.Seq)((Success)try_).value();
        } else if (try_ instanceof Failure) {
            Throwable exception = ((Failure)try_).exception();
            logger.warn("Could not retrieve dependencies for Gradle project at path `" + projectDir + "`\n" + exception.getMessage());
            seq = (scala.collection.immutable.Seq)package$.MODULE$.Seq().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Nothing$[0]));
        } else {
            throw new MatchError(try_);
        }
        scala.collection.immutable.Seq lines = seq;
        scala.collection.immutable.Seq<String> coordinates = MavenCoordinates$.MODULE$.fromGradleOutput((scala.collection.immutable.Seq<String>)lines);
        logger.info("Got {} Maven coordinates", (Object)BoxesRunTime.boxToInteger((int)coordinates.size()));
        return Some$.MODULE$.apply(coordinates);
    }

    public Option<scala.collection.immutable.Seq<String>> getDependencies(Path projectDir, DependencyResolverParams params) {
        List dependencies = (List)this.findSupportedBuildFiles(File$.MODULE$.apply(projectDir), this.findSupportedBuildFiles$default$2()).flatMap((Function1 & Serializable)buildFile -> {
            Nil$ nil$;
            if (MODULE$.isMavenBuildFile(File$.MODULE$.apply(buildFile))) {
                return MavenDependencies$.MODULE$.get(buildFile.getParent());
            }
            if (MODULE$.isGradleBuildFile(File$.MODULE$.apply(buildFile))) {
                nil$ = MODULE$.getDepsForGradleProject(params, buildFile.getParent());
            } else {
                logger.warn("Found unsupported build file " + buildFile);
                nil$ = package$.MODULE$.Nil();
            }
            return (IterableOnce)nil$;
        }).flatten(Predef$.MODULE$.$conforms());
        return Option$.MODULE$.when(dependencies.nonEmpty(), () -> DependencyResolver$.getDependencies$$anonfun$1(dependencies));
    }

    public DependencyResolverParams getDependencies$default$2() {
        return new DependencyResolverParams(DependencyResolverParams$.MODULE$.$lessinit$greater$default$1(), DependencyResolverParams$.MODULE$.$lessinit$greater$default$2());
    }

    private Option<Seq<String>> getDepsForGradleProject(DependencyResolverParams params, Path projectDir) {
        Map<String, Seq<String>> map;
        logger.info("resolving Gradle dependencies at {}", (Object)projectDir);
        Option maybeProjectNameOverride = params.forGradle().get((Object)GradleConfigKeys$.MODULE$.ProjectName());
        Option maybeConfigurationOverride = params.forGradle().get((Object)GradleConfigKeys$.MODULE$.ConfigurationName());
        Map<String, Seq<String>> dependenciesMap = map = GradleDependencies$.MODULE$.get(projectDir, (Option<String>)maybeProjectNameOverride, (Option<String>)maybeConfigurationOverride);
        if (dependenciesMap.values().exists((Function1 & Serializable)_$1 -> _$1.nonEmpty())) {
            return Option$.MODULE$.apply((Object)((IterableOnceOps)dependenciesMap.values().flatten(Predef$.MODULE$.$conforms())).toSet().toSeq());
        }
        logger.warn("Could not download Gradle dependencies for project at path `" + projectDir + "`");
        return None$.MODULE$;
    }

    private boolean isGradleBuildFile(File file) {
        String pathString = file.pathAsString();
        return pathString.endsWith(".gradle") || pathString.endsWith(".gradle.kts");
    }

    private boolean isMavenBuildFile(File file) {
        return file.pathAsString().endsWith("pom.xml");
    }

    private List<Path> findSupportedBuildFiles(File currentDir, int depth) {
        if (depth >= MaxSearchDepth) {
            logger.info("findSupportedBuildFiles reached max depth before finding build files");
            return package$.MODULE$.Nil();
        }
        Tuple2 tuple2 = currentDir.children().partition((Function1 & Serializable)_$2 -> _$2.isDirectory(_$2.isDirectory$default$1()));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator childDirectories = (Iterator)tuple2._1();
        Iterator childFiles = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)childDirectories, (Object)childFiles);
        Iterator childDirectories2 = (Iterator)tuple22._1();
        Iterator childFiles2 = (Iterator)tuple22._2();
        List childFileList = childFiles2.toList();
        Option option = childFileList.find((Function1 & Serializable)file -> MODULE$.isGradleBuildFile((File)file)).orElse(() -> DependencyResolver$.findSupportedBuildFiles$$anonfun$2(childFileList));
        if (option instanceof Some) {
            File buildFile = (File)((Some)option).value();
            return package$.MODULE$.Nil().$colon$colon((Object)buildFile.path());
        }
        if (None$.MODULE$.equals(option)) {
            if (childDirectories2.isEmpty()) {
                return package$.MODULE$.Nil();
            }
            return childDirectories2.flatMap((Function1 & Serializable)dir -> MODULE$.findSupportedBuildFiles((File)dir, depth + 1)).toList();
        }
        throw new MatchError((Object)option);
    }

    private int findSupportedBuildFiles$default$2() {
        return 0;
    }

    private static final List getCoordinates$$anonfun$1(List coordinates$1) {
        return coordinates$1;
    }

    private static final List getDependencies$$anonfun$1(List dependencies$1) {
        return dependencies$1;
    }

    private static final Option findSupportedBuildFiles$$anonfun$2(List childFileList$1) {
        return childFileList$1.find((Function1 & Serializable)file -> MODULE$.isMavenBuildFile((File)file));
    }
}

