/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.passes.frontend;

import flatgraph.DNode;
import flatgraph.DiffGraphBuilder;
import flatgraph.traversal.GenericSteps$;
import io.joern.x2cpg.passes.frontend.XConfigFileCreationPass$;
import io.shiftleft.codepropertygraph.generated.Cpg;
import io.shiftleft.codepropertygraph.generated.nodes.NewConfigFile;
import io.shiftleft.codepropertygraph.generated.nodes.NewConfigFile$;
import io.shiftleft.codepropertygraph.generated.traversals.TraversalPropertyRoot$;
import io.shiftleft.passes.ForkJoinParallelCpgPass;
import io.shiftleft.passes.ForkJoinParallelCpgPass$;
import io.shiftleft.semanticcpg.language.package$;
import io.shiftleft.semanticcpg.utils.FileUtil;
import io.shiftleft.semanticcpg.utils.FileUtil$;
import io.shiftleft.utils.IOUtils$;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.List;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

public abstract class XConfigFileCreationPass
extends ForkJoinParallelCpgPass<Path> {
    private final Cpg cpg;
    private final Option<String> rootDir;
    private final Logger logger;

    public static Option<String> $lessinit$greater$default$2() {
        return XConfigFileCreationPass$.MODULE$.$lessinit$greater$default$2();
    }

    public XConfigFileCreationPass(Cpg cpg, Option<String> rootDir) {
        this.cpg = cpg;
        this.rootDir = rootDir;
        super(cpg, ForkJoinParallelCpgPass$.MODULE$.$lessinit$greater$default$2());
        this.logger = LoggerFactory.getLogger((Class)this.getClass());
    }

    private Option<String> rootDir() {
        return this.rootDir;
    }

    public abstract List<Function1<Path, Object>> configFileFilters();

    public Path[] generateParts() {
        Option option = this.rootDir().orElse(this::generateParts$$anonfun$1);
        if (option instanceof Some) {
            String root = (String)((Some)option).value();
            Try try_ = Try$.MODULE$.apply(() -> XConfigFileCreationPass.generateParts$$anonfun$2(root));
            if (try_ instanceof Success) {
                Path path = (Path)((Success)try_).value();
                Path file2 = path;
                if (Files.isDirectory(file2, new LinkOption[0])) {
                    return (Path[])FileUtil$.MODULE$.PathExt(file2).walk().filterNot((Function1 & Serializable)_$1 -> {
                        Path path = _$1;
                        Path path2 = file2;
                        return !(path != null ? !((Object)path).equals(path2) : path2 != null);
                    }).filter((Function1 & Serializable)file -> this.isConfigFile((Path)file)).toArray(ClassTag$.MODULE$.apply(Path.class));
                }
                Path file3 = path;
                if (this.isConfigFile(file3)) {
                    return new Path[]{file3};
                }
            }
            return (Path[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Path.class));
        }
        if (None$.MODULE$.equals(option)) {
            this.logger.warn("Unable to recover project directory for configuration file pass.");
            return (Path[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(Path.class));
        }
        throw new MatchError((Object)option);
    }

    public void runOnPart(DiffGraphBuilder diffGraph, Path file) {
        Try try_ = Try$.MODULE$.apply(() -> XConfigFileCreationPass.runOnPart$$anonfun$1(file));
        if (try_ instanceof Success) {
            String content = (String)((Success)try_).value();
            String name = this.configFileName(file);
            NewConfigFile configNode = NewConfigFile$.MODULE$.apply().name(name).content(content);
            this.logger.debug("Adding config file " + name);
            diffGraph.addNode((DNode)configNode);
            return;
        }
        if (try_ instanceof Failure) {
            Throwable error = ((Failure)try_).exception();
            this.logger.warn("Unable to create config file node for " + file.toAbsolutePath() + ": " + error);
            return;
        }
        throw new MatchError((Object)try_);
    }

    private String configFileName(Path configFile) {
        return (String)Try$.MODULE$.apply(this::configFileName$$anonfun$1).map((Function1 & Serializable)_$2 -> _$2.relativize(configFile.toAbsolutePath()).toString()).getOrElse(() -> XConfigFileCreationPass.configFileName$$anonfun$3(configFile));
    }

    public boolean extensionFilter(String extension, Path file) {
        FileUtil.PathExt pathExt = FileUtil$.MODULE$.PathExt(file);
        return pathExt.extension(pathExt.extension$default$1()).contains((Object)extension);
    }

    public boolean pathEndFilter(String pathEnd, Path file) {
        return FileUtil$.MODULE$.PathExt(file).absolutePathAsString().endsWith(pathEnd);
    }

    private boolean isConfigFile(Path file) {
        return this.configFileFilters().exists((Function1 & Serializable)predicate -> BoxesRunTime.unboxToBoolean((Object)predicate.apply((Object)file)));
    }

    private final Option generateParts$$anonfun$1() {
        Iterator iterator = package$.MODULE$.accessPropertyRootTraversal((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(this.cpg).metaData());
        Iterator iterator2 = package$.MODULE$.iterableToGenericSteps((IterableOnce)TraversalPropertyRoot$.MODULE$.root$extension(iterator));
        return GenericSteps$.MODULE$.headOption$extension(iterator2);
    }

    private static final Path generateParts$$anonfun$2(String root$1) {
        return Paths.get(root$1, new String[0]);
    }

    private static final String runOnPart$$anonfun$1(Path file$2) {
        return IOUtils$.MODULE$.readEntireFile(file$2);
    }

    private final String configFileName$$anonfun$1$$anonfun$1() {
        Iterator iterator = package$.MODULE$.accessPropertyRootTraversal((IterableOnce)package$.MODULE$.toGeneratedNodeStarters(this.cpg).metaData());
        Iterator iterator2 = package$.MODULE$.iterableToGenericSteps((IterableOnce)TraversalPropertyRoot$.MODULE$.root$extension(iterator));
        return (String)GenericSteps$.MODULE$.head$extension(iterator2);
    }

    private final Path configFileName$$anonfun$1() {
        return Paths.get((String)this.rootDir().getOrElse(this::configFileName$$anonfun$1$$anonfun$1), new String[0]).toAbsolutePath();
    }

    private static final String configFileName$$anonfun$3(Path configFile$2) {
        return FileUtil$.MODULE$.PathExt(configFile$2).fileName();
    }
}

