/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import io.joern.x2cpg.utils.dependency.DependencyResolverParams;
import io.joern.x2cpg.utils.dependency.DependencyResolverParams$;
import io.joern.x2cpg.utils.dependency.GradleConfigKeys$;
import io.joern.x2cpg.utils.dependency.GradleDependencies$;
import io.joern.x2cpg.utils.dependency.MavenCoordinates$;
import io.joern.x2cpg.utils.dependency.MavenDependencies$;
import io.shiftleft.semanticcpg.utils.ExternalCommand$;
import io.shiftleft.semanticcpg.utils.FileUtil$;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.concurrent.duration.Duration;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;

public final class DependencyResolver$
implements Serializable {
    private static final Logger logger;
    private static final int MaxSearchDepth;
    public static final DependencyResolver$ MODULE$;

    private DependencyResolver$() {
    }

    static {
        MODULE$ = new DependencyResolver$();
        logger = LoggerFactory.getLogger(MODULE$.getClass());
        MaxSearchDepth = 4;
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DependencyResolver$.class);
    }

    public Option<Seq<String>> getCoordinates(Path projectDir, DependencyResolverParams params) {
        List coordinates = (List)this.findSupportedBuildFiles(projectDir, this.findSupportedBuildFiles$default$2()).flatMap((Function1 & Serializable)buildFile -> {
            Nil$ nil$;
            if (MODULE$.isMavenBuildFile((Path)buildFile)) {
                return None$.MODULE$;
            }
            if (MODULE$.isGradleBuildFile((Path)buildFile)) {
                nil$ = MODULE$.getCoordinatesForGradleProject(buildFile.getParent(), "compileClasspath");
            } else {
                logger.warn("Found unsupported build file " + buildFile);
                nil$ = package$.MODULE$.Nil();
            }
            return (IterableOnce)nil$;
        }).flatten(Predef$.MODULE$.$conforms());
        return Option$.MODULE$.when(coordinates.nonEmpty(), () -> DependencyResolver$.getCoordinates$$anonfun$1(coordinates));
    }

    public DependencyResolverParams getCoordinates$default$2() {
        return new DependencyResolverParams(DependencyResolverParams$.MODULE$.$lessinit$greater$default$1(), DependencyResolverParams$.MODULE$.$lessinit$greater$default$2());
    }

    private Option<Seq<String>> getCoordinatesForGradleProject(Path projectDir, String configuration) {
        scala.collection.immutable.Seq seq = (scala.collection.immutable.Seq)((SeqOps)new .colon.colon((Object)"gradle", (List)new .colon.colon((Object)"dependencies", (List)new .colon.colon((Object)"--configuration,", (List)new .colon.colon((Object)configuration, (List)Nil$.MODULE$)))));
        Option option = Option$.MODULE$.apply((Object)projectDir);
        boolean bl = ExternalCommand$.MODULE$.run$default$3();
        Map map = ExternalCommand$.MODULE$.run$default$4();
        boolean bl2 = ExternalCommand$.MODULE$.run$default$5();
        Duration duration = ExternalCommand$.MODULE$.run$default$6();
        scala.collection.immutable.Seq lines = (scala.collection.immutable.Seq)ExternalCommand$.MODULE$.run(seq, option, bl, map, bl2, duration, "trying to retrieve dependencies for Gradle project at path `$projectDir`").logIfFailed().successOption().getOrElse(DependencyResolver$::$anonfun$2);
        scala.collection.immutable.Seq<String> coordinates = MavenCoordinates$.MODULE$.fromGradleOutput((scala.collection.immutable.Seq<String>)lines);
        logger.info("Got {} Maven coordinates", (Object)BoxesRunTime.boxToInteger((int)coordinates.size()));
        return Some$.MODULE$.apply(coordinates);
    }

    public Option<scala.collection.immutable.Seq<String>> getDependencies(Path projectDir, DependencyResolverParams params) {
        List dependencies = (List)this.findSupportedBuildFiles(projectDir, this.findSupportedBuildFiles$default$2()).flatMap((Function1 & Serializable)buildFile -> {
            Nil$ nil$;
            if (MODULE$.isMavenBuildFile((Path)buildFile)) {
                return MavenDependencies$.MODULE$.get(buildFile.getParent());
            }
            if (MODULE$.isGradleBuildFile((Path)buildFile)) {
                nil$ = MODULE$.getDepsForGradleProject(params, buildFile.getParent());
            } else {
                logger.warn("Found unsupported build file " + buildFile);
                nil$ = package$.MODULE$.Nil();
            }
            return (IterableOnce)nil$;
        }).flatten(Predef$.MODULE$.$conforms());
        return Option$.MODULE$.when(dependencies.nonEmpty(), () -> DependencyResolver$.getDependencies$$anonfun$1(dependencies));
    }

    public DependencyResolverParams getDependencies$default$2() {
        return new DependencyResolverParams(DependencyResolverParams$.MODULE$.$lessinit$greater$default$1(), DependencyResolverParams$.MODULE$.$lessinit$greater$default$2());
    }

    private Option<Seq<String>> getDepsForGradleProject(DependencyResolverParams params, Path projectDir) {
        Map<String, Seq<String>> map;
        logger.info("resolving Gradle dependencies at {}", (Object)projectDir);
        Option maybeProjectNameOverride = params.forGradle().get((Object)GradleConfigKeys$.MODULE$.ProjectName());
        Option maybeConfigurationOverride = params.forGradle().get((Object)GradleConfigKeys$.MODULE$.ConfigurationName());
        Map<String, Seq<String>> dependenciesMap = map = GradleDependencies$.MODULE$.get(projectDir, (Option<String>)maybeProjectNameOverride, (Option<String>)maybeConfigurationOverride);
        if (dependenciesMap.values().exists((Function1 & Serializable)_$1 -> _$1.nonEmpty())) {
            return Option$.MODULE$.apply(((IterableOnceOps)dependenciesMap.values().flatten(Predef$.MODULE$.$conforms())).toList().distinctBy((Function1 & Serializable)path -> {
                Object object = Predef$.MODULE$.refArrayOps((Object[])StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(path), File.separatorChar));
                return (String)ArrayOps$.MODULE$.last$extension(object);
            }));
        }
        logger.warn("Could not download Gradle dependencies for project at path `" + projectDir + "`");
        return None$.MODULE$;
    }

    private boolean isGradleBuildFile(Path file) {
        String pathString = file.toString();
        return pathString.endsWith(".gradle") || pathString.endsWith(".gradle.kts");
    }

    private boolean isMavenBuildFile(Path file) {
        return file.toString().endsWith("pom.xml");
    }

    private List<Path> findSupportedBuildFiles(Path currentDir, int depth) {
        if (depth >= MaxSearchDepth) {
            logger.info("findSupportedBuildFiles reached max depth before finding build files");
            return package$.MODULE$.Nil();
        }
        Tuple2 tuple2 = FileUtil$.MODULE$.PathExt(currentDir).listFiles().partition((Function1 & Serializable)_$2 -> Files.isDirectory(_$2, new LinkOption[0]));
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Iterator childDirectories = (Iterator)tuple2._1();
        Iterator childFiles = (Iterator)tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)childDirectories, (Object)childFiles);
        Iterator childDirectories2 = (Iterator)tuple22._1();
        Iterator childFiles2 = (Iterator)tuple22._2();
        List childFileList = childFiles2.toList();
        Option option = childFileList.find((Function1 & Serializable)file -> MODULE$.isGradleBuildFile((Path)file)).orElse(() -> DependencyResolver$.findSupportedBuildFiles$$anonfun$2(childFileList));
        if (option instanceof Some) {
            Path buildFile = (Path)((Some)option).value();
            return package$.MODULE$.Nil().$colon$colon((Object)buildFile);
        }
        if (None$.MODULE$.equals(option)) {
            if (childDirectories2.isEmpty()) {
                return package$.MODULE$.Nil();
            }
            return childDirectories2.flatMap((Function1 & Serializable)dir -> MODULE$.findSupportedBuildFiles((Path)dir, depth + 1)).toList();
        }
        throw new MatchError((Object)option);
    }

    private int findSupportedBuildFiles$default$2() {
        return 0;
    }

    private static final List getCoordinates$$anonfun$1(List coordinates$1) {
        return coordinates$1;
    }

    private static final scala.collection.immutable.Seq $anonfun$2() {
        return (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
    }

    private static final List getDependencies$$anonfun$1(List dependencies$1) {
        return dependencies$1;
    }

    private static final Option findSupportedBuildFiles$$anonfun$2(List childFileList$1) {
        return childFileList$1.find((Function1 & Serializable)file -> MODULE$.isMavenBuildFile((Path)file));
    }
}

