/*
 * Decompiled with CFR 0.152.
 */
package io.joern.x2cpg.utils.dependency;

import io.joern.x2cpg.utils.dependency.GradleDepsInitScript;
import io.joern.x2cpg.utils.dependency.GradleDepsInitScript$;
import io.joern.x2cpg.utils.dependency.GradleVersion;
import io.joern.x2cpg.utils.dependency.GradleVersion$;
import io.shiftleft.semanticcpg.utils.FileUtil;
import io.shiftleft.semanticcpg.utils.FileUtil$;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.nio.charset.Charset;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.gradle.tooling.BuildLauncher;
import org.gradle.tooling.GradleConnector;
import org.gradle.tooling.ProjectConnection;
import org.gradle.tooling.model.build.BuildEnvironment;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.IterableOnceOps;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Map$;
import scala.io.Codec$;
import scala.io.Source$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.function.JProcedure1;
import scala.util.Failure;
import scala.util.Random$;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;
import scala.util.Using;
import scala.util.Using$;

public final class GradleDependencies$
implements Serializable {
    private static final String aarFileExtension;
    private static final String jarInsideAarFileName;
    private static final String initScriptPrefix;
    private static final String taskNamePrefix;
    private static final String tempDirPrefix;
    private static final String defaultGradleAppName;
    private static final Logger logger;
    public static final GradleDependencies$ MODULE$;

    private GradleDependencies$() {
    }

    static {
        MODULE$ = new GradleDependencies$();
        aarFileExtension = "aar";
        jarInsideAarFileName = "classes.jar";
        initScriptPrefix = "x2cpg.init.gradle";
        taskNamePrefix = "x2cpgCopyDeps";
        tempDirPrefix = "x2cpgDependencies";
        defaultGradleAppName = "app";
        logger = LoggerFactory.getLogger(MODULE$.getClass());
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(GradleDependencies$.class);
    }

    /*
     * Unable to fully structure code
     */
    private String getInitScriptContent(String taskName, String destinationDir, GradleVersion gradleVersion, Option<String> projectNameOverride, Option<String> configurationNameOverride) {
        var7_6 = gradleVersion;
        if (var7_6 == null) ** GOTO lbl-1000
        var8_7 = GradleVersion$.MODULE$.unapply(var7_6);
        var9_8 = var8_7._1();
        var10_9 = var8_7._2();
        major = var9_8;
        minor = var10_9;
        if (major >= 5 && minor >= 1) {
            v0 = "tasks.register";
        } else lbl-1000:
        // 2 sources

        {
            v0 = "tasks.create";
        }
        taskCreationFunction = v0;
        projectNameOverrideString = "[" + projectNameOverride.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$1(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((GradleDependencies$)this)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$2(), ()Ljava/lang/String;)()) + "]";
        configurationNameOverrideString = "[" + configurationNameOverride.map((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$3(java.lang.String ), (Ljava/lang/String;)Ljava/lang/String;)((GradleDependencies$)this)).getOrElse((Function0)(Function0 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, ()Ljava/lang/Object;, $anonfun$4(), ()Ljava/lang/String;)()) + "]";
        return Source$.MODULE$.fromResource("io/joern/x2cpg/utils/dependency/dependency-fetcher-init.gradle", Source$.MODULE$.fromResource$default$2(), Codec$.MODULE$.fallbackSystemCodec()).getLines().mkString(System.lineSeparator()).replaceAll("__projectNameOverrides__", projectNameOverrideString).replaceAll("__configurationNameOverrides__", configurationNameOverrideString).replaceAll("__taskNameString__", this.addSurroundingQuotes$1(taskName)).replaceAll("__destinationDirString__", this.addSurroundingQuotes$1(destinationDir)).replaceAll("__defaultProjectNameString__", this.addSurroundingQuotes$1(GradleDependencies$.defaultGradleAppName)).replaceAll("tasks.register", taskCreationFunction);
    }

    private GradleVersion getGradleVersionMajorMinor(ProjectConnection connection) {
        BuildEnvironment buildEnv = (BuildEnvironment)connection.getModel(BuildEnvironment.class);
        String gradleVersion = buildEnv.getGradle().getGradleVersion();
        String[] parts = StringOps$.MODULE$.split$extension(Predef$.MODULE$.augmentString(gradleVersion), '.');
        if (parts.length == 1 && this.isValidPart$1(parts[0])) {
            return GradleVersion$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parts[0])), 0);
        }
        if (parts.length >= 2 && this.isValidPart$1(parts[0]) && this.isValidPart$1(parts[1])) {
            return GradleVersion$.MODULE$.apply(StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parts[0])), StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(parts[1])));
        }
        return GradleVersion$.MODULE$.apply(-1, -1);
    }

    private GradleDepsInitScript makeInitScript(Path destinationDir, GradleVersion gradleVersion, Option<String> projectNameOverride, Option<String> configurationNameOverride) {
        String taskName = taskNamePrefix + "_" + Random$.MODULE$.alphanumeric().take(8).toList().mkString();
        String content = this.getInitScriptContent(taskName, destinationDir.toString(), gradleVersion, projectNameOverride, configurationNameOverride);
        return GradleDepsInitScript$.MODULE$.apply(content, taskName, destinationDir);
    }

    public ProjectConnection makeConnection(File projectDir) {
        return GradleConnector.newConnector().forProjectDirectory(projectDir).connect();
    }

    private Map<String, List<String>> dependencyMapFromOutputDir(Path outputDir) {
        Throwable throwable;
        scala.collection.mutable.Map dependencyMap = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Try try_ = Try$.MODULE$.apply(() -> GradleDependencies$.dependencyMapFromOutputDir$$anonfun$1(outputDir));
        if (try_ instanceof Success) {
            Stream fileStreamResource = (Stream)((Success)try_).value();
            Using$.MODULE$.resource((Object)fileStreamResource, (Function1)(JProcedure1 & Serializable)fileStream -> CollectionConverters$.MODULE$.ListHasAsScala(fileStream.collect(Collectors.toList())).asScala().groupBy((Function1 & Serializable)path -> path.getParent().toString()).foreach((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    String parentStr = (String)tuple2._1();
                    Buffer paths = (Buffer)tuple2._2();
                    return (Buffer)paths.collect((PartialFunction)new Serializable(dependencyMap, parentStr){
                        private final scala.collection.mutable.Map dependencyMap$3;
                        private final String parentStr$1;
                        {
                            this.dependencyMap$3 = dependencyMap$4;
                            this.parentStr$1 = parentStr$2;
                        }

                        public final boolean isDefinedAt(Path x) {
                            Path path = x;
                            Path path2 = path;
                            return !Files.isDirectory(path2, new LinkOption[0]);
                        }

                        public final Object applyOrElse(Path x, Function1 function1) {
                            Path path = x;
                            Path path2 = path;
                            if (!Files.isDirectory(path2, new LinkOption[0])) {
                                String string = path2.toAbsolutePath().toString();
                                return this.dependencyMap$3.put((Object)this.parentStr$1, (Object)((List)this.dependencyMap$3.getOrElseUpdate((Object)this.parentStr$1, GradleDependencies$::io$joern$x2cpg$utils$dependency$GradleDependencies$$anon$1$$_$applyOrElse$$anonfun$1)).$colon$colon((Object)string));
                            }
                            return function1.apply((Object)x);
                        }

                        private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                            return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{io$joern$x2cpg$utils$dependency$GradleDependencies$$anon$1$$_$applyOrElse$$anonfun$1()}, serializedLambda);
                        }
                    });
                }
                throw new MatchError((Object)tuple2);
            }), (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
        } else if (try_ instanceof Failure && (throwable = ((Failure)try_).exception()) != null) {
            Throwable e = throwable;
            logger.warn("Encountered exception while walking dependency fetcher output: " + e.getMessage());
        } else {
            throw new MatchError((Object)try_);
        }
        return dependencyMap.toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private Map<String, List<String>> runGradleTask(ProjectConnection connection, String taskName, Path destinationDir, String initScriptPath) {
        return (Map)Using$.MODULE$.resources((Object)new ByteArrayOutputStream(), GradleDependencies$::runGradleTask$$anonfun$1, (Function2 & Serializable)(x$1, x$2) -> {
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
            if (tuple2 != null) {
                ByteArrayOutputStream stdoutStream = (ByteArrayOutputStream)tuple2._1();
                ByteArrayOutputStream stderrStream = (ByteArrayOutputStream)tuple2._2();
                Option option = Option$.MODULE$.apply((Object)System.getenv("ANDROID_HOME"));
                if (option instanceof Some) {
                    String androidHome = (String)((Some)option).value();
                    logger.debug("Found ANDROID_HOME set to " + androidHome);
                } else if (None$.MODULE$.equals(option)) {
                    logger.debug("ANDROID_HOME not set");
                } else {
                    throw new MatchError((Object)option);
                }
                logger.debug("Executing gradle task '" + taskName + "'...");
                Try try_ = Try$.MODULE$.apply((Function0 & Serializable)() -> {
                    GradleDependencies$.runGradleTask$$anonfun$2$$anonfun$1(connection, taskName, initScriptPath, stdoutStream, stderrStream);
                    return BoxedUnit.UNIT;
                });
                if (try_ instanceof Success) {
                    Map<String, List<String>> result = MODULE$.dependencyMapFromOutputDir(destinationDir);
                    int dependencyCount = ((IterableOnceOps)result.values().flatten(Predef$.MODULE$.$conforms())).size();
                    logger.info("Task " + taskName + " resolved `" + dependencyCount + "` dependency files.");
                    return result;
                }
                if (try_ instanceof Failure) {
                    Throwable ex = ((Failure)try_).exception();
                    logger.warn("Caught exception while executing Gradle task: " + ex.getMessage());
                    String androidSdkError = "Define a valid SDK location with an ANDROID_HOME environment variable";
                    if (stderrStream.toString().contains(androidSdkError)) {
                        logger.warn("A missing Android SDK configuration caused gradle dependency fetching failures. Please define a valid SDK location with an ANDROID_HOME environment variable or by setting the sdk.dir path in your project's local properties file");
                    }
                    if (stderrStream.toString().contains("Could not compile initialization script")) {
                        String scriptContents = new String(Files.readAllBytes(Paths.get(initScriptPath, new String[0])), Charset.defaultCharset());
                        logger.debug("########## INITIALIZATION_SCRIPT ##########\n" + scriptContents + "\n###########################################");
                    }
                    logger.debug("Gradle task execution stdout: \n" + stdoutStream);
                    logger.debug("Gradle task execution stderr: \n" + stderrStream);
                    return Predef$.MODULE$.Map().empty();
                }
                throw new MatchError((Object)try_);
            }
            throw new MatchError((Object)tuple2);
        }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
    }

    private Option<Path> extractClassesJarFromAar(Path aar) {
        String newPath = aar.toString().replaceFirst(aarFileExtension + "$", "jar");
        String aarUnzipDirSuffix = ".unzipped";
        Path outDir = Paths.get(aar.toString() + aarUnzipDirSuffix, new String[0]);
        FileUtil.PathExt pathExt = FileUtil$.MODULE$.PathExt(aar);
        pathExt.unzipTo(outDir, pathExt.unzipTo$default$2(), pathExt.unzipTo$default$3());
        Path outFile = Paths.get(newPath, new String[0]);
        List classesJarEntries = CollectionConverters$.MODULE$.IteratorHasAsScala(Files.walk(outDir, new FileVisitOption[0]).iterator()).asScala().filterNot((Function1 & Serializable)_$1 -> {
            Path path = _$1;
            Path path2 = outDir;
            return !(path != null ? !((Object)path).equals(path2) : path2 != null);
        }).filter((Function1 & Serializable)_$2 -> {
            String string = FileUtil$.MODULE$.PathExt(_$2).fileName();
            String string2 = jarInsideAarFileName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).toList();
        if (classesJarEntries.size() != 1) {
            logger.debug("Found aar file without `classes.jar` inside at path " + aar);
            FileUtil$.MODULE$.delete(outDir, FileUtil$.MODULE$.delete$default$2(), FileUtil$.MODULE$.delete$default$3());
            return None$.MODULE$;
        }
        Path classesJar = (Path)classesJarEntries.head();
        logger.trace("Copying `classes.jar` for aar at `" + aar.toString() + "` into `" + newPath + "`");
        FileUtil.PathExt pathExt2 = FileUtil$.MODULE$.PathExt(classesJar);
        pathExt2.copyTo(outFile, pathExt2.copyTo$default$2());
        FileUtil$.MODULE$.delete(outDir, FileUtil$.MODULE$.delete$default$2(), FileUtil$.MODULE$.delete$default$3());
        FileUtil$.MODULE$.delete(aar, FileUtil$.MODULE$.delete$default$2(), FileUtil$.MODULE$.delete$default$3());
        return Some$.MODULE$.apply((Object)outFile);
    }

    public Map<String, Seq<String>> get(Path projectDir, Option<String> projectNameOverride, Option<String> configurationNameOverride) {
        logger.info("Fetching Gradle project information at path `" + projectDir + "`.");
        Try try_ = Try$.MODULE$.apply(GradleDependencies$::get$$anonfun$1);
        if (try_ instanceof Success) {
            Path destinationDir = (Path)((Success)try_).value();
            FileUtil$.MODULE$.deleteOnExit(destinationDir, FileUtil$.MODULE$.deleteOnExit$default$2(), FileUtil$.MODULE$.deleteOnExit$default$3());
            Try try_2 = Try$.MODULE$.apply(GradleDependencies$::get$$anonfun$2);
            if (try_2 instanceof Success) {
                Path initScriptFile = (Path)((Success)try_2).value();
                FileUtil$.MODULE$.deleteOnExit(initScriptFile, FileUtil$.MODULE$.deleteOnExit$default$2(), FileUtil$.MODULE$.deleteOnExit$default$3());
                Try try_3 = Try$.MODULE$.apply(() -> GradleDependencies$.get$$anonfun$3(projectDir));
                if (try_3 instanceof Success) {
                    ProjectConnection connection = (ProjectConnection)((Success)try_3).value();
                    return (Map)Using$.MODULE$.resource((Object)connection, (Function1 & Serializable)c -> {
                        GradleVersion gradleVersion = MODULE$.getGradleVersionMajorMinor(connection);
                        GradleDepsInitScript initScript = MODULE$.makeInitScript(destinationDir, gradleVersion, projectNameOverride, configurationNameOverride);
                        Files.writeString(initScriptFile, (CharSequence)initScript.contents(), new OpenOption[0]);
                        return (Map)MODULE$.runGradleTask((ProjectConnection)c, initScript.taskName(), initScript.destinationDir(), initScriptFile.toString()).map((Function1 & Serializable)x$1 -> {
                            Tuple2 tuple2 = x$1;
                            if (tuple2 != null) {
                                String projectName = (String)tuple2._1();
                                List dependencies = (List)tuple2._2();
                                String string = (String)Predef$.MODULE$.ArrowAssoc((Object)projectName);
                                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)string, (Object)dependencies.map((Function1 & Serializable)dependency -> {
                                    if (!dependency.endsWith(aarFileExtension)) {
                                        return dependency;
                                    }
                                    Option<Path> option = MODULE$.extractClassesJarFromAar(Paths.get(dependency, new String[0]));
                                    if (option instanceof Some) {
                                        Path path = (Path)((Some)option).value();
                                        return path.toString();
                                    }
                                    if (None$.MODULE$.equals(option)) {
                                        return dependency;
                                    }
                                    throw new MatchError(option);
                                }));
                            }
                            throw new MatchError((Object)tuple2);
                        });
                    }, (Using.Releasable)Using.Releasable$.AutoCloseableIsReleasable$.MODULE$);
                }
                if (try_3 instanceof Failure) {
                    Throwable ex = ((Failure)try_3).exception();
                    logger.warn("Caught exception while trying to establish a Gradle connection: " + ex.getMessage());
                    logger.debug("Full exception: ", ex);
                    return Predef$.MODULE$.Map().empty();
                }
                throw new MatchError((Object)try_3);
            }
            if (try_2 instanceof Failure) {
                Throwable ex = ((Failure)try_2).exception();
                logger.warn("Could not create temporary file for Gradle init script: " + ex.getMessage());
                logger.debug("Full exception: ", ex);
                return Predef$.MODULE$.Map().empty();
            }
            throw new MatchError((Object)try_2);
        }
        if (try_ instanceof Failure) {
            Throwable ex = ((Failure)try_).exception();
            logger.warn("Could not create temporary directory for saving dependency files: " + ex.getMessage());
            logger.debug("Full exception: ", ex);
            return Predef$.MODULE$.Map().empty();
        }
        throw new MatchError((Object)try_);
    }

    private final String addSurroundingQuotes$1(String input) {
        return "\"" + input + "\"";
    }

    private final /* synthetic */ String $anonfun$1(String input) {
        return this.addSurroundingQuotes$1(input);
    }

    private static final String $anonfun$2() {
        return "";
    }

    private final /* synthetic */ String $anonfun$3(String input) {
        return this.addSurroundingQuotes$1(input);
    }

    private static final String $anonfun$4() {
        return "";
    }

    private static final /* synthetic */ boolean isValidPart$1$$anonfun$1(char x$0) {
        return Character.isDigit(x$0);
    }

    private final boolean isValidPart$1(String part) {
        return StringOps$.MODULE$.forall$extension(Predef$.MODULE$.augmentString(part), (Function1 & Serializable)x$0 -> GradleDependencies$.isValidPart$1$$anonfun$1(BoxesRunTime.unboxToChar((Object)x$0)));
    }

    private static final Stream dependencyMapFromOutputDir$$anonfun$1(Path outputDir$1) {
        return Files.walk(outputDir$1, new FileVisitOption[0]);
    }

    public static final List io$joern$x2cpg$utils$dependency$GradleDependencies$$anon$1$$_$applyOrElse$$anonfun$1() {
        return package$.MODULE$.Nil();
    }

    private static final ByteArrayOutputStream runGradleTask$$anonfun$1() {
        return new ByteArrayOutputStream();
    }

    private static final void runGradleTask$$anonfun$2$$anonfun$1(ProjectConnection connection$2, String taskName$2, String initScriptPath$2, ByteArrayOutputStream stdoutStream$1, ByteArrayOutputStream stderrStream$1) {
        ((BuildLauncher)connection$2.newBuild().forTasks(new String[]{taskName$2}).withArguments(new String[]{"--init-script", initScriptPath$2}).setStandardOutput((OutputStream)stdoutStream$1).setStandardError((OutputStream)stderrStream$1).setEnvironmentVariables(System.getenv())).run();
    }

    private static final Path get$$anonfun$1() {
        return Files.createTempDirectory(tempDirPrefix, new FileAttribute[0]);
    }

    private static final Path get$$anonfun$2() {
        return Files.createTempFile(initScriptPrefix, "", new FileAttribute[0]);
    }

    private static final ProjectConnection get$$anonfun$3(Path projectDir$1) {
        return MODULE$.makeConnection(projectDir$1.toFile());
    }
}

