/*
 * Decompiled with CFR 0.152.
 */
package io.joj.fluence.guava;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;

public class GuavaCollectors {
    public static <T> Collector<T, ?, ImmutableList<T>> toImmutableList() {
        return GuavaCollectors.toImmutableListImpl();
    }

    @VisibleForTesting
    static <T> Collector<T, ImmutableList.Builder<T>, ImmutableList<T>> toImmutableListImpl() {
        return Collector.of(ImmutableList::builder, ImmutableList.Builder::add, (builder1, builder2) -> builder1.addAll((Iterable)builder2.build()), ImmutableList.Builder::build, new Collector.Characteristics[0]);
    }

    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return GuavaCollectors.toImmutableMapImpl(keyMapper, valueMapper);
    }

    @VisibleForTesting
    static <T, K, V> Collector<T, ImmutableMap.Builder<K, V>, ImmutableMap<K, V>> toImmutableMapImpl(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends V> valueMapper) {
        return Collector.of(ImmutableMap::builder, (builder, element) -> builder.put(keyMapper.apply(element), valueMapper.apply(element)), (builder1, builder2) -> builder1.putAll((Map)builder2.build()), ImmutableMap.Builder::build, Collector.Characteristics.UNORDERED);
    }
}

