/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.apt;

import io.jooby.MvcFactory;
import io.jooby.SneakyThrows;
import io.jooby.apt.Annotations;
import io.jooby.internal.apt.HandlerCompiler;
import io.jooby.internal.apt.ModuleCompiler;
import io.jooby.internal.apt.Opts;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedOptions;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedOptions(value={"jooby.debug", "jooby.incremental", "jooby.services", "jooby.skipAttributeAnnotations", "jooby.extendedLookupOfSuperTypes"})
public class JoobyProcessor
extends AbstractProcessor {
    private ProcessingEnvironment processingEnv;
    private Map<TypeElement, Map<TypeElement, List<ExecutableElement>>> routeMap = new LinkedHashMap<TypeElement, Map<TypeElement, List<ExecutableElement>>>();
    private boolean debug;
    private boolean incremental;
    private boolean services;
    private boolean extendedLooupOfSuperTypes;
    private int round;

    @Override
    public Set<String> getSupportedOptions() {
        HashSet<String> options = new HashSet<String>(super.getSupportedOptions());
        if (this.incremental) {
            options.add(String.format("org.gradle.annotation.processing.%s", this.services ? "aggregating" : "isolating"));
        }
        return options;
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Stream.concat(Annotations.PATH.stream(), Annotations.HTTP_METHODS.stream()).collect(Collectors.toCollection(LinkedHashSet::new));
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnvironment) {
        this.processingEnv = processingEnvironment;
        this.debug = Opts.boolOpt(this.processingEnv, "jooby.debug", false);
        this.incremental = Opts.boolOpt(this.processingEnv, "jooby.incremental", true);
        this.services = Opts.boolOpt(this.processingEnv, "jooby.services", true);
        this.extendedLooupOfSuperTypes = Opts.boolOpt(this.processingEnv, "jooby.extendedLookupOfSuperTypes", false);
        this.debug("Incremental annotation processing is turned %s.", this.incremental ? "ON" : "OFF");
        this.debug("Generation of service provider configuration is turned %s.", this.services ? "ON" : "OFF");
        this.debug("Extended lookup of superTypes %s.", this.extendedLooupOfSuperTypes ? "ON" : "OFF");
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            this.debug("Round #%s", this.round++);
            if (roundEnv.processingOver()) {
                this.build(this.processingEnv.getFiler());
                return false;
            }
            for (TypeElement typeElement : annotations) {
                Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(typeElement);
                elements.stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).filter(type -> !type.getModifiers().contains((Object)Modifier.ABSTRACT)).forEach(e -> this.routeMap.computeIfAbsent((TypeElement)e, k -> new LinkedHashMap()));
                if (Annotations.HTTP_METHODS.contains(typeElement.asType().toString())) {
                    Set methods = elements.stream().filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
                    for (ExecutableElement method : methods) {
                        Map mapping = this.routeMap.computeIfAbsent((TypeElement)method.getEnclosingElement(), k -> new LinkedHashMap());
                        mapping.computeIfAbsent(typeElement, k -> new ArrayList()).add(method);
                    }
                    continue;
                }
                if (!this.extendedLooupOfSuperTypes) continue;
                elements.stream().filter(TypeElement.class::isInstance).map(TypeElement.class::cast).forEach(parentTypeElement -> this.extendedLookupOfSuperTypes((TypeElement)parentTypeElement));
            }
            return true;
        }
        catch (Exception x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private void extendedLookupOfSuperTypes(TypeElement parentTypeElement) {
        for (TypeElement superType : this.superTypes(parentTypeElement)) {
            Set methods = superType.getEnclosedElements().stream().filter(ExecutableElement.class::isInstance).map(ExecutableElement.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
            for (ExecutableElement method : methods) {
                LinkedHashSet annotationTypes = method.getAnnotationMirrors().stream().map(AnnotationMirror::getAnnotationType).map(DeclaredType::asElement).filter(TypeElement.class::isInstance).map(TypeElement.class::cast).collect(Collectors.toCollection(LinkedHashSet::new));
                for (TypeElement annotationType : annotationTypes) {
                    if (!Annotations.HTTP_METHODS.contains(annotationType.toString())) continue;
                    Map mapping = this.routeMap.computeIfAbsent(parentTypeElement, k -> new LinkedHashMap());
                    List list = mapping.computeIfAbsent(annotationType, k -> new ArrayList());
                    if (!list.stream().map(this::signature).noneMatch(this.signature(method)::equals)) continue;
                    list.add(method);
                }
            }
        }
    }

    private void build(Filer filer) throws Exception {
        Types typeUtils = this.processingEnv.getTypeUtils();
        LinkedHashMap<TypeElement, List> classes = new LinkedHashMap<TypeElement, List>();
        for (Map.Entry<TypeElement, Map<TypeElement, List<ExecutableElement>>> e : this.routeMap.entrySet()) {
            TypeElement type = e.getKey();
            boolean isAbstract = type.getModifiers().contains((Object)Modifier.ABSTRACT);
            if (isAbstract) continue;
            Map<TypeElement, List<ExecutableElement>> mappings = e.getValue();
            for (TypeElement typeElement : this.superTypes(type)) {
                Map baseMappings = this.routeMap.getOrDefault(typeElement, Collections.emptyMap());
                for (Map.Entry be : baseMappings.entrySet()) {
                    List<ExecutableElement> methods = mappings.get(be.getKey());
                    if (methods == null) {
                        mappings.put((TypeElement)be.getKey(), (List<ExecutableElement>)be.getValue());
                        continue;
                    }
                    for (ExecutableElement it : (List)be.getValue()) {
                        String signature = this.signature(it);
                        if (!methods.stream().map(this::signature).noneMatch(signature::equals)) continue;
                        methods.add(it);
                    }
                }
            }
            for (Map.Entry entry : mappings.entrySet()) {
                TypeElement httpMethod = (TypeElement)entry.getKey();
                List methods = (List)entry.getValue();
                for (ExecutableElement method : methods) {
                    this.debug("Found method %s.%s", type, method);
                    List<String> paths = this.path(type, httpMethod, method);
                    for (String path : paths) {
                        this.debug("  route %s %s", httpMethod.getSimpleName(), path);
                        HandlerCompiler compiler = new HandlerCompiler(this.processingEnv, type, method, httpMethod, path);
                        classes.computeIfAbsent(type, k -> new ArrayList()).add(compiler);
                    }
                }
            }
        }
        LinkedHashMap<TypeElement, String> modules = new LinkedHashMap<TypeElement, String>();
        for (Map.Entry entry : classes.entrySet()) {
            TypeElement type = (TypeElement)entry.getKey();
            String typeName = typeUtils.erasure(type.asType()).toString();
            List handlers = (List)entry.getValue();
            ModuleCompiler moduleCompiler = new ModuleCompiler(this.processingEnv, typeName);
            String moduleClass = moduleCompiler.getModuleClass();
            byte[] moduleBin = moduleCompiler.compile(handlers);
            this.onClass(moduleClass, moduleBin);
            this.writeClass(filer.createClassFile(moduleClass, type), moduleBin);
            modules.put(type, moduleClass);
        }
        if (this.services) {
            this.doServices(filer, modules);
        }
    }

    private String signature(ExecutableElement method) {
        return method.toString();
    }

    private List<TypeElement> superTypes(Element owner) {
        Types typeUtils = this.processingEnv.getTypeUtils();
        List<? extends TypeMirror> supertypes = typeUtils.directSupertypes(owner.asType());
        if (supertypes == null || supertypes.isEmpty()) {
            return Collections.emptyList();
        }
        TypeMirror supertype = supertypes.get(0);
        String supertypeName = typeUtils.erasure(supertype).toString();
        Element supertypeElement = typeUtils.asElement(supertype);
        if (!Object.class.getName().equals(supertypeName) && supertypeElement.getKind() == ElementKind.CLASS) {
            ArrayList<TypeElement> result = new ArrayList<TypeElement>();
            result.addAll(this.superTypes(supertypeElement));
            result.add((TypeElement)supertypeElement);
            return result;
        }
        return Collections.emptyList();
    }

    private void debug(String format, Object ... args) {
        if (this.debug) {
            System.out.printf(format + "\n", args);
        }
    }

    private void doServices(Filer filer, Map<TypeElement, String> modules) throws IOException {
        String location = "META-INF/services/" + MvcFactory.class.getName();
        Element[] originatingElements = modules.keySet().toArray(new Element[0]);
        this.debug("%s", location);
        FileObject resource = filer.createResource(StandardLocation.CLASS_OUTPUT, "", location, originatingElements);
        StringBuilder content = new StringBuilder();
        for (Map.Entry<TypeElement, String> e : modules.entrySet()) {
            String classname = e.getValue();
            this.debug("  %s", classname);
            content.append(classname).append(System.getProperty("line.separator"));
        }
        this.onResource(location, content.toString());
        try (PrintWriter writer = new PrintWriter(resource.openOutputStream());){
            writer.println(content);
        }
    }

    protected void onClass(String className, byte[] bytecode) {
    }

    protected void onResource(String location, String content) {
    }

    private void writeClass(JavaFileObject javaFileObject, byte[] bytecode) throws IOException {
        try (OutputStream output = javaFileObject.openOutputStream();){
            output.write(bytecode);
        }
    }

    private List<String> path(Element owner, TypeElement annotation, ExecutableElement exec) {
        List<String> path;
        List<String> prefix = this.path(owner);
        if (prefix.isEmpty()) {
            List<TypeElement> superTypes = this.superTypes(owner);
            int i = superTypes.size() - 1;
            while (prefix.isEmpty() && i >= 0) {
                prefix = this.path(superTypes.get(i--));
            }
        }
        if ((path = this.path(annotation.getQualifiedName().toString(), annotation.getAnnotationMirrors())).isEmpty()) {
            path = this.path(annotation.getQualifiedName().toString(), exec.getAnnotationMirrors());
        }
        List<String> methodPath = path;
        if (prefix.isEmpty()) {
            return path.isEmpty() ? Collections.singletonList("/") : path;
        }
        if (path.isEmpty()) {
            return prefix.isEmpty() ? Collections.singletonList("/") : prefix;
        }
        return prefix.stream().flatMap(root -> methodPath.stream().map(p -> root.equals("/") ? p : root + p)).distinct().collect(Collectors.toList());
    }

    private List<String> path(Element element) {
        return this.path(null, element.getAnnotationMirrors());
    }

    private List<String> path(String method, List<? extends AnnotationMirror> annotations) {
        return annotations.stream().map(AnnotationMirror.class::cast).flatMap(mirror -> {
            String type = mirror.getAnnotationType().toString();
            if (Annotations.PATH.contains(type) || type.equals(method)) {
                return Stream.concat(Annotations.attribute(mirror, "path").stream(), Annotations.attribute(mirror, "value").stream());
            }
            return Stream.empty();
        }).distinct().collect(Collectors.toList());
    }
}

