/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

public interface Annotations {
    public static final String CONNECT = "io.jooby.annotation.CONNECT";
    public static final String Consumes = "io.jooby.annotation.Consumes";
    public static final String ContextParam = "io.jooby.annotation.ContextParam";
    public static final String DELETE = "io.jooby.annotation.DELETE";
    public static final String FlashParam = "io.jooby.annotation.FlashParam";
    public static final String FormParam = "io.jooby.annotation.FormParam";
    public static final String CookieParam = "io.jooby.annotation.CookieParam";
    public static final String GET = "io.jooby.annotation.GET";
    public static final String HEAD = "io.jooby.annotation.HEAD";
    public static final String HeaderParam = "io.jooby.annotation.HeaderParam";
    public static final String OPTIONS = "io.jooby.annotation.OPTIONS";
    public static final String PATCH = "io.jooby.annotation.PATCH";
    public static final String POST = "io.jooby.annotation.POST";
    public static final String PUT = "io.jooby.annotation.PUT";
    public static final String Param = "io.jooby.annotation.Param";
    public static final String Path = "io.jooby.annotation.Path";
    public static final String PathParam = "io.jooby.annotation.PathParam";
    public static final String Produces = "io.jooby.annotation.Produces";
    public static final String QueryParam = "io.jooby.annotation.QueryParam";
    public static final String SessionParam = "io.jooby.annotation.SessionParam";
    public static final String TRACE = "io.jooby.annotation.TRACE";
    public static final String JAXRS_GET = "jakarta.ws.rs.GET";
    public static final String JAXRS_POST = "jakarta.ws.rs.POST";
    public static final String JAXRS_PUT = "jakarta.ws.rs.PUT";
    public static final String JAXRS_DELETE = "jakarta.ws.rs.DELETE";
    public static final String JAXRS_PATCH = "jakarta.ws.rs.PATCH";
    public static final String JAXRS_HEAD = "jakarta.ws.rs.HEAD";
    public static final String JAXRS_OPTIONS = "jakarta.ws.rs.OPTIONS";
    public static final String JAXRS_CONTEXT = "jakarta.ws.rs.core.Context";
    public static final String JAXRS_QUERY = "jakarta.ws.rs.QueryParam";
    public static final String JAXRS_PATH_PARAM = "jakarta.ws.rs.PathParam";
    public static final String JAXRS_COOKIE = "jakarta.ws.rs.CookieParam";
    public static final String JAXRS_HEADER = "jakarta.ws.rs.HeaderParam";
    public static final String JAXRS_FORM = "jakarta.ws.rs.FormParam";
    public static final String JAXRS_PRODUCES = "jakarta.ws.rs.Produces";
    public static final String JAXRS_CONSUMES = "jakarta.ws.rs.Consumes";
    public static final String JAXRS_PATH = "jakarta.ws.rs.Path";
    public static final Set<String> HTTP_METHODS = Stream.of("io.jooby.annotation.GET", "jakarta.ws.rs.GET", "io.jooby.annotation.POST", "jakarta.ws.rs.POST", "io.jooby.annotation.PUT", "jakarta.ws.rs.PUT", "io.jooby.annotation.DELETE", "jakarta.ws.rs.DELETE", "io.jooby.annotation.PATCH", "jakarta.ws.rs.PATCH", "io.jooby.annotation.HEAD", "jakarta.ws.rs.HEAD", "io.jooby.annotation.OPTIONS", "jakarta.ws.rs.OPTIONS", "io.jooby.annotation.CONNECT", "io.jooby.annotation.TRACE").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> PATH_PARAMS = Stream.of("io.jooby.annotation.PathParam", "jakarta.ws.rs.PathParam").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> CONTEXT_PARAMS = Stream.of("io.jooby.annotation.ContextParam", "jakarta.ws.rs.core.Context").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> QUERY_PARAMS = Stream.of("io.jooby.annotation.QueryParam", "jakarta.ws.rs.QueryParam").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> SESSION_PARAMS = Collections.singleton("io.jooby.annotation.SessionParam");
    public static final Set<String> COOKIE_PARAMS = Stream.of("io.jooby.annotation.CookieParam", "jakarta.ws.rs.CookieParam").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> HEADER_PARAMS = Stream.of("io.jooby.annotation.HeaderParam", "jakarta.ws.rs.HeaderParam").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> FLASH_PARAMS = Stream.of("io.jooby.annotation.FlashParam").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> FORM_PARAMS = Stream.of("io.jooby.annotation.FormParam", "jakarta.ws.rs.FormParam").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> PARAM_LOOKUP = Stream.of("io.jooby.annotation.Param").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> PRODUCES_PARAMS = Stream.of("io.jooby.annotation.Produces", "jakarta.ws.rs.Produces").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> CONSUMES_PARAMS = Stream.of("io.jooby.annotation.Consumes", "jakarta.ws.rs.Consumes").collect(Collectors.toUnmodifiableSet());
    public static final Set<String> PATH = Stream.of("io.jooby.annotation.Path", "jakarta.ws.rs.Path").collect(Collectors.toUnmodifiableSet());

    public static List<String> attribute(AnnotationMirror mirror, String name) {
        return Annotations.attribute(mirror, name, v -> v.getValue().toString());
    }

    public static <T> List<T> attribute(AnnotationMirror mirror, String name, Function<AnnotationValue, T> mapper) {
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : mirror.getElementValues().entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(name)) continue;
            Object value = entry.getValue().getValue();
            if (value instanceof List) {
                List values = (List)value;
                return values.stream().map(mapper).filter(Objects::nonNull).collect(Collectors.toList());
            }
            T singleValue = mapper.apply(entry.getValue());
            return singleValue == null ? Collections.emptyList() : Collections.singletonList(singleValue);
        }
        return Collections.emptyList();
    }
}

