/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt;

import io.jooby.internal.apt.Annotations;
import io.jooby.internal.apt.JoobyTypes;
import io.jooby.internal.apt.MethodDescriptor;
import io.jooby.internal.apt.ParamDefinition;
import io.jooby.internal.apt.Primitives;
import io.jooby.internal.apt.TypeDefinition;
import io.jooby.internal.apt.asm.ClassWriter;
import io.jooby.internal.apt.asm.Handle;
import io.jooby.internal.apt.asm.Label;
import io.jooby.internal.apt.asm.MethodVisitor;
import io.jooby.internal.apt.asm.NameGenerator;
import io.jooby.internal.apt.asm.ParamWriter;
import io.jooby.internal.apt.asm.Type;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Types;

public class HandlerCompiler {
    private static final Type OBJ = Type.getType(Object.class);
    private static final String PROVIDER_DESCRIPTOR = Type.getMethodDescriptor(OBJ, new Type[0]);
    private TypeDefinition owner;
    private ExecutableElement executable;
    private ProcessingEnvironment environment;
    private String httpMethod;
    private String pattern;
    private Types typeUtils;
    private TypeMirror annotation;

    public HandlerCompiler(ProcessingEnvironment environment, TypeElement owner, ExecutableElement executable, TypeElement httpMethod, String pattern) {
        this.httpMethod = httpMethod.getSimpleName().toString().toLowerCase();
        this.annotation = httpMethod.asType();
        this.pattern = HandlerCompiler.leadingSlash(pattern);
        this.environment = environment;
        this.executable = executable;
        this.typeUtils = environment.getTypeUtils();
        this.owner = new TypeDefinition(this.typeUtils, owner.asType());
    }

    public ExecutableElement getExecutable() {
        return this.executable;
    }

    public String getPattern() {
        return this.pattern;
    }

    public String getHttpMethod() {
        return this.httpMethod;
    }

    public TypeDefinition getReturnType() {
        return new TypeDefinition(this.typeUtils, this.executable.getReturnType());
    }

    public List<String> getConsumes() {
        return this.mediaType(this.executable, this.annotation, "consumes", Annotations.CONSUMES_PARAMS);
    }

    public List<String> getProduces() {
        return this.mediaType(this.executable, this.annotation, "produces", Annotations.PRODUCES_PARAMS);
    }

    public void compile(String internalName, ClassWriter writer, MethodVisitor methodVisitor, NameGenerator nameRegistry) throws Exception {
        String key = this.httpMethod + this.camelCase(this.executable.getSimpleName().toString()) + this.arguments(this.executable);
        String methodName = nameRegistry.generate(key);
        methodVisitor.visitInvokeDynamicInsn("apply", "(Ljakarta/inject/Provider;)Lio/jooby/Route$Handler;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), Type.getType("(Lio/jooby/Context;)Ljava/lang/Object;"), new Handle(6, internalName, methodName, "(Ljakarta/inject/Provider;Lio/jooby/Context;)Ljava/lang/Object;", false), Type.getType("(Lio/jooby/Context;)Ljava/lang/Object;"));
        this.apply(writer, internalName, methodName, nameRegistry);
    }

    private String camelCase(String name) {
        if (name.length() > 1) {
            return Character.toUpperCase(name.charAt(0)) + name.substring(1);
        }
        return name.toUpperCase();
    }

    private String arguments(ExecutableElement executable) {
        StringBuilder buff = new StringBuilder();
        for (VariableElement variableElement : executable.getParameters()) {
            buff.append("$").append(variableElement.getSimpleName());
        }
        return buff.toString();
    }

    private void apply(ClassWriter writer, String moduleInternalName, String lambdaName, NameGenerator registry) throws Exception {
        Type owner = this.getController().toJvmType();
        String methodName = this.executable.getSimpleName().toString();
        String methodDescriptor = this.methodDescriptor();
        MethodVisitor apply = writer.visitMethod(4106, lambdaName, "(Ljakarta/inject/Provider;Lio/jooby/Context;)Ljava/lang/Object;", null, new String[]{"java/lang/Exception"});
        apply.visitParameter("provider", 4112);
        apply.visitParameter("ctx", 4096);
        apply.visitCode();
        Label sourceStart = new Label();
        apply.visitLabel(sourceStart);
        apply.visitVarInsn(25, 0);
        apply.visitMethodInsn(185, JoobyTypes.Provider.getInternalName(), "get", PROVIDER_DESCRIPTOR, true);
        apply.visitTypeInsn(192, owner.getInternalName());
        apply.visitVarInsn(58, 2);
        apply.visitVarInsn(25, 2);
        this.processArguments(writer, apply, owner, moduleInternalName, registry);
        this.setDefaultResponseType(apply);
        apply.visitMethodInsn(182, owner.getInternalName(), methodName, methodDescriptor, false);
        this.processReturnType(apply);
        apply.visitEnd();
    }

    public boolean isSuspendFunction() {
        List<? extends VariableElement> parameters = this.executable.getParameters();
        if (parameters.isEmpty()) {
            return false;
        }
        VariableElement last = parameters.get(parameters.size() - 1);
        return this.isSuspendFunction(last);
    }

    private boolean isSuspendFunction(VariableElement parameter) {
        String type = ParamDefinition.create(this.environment, parameter).getType().getRawType().toString();
        return type.equals("kotlin.coroutines.Continuation");
    }

    private void processArguments(ClassWriter classWriter, MethodVisitor visitor, Type controller, String moduleInternalName, NameGenerator registry) throws Exception {
        for (VariableElement variableElement : this.executable.getParameters()) {
            if (this.isSuspendFunction(variableElement)) {
                visitor.visitVarInsn(25, 1);
                visitor.visitMethodInsn(185, "io/jooby/Context", "getAttributes", "()Ljava/util/Map;", true);
                visitor.visitLdcInsn("___continuation");
                visitor.visitMethodInsn(185, "java/util/Map", "remove", "(Ljava/lang/Object;)Ljava/lang/Object;", true);
                visitor.visitTypeInsn(192, "kotlin/coroutines/Continuation");
                continue;
            }
            visitor.visitVarInsn(25, 1);
            ParamDefinition param = ParamDefinition.create(this.environment, variableElement);
            ParamWriter writer = param.newWriter();
            writer.accept(classWriter, controller, moduleInternalName, visitor, param, registry);
        }
    }

    private void setDefaultResponseType(MethodVisitor visitor) throws Exception {
        TypeKind kind = this.executable.getReturnType().getKind();
        if (kind == TypeKind.VOID && this.getHttpMethod().equalsIgnoreCase("DELETE")) {
            visitor.visitVarInsn(25, 1);
            visitor.visitFieldInsn(178, JoobyTypes.StatusCode.getInternalName(), "NO_CONTENT", JoobyTypes.StatusCode.getDescriptor());
            visitor.visitMethodInsn(185, MethodDescriptor.Context.setResponseCode().getDeclaringType().getInternalName(), MethodDescriptor.Context.setResponseCode().getName(), MethodDescriptor.Context.setResponseCode().getDescriptor(), true);
            visitor.visitInsn(87);
        }
    }

    private void processReturnType(MethodVisitor visitor) throws Exception {
        TypeKind kind = this.executable.getReturnType().getKind();
        if (kind == TypeKind.VOID) {
            visitor.visitVarInsn(25, 1);
            visitor.visitMethodInsn(185, MethodDescriptor.Context.getResponseCode().getDeclaringType().getInternalName(), MethodDescriptor.Context.getResponseCode().getName(), MethodDescriptor.Context.getResponseCode().getDescriptor(), true);
        } else {
            Method wrapper = Primitives.wrapper(kind);
            if (wrapper == null) {
                TypeDefinition returnType = this.getReturnType();
                if (returnType.is(JoobyTypes.StatusCode.getClassName(), new String[0])) {
                    visitor.visitVarInsn(58, 2);
                    visitor.visitVarInsn(25, 1);
                    visitor.visitVarInsn(25, 2);
                    visitor.visitMethodInsn(185, MethodDescriptor.Context.setResponseCode().getDeclaringType().getInternalName(), MethodDescriptor.Context.setResponseCode().getName(), MethodDescriptor.Context.setResponseCode().getDescriptor(), true);
                    visitor.visitInsn(87);
                    visitor.visitVarInsn(25, 2);
                }
            } else {
                visitor.visitMethodInsn(184, Type.getInternalName(wrapper.getDeclaringClass()), wrapper.getName(), Type.getMethodDescriptor(wrapper), false);
            }
        }
        visitor.visitInsn(176);
        visitor.visitMaxs(0, 0);
    }

    public TypeDefinition getController() {
        return this.owner;
    }

    private String methodDescriptor() {
        Types typeUtils = this.environment.getTypeUtils();
        Type returnType = new TypeDefinition(typeUtils, this.executable.getReturnType()).toJvmType();
        Type[] arguments = (Type[])this.executable.getParameters().stream().map(var -> new TypeDefinition(typeUtils, var.asType()).toJvmType()).toArray(Type[]::new);
        return Type.getMethodDescriptor(returnType, arguments);
    }

    private List<String> mediaType(ExecutableElement element, TypeMirror annotation, String property, Set<String> types) {
        List<String> result = element.getAnnotationMirrors().stream().filter(it -> it.getAnnotationType().equals(annotation)).findFirst().map(it -> Annotations.attribute(it, property)).orElse(Collections.emptyList());
        if (result.size() == 0) {
            return this.mediaType(element, types);
        }
        return result;
    }

    private List<String> mediaType(Element element, Set<String> types) {
        return element.getAnnotationMirrors().stream().filter(it -> types.contains(it.getAnnotationType().toString())).findFirst().map(it -> Annotations.attribute(it, "value")).orElseGet(() -> {
            if (element instanceof ExecutableElement) {
                return this.mediaType(element.getEnclosingElement(), types);
            }
            return Collections.emptyList();
        });
    }

    static String leadingSlash(String path) {
        if (path == null || path.length() == 0 || path.equals("/")) {
            return "/";
        }
        return path.charAt(0) == '/' ? path : "/" + path;
    }
}

