/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt;

import io.jooby.apt.JoobyProcessor;
import io.jooby.internal.apt.HandlerCompiler;
import io.jooby.internal.apt.JoobyTypes;
import io.jooby.internal.apt.MethodDescriptor;
import io.jooby.internal.apt.Opts;
import io.jooby.internal.apt.ParamDefinition;
import io.jooby.internal.apt.Primitives;
import io.jooby.internal.apt.TypeDefinition;
import io.jooby.internal.apt.asm.ArrayWriter;
import io.jooby.internal.apt.asm.ClassWriter;
import io.jooby.internal.apt.asm.Handle;
import io.jooby.internal.apt.asm.Label;
import io.jooby.internal.apt.asm.MethodVisitor;
import io.jooby.internal.apt.asm.NameGenerator;
import io.jooby.internal.apt.asm.Opcodes;
import io.jooby.internal.apt.asm.RouteAttributesWriter;
import io.jooby.internal.apt.asm.Type;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.ExecutableElement;

public class ModuleCompiler {
    private static final Type OBJ = Type.getType(Object.class);
    private final String controllerClass;
    private final String moduleClass;
    private final String moduleInternalName;
    private final String moduleJava;
    private final ProcessingEnvironment processingEnv;
    private final boolean debug;

    public ModuleCompiler(ProcessingEnvironment processingEnv, String controllerClass) {
        this.controllerClass = controllerClass;
        this.moduleClass = this.controllerClass + "$Module";
        this.moduleJava = this.moduleClass + ".java";
        this.moduleInternalName = this.moduleClass.replace(".", "/");
        this.processingEnv = processingEnv;
        this.debug = Boolean.parseBoolean(processingEnv.getOptions().getOrDefault("debug", "false"));
    }

    public String getModuleClass() {
        return this.moduleClass;
    }

    public byte[] compile(List<HandlerCompiler> handlers) throws Exception {
        ClassWriter writer = new ClassWriter(1);
        writer.visit(52, 4129, this.moduleInternalName, null, OBJ.getInternalName(), new String[]{JoobyTypes.MvcFactory.getInternalName()});
        writer.visitSource(this.moduleJava, null);
        this.defaultConstructor(writer);
        this.supports(writer);
        this.create(writer);
        this.install(writer, handlers);
        writer.visitEnd();
        return writer.toByteArray();
    }

    private void defaultConstructor(ClassWriter writer) {
        MethodVisitor constructor = writer.visitMethod(1, "<init>", "()V", null, null);
        constructor.visitCode();
        constructor.visitVarInsn(25, 0);
        constructor.visitMethodInsn(183, OBJ.getInternalName(), "<init>", "()V", false);
        constructor.visitInsn(177);
        constructor.visitMaxs(0, 0);
        constructor.visitEnd();
    }

    private void create(ClassWriter writer) {
        String lambdaCreate = "makeExtension";
        MethodVisitor methodVisitor = writer.visitMethod(1, "create", "(Ljakarta/inject/Provider;)Lio/jooby/Extension;", null, null);
        methodVisitor.visitParameter("provider", 0);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitInvokeDynamicInsn("install", "(Ljakarta/inject/Provider;)Lio/jooby/Extension;", new Handle(6, "java/lang/invoke/LambdaMetafactory", "metafactory", "(Ljava/lang/invoke/MethodHandles$Lookup;Ljava/lang/String;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodType;Ljava/lang/invoke/MethodHandle;Ljava/lang/invoke/MethodType;)Ljava/lang/invoke/CallSite;", false), Type.getType("(Lio/jooby/Jooby;)V"), new Handle(6, this.moduleInternalName, lambdaCreate, "(Ljakarta/inject/Provider;Lio/jooby/Jooby;)V", false), Type.getType("(Lio/jooby/Jooby;)V"));
        methodVisitor.visitInsn(176);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
        this.makeExtension(writer, lambdaCreate);
    }

    private void makeExtension(ClassWriter writer, String methodName) {
        MethodVisitor methodVisitor = writer.visitMethod(4106, methodName, "(Ljakarta/inject/Provider;Lio/jooby/Jooby;)V", null, new String[]{"java/lang/Exception"});
        methodVisitor.visitParameter("provider", 4112);
        methodVisitor.visitParameter("app", 4096);
        methodVisitor.visitCode();
        methodVisitor.visitVarInsn(25, 1);
        methodVisitor.visitVarInsn(25, 0);
        methodVisitor.visitMethodInsn(184, this.moduleInternalName, "install", "(Lio/jooby/Jooby;Ljakarta/inject/Provider;)V", false);
        methodVisitor.visitInsn(177);
        methodVisitor.visitMaxs(0, 0);
        methodVisitor.visitEnd();
    }

    private void install(ClassWriter writer, List<HandlerCompiler> handlers) throws Exception {
        MethodVisitor visitor = writer.visitMethod(10, "install", "(Lio/jooby/Jooby;Ljakarta/inject/Provider;)V", "(Lio/jooby/Jooby;Ljakarta/inject/Provider<" + Type.getObjectType(this.controllerClass.replace(".", "/")) + ">;)V", new String[]{"java/lang/Exception"});
        visitor.visitParameter("app", 0);
        visitor.visitParameter("provider", 0);
        visitor.visitCode();
        String[] userAttrFilter = Opts.stringListOpt(this.processingEnv, "jooby.skipAttributeAnnotations", "");
        RouteAttributesWriter routeAttributes = new RouteAttributesWriter(this.processingEnv.getElementUtils(), this.processingEnv.getTypeUtils(), writer, this.moduleInternalName, visitor, userAttrFilter);
        NameGenerator nameRegistry = new NameGenerator();
        for (HandlerCompiler handler : handlers) {
            visitor.visitVarInsn(25, 0);
            visitor.visitLdcInsn(handler.getPattern());
            if (handler.isSuspendFunction()) {
                visitor.visitTypeInsn(187, "io/jooby/internal/kt/CoroutineLauncher");
                visitor.visitInsn(89);
            }
            visitor.visitVarInsn(25, 1);
            handler.compile(this.moduleInternalName, writer, visitor, nameRegistry);
            if (handler.isSuspendFunction()) {
                visitor.visitMethodInsn(183, "io/jooby/internal/kt/CoroutineLauncher", "<init>", "(Lio/jooby/Route$Handler;)V", false);
            }
            visitor.visitMethodInsn(182, "io/jooby/Jooby", handler.getHttpMethod(), "(Ljava/lang/String;Lio/jooby/Route$Handler;)Lio/jooby/Route;", false);
            visitor.visitVarInsn(58, 2);
            visitor.visitVarInsn(25, 2);
            this.setReturnType(visitor, handler);
            this.setMvcMethod(visitor, handler);
            this.setContentType(visitor, "setConsumes", handler.getConsumes());
            this.setContentType(visitor, "setProduces", handler.getProduces());
            this.debug("route attributes %s.%s", handler.getExecutable().getEnclosingElement(), handler.getExecutable());
            routeAttributes.process(handler.getExecutable(), this::debug);
            this.setDispatch(visitor, handler.getExecutable());
        }
        visitor.visitInsn(177);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void setMvcMethod(MethodVisitor visitor, HandlerCompiler handler) {
        visitor.visitVarInsn(25, 2);
        visitor.visitLdcInsn(handler.getController().toJvmType());
        ExecutableElement executable = handler.getExecutable();
        visitor.visitLdcInsn(executable.getSimpleName().toString());
        List args = executable.getParameters().stream().map(it -> ParamDefinition.create(this.processingEnv, it)).map(ParamDefinition::getType).collect(Collectors.toUnmodifiableList());
        ArrayWriter.write(visitor, Class.class.getName(), args, type -> {
            if (type.isPrimitive()) {
                try {
                    Method wrapper = Primitives.wrapper(type);
                    visitor.visitFieldInsn(178, Type.getInternalName(wrapper.getDeclaringClass()), "TYPE", "Ljava/lang/Class;");
                }
                catch (NoSuchMethodException x) {
                    JoobyProcessor.propagate(x);
                }
            } else {
                visitor.visitLdcInsn(type.toJvmType());
            }
        });
        visitor.visitMethodInsn(182, "java/lang/Class", "getMethod", "(Ljava/lang/String;[Ljava/lang/Class;)Ljava/lang/reflect/Method;", false);
        visitor.visitMethodInsn(182, "io/jooby/Route", MethodDescriptor.Route.setMvcMethod().getName(), MethodDescriptor.Route.setMvcMethod().getDescriptor(), false);
        visitor.visitInsn(87);
    }

    private void setDispatch(MethodVisitor visitor, ExecutableElement executable) throws NoSuchMethodException {
        String executorKey = this.findAnnotation(executable.getAnnotationMirrors(), JoobyTypes.Dispatch.getClassName()).map(it -> this.annotationAttribute((AnnotationMirror)it, "value").toString()).orElseGet(() -> this.findAnnotation(executable.getEnclosingElement().getAnnotationMirrors(), JoobyTypes.Dispatch.getClassName()).map(it -> this.annotationAttribute((AnnotationMirror)it, "value").toString()).orElse(null));
        if (executorKey != null) {
            visitor.visitVarInsn(25, 2);
            visitor.visitLdcInsn(executorKey);
            visitor.visitMethodInsn(182, MethodDescriptor.Route.setExecutorKey().getDeclaringType().getInternalName(), MethodDescriptor.Route.setExecutorKey().getName(), MethodDescriptor.Route.setExecutorKey().getDescriptor(), false);
            visitor.visitInsn(87);
        }
    }

    private Object annotationAttribute(AnnotationMirror annotationMirror, String method) {
        Map<? extends ExecutableElement, ? extends AnnotationValue> map = this.processingEnv.getElementUtils().getElementValuesWithDefaults(annotationMirror);
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : map.entrySet()) {
            if (!entry.getKey().getSimpleName().toString().equals(method)) continue;
            return entry.getValue().getValue();
        }
        throw new IllegalArgumentException("Missing: " + annotationMirror.getAnnotationType().toString() + "." + method);
    }

    private Optional<? extends AnnotationMirror> findAnnotation(List<? extends AnnotationMirror> annotationMirrors, String name) {
        return annotationMirrors.stream().filter(it -> it.getAnnotationType().toString().equals(name)).findFirst();
    }

    private void setReturnType(MethodVisitor visitor, HandlerCompiler handler) throws NoSuchMethodException {
        TypeDefinition returnType = handler.getReturnType();
        if (handler.isSuspendFunction()) {
            visitor.visitLdcInsn(Type.getType("Lkotlin/coroutines/Continuation;"));
        } else if (returnType.isVoid()) {
            visitor.visitLdcInsn(JoobyTypes.StatusCode);
        } else if (returnType.isPrimitive()) {
            Method wrapper = Primitives.wrapper(returnType);
            visitor.visitFieldInsn(178, Type.getInternalName(wrapper.getDeclaringClass()), "TYPE", "Ljava/lang/Class;");
        } else if (returnType.isRawType()) {
            visitor.visitLdcInsn(handler.getReturnType().toJvmType());
        } else {
            visitor.visitLdcInsn(returnType.toJvmType());
            List<TypeDefinition> args = returnType.getArguments();
            ArrayWriter.write(visitor, java.lang.reflect.Type.class.getName(), args, type -> visitor.visitLdcInsn(type.toJvmType()));
            visitor.visitMethodInsn(184, "io/jooby/Reified", MethodDescriptor.Reified.getParameterized().getName(), MethodDescriptor.Reified.getParameterized().getDescriptor(), false);
            visitor.visitMethodInsn(182, "io/jooby/Reified", MethodDescriptor.Reified.getType().getName(), MethodDescriptor.Reified.getType().getDescriptor(), false);
        }
        visitor.visitMethodInsn(182, "io/jooby/Route", MethodDescriptor.Route.setReturnType().getName(), MethodDescriptor.Route.setReturnType().getDescriptor(), false);
        visitor.visitInsn(87);
    }

    private void setContentType(MethodVisitor visitor, String methodName, List<String> mediaTypes) {
        if (mediaTypes.size() > 0) {
            visitor.visitVarInsn(25, 2);
            ArrayWriter.write(visitor, JoobyTypes.MediaType.getClassName(), mediaTypes, mediaType -> {
                visitor.visitLdcInsn(mediaType);
                visitor.visitMethodInsn(184, "io/jooby/MediaType", "valueOf", "(Ljava/lang/String;)Lio/jooby/MediaType;", false);
            });
            visitor.visitMethodInsn(184, "java/util/Arrays", "asList", "([Ljava/lang/Object;)Ljava/util/List;", false);
            visitor.visitMethodInsn(182, "io/jooby/Route", methodName, "(Ljava/util/Collection;)Lio/jooby/Route;", false);
            visitor.visitInsn(87);
        }
    }

    private void supports(ClassWriter writer) {
        MethodVisitor visitor = writer.visitMethod(1, "supports", "(Ljava/lang/Class;)Z", null, null);
        visitor.visitParameter("type", 0);
        visitor.visitCode();
        visitor.visitVarInsn(25, 1);
        visitor.visitLdcInsn(Type.getObjectType(this.controllerClass.replace(".", "/")));
        Label l0 = new Label();
        visitor.visitJumpInsn(166, l0);
        visitor.visitInsn(4);
        Label l1 = new Label();
        visitor.visitJumpInsn(167, l1);
        visitor.visitLabel(l0);
        visitor.visitFrame(3, 0, null, 0, null);
        visitor.visitInsn(3);
        visitor.visitLabel(l1);
        visitor.visitFrame(4, 0, null, 1, new Object[]{Opcodes.INTEGER});
        visitor.visitInsn(172);
        visitor.visitMaxs(0, 0);
        visitor.visitEnd();
    }

    private void debug(String format, Object ... args) {
        if (this.debug) {
            System.out.printf(format + "\n", args);
        }
    }
}

