/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt;

import io.jooby.internal.apt.Annotations;
import io.jooby.internal.apt.JoobyTypes;
import io.jooby.internal.apt.MethodDescriptor;
import io.jooby.internal.apt.ParamKind;
import io.jooby.internal.apt.TypeDefinition;
import io.jooby.internal.apt.asm.ParamWriter;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.Period;
import java.time.ZoneId;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.AnnotatedConstruct;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Types;

public class ParamDefinition {
    private final VariableElement parameter;
    private final TypeDefinition type;
    private final Types typeUtils;
    private final ParamKind kind;
    private final String name;
    private final String httpName;

    private ParamDefinition(ProcessingEnvironment environment, VariableElement parameter) {
        this.typeUtils = environment.getTypeUtils();
        this.parameter = parameter;
        this.name = parameter.getSimpleName().toString();
        this.type = new TypeDefinition(this.typeUtils, parameter.asType());
        this.kind = this.computeKind();
        this.httpName = this.parameterName(parameter, this.kind.annotations());
    }

    public ParamWriter newWriter() {
        try {
            return this.getKind().newWriter();
        }
        catch (UnsupportedOperationException x) {
            throw new UnsupportedOperationException("No writer for: '" + this.toString() + "'; kind: " + this.getKind());
        }
    }

    public String getHttpName() {
        return this.httpName;
    }

    public String getName() {
        return this.name;
    }

    public TypeDefinition getType() {
        return this.type;
    }

    public ParamKind getKind() {
        return this.kind;
    }

    public boolean is(Class type, Class ... arguments) {
        return this.getType().is(type, arguments);
    }

    public boolean is(String type, String ... arguments) {
        return this.getType().is(type, arguments);
    }

    public boolean isOptional() {
        return this.is(Optional.class, new Class[0]);
    }

    public boolean isList() {
        return this.is(List.class, new Class[0]);
    }

    public boolean isNamed() {
        return this.isSimpleType();
    }

    public boolean isNullable() {
        boolean nonnull;
        if (this.hasAnnotation(".Nullable")) {
            return true;
        }
        boolean bl = nonnull = this.hasAnnotation(".NotNull") || this.hasAnnotation(".NonNull");
        if (nonnull) {
            return false;
        }
        return !this.getType().isPrimitive();
    }

    private boolean hasAnnotation(String type) {
        Set<String> annotations = this.annotations(this.parameter);
        for (String annotation : annotations) {
            if (!annotation.endsWith(type)) continue;
            return true;
        }
        return false;
    }

    private Set<String> annotations(VariableElement parameter) {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        annotations.addAll(this.annotationsFrom(parameter));
        annotations.addAll(this.annotationsFrom(parameter.asType()));
        return annotations;
    }

    private Set<String> annotationsFrom(AnnotatedConstruct annotated) {
        LinkedHashSet<String> annotations = new LinkedHashSet<String>();
        for (AnnotationMirror annotationMirror : annotated.getAnnotationMirrors()) {
            DeclaredType typeMirror = annotationMirror.getAnnotationType();
            annotations.add(typeMirror.toString());
        }
        return annotations;
    }

    public MethodDescriptor getObjectValue() throws NoSuchMethodException {
        return this.getKind().valueObject(this);
    }

    public MethodDescriptor getSingleValue() throws NoSuchMethodException {
        return this.getKind().singleValue(this);
    }

    public boolean isSimpleType() {
        for (String builtinType : this.builtinTypes()) {
            if (!this.is(builtinType, new String[0]) && !this.is(Optional.class.getName(), builtinType) && !this.is(List.class.getName(), builtinType) && !this.is(Set.class.getName(), builtinType)) continue;
            return true;
        }
        return false;
    }

    public String[] sources() {
        return (String[])this.annotations(this.parameter.getAnnotationMirrors(), this.kind.annotations()).stream().flatMap(it -> Annotations.attribute(it, "value", v -> ((VariableElement)v.getValue()).getSimpleName().toString()).stream()).toArray(String[]::new);
    }

    private String[] builtinTypes() {
        return new String[]{String.class.getName(), Boolean.class.getName(), Boolean.TYPE.getName(), Byte.class.getName(), Byte.TYPE.getName(), Character.class.getName(), Character.TYPE.getName(), Short.class.getName(), Short.TYPE.getName(), Integer.class.getName(), Integer.TYPE.getName(), Long.class.getName(), Long.TYPE.getName(), Float.class.getName(), Float.TYPE.getName(), Double.class.getName(), Double.TYPE.getName(), Enum.class.getName(), UUID.class.getName(), Instant.class.getName(), Date.class.getName(), LocalDate.class.getName(), LocalDateTime.class.getName(), BigDecimal.class.getName(), BigInteger.class.getName(), Duration.class.getName(), Period.class.getName(), Charset.class.getName(), JoobyTypes.StatusCode.getClassName(), TimeZone.class.getName(), ZoneId.class.getName(), URI.class.getName(), URL.class.getName()};
    }

    public String toString() {
        return this.parameter.getSimpleName() + ": " + this.parameter.asType();
    }

    public MethodDescriptor getMethod() throws NoSuchMethodException {
        if (!this.isNullable()) {
            if (this.is(String.class, new Class[0])) {
                return MethodDescriptor.Value.value();
            }
            if (this.is(Integer.TYPE, new Class[0])) {
                return MethodDescriptor.Value.intValue();
            }
            if (this.is(Byte.TYPE, new Class[0])) {
                return MethodDescriptor.Value.byteValue();
            }
            if (this.is(Long.TYPE, new Class[0])) {
                return MethodDescriptor.Value.longValue();
            }
            if (this.is(Float.TYPE, new Class[0])) {
                return MethodDescriptor.Value.floatValue();
            }
            if (this.is(Double.TYPE, new Class[0])) {
                return MethodDescriptor.Value.doubleValue();
            }
            if (this.is(Boolean.TYPE, new Class[0])) {
                return MethodDescriptor.Value.booleanValue();
            }
            if (this.is(Optional.class, String.class)) {
                return MethodDescriptor.Value.toOptional();
            }
            if (this.is(List.class, String.class)) {
                return MethodDescriptor.Value.toList();
            }
            if (this.is(Set.class, String.class)) {
                return MethodDescriptor.Value.toSet();
            }
        }
        if (this.isOptional()) {
            return MethodDescriptor.ValueNode.toOptional();
        }
        if (this.isList()) {
            return MethodDescriptor.ValueNode.toList();
        }
        if (this.is(Set.class, new Class[0])) {
            return MethodDescriptor.ValueNode.toSet();
        }
        if (this.kind == ParamKind.BODY_PARAM) {
            return this.type.isRawType() ? MethodDescriptor.Context.bodyClass() : MethodDescriptor.Context.bodyType();
        }
        return this.isNullable() ? MethodDescriptor.ValueNode.toNullable() : MethodDescriptor.ValueNode.to();
    }

    public static ParamDefinition create(ProcessingEnvironment environment, VariableElement parameter) {
        ParamDefinition definition = new ParamDefinition(environment, parameter);
        return definition;
    }

    private ParamKind computeKind() {
        if (this.isTypeInjection()) {
            return ParamKind.TYPE;
        }
        if (this.is(JoobyTypes.FileUpload.getClassName(), new String[0]) || this.is(List.class.getName(), JoobyTypes.FileUpload.getClassName()) || this.is(Optional.class.getName(), JoobyTypes.FileUpload.getClassName()) || this.is(Path.class, new Class[0])) {
            return ParamKind.FILE_UPLOAD;
        }
        for (ParamKind strategy : ParamKind.values()) {
            if (!this.isParam(this.parameter, strategy.annotations())) continue;
            return strategy;
        }
        return ParamKind.BODY_PARAM;
    }

    private boolean isTypeInjection() {
        if (this.is(JoobyTypes.Context.getClassName(), new String[0])) {
            return true;
        }
        if (this.is(JoobyTypes.QueryString.getClassName(), new String[0])) {
            return true;
        }
        if (this.is(JoobyTypes.Formdata.getClassName(), new String[0])) {
            return true;
        }
        if (this.is(JoobyTypes.FlashMap.getClassName(), new String[0])) {
            return true;
        }
        if (this.is(JoobyTypes.Session.getClassName(), new String[0]) || this.is(Optional.class.getName(), JoobyTypes.Session.getClassName())) {
            return true;
        }
        return this.is(JoobyTypes.Route.getClassName(), new String[0]);
    }

    private boolean isParam(VariableElement parameter, Set<String> annotations) {
        return this.annotations(parameter.getAnnotationMirrors(), annotations).size() > 0;
    }

    private List<AnnotationMirror> annotations(List<? extends AnnotationMirror> annotationMirrors, Set<String> annotations) {
        return annotationMirrors.stream().filter(it -> {
            String rawType = new TypeDefinition(this.typeUtils, it.getAnnotationType()).getRawType().toString();
            return annotations.contains(rawType);
        }).collect(Collectors.toList());
    }

    private String parameterName(VariableElement parameter, Set<String> types) {
        return this.annotations(parameter.getAnnotationMirrors(), types).stream().flatMap(it -> Annotations.attribute(it, this.kind.httpNameMemberName()).stream()).findFirst().orElse(parameter.getSimpleName().toString());
    }
}

