/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.apt.asm;

import io.jooby.internal.apt.JoobyTypes;
import io.jooby.internal.apt.MethodDescriptor;
import io.jooby.internal.apt.ParamDefinition;
import io.jooby.internal.apt.asm.ClassWriter;
import io.jooby.internal.apt.asm.MethodVisitor;
import io.jooby.internal.apt.asm.NameGenerator;
import io.jooby.internal.apt.asm.Type;
import io.jooby.internal.apt.asm.ValueWriter;

public class ParamLookupWriter
extends ValueWriter {
    @Override
    public void accept(ClassWriter writer, Type controller, String handlerInternalName, MethodVisitor visitor, ParamDefinition parameter, NameGenerator nameGenerator) throws Exception {
        String parameterName = parameter.getHttpName();
        String[] sources = parameter.sources();
        MethodDescriptor paramMethod = parameter.getSingleValue();
        String internalName = JoobyTypes.ParamSource.getInternalName();
        visitor.visitLdcInsn(parameterName);
        this.pushInt(sources.length, visitor);
        visitor.visitTypeInsn(189, internalName);
        int n = sources.length;
        for (int i = 0; i < n; ++i) {
            visitor.visitInsn(89);
            this.pushInt(i, visitor);
            visitor.visitFieldInsn(178, internalName, sources[i], JoobyTypes.ParamSource.getDescriptor());
            visitor.visitInsn(83);
        }
        visitor.visitMethodInsn(185, paramMethod.getDeclaringType().getInternalName(), paramMethod.getName(), paramMethod.getDescriptor(), true);
        super.accept(writer, controller, handlerInternalName, visitor, parameter, nameGenerator);
    }

    private void pushInt(int value, MethodVisitor visitor) {
        switch (value) {
            case 0: {
                visitor.visitInsn(3);
                break;
            }
            case 1: {
                visitor.visitInsn(4);
                break;
            }
            case 2: {
                visitor.visitInsn(5);
                break;
            }
            case 3: {
                visitor.visitInsn(6);
                break;
            }
            case 4: {
                visitor.visitInsn(7);
                break;
            }
            case 5: {
                visitor.visitInsn(8);
                break;
            }
            default: {
                visitor.visitIntInsn(16, value);
            }
        }
    }
}

