/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.gson;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.ServiceRegistry;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;

public class GsonModule
implements Extension,
MessageDecoder,
MessageEncoder {
    private Gson gson;

    public GsonModule(@NonNull Gson gson) {
        this.gson = gson;
    }

    public GsonModule() {
        this(new GsonBuilder().create());
    }

    public void install(@NonNull Jooby application) throws Exception {
        application.decoder(MediaType.json, (MessageDecoder)this);
        application.encoder(MediaType.json, (MessageEncoder)this);
        ServiceRegistry services = application.getServices();
        services.put(Gson.class, (Object)this.gson);
    }

    @NonNull
    public Object decode(@NonNull Context ctx, @NonNull Type type) throws Exception {
        Body body = ctx.body();
        if (body.isInMemory()) {
            return this.gson.fromJson((Reader)new InputStreamReader((InputStream)new ByteArrayInputStream(body.bytes()), StandardCharsets.UTF_8), type);
        }
        try (InputStream stream = body.stream();){
            Object object = this.gson.fromJson((Reader)new InputStreamReader(stream, StandardCharsets.UTF_8), type);
            return object;
        }
    }

    @NonNull
    public byte[] encode(@NonNull Context ctx, @NonNull Object value) {
        ctx.setDefaultResponseType(MediaType.json);
        return this.gson.toJson(value).getBytes(StandardCharsets.UTF_8);
    }
}

