/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.di;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.Registry;
import io.jooby.di.GuiceRegistry;
import io.jooby.di.JoobyModule;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class GuiceModule
implements Extension {
    private Injector injector;
    private List<Module> modules = new ArrayList<Module>();

    public GuiceModule(@Nonnull Injector injector) {
        this.injector = injector;
    }

    public GuiceModule(Module ... modules) {
        Stream.of(modules).forEach(this.modules::add);
    }

    public boolean lateinit() {
        return true;
    }

    public void install(@Nonnull Jooby application) {
        if (this.injector == null) {
            Environment env = application.getEnvironment();
            this.modules.add((Module)new JoobyModule(application));
            Stage stage = env.isActive("dev", new String[]{"test"}) ? Stage.DEVELOPMENT : Stage.PRODUCTION;
            this.injector = Guice.createInjector((Stage)stage, this.modules);
        }
        application.registry((Registry)new GuiceRegistry(this.injector));
    }
}

