/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.di;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import io.jooby.Registry;
import io.jooby.ServiceKey;
import io.jooby.exception.RegistryException;
import java.lang.annotation.Annotation;
import javax.annotation.Nonnull;

class GuiceRegistry
implements Registry {
    private Injector injector;

    GuiceRegistry(Injector injector) {
        this.injector = injector;
    }

    @Nonnull
    public <T> T require(@Nonnull Class<T> type) {
        return this.require(Key.get(type));
    }

    @Nonnull
    public <T> T require(@Nonnull Class<T> type, @Nonnull String name) {
        return this.require(Key.get(type, (Annotation)Names.named((String)name)));
    }

    @Nonnull
    public <T> T require(@Nonnull ServiceKey<T> key) throws RegistryException {
        String name = key.getName();
        return name == null ? this.require(key.getType()) : this.require(key.getType(), name);
    }

    @Nonnull
    private <T> T require(@Nonnull Key<T> key) {
        try {
            return (T)this.injector.getInstance(key);
        }
        catch (ConfigurationException | ProvisionException x) {
            throw new RegistryException("Provisioning of `" + key + "` resulted in exception", x);
        }
    }
}

