/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.di;

import com.google.inject.AbstractModule;
import com.google.inject.Key;
import com.google.inject.name.Named;
import com.google.inject.name.Names;
import com.google.inject.util.Types;
import com.typesafe.config.Config;
import com.typesafe.config.ConfigValue;
import io.jooby.Environment;
import io.jooby.Jooby;
import io.jooby.ServiceKey;
import io.jooby.ServiceRegistry;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.inject.Provider;

public class JoobyModule
extends AbstractModule {
    private Jooby application;

    public JoobyModule(@Nonnull Jooby application) {
        this.application = application;
    }

    protected void configure() {
        this.configureEnv(this.application.getEnvironment());
        this.configureResources(this.application.getServices());
    }

    private void configureResources(ServiceRegistry registry) {
        for (Map.Entry entry : registry.entrySet()) {
            ServiceKey key = (ServiceKey)entry.getKey();
            Provider provider = (Provider)entry.getValue();
            Object binding = key.getName() != null ? this.bind(key.getType()).annotatedWith((Annotation)Names.named((String)key.getName())) : this.bind(key.getType());
            binding.toProvider(provider);
        }
    }

    void configureEnv(Environment env) {
        Config config = env.getConfig();
        for (Map.Entry entry : config.entrySet()) {
            String name = (String)entry.getKey();
            Named named = Names.named((String)name);
            Object value = ((ConfigValue)entry.getValue()).unwrapped();
            if (value instanceof List) {
                List values = (List)value;
                this.componentType(values).forEach(componentType -> {
                    ParameterizedType listType = Types.listOf((Type)componentType);
                    Key key = Key.get((Type)listType, (Annotation)Names.named((String)name));
                    this.bind(key).toInstance((Object)values);
                });
                value = values.stream().map(Object::toString).collect(Collectors.joining(","));
            }
            this.bindConstant().annotatedWith((Annotation)named).to(value.toString());
        }
    }

    private Stream<Class> componentType(List values) {
        if (values.isEmpty()) {
            return Stream.of(String.class, Integer.class, Long.class, Float.class, Double.class, Boolean.class, Object.class);
        }
        return Stream.of(values.get(0).getClass());
    }
}

