/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.guice;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Environment;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.Registry;
import io.jooby.guice.GuiceRegistry;
import io.jooby.guice.JoobyModule;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public class GuiceModule
implements Extension {
    private Injector injector;
    private List<Module> modules = new ArrayList<Module>();

    public GuiceModule(@NonNull Injector injector) {
        this.injector = injector;
    }

    public GuiceModule(Module ... modules) {
        Stream.of(modules).forEach(this.modules::add);
    }

    public boolean lateinit() {
        return true;
    }

    public void install(@NonNull Jooby application) {
        if (this.injector == null) {
            Environment env = application.getEnvironment();
            this.modules.add((Module)new JoobyModule(application));
            Stage stage = env.isActive("dev", new String[]{"test"}) ? Stage.DEVELOPMENT : Stage.PRODUCTION;
            this.injector = Guice.createInjector((Stage)stage, this.modules);
        }
        application.registry((Registry)new GuiceRegistry(this.injector));
    }
}

