/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.guice;

import com.google.inject.ConfigurationException;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.ProvisionException;
import com.google.inject.name.Names;
import edu.umd.cs.findbugs.annotations.NonNull;
import io.jooby.Registry;
import io.jooby.ServiceKey;
import io.jooby.exception.RegistryException;
import java.lang.annotation.Annotation;

class GuiceRegistry
implements Registry {
    private Injector injector;

    GuiceRegistry(Injector injector) {
        this.injector = injector;
    }

    @NonNull
    public <T> T require(@NonNull Class<T> type) {
        return this.require(Key.get(type));
    }

    @NonNull
    public <T> T require(@NonNull Class<T> type, @NonNull String name) {
        return this.require(Key.get(type, (Annotation)Names.named((String)name)));
    }

    @NonNull
    public <T> T require(@NonNull ServiceKey<T> key) throws RegistryException {
        String name = key.getName();
        return name == null ? this.require(key.getType()) : this.require(key.getType(), name);
    }

    @NonNull
    private <T> T require(@NonNull Key<T> key) {
        try {
            return (T)this.injector.getInstance(key);
        }
        catch (ConfigurationException | ProvisionException x) {
            throw new RegistryException("Provisioning of `" + key + "` resulted in exception", x);
        }
    }
}

