/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.json;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import io.jooby.Body;
import io.jooby.Context;
import io.jooby.Extension;
import io.jooby.Jooby;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MessageEncoder;
import io.jooby.ServiceRegistry;
import io.jooby.StatusCode;
import java.io.InputStream;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public class JacksonModule
implements Extension,
MessageDecoder,
MessageEncoder {
    private final MediaType mediaType;
    private final ObjectMapper mapper;
    private final TypeFactory typeFactory;
    private final Set<Class<? extends Module>> modules = new HashSet<Class<? extends Module>>();
    private static final Map<String, MediaType> defaultTypes = new HashMap<String, MediaType>();

    public JacksonModule(@Nonnull ObjectMapper mapper, @Nonnull MediaType contentType) {
        this.mapper = mapper;
        this.typeFactory = mapper.getTypeFactory();
        this.mediaType = contentType;
    }

    public JacksonModule(@Nonnull ObjectMapper mapper) {
        this(mapper, defaultTypes.getOrDefault(mapper.getClass().getSimpleName(), MediaType.json));
    }

    public JacksonModule() {
        this(JacksonModule.create(new Module[0]));
    }

    public JacksonModule module(Class<? extends Module> module) {
        this.modules.add(module);
        return this;
    }

    public void install(@Nonnull Jooby application) {
        application.decoder(this.mediaType, (MessageDecoder)this);
        application.encoder(this.mediaType, (MessageEncoder)this);
        ServiceRegistry services = application.getServices();
        Class<?> mapperType = this.mapper.getClass();
        services.put(mapperType, (Object)this.mapper);
        services.put(ObjectMapper.class, (Object)this.mapper);
        application.errorCode(JsonParseException.class, StatusCode.BAD_REQUEST);
        application.onStarted(() -> {
            for (Class<? extends Module> type : this.modules) {
                Module module = (Module)application.require(type);
                this.mapper.registerModule(module);
            }
        });
    }

    public byte[] encode(@Nonnull Context ctx, @Nonnull Object value) throws Exception {
        ctx.setDefaultResponseType(this.mediaType);
        return this.mapper.writer().writeValueAsBytes(value);
    }

    public Object decode(Context ctx, Type type) throws Exception {
        Body body = ctx.body();
        if (body.isInMemory()) {
            if (type == JsonNode.class) {
                return this.mapper.readTree(body.bytes());
            }
            return this.mapper.readValue(body.bytes(), this.typeFactory.constructType(type));
        }
        try (InputStream stream = body.stream();){
            if (type == JsonNode.class) {
                JsonNode jsonNode = this.mapper.readTree(stream);
                return jsonNode;
            }
            Object object = this.mapper.readValue(stream, this.typeFactory.constructType(type));
            return object;
        }
    }

    @Nonnull
    public static ObjectMapper create(Module ... modules) {
        JsonMapper.Builder builder = (JsonMapper.Builder)((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().addModule((Module)new ParameterNamesModule())).addModule((Module)new Jdk8Module())).addModule((Module)new JavaTimeModule());
        Stream.of(modules).forEach(arg_0 -> ((JsonMapper.Builder)builder).addModule(arg_0));
        return builder.build();
    }

    static {
        defaultTypes.put("XmlMapper", MediaType.xml);
    }
}

