/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.module.SimpleDeserializers;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.jooby.SneakyThrows;
import io.jooby.internal.openapi.OpenAPIExt;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ParameterDeserializer;
import io.swagger.v3.core.util.Yaml;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;

public class OpenApiTemplate {
    public static final ObjectMapper yaml = OpenApiTemplate.override(Yaml.mapper());
    private static final ObjectMapper json = OpenApiTemplate.override(Json.mapper());

    private static ObjectMapper override(ObjectMapper mapper) {
        PartialParameterDeserializer partial = new PartialParameterDeserializer();
        SimpleDeserializers deserializers = new SimpleDeserializers();
        deserializers.addDeserializer(Parameter.class, (JsonDeserializer)partial);
        SimpleModule override = new SimpleModule();
        override.setDeserializers(deserializers);
        mapper.registerModule((Module)override);
        return mapper;
    }

    public static Optional<OpenAPIExt> fromTemplate(Path basedir, ClassLoader classLoader, String templateName) {
        try {
            boolean yamlExt;
            Path path = basedir.resolve("conf").resolve(templateName);
            boolean bl = yamlExt = templateName.endsWith(".yaml") || templateName.endsWith(".yml");
            if (Files.exists(path, new LinkOption[0])) {
                return yamlExt ? Optional.of((OpenAPIExt)((Object)yaml.readValue(path.toFile(), OpenAPIExt.class))) : Optional.of((OpenAPIExt)((Object)json.readValue(path.toFile(), OpenAPIExt.class)));
            }
            URL resource = classLoader.getResource(templateName);
            if (resource != null) {
                return yamlExt ? Optional.of((OpenAPIExt)((Object)yaml.readValue(resource, OpenAPIExt.class))) : Optional.of((OpenAPIExt)((Object)json.readValue(resource, OpenAPIExt.class)));
            }
            return Optional.empty();
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    private static class PartialParameterDeserializer
    extends ParameterDeserializer {
        private PartialParameterDeserializer() {
        }

        public Parameter deserialize(JsonParser jp, DeserializationContext ctx) throws IOException {
            ObjectCodec codec = jp.getCodec();
            ObjectNode node = (ObjectNode)codec.readTree(jp);
            JsonFactory factory = codec.getFactory();
            Parameter result = this.parse(factory, ctx, node.toString());
            if (result == null) {
                node.put("in", "query");
                result = this.parse(factory, ctx, node.toString());
                result.setIn(null);
            }
            return result;
        }

        private Parameter parse(JsonFactory factory, DeserializationContext ctx, String json) throws IOException {
            try (JsonParser jp1 = factory.createParser(json);){
                Parameter parameter = super.deserialize(jp1, ctx);
                return parameter;
            }
        }
    }
}

