/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import com.fasterxml.jackson.annotation.JsonIgnore;
import io.jooby.MediaType;
import io.jooby.Router;
import io.jooby.internal.openapi.RequestBodyExt;
import io.jooby.internal.openapi.ResponseExt;
import io.jooby.internal.openapi.StatusCodeParser;
import io.jooby.internal.openapi.asm.tree.AnnotationNode;
import io.jooby.internal.openapi.asm.tree.ClassNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class OperationExt
extends Operation {
    @JsonIgnore
    private final MethodNode node;
    @JsonIgnore
    private String method;
    @JsonIgnore
    private final String pattern;
    @JsonIgnore
    private Boolean hidden;
    @JsonIgnore
    private LinkedList<String> produces = new LinkedList();
    @JsonIgnore
    private LinkedList<String> consumes = new LinkedList();
    @JsonIgnore
    private ResponseExt defaultResponse;
    @JsonIgnore
    private List<String> responseCodes = new ArrayList<String>();
    @JsonIgnore
    private String pathSummary;
    @JsonIgnore
    private String pathDescription;
    @JsonIgnore
    private List<Tag> globalTags = new ArrayList<Tag>();
    @JsonIgnore
    private ClassNode application;
    @JsonIgnore
    private ClassNode controller;

    public OperationExt(MethodNode node, String method, String pattern, List arguments, ResponseExt response) {
        this.node = node;
        this.method = method.toUpperCase();
        this.pattern = pattern;
        this.setParameters(arguments);
        this.defaultResponse = response;
        this.setResponses(OperationExt.apiResponses(Collections.singletonList(response)));
    }

    private static ApiResponses apiResponses(List<ResponseExt> responses) {
        ApiResponses result = new ApiResponses();
        for (ResponseExt rsp : responses) {
            result.addApiResponse(rsp.getCode(), (ApiResponse)rsp);
        }
        return result;
    }

    public MethodNode getNode() {
        return this.node;
    }

    public RequestBodyExt getRequestBody() {
        return (RequestBodyExt)super.getRequestBody();
    }

    public ResponseExt getDefaultResponse() {
        return this.defaultResponse;
    }

    public List<String> getResponseCodes() {
        return this.responseCodes;
    }

    public ResponseExt getResponse(String code) {
        return (ResponseExt)((Object)this.getResponses().get((Object)code));
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getPattern() {
        return this.pattern;
    }

    public List<String> getProduces() {
        return this.produces;
    }

    public List<String> getConsumes() {
        return this.consumes;
    }

    public void addProduces(String value) {
        this.produces.addFirst(this.toMediaType(value));
    }

    public void addConsumes(String value) {
        this.consumes.addFirst(this.toMediaType(value));
    }

    private String toMediaType(String value) {
        return MediaType.valueOf((String)value).toString();
    }

    public Boolean getHidden() {
        return this.hidden;
    }

    public void setHidden(Boolean hidden) {
        this.hidden = hidden;
    }

    public String toString() {
        return this.getMethod() + " " + this.getPattern();
    }

    public Parameter getParameter(int i) {
        if (i < this.getParameters().size()) {
            return (Parameter)this.getParameters().get(i);
        }
        return null;
    }

    public Optional<Parameter> getParameter(String name) {
        if (this.getParameters() != null) {
            return this.getParameters().stream().filter(p -> p.getName().equals(name)).findFirst();
        }
        return Optional.empty();
    }

    public ResponseExt addResponse(String code) {
        this.responseCodes.add(code);
        return (ResponseExt)((Object)this.getResponses().computeIfAbsent((Object)code, statusCode -> {
            ResponseExt rsp = new ResponseExt((String)statusCode);
            if (StatusCodeParser.isSuccessCode(statusCode)) {
                rsp.setJavaTypes(this.defaultResponse.getJavaTypes());
            }
            return rsp;
        }));
    }

    public String getPathDescription() {
        return this.pathDescription;
    }

    public void setPathDescription(String pathDescription) {
        this.pathDescription = pathDescription;
    }

    public String getPathSummary() {
        return this.pathSummary;
    }

    public void setPathSummary(String pathSummary) {
        this.pathSummary = pathSummary;
    }

    public void addTag(Tag tag) {
        this.globalTags.add(tag);
        this.addTagsItem(tag.getName());
    }

    public List<Tag> getGlobalTags() {
        return this.globalTags;
    }

    public void setGlobalTags(List<Tag> globalTags) {
        this.globalTags = globalTags;
    }

    public ClassNode getApplication() {
        return this.application;
    }

    public void setApplication(ClassNode application) {
        this.application = application;
    }

    @JsonIgnore
    public ClassNode getController() {
        return this.controller;
    }

    @JsonIgnore
    public String getControllerName() {
        return Optional.ofNullable(this.controller).map(it -> it.name).orElse(null);
    }

    public void setController(ClassNode controller) {
        this.controller = controller;
    }

    @JsonIgnore
    public List<AnnotationNode> getAllAnnotations() {
        return Stream.of(Optional.ofNullable(this.controller).map(c -> c.visibleAnnotations).orElse(this.application.visibleAnnotations), this.node.visibleAnnotations).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public OperationExt copy(String pattern) {
        OperationExt copy = new OperationExt(this.node, this.method, pattern, this.getParameters(), this.defaultResponse);
        copy.setTags(this.getTags());
        copy.setResponses(this.getResponses());
        List keys = Router.pathKeys((String)pattern);
        ArrayList newParameters = new ArrayList();
        List parameters = this.getParameters();
        for (String key : keys) {
            parameters.stream().filter(p -> p.getName().equals(key)).findFirst().ifPresent(newParameters::add);
        }
        copy.setParameters(newParameters);
        copy.setRequestBody(this.getRequestBody());
        copy.setHidden(this.getHidden());
        copy.setMethod(this.getMethod());
        copy.setDeprecated(this.getDeprecated());
        copy.setHidden(this.getHidden());
        copy.setDescription(this.getDescription());
        copy.setSummary(this.getSummary());
        copy.setOperationId(this.getOperationId());
        copy.setServers(this.getServers());
        copy.setCallbacks(this.getCallbacks());
        copy.setExternalDocs(this.getExternalDocs());
        copy.setSecurity(this.getSecurity());
        copy.setPathDescription(this.getPathDescription());
        copy.setPathSummary(this.getPathSummary());
        copy.setGlobalTags(this.getGlobalTags());
        copy.setApplication(this.getApplication());
        copy.setController(this.getController());
        return copy;
    }
}

