/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.openapi;

import io.jooby.Context;
import io.jooby.MediaType;
import io.jooby.Route;
import io.jooby.RouteSet;
import io.jooby.Router;
import io.jooby.SneakyThrows;
import io.jooby.annotation.OpenApiRegister;
import io.jooby.internal.openapi.AnnotationParser;
import io.jooby.internal.openapi.AsmUtils;
import io.jooby.internal.openapi.InsnSupport;
import io.jooby.internal.openapi.OpenAPIParser;
import io.jooby.internal.openapi.OperationExt;
import io.jooby.internal.openapi.ParameterExt;
import io.jooby.internal.openapi.ParserContext;
import io.jooby.internal.openapi.RequestBodyExt;
import io.jooby.internal.openapi.RequestParser;
import io.jooby.internal.openapi.ResponseExt;
import io.jooby.internal.openapi.ReturnTypeParser;
import io.jooby.internal.openapi.RoutePath;
import io.jooby.internal.openapi.SchemaRef;
import io.jooby.internal.openapi.Signature;
import io.jooby.internal.openapi.StatusCodeParser;
import io.jooby.internal.openapi.TypeFactory;
import io.jooby.internal.openapi.asm.Handle;
import io.jooby.internal.openapi.asm.Type;
import io.jooby.internal.openapi.asm.tree.AbstractInsnNode;
import io.jooby.internal.openapi.asm.tree.ClassNode;
import io.jooby.internal.openapi.asm.tree.FieldInsnNode;
import io.jooby.internal.openapi.asm.tree.InsnList;
import io.jooby.internal.openapi.asm.tree.InsnNode;
import io.jooby.internal.openapi.asm.tree.InvokeDynamicInsnNode;
import io.jooby.internal.openapi.asm.tree.LdcInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodInsnNode;
import io.jooby.internal.openapi.asm.tree.MethodNode;
import io.jooby.internal.openapi.asm.tree.TypeInsnNode;
import io.jooby.internal.openapi.asm.tree.VarInsnNode;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class RouteParser {
    private String metaInf;

    public RouteParser(String metaInf) {
        this.metaInf = metaInf;
    }

    public List<OperationExt> parse(ParserContext ctx) {
        List<OperationExt> operations = this.parse(ctx, null, ctx.classNode(ctx.getRouter()));
        Set controllers = operations.stream().map(OperationExt::getControllerName).filter(Objects::nonNull).collect(Collectors.toSet());
        operations.addAll(this.metaInf(ctx, null, name -> !controllers.contains(name)));
        operations.addAll(this.parseManuallyRegisteredControllers(ctx));
        String applicationName = Optional.ofNullable(ctx.getMainClass()).orElse(ctx.getRouter().getClassName());
        ClassNode application = ctx.classNode(Type.getObjectType(applicationName.replace(".", "/")));
        for (OperationExt operation : operations) {
            operation.setApplication(application);
            OpenAPIParser.parse(ctx, operation);
        }
        ArrayList<OperationExt> result = new ArrayList<OperationExt>();
        for (OperationExt operation : operations) {
            List patterns = Router.expandOptionalVariables((String)operation.getPattern());
            if (patterns.size() == 1) {
                result.add(operation);
                continue;
            }
            for (String pattern : patterns) {
                result.add(operation.copy(pattern));
            }
        }
        for (OperationExt operation : result) {
            operation.setParameters(this.checkParameters(ctx, operation.getParameters()));
            this.checkRequestBody(ctx, operation);
            this.checkResponses(ctx, operation);
        }
        this.uniqueOperationId(result);
        this.cleanup(result);
        return result;
    }

    private void checkResponses(ParserContext ctx, OperationExt operation) {
        for (Map.Entry entry : operation.getResponses().entrySet()) {
            this.checkResponse(ctx, operation, (String)entry.getKey(), (ResponseExt)((Object)entry.getValue()));
        }
    }

    private void checkResponse(ParserContext ctx, OperationExt operation, String statusCode, ResponseExt response) {
        Schema defaultSchema = this.parseSchema(ctx, response);
        if (defaultSchema != null) {
            Content content = response.getContent();
            if (content == null) {
                content = new Content();
                response.setContent(content);
            }
            if (content.isEmpty()) {
                io.swagger.v3.oas.models.media.MediaType mediaTypeObject = new io.swagger.v3.oas.models.media.MediaType();
                String mediaType = operation.getProduces().stream().findFirst().orElse("application/json");
                content.addMediaType(mediaType, mediaTypeObject);
            }
            if (StatusCodeParser.isSuccessCode(statusCode)) {
                for (String mediaType : content.values()) {
                    Schema schema = mediaType.getSchema();
                    if (schema != null) continue;
                    mediaType.setSchema(defaultSchema);
                }
            }
        }
    }

    private void checkRequestBody(ParserContext ctx, OperationExt operation) {
        RequestBodyExt requestBody = operation.getRequestBody();
        if (requestBody != null && requestBody.getContent() == null) {
            io.swagger.v3.oas.models.media.MediaType mediaType = new io.swagger.v3.oas.models.media.MediaType();
            mediaType.setSchema(ctx.schema(requestBody.getJavaType()));
            String mediaTypeName = operation.getConsumes().stream().findFirst().orElseGet(requestBody::getContentType);
            Content content = new Content();
            content.addMediaType(mediaTypeName, mediaType);
            requestBody.setContent(content);
        }
    }

    private List<Parameter> checkParameters(ParserContext ctx, List<Parameter> parameters) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        for (Parameter parameter : parameters) {
            String javaType = ((ParameterExt)parameter).getJavaType();
            if (parameter.getSchema() == null) {
                Optional.ofNullable(ctx.schema(javaType)).ifPresent(arg_0 -> ((Parameter)parameter).setSchema(arg_0));
            }
            if (parameter.getSchema() instanceof StringSchema && this.isPassword(parameter.getName())) {
                parameter.getSchema().setFormat("password");
            }
            if (parameter.getIn().equals("query")) {
                boolean expand = ctx.schemaRef(javaType).filter(ref -> "object".equals(ref.schema.getType())).isPresent();
                if (expand) {
                    SchemaRef ref2 = ctx.schemaRef(javaType).get();
                    for (Map.Entry e : ref2.schema.getProperties().entrySet()) {
                        String name = (String)e.getKey();
                        Schema s = (Schema)e.getValue();
                        ParameterExt p = new ParameterExt();
                        p.setName(name);
                        p.setIn(parameter.getIn());
                        p.setSchema(s);
                        params.add(p);
                    }
                    continue;
                }
                params.add(parameter);
                continue;
            }
            params.add(parameter);
        }
        return params;
    }

    private boolean isPassword(String name) {
        return "password".equalsIgnoreCase(name) || "pass".equalsIgnoreCase(name);
    }

    private void uniqueOperationId(List<OperationExt> operations) {
        HashMap<String, AtomicInteger> names = new HashMap<String, AtomicInteger>();
        for (OperationExt operation : operations) {
            String operationId = this.operationId(operation);
            int c = names.computeIfAbsent(operationId, k -> new AtomicInteger()).incrementAndGet();
            if (c > 1) {
                operation.setOperationId(operationId + c);
                continue;
            }
            operation.setOperationId(operationId);
        }
    }

    private String operationId(OperationExt operation) {
        return Optional.ofNullable(operation.getOperationId()).orElseGet(() -> operation.getMethod().toLowerCase() + this.patternToOperationId(operation.getPattern()));
    }

    private String patternToOperationId(String pattern) {
        if (pattern.equals("/")) {
            return "";
        }
        return Stream.of(pattern.split("\\W+")).filter(s -> s.length() > 0).map(segment -> Character.toUpperCase(segment.charAt(0)) + (segment.length() > 1 ? segment.substring(1) : "")).collect(Collectors.joining());
    }

    private void cleanup(List<OperationExt> operations) {
        Iterator<OperationExt> it = operations.iterator();
        while (it.hasNext()) {
            OperationExt operation = it.next();
            if (operation.getHidden() == Boolean.TRUE) {
                it.remove();
                continue;
            }
            if (!operation.getParameters().isEmpty()) continue;
            operation.setParameters(null);
        }
    }

    private Schema parseSchema(ParserContext ctx, ResponseExt response) {
        List schemas;
        List<String> javaTypes = response.getJavaTypes();
        Schema schema = javaTypes.size() == 1 ? ctx.schema(javaTypes.get(0)) : (javaTypes.size() > 1 ? ((schemas = javaTypes.stream().map(ctx::schema).filter(Objects::nonNull).collect(Collectors.toList())).isEmpty() ? null : new ComposedSchema().oneOf(schemas)) : null);
        return schema;
    }

    public List<OperationExt> parse(ParserContext ctx, String prefix, ClassNode node) {
        ArrayList<OperationExt> handlerList = new ArrayList<OperationExt>();
        for (MethodNode method : node.methods) {
            handlerList.addAll(this.routeHandler(ctx, prefix, method));
        }
        return handlerList;
    }

    private List<OperationExt> metaInf(ParserContext ctx, String prefix, Predicate<String> predicate) {
        try {
            String content = new String(ctx.loadResource(this.metaInf), StandardCharsets.UTF_8);
            String[] lines = content.split("\\n");
            ArrayList<OperationExt> handlerList = new ArrayList<OperationExt>();
            for (String line : lines) {
                Type type;
                String controller = line.replace("$Module", "").trim();
                if (controller.isEmpty() || !predicate.test((type = TypeFactory.fromJavaName(controller)).getInternalName())) continue;
                handlerList.addAll(AnnotationParser.parse(ctx, prefix, type));
            }
            return handlerList;
        }
        catch (IOException ex) {
            return Collections.emptyList();
        }
    }

    private List<OperationExt> parseManuallyRegisteredControllers(ParserContext ctx) {
        ArrayList<OperationExt> handlerList = new ArrayList<OperationExt>();
        ClassNode classNode = ctx.classNode(ctx.getRouter());
        AsmUtils.findAnnotationByType(classNode.visibleAnnotations, OpenApiRegister.class).stream().map(AsmUtils::toMap).forEach(annotationMap -> {
            for (Type registeredClass : (List)annotationMap.get("value")) {
                handlerList.addAll(AnnotationParser.parse(ctx, null, registeredClass));
            }
        });
        return handlerList;
    }

    private List<OperationExt> routeHandler(ParserContext ctx, String prefix, MethodNode method) {
        ArrayList<OperationExt> handlerList = new ArrayList<OperationExt>();
        AbstractInsnNode instructionTo = null;
        int routeIndex = -1;
        for (AbstractInsnNode it : method.instructions) {
            if (!(it instanceof MethodInsnNode)) continue;
            MethodInsnNode node = (MethodInsnNode)it;
            if (!ctx.process(it)) continue;
            Signature signature = Signature.create(node);
            if (ctx.isRouter(signature.getOwner().orElse(null))) {
                String httpMethod;
                if (signature.matches("mvc")) {
                    handlerList.addAll(AnnotationParser.parse(ctx, prefix, signature, (MethodInsnNode)it));
                    continue;
                }
                if (signature.matches("<init>", TypeFactory.KT_FUN_1)) {
                    handlerList.addAll(this.kotlinHandler(ctx, null, prefix, node, false));
                    continue;
                }
                if (signature.matches(TypeFactory.KOOBY) && signature.getDescriptor() != null && Type.getReturnType(signature.getDescriptor()) == Type.VOID_TYPE) {
                    handlerList.addAll(this.kotlinHandler(ctx, null, prefix, node, true));
                    continue;
                }
                if (signature.matches("mount", Router.class)) {
                    handlerList.addAll(this.mountHandler(ctx, prefix, null, node));
                    continue;
                }
                if (signature.matches("install", String.class, SneakyThrows.Supplier.class)) {
                    String pattern = this.routePattern(node, node);
                    handlerList.addAll(this.installApp(ctx, RoutePath.path(prefix, pattern), node, node));
                    continue;
                }
                if (signature.matches("install", SneakyThrows.Supplier.class)) {
                    handlerList.addAll(this.installApp(ctx, prefix, node, node));
                    continue;
                }
                if (signature.matches("mount", String.class, Router.class)) {
                    handlerList.addAll(this.mountHandler(ctx, prefix, this.routePatternNode((MethodInsnNode)node, (AbstractInsnNode)node).cst.toString(), node));
                    continue;
                }
                if (signature.matches("path", String.class, Runnable.class) || signature.matches("routes", Runnable.class)) {
                    String path;
                    AbstractInsnNode subrouteInsn;
                    boolean routes = signature.matches("routes", Runnable.class);
                    routeIndex = handlerList.size();
                    instructionTo = node;
                    if (node.owner.equals(TypeFactory.KOOBY.getInternalName())) {
                        subrouteInsn = InsnSupport.prev(node).filter(MethodInsnNode.class::isInstance).findFirst().map(MethodInsnNode.class::cast).orElseThrow(() -> new IllegalStateException("Subroute definition not found"));
                        path = routes ? "/" : this.routePattern(node, subrouteInsn);
                        handlerList.addAll(this.kotlinHandler(ctx, null, RoutePath.path(prefix, path), (MethodInsnNode)subrouteInsn, false));
                        continue;
                    }
                    subrouteInsn = InsnSupport.prev(node).filter(InvokeDynamicInsnNode.class::isInstance).findFirst().map(InvokeDynamicInsnNode.class::cast).orElseThrow(() -> new IllegalStateException("Subroute definition not found"));
                    path = routes ? "/" : this.routePattern(node, subrouteInsn);
                    MethodNode methodLink = this.findLambda(ctx, (InvokeDynamicInsnNode)subrouteInsn);
                    ctx.debugHandlerLink(methodLink);
                    handlerList.addAll(this.routeHandler(ctx, RoutePath.path(prefix, path), methodLink));
                    continue;
                }
                if (Router.METHODS.contains(signature.getMethod().toUpperCase()) && signature.matches(String.class, Route.Handler.class)) {
                    MethodNode handler;
                    AbstractInsnNode astore;
                    VarInsnNode varInsnNode;
                    instructionTo = node;
                    AbstractInsnNode previous = node.getPrevious();
                    String path = this.routePattern(node, previous);
                    String httpMethod2 = signature.getMethod().toUpperCase();
                    if (node.owner.equals(TypeFactory.KOOBY.getInternalName())) {
                        handlerList.addAll(this.kotlinHandler(ctx, httpMethod2, RoutePath.path(prefix, path), node, false));
                        continue;
                    }
                    if (previous instanceof InvokeDynamicInsnNode) {
                        MethodNode handler2 = this.findLambda(ctx, (InvokeDynamicInsnNode)previous);
                        ctx.debugHandler(handler2);
                        handlerList.add(this.newRouteDescriptor(ctx, handler2, httpMethod2, RoutePath.path(prefix, path)));
                        continue;
                    }
                    if (previous instanceof MethodInsnNode) {
                        if (!InsnSupport.opcode(183).test(previous)) continue;
                        MethodInsnNode methodInsnNode = (MethodInsnNode)previous;
                        MethodNode handler3 = this.findRouteHandler(ctx, methodInsnNode);
                        ctx.debugHandler(handler3);
                        handlerList.add(this.newRouteDescriptor(ctx, handler3, httpMethod2, RoutePath.path(prefix, path)));
                        continue;
                    }
                    if (!(previous instanceof VarInsnNode) || (varInsnNode = (VarInsnNode)previous).getOpcode() != 25 || (astore = (AbstractInsnNode)InsnSupport.prev(varInsnNode).filter(InsnSupport.varInsn(58, varInsnNode.var)).findFirst().orElse(null)) == null) continue;
                    AbstractInsnNode varType = InsnSupport.prev(astore).filter(e -> e instanceof InvokeDynamicInsnNode || e instanceof MethodInsnNode).findFirst().orElse(null);
                    if (varType instanceof MethodInsnNode) {
                        handler = this.findRouteHandler(ctx, (MethodInsnNode)varType);
                        ctx.debugHandler(handler);
                        handlerList.add(this.newRouteDescriptor(ctx, handler, httpMethod2, RoutePath.path(prefix, path)));
                        continue;
                    }
                    if (!(varType instanceof InvokeDynamicInsnNode)) continue;
                    handler = this.findLambda(ctx, (InvokeDynamicInsnNode)varType);
                    ctx.debugHandler(handler);
                    handlerList.add(this.newRouteDescriptor(ctx, handler, httpMethod2, RoutePath.path(prefix, path)));
                    continue;
                }
                if (Router.METHODS.contains(signature.getMethod().toUpperCase()) && signature.matches(TypeFactory.STRING, TypeFactory.KT_FUN_1)) {
                    instructionTo = node;
                    String path = this.routePattern(node, node.getPrevious());
                    httpMethod = signature.getMethod().toUpperCase();
                    handlerList.addAll(this.kotlinHandler(ctx, httpMethod, RoutePath.path(prefix, path), node, false));
                    continue;
                }
                if (Router.METHODS.contains(signature.getMethod().toUpperCase()) && signature.matches(TypeFactory.STRING, TypeFactory.KT_FUN_2)) {
                    instructionTo = node;
                    String path = this.routePattern(node, node.getPrevious());
                    httpMethod = signature.getMethod().toUpperCase();
                    handlerList.addAll(this.kotlinHandler(ctx, httpMethod, RoutePath.path(prefix, path), node, false));
                    continue;
                }
                if (!signature.getMethod().startsWith("coroutine")) continue;
                handlerList.addAll(this.kotlinHandler(ctx, null, prefix, node, false));
                continue;
            }
            if (signature.matches(TypeFactory.KOOBYKT, "runApp")) {
                handlerList.addAll(this.kotlinRunApp(ctx, prefix, node, signature.matches("runApp", TypeFactory.STRING_ARRAY, TypeFactory.KT_FUN_0)));
                continue;
            }
            if (signature.matches(Route.class, "produces", MediaType[].class)) {
                if (instructionTo == null) continue;
                OperationExt route = (OperationExt)((Object)handlerList.get(handlerList.size() - 1));
                InsnSupport.prev(it, instructionTo).flatMap(RouteParser.mediaType()).forEach(route::addProduces);
                instructionTo = it;
                continue;
            }
            if (signature.matches(Route.class, "consumes", MediaType[].class)) {
                if (instructionTo == null) continue;
                OperationExt route = (OperationExt)((Object)handlerList.get(handlerList.size() - 1));
                InsnSupport.prev(it, instructionTo).flatMap(RouteParser.mediaType()).forEach(route::addConsumes);
                instructionTo = it;
                continue;
            }
            if (signature.matches(Route.class, "summary", String.class)) {
                instructionTo = this.parseText(it, instructionTo, arg_0 -> ((OperationExt)((OperationExt)((Object)handlerList.get(handlerList.size() - 1)))).setSummary(arg_0));
                continue;
            }
            if (signature.matches(Route.class, "description", String.class)) {
                instructionTo = this.parseText(it, instructionTo, arg_0 -> ((OperationExt)((OperationExt)((Object)handlerList.get(handlerList.size() - 1)))).setDescription(arg_0));
                continue;
            }
            if (signature.matches(Route.class, "tags", String[].class)) {
                instructionTo = this.parseTags(it, instructionTo, (OperationExt)((Object)handlerList.get(handlerList.size() - 1)));
                continue;
            }
            if (signature.matches(RouteSet.class, "summary", String.class)) {
                instructionTo = this.parseText(it, instructionTo, ((OperationExt)((Object)handlerList.get(handlerList.size() - 1)))::setPathSummary);
                continue;
            }
            if (signature.matches(RouteSet.class, "description", String.class)) {
                instructionTo = this.parseText(it, instructionTo, ((OperationExt)((Object)handlerList.get(handlerList.size() - 1)))::setPathDescription);
                continue;
            }
            if (!signature.matches(RouteSet.class, "tags", String[].class) || routeIndex < 0) continue;
            for (int i = routeIndex; i < handlerList.size(); ++i) {
                instructionTo = this.parseTags(it, instructionTo, (OperationExt)((Object)handlerList.get(i)));
            }
            routeIndex = -1;
        }
        return handlerList;
    }

    private List<OperationExt> mountHandler(ParserContext ctx, String prefix, String pattern, MethodInsnNode node) {
        String path;
        Handle ktAnonymousRouter = this.kotlinAnonymousRouter(node);
        String string = path = pattern == null ? prefix : RoutePath.path(prefix, pattern);
        if (ktAnonymousRouter != null) {
            return this.routeHandler(ctx, path, ctx.findMethodNode(Type.getObjectType(ktAnonymousRouter.getOwner()), ktAnonymousRouter.getName()));
        }
        AbstractInsnNode routerInstruction = this.findRouterInstruction(node);
        return this.mountRouter(ctx, path, node, routerInstruction);
    }

    private Handle kotlinAnonymousRouter(AbstractInsnNode node) {
        return InsnSupport.prev(node).filter(InvokeDynamicInsnNode.class::isInstance).map(InvokeDynamicInsnNode.class::cast).filter(it -> it.name.equals("invoke") && Type.getReturnType(it.desc).equals(TypeFactory.KT_FUN_1)).map(it -> (Handle)it.bsmArgs[1]).findFirst().orElse(null);
    }

    private AbstractInsnNode parseText(AbstractInsnNode start, AbstractInsnNode end, Consumer<String> consumer) {
        if (end != null) {
            InsnSupport.prev(start, end).filter(LdcInsnNode.class::isInstance).findFirst().map(LdcInsnNode.class::cast).map(i -> i.cst.toString()).ifPresent(consumer);
        }
        return start;
    }

    private AbstractInsnNode parseTags(AbstractInsnNode start, AbstractInsnNode end, OperationExt route) {
        if (end != null) {
            InsnSupport.prev(start, end).filter(LdcInsnNode.class::isInstance).map(LdcInsnNode.class::cast).map(i -> i.cst.toString()).forEach(arg_0 -> ((OperationExt)route).addTagsItem(arg_0));
        }
        return start;
    }

    private List<OperationExt> kotlinRunApp(ParserContext ctx, String prefix, MethodInsnNode node, boolean supplier) {
        ArrayList<OperationExt> handlerList = new ArrayList<OperationExt>();
        Type type = null;
        for (AbstractInsnNode it : InsnSupport.prev(node).toList()) {
            if (it instanceof FieldInsnNode) {
                FieldInsnNode getstatic = (FieldInsnNode)it;
                if (getstatic.getOpcode() != 178) continue;
                type = Type.getObjectType(getstatic.owner);
                break;
            }
            if (!(it instanceof InvokeDynamicInsnNode)) continue;
            InvokeDynamicInsnNode invokeDynamic = (InvokeDynamicInsnNode)it;
            Handle handle = (Handle)invokeDynamic.bsmArgs[1];
            type = Type.getObjectType(handle.getOwner());
            break;
        }
        if (type == null) {
            throw new IllegalStateException("io.jooby.runApp(String[]) parsing failure");
        }
        ClassNode classNode = ctx.classNode(type);
        if (supplier) {
            String signature = classNode.signature;
            Type mainClass = Type.getType(signature.substring(signature.lastIndexOf(60) + 1, signature.length() - 2));
            ctx.setMainClass(mainClass.getClassName());
            classNode = ctx.classNode(mainClass);
        }
        handlerList.addAll(this.parse(ctx, prefix, classNode));
        return handlerList;
    }

    private static Function<AbstractInsnNode, Stream<String>> mediaType() {
        return e -> {
            if (e instanceof FieldInsnNode) {
                if (((FieldInsnNode)e).owner.equals("io/jooby/MediaType")) {
                    return Stream.of(((FieldInsnNode)e).name);
                }
            } else if (e instanceof MethodInsnNode && ((MethodInsnNode)e).owner.equals("io/jooby/MediaType") && ((MethodInsnNode)e).name.equals("valueOf")) {
                return InsnSupport.prev(e).filter(LdcInsnNode.class::isInstance).findFirst().map(i -> ((LdcInsnNode)i).cst.toString()).stream();
            }
            return Stream.of(new String[0]);
        };
    }

    private AbstractInsnNode findRouterInstruction(AbstractInsnNode node) {
        return InsnSupport.prev(node).filter(e -> {
            if (e instanceof TypeInsnNode) {
                return e.getOpcode() != 192;
            }
            if (e instanceof LdcInsnNode) {
                return ((LdcInsnNode)e).cst instanceof Type;
            }
            return false;
        }).findFirst().orElseThrow(() -> new IllegalStateException("Unsupported router type: " + node));
    }

    private List<OperationExt> mountRouter(ParserContext ctx, String prefix, MethodInsnNode node, AbstractInsnNode routerInstruction) {
        Type router;
        if (routerInstruction instanceof TypeInsnNode) {
            router = Type.getObjectType(((TypeInsnNode)routerInstruction).desc);
        } else if (routerInstruction instanceof LdcInsnNode) {
            router = (Type)((LdcInsnNode)routerInstruction).cst;
        } else {
            throw new UnsupportedOperationException(InsnSupport.toString(node));
        }
        ClassNode classNode = ctx.classNode(router);
        return this.parse(ctx.newContext(router), prefix, classNode);
    }

    private List<OperationExt> installApp(ParserContext ctx, String prefix, MethodInsnNode node, AbstractInsnNode ins) {
        Type router;
        AbstractInsnNode previous = ins.getPrevious();
        if (previous instanceof InvokeDynamicInsnNode) {
            InvokeDynamicInsnNode idin = (InvokeDynamicInsnNode)previous;
            Handle handle = (Handle)idin.bsmArgs[1];
            router = TypeFactory.fromInternalName(handle.getOwner());
            if (!handle.getName().equals("<init>")) {
                MethodNode lambda = this.findLambda(ctx, idin);
                router = ReturnTypeParser.parse(ctx, lambda).stream().findFirst().map(TypeFactory::fromJavaName).orElseThrow(() -> new UnsupportedOperationException(InsnSupport.toString(node)));
            }
        } else if (node.owner.equals("io/jooby/kt/Kooby")) {
            router = this.kotlinSupplier(ctx, node, previous);
        } else {
            throw new UnsupportedOperationException(InsnSupport.toString(node));
        }
        ClassNode classNode = ctx.classNode(router);
        return this.parse(ctx.newContext(router), prefix, classNode);
    }

    private Type kotlinSupplier(ParserContext ctx, MethodInsnNode node, AbstractInsnNode ins) {
        FieldInsnNode frame = InsnSupport.prev(ins).filter(FieldInsnNode.class::isInstance).map(FieldInsnNode.class::cast).filter(it -> it.getOpcode() == 178).findFirst().orElse(null);
        Type type = null;
        if (frame != null) {
            ClassNode lambdaClass = ctx.classNode(TypeFactory.fromInternalName(frame.owner));
            type = this.findMethods(lambdaClass, "invoke", (method, signature) -> (method.access & 1) != 0).stream().map(it -> {
                String desc = Optional.ofNullable(it.signature).orElse(it.desc);
                return Type.getReturnType(desc);
            }).filter(it -> !it.equals(TypeFactory.OBJECT)).findFirst().orElseGet(() -> this.findMethods(lambdaClass, "tryGet", (method, signature) -> Type.getReturnType(method.desc).equals(TypeFactory.JOOBY) || Type.getReturnType(method.desc).equals(TypeFactory.KOOBY)).stream().findFirst().map(it -> ReturnTypeParser.parseIgnoreSignature(ctx, it).stream().findFirst().map(TypeFactory::fromJavaName).orElse(null)).orElseGet(() -> this.findMethods(lambdaClass, "<init>", (method, signature) -> true).stream().findFirst().map(init -> InsnSupport.next(init.instructions.getFirst()).filter(LdcInsnNode.class::isInstance).map(LdcInsnNode.class::cast).filter(it -> Type.class.isInstance(it.cst)).map(it -> (Type)it.cst).findFirst().orElse(null)).orElse(null)));
        }
        if (type == null) {
            throw new UnsupportedOperationException(InsnSupport.toString(node));
        }
        return type;
    }

    private List<MethodNode> findMethods(ClassNode clazz, String name, BiPredicate<MethodNode, Signature> predicate) {
        ArrayList<MethodNode> result = new ArrayList<MethodNode>();
        for (MethodNode method : clazz.methods) {
            Signature signature;
            if (!method.name.equals(name) || !predicate.test(method, signature = Signature.create(method))) continue;
            result.add(method);
        }
        return result;
    }

    private List<OperationExt> kotlinHandler(ParserContext ctx, String httpMethod, String prefix, MethodInsnNode node, boolean extensionMethod) {
        ArrayList<OperationExt> handlerList = new ArrayList<OperationExt>();
        List lookup = extensionMethod ? List.of(node.owner, node.name, node.desc) : InsnSupport.prev(node.getPrevious()).map(it -> {
            MethodInsnNode methodInsnNode;
            Signature signature;
            if (it instanceof InvokeDynamicInsnNode) {
                Object patt31813$temp;
                InvokeDynamicInsnNode invokeDynamic = (InvokeDynamicInsnNode)it;
                Object[] args = invokeDynamic.bsmArgs;
                if (args.length > 1 && (patt31813$temp = args[1]) instanceof Handle) {
                    Handle handle = (Handle)patt31813$temp;
                    return Arrays.asList(handle.getOwner(), handle.getName(), handle.getDesc());
                }
            }
            if (it instanceof FieldInsnNode) {
                FieldInsnNode fieldInsnNode = (FieldInsnNode)it;
                return Collections.singletonList(fieldInsnNode.owner);
            }
            if (it instanceof MethodInsnNode && !(signature = Signature.create(methodInsnNode = (MethodInsnNode)it)).matches("<init>", TypeFactory.KT_FUN_1)) {
                return Collections.singletonList(((MethodInsnNode)it).owner);
            }
            return null;
        }).filter(Objects::nonNull).findFirst().orElseThrow(() -> new IllegalStateException("Kotlin lambda not found: " + InsnSupport.toString(node)));
        ClassNode classNode = ctx.classNode(Type.getObjectType(lookup.get(0)));
        MethodNode apply = null;
        if (lookup.size() > 1) {
            boolean synthetic;
            Object method = classNode.methods.stream().filter(it -> it.name.equals(lookup.get(1)) && it.desc.equals(lookup.get(2))).findFirst().orElseThrow(() -> new IllegalStateException("Kotlin lambda not found: " + InsnSupport.toString(node)));
            ctx.debugHandlerLink((MethodNode)method);
            boolean bl = synthetic = (((MethodNode)method).access & 2) != 0;
            if (synthetic && (((MethodNode)method).name.startsWith("invoke$") || ((MethodNode)method).name.contains("$lambda"))) {
                method = this.ktFunRef160(ctx, (MethodNode)method);
            }
            if (httpMethod == null) {
                handlerList.addAll(this.routeHandler(ctx, prefix, (MethodNode)method));
            } else {
                handlerList.add(this.newRouteDescriptor(ctx, (MethodNode)method, httpMethod, prefix));
            }
        } else {
            for (MethodNode method : classNode.methods) {
                Signature signature = Signature.create(method);
                if (signature.matches("invoke", TypeFactory.KOOBY)) {
                    ctx.debugHandlerLink(method);
                    handlerList.addAll(this.routeHandler(ctx, prefix, method));
                    continue;
                }
                if (signature.matches("invoke", TypeFactory.COROUTINE_ROUTER)) {
                    ctx.debugHandlerLink(method);
                    handlerList.addAll(this.routeHandler(ctx, prefix, method));
                    continue;
                }
                if (signature.matches("invoke", TypeFactory.HANDLER_CONTEXT)) {
                    ctx.debugHandler(method);
                    handlerList.add(this.newRouteDescriptor(ctx, method, httpMethod, prefix));
                    continue;
                }
                if (signature.matches("invoke", TypeFactory.CONTEXT)) {
                    MethodNode ref = this.kotlinFunctionReference(ctx, classNode, method);
                    ctx.debugHandler(ref);
                    handlerList.add(this.newRouteDescriptor(ctx, ref, httpMethod, prefix));
                    continue;
                }
                if (signature.matches("invokeSuspend", Object.class)) {
                    ctx.debugHandler(method);
                    handlerList.add(this.newRouteDescriptor(ctx, method, httpMethod, prefix));
                    continue;
                }
                if (signature.matches("apply", TypeFactory.CONTEXT)) {
                    if (apply == null) {
                        apply = method;
                        continue;
                    }
                    if (this.returnTypePrecedence(method) <= this.returnTypePrecedence(apply)) continue;
                    apply = method;
                    continue;
                }
                if (!signature.matches("run")) continue;
                ctx.debugHandlerLink(method);
                handlerList.addAll(this.routeHandler(ctx, prefix, method));
            }
        }
        if (apply != null) {
            Signature signature = Signature.create(node);
            if (signature.matches(String.class, Route.Handler.class)) {
                apply = this.ktFunRef160(ctx, apply);
            }
            ctx.debugHandler(apply);
            handlerList.add(this.newRouteDescriptor(ctx, apply, httpMethod, prefix));
        }
        return handlerList;
    }

    private MethodNode ktFunRef160(ParserContext ctx, MethodNode method) {
        MethodNode methodRef;
        ClassNode owner;
        MethodInsnNode call = InsnSupport.prev(method.instructions.getLast()).filter(MethodInsnNode.class::isInstance).map(MethodInsnNode.class::cast).filter(it -> Signature.create(it).matches(Context.class)).findFirst().orElse(null);
        if (call != null && (owner = ctx.classNodeOrNull(Type.getObjectType(call.owner))) != null && (methodRef = (MethodNode)owner.methods.stream().filter(it -> it.name.equals(call.name) && it.desc.equals(call.desc)).findFirst().orElse(null)) != null) {
            return methodRef;
        }
        return method;
    }

    private MethodNode kotlinFunctionReference(ParserContext ctx, ClassNode classNode, MethodNode node) {
        MethodInsnNode ref = InsnSupport.prev(node.instructions.getLast()).filter(MethodInsnNode.class::isInstance).map(MethodInsnNode.class::cast).findFirst().orElseThrow(() -> new IllegalStateException("Kotlin reference function not found"));
        String refname = ref.name.equals("invoke") ? classNode.methods.stream().filter(m -> m.name.equals("getName")).findFirst().map(m -> InsnSupport.next(m.instructions.getFirst()).filter(LdcInsnNode.class::isInstance).findFirst().map(LdcInsnNode.class::cast).map(n -> n.cst.toString()).orElse(ref.name)).orElse(ref.name) : ref.name;
        MethodNode method = ctx.classNode((Type)Type.getObjectType((String)ref.owner)).methods.stream().filter(m -> m.name.equals(ref.name) && m.desc.equals(ref.desc)).findFirst().orElseThrow(() -> new IllegalStateException("Kotlin reference function not found"));
        method.name = refname;
        return method;
    }

    private OperationExt newRouteDescriptor(ParserContext ctx, MethodNode node, String httpMethod, String prefix) {
        boolean lambda;
        Optional<RequestBodyExt> requestBody = RequestParser.requestBody(ctx, node);
        List<ParameterExt> arguments = RequestParser.parameters(node, prefix);
        ResponseExt response = new ResponseExt();
        List<String> returnTypes = ReturnTypeParser.parse(ctx, node);
        response.setJavaTypes(returnTypes);
        OperationExt operation = new OperationExt(node, httpMethod, prefix, arguments, response);
        boolean notSynthetic = (node.access & 0x1000) == 0;
        boolean bl = lambda = node.name.equals("apply") || node.name.equals("invoke") || node.name.startsWith("invoke$") || node.name.contains("$lambda");
        if (notSynthetic && !lambda) {
            operation.setOperationId(node.name);
        }
        requestBody.ifPresent(arg_0 -> ((OperationExt)operation).setRequestBody(arg_0));
        return operation;
    }

    private int returnTypePrecedence(MethodNode method) {
        return Type.getReturnType(method.desc).getClassName().equals("java.lang.Object") ? 0 : 1;
    }

    private LdcInsnNode routePatternNode(MethodInsnNode methodInsnNode, AbstractInsnNode node) {
        return InsnSupport.prev(node).filter(it -> it instanceof LdcInsnNode && ((LdcInsnNode)it).cst instanceof String).findFirst().map(LdcInsnNode.class::cast).orElseThrow(() -> new IllegalStateException("Route pattern not found: " + InsnSupport.toString(methodInsnNode)));
    }

    private String routePattern(MethodInsnNode methodInsnNode, AbstractInsnNode node) {
        return this.routePatternNode((MethodInsnNode)methodInsnNode, (AbstractInsnNode)node).cst.toString();
    }

    private MethodNode findRouteHandler(ParserContext ctx, MethodInsnNode node) {
        Type owner = TypeFactory.fromInternalName(node.owner);
        return ctx.classNode((Type)owner).methods.stream().filter(m -> {
            Signature signature = new Signature(owner, "apply", m.desc);
            return Modifier.isPublic(m.access) && signature.matches(Context.class);
        }).findFirst().orElseThrow(() -> new IllegalStateException("Handler not found: " + InsnSupport.toString(node)));
    }

    private MethodNode findLambda(ParserContext ctx, InvokeDynamicInsnNode node) {
        Handle handle = (Handle)node.bsmArgs[1];
        Type owner = TypeFactory.fromInternalName(handle.getOwner());
        if (owner.equals(TypeFactory.CONTEXT)) {
            return this.contextReference(handle);
        }
        return ctx.classNode((Type)owner).methods.stream().filter(n -> n.name.equals(handle.getName()) && n.desc.equals(handle.getDesc())).findFirst().orElseThrow(() -> new IllegalStateException("Handler not found: " + InsnSupport.toString(node)));
    }

    private MethodNode contextReference(Handle handle) {
        String suffix = Long.toHexString(UUID.randomUUID().getMostSignificantBits());
        MethodNode method = new MethodNode(0, "fake$" + handle.getName() + "$" + suffix, handle.getDesc(), null, null);
        method.instructions = new InsnList();
        method.instructions.add(new MethodInsnNode(182, handle.getOwner(), handle.getName(), handle.getDesc()));
        method.instructions.add(new InsnNode(176));
        return method;
    }
}

