/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.run;

import io.jooby.run.Specs;
import java.io.IOException;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jboss.modules.ModuleFinder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.ModuleSpec;

class FlattenClasspath
implements ModuleFinder {
    private final Set<Path> resources;
    private final String name;

    FlattenClasspath(String name, Set<Path> resources, Set<Path> dependencies) {
        this.name = name;
        this.resources = new LinkedHashSet<Path>(resources.size() + dependencies.size());
        this.resources.addAll(resources);
        this.resources.add(FlattenClasspath.joobyRunHook(this.getClass()));
        this.resources.addAll(dependencies);
    }

    static Path joobyRunHook(Class loader) {
        try {
            URL serverRef = loader.getResource("/" + "io.jooby.run.ServerRef".replace(".", "/") + ".class");
            JarURLConnection connection = (JarURLConnection)serverRef.openConnection();
            return Paths.get(connection.getJarFileURL().toURI());
        }
        catch (IOException | URISyntaxException x) {
            throw new IllegalStateException("jooby-run.jar not found", x);
        }
    }

    public ModuleSpec findModule(String name, ModuleLoader delegateLoader) throws ModuleLoadException {
        if (this.name.equals(name)) {
            return Specs.spec(name, this.resources, Collections.emptySet());
        }
        return null;
    }
}

