/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.run;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Set;
import java.util.jar.JarFile;
import org.jboss.modules.DependencySpec;
import org.jboss.modules.ModuleDependencySpecBuilder;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleSpec;
import org.jboss.modules.PathUtils;
import org.jboss.modules.ResourceLoader;
import org.jboss.modules.ResourceLoaderSpec;
import org.jboss.modules.ResourceLoaders;
import org.jboss.modules.filter.PathFilters;

final class Specs {
    private Specs() {
    }

    static DependencySpec metaInf(String moduleName) {
        return new ModuleDependencySpecBuilder().setImportFilter(PathFilters.acceptAll()).setExportFilter(PathFilters.getMetaInfServicesFilter()).setName(moduleName).setOptional(false).build();
    }

    public static ModuleSpec spec(String name, Set<Path> resources, Set<String> dependencies) throws ModuleLoadException {
        try {
            ModuleSpec.Builder builder = ModuleSpec.build((String)name);
            for (Path path : resources) {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createPathResourceLoader((Path)path)));
                    continue;
                }
                builder.addResourceRoot(ResourceLoaderSpec.createResourceLoaderSpec((ResourceLoader)ResourceLoaders.createJarResourceLoader((JarFile)new JarFile(path.toFile()))));
            }
            builder.addDependency(DependencySpec.createLocalDependencySpec());
            builder.addDependency(DependencySpec.createSystemDependencySpec((Set)PathUtils.getPathSet(null)));
            for (String dependency : dependencies) {
                builder.addDependency(Specs.metaInf(dependency));
            }
            return builder.create();
        }
        catch (IOException x) {
            throw new ModuleLoadException(name, (Throwable)x);
        }
    }
}

