/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.Body;
import io.jooby.CompletionListeners;
import io.jooby.Context;
import io.jooby.Cookie;
import io.jooby.DefaultContext;
import io.jooby.FileDownload;
import io.jooby.FileUpload;
import io.jooby.FlashMap;
import io.jooby.Formdata;
import io.jooby.MediaType;
import io.jooby.MessageDecoder;
import io.jooby.MockResponse;
import io.jooby.MockRouter;
import io.jooby.MockSession;
import io.jooby.Multipart;
import io.jooby.QueryString;
import io.jooby.Reified;
import io.jooby.Route;
import io.jooby.Router;
import io.jooby.Sender;
import io.jooby.ServerSentEmitter;
import io.jooby.Session;
import io.jooby.StatusCode;
import io.jooby.Value;
import io.jooby.ValueNode;
import io.jooby.WebSocket;
import io.jooby.exception.TypeMismatchException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockContext
implements DefaultContext {
    private String method = "GET";
    private Route route;
    private String requestPath = "/";
    private Map<String, String> pathMap = new HashMap<String, String>();
    private String queryString;
    private Map<String, Collection<String>> headers = new HashMap<String, Collection<String>>();
    private Formdata formdata = Formdata.create((Context)this);
    private Multipart multipart = Multipart.create((Context)this);
    private Body body;
    private Object bodyObject;
    private Map<String, MessageDecoder> decoders = new HashMap<String, MessageDecoder>();
    private Map<String, Object> responseHeaders = new HashMap<String, Object>();
    private Map<String, Object> attributes = new HashMap<String, Object>();
    private MockResponse response = new MockResponse();
    private Map<String, String> cookies = new LinkedHashMap<String, String>();
    private FlashMap flashMap = FlashMap.create((Context)this, (Cookie)new Cookie("jooby.sid").setHttpOnly(true));
    private Session session;
    private Router router;
    private Map<String, List<FileUpload>> files = new LinkedHashMap<String, List<FileUpload>>();
    private boolean responseStarted;
    private boolean resetHeadersOnError = true;
    private CompletionListeners listeners = new CompletionListeners();
    private Consumer<MockResponse> consumer;
    private MockRouter mockRouter;
    private String remoteAddress = "0.0.0.0";
    private String host;
    private String scheme = "http";
    private int port = -1;

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    @Nonnull
    public Context setPort(int port) {
        this.port = port;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    @Nonnull
    public MockContext setMethod(@Nonnull String method) {
        this.method = method.toUpperCase();
        return this;
    }

    @Nonnull
    public Session session() {
        if (this.session == null) {
            this.session = new MockSession(this);
        }
        return this.session;
    }

    @Nonnull
    public MockContext setSession(@Nonnull MockSession session) {
        this.session = session;
        return this;
    }

    @Nullable
    public Session sessionOrNull() {
        return this.session;
    }

    @Nonnull
    public Map<String, String> cookieMap() {
        return this.cookies;
    }

    @Nonnull
    public Context forward(@Nonnull String path) {
        this.setRequestPath(path);
        if (this.mockRouter != null) {
            this.mockRouter.call(this.getMethod(), path, this, this.consumer);
        }
        return this;
    }

    @Nonnull
    public MockContext setCookieMap(@Nonnull Map<String, String> cookies) {
        this.cookies = cookies;
        return this;
    }

    @Nonnull
    public FlashMap flash() {
        return this.flashMap;
    }

    public MockContext setFlashMap(@Nonnull FlashMap flashMap) {
        this.flashMap = flashMap;
        return this;
    }

    @Nonnull
    public MockContext setFlashAttribute(@Nonnull String name, @Nonnull String value) {
        this.flashMap.put((Object)name, (Object)value);
        return this;
    }

    @Nonnull
    public Route getRoute() {
        return this.route;
    }

    @Nonnull
    public MockContext setRoute(@Nonnull Route route) {
        this.route = route;
        return this;
    }

    @Nonnull
    public String getRequestPath() {
        return this.requestPath;
    }

    @Nonnull
    public MockContext setRequestPath(@Nonnull String pathString) {
        int q = pathString.indexOf("?");
        this.requestPath = q > 0 ? pathString.substring(0, q) : pathString;
        return this;
    }

    @Nonnull
    public Map<String, String> pathMap() {
        return this.pathMap;
    }

    @Nonnull
    public MockContext setPathMap(@Nonnull Map<String, String> pathMap) {
        this.pathMap = pathMap;
        return this;
    }

    @Nonnull
    public QueryString query() {
        return QueryString.create((Context)this, (String)this.queryString);
    }

    @Nonnull
    public String queryString() {
        return this.queryString;
    }

    @Nonnull
    public MockContext setQueryString(@Nonnull String queryString) {
        this.queryString = queryString;
        return this;
    }

    @Nonnull
    public ValueNode header() {
        return Value.headers((Context)this, this.headers);
    }

    @Nonnull
    public MockContext setHeaders(@Nonnull Map<String, Collection<String>> headers) {
        this.headers = headers;
        return this;
    }

    @Nonnull
    public MockContext setRequestHeader(@Nonnull String name, @Nonnull String value) {
        Collection values = this.headers.computeIfAbsent(name, k -> new ArrayList());
        values.add(value);
        return this;
    }

    @Nonnull
    public Formdata form() {
        return this.formdata;
    }

    @Nonnull
    public MockContext setForm(@Nonnull Formdata formdata) {
        this.formdata = formdata;
        return this;
    }

    @Nonnull
    public Multipart multipart() {
        return this.multipart;
    }

    @Nonnull
    public List<FileUpload> files() {
        return this.files.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public MockContext setFile(@Nonnull String name, @Nonnull FileUpload file) {
        this.files.computeIfAbsent(name, k -> new ArrayList()).add(file);
        return this;
    }

    @Nonnull
    public List<FileUpload> files(@Nonnull String name) {
        return this.files.entrySet().stream().filter(it -> ((String)it.getKey()).equals(name)).flatMap(it -> ((List)it.getValue()).stream()).collect(Collectors.toList());
    }

    @Nonnull
    public FileUpload file(@Nonnull String name) {
        return this.files.entrySet().stream().filter(it -> ((String)it.getKey()).equals(name)).findFirst().map(it -> (FileUpload)((List)it.getValue()).get(0)).orElseThrow(() -> new TypeMismatchException(name, FileUpload.class));
    }

    @Nonnull
    public MockContext setMultipart(@Nonnull Multipart multipart) {
        this.multipart = multipart;
        return this;
    }

    @Nonnull
    public Body body() {
        if (this.body == null) {
            throw new IllegalStateException("No body was set, use setBody() to set one.");
        }
        return this.body;
    }

    @Nonnull
    public <T> T body(@Nonnull Class<T> type) {
        return this.decode(type, MediaType.text);
    }

    @Nonnull
    public <T> T body(@Nonnull Type type) {
        return this.decode(type, MediaType.text);
    }

    @Nonnull
    public <T> T decode(@Nonnull Type type, @Nonnull MediaType contentType) {
        if (this.bodyObject == null) {
            throw new IllegalStateException("No body was set, use setBodyObject() to set one.");
        }
        Reified reified = Reified.get((Type)type);
        if (!reified.getRawType().isInstance(this.bodyObject)) {
            throw new TypeMismatchException("body", type);
        }
        return (T)this.bodyObject;
    }

    @Nonnull
    public MockContext setBody(@Nonnull Body body) {
        this.body = body;
        return this;
    }

    @Nonnull
    public MockContext setBodyObject(@Nonnull Object body) {
        this.bodyObject = body;
        return this;
    }

    @Nonnull
    public MockContext setBody(@Nonnull String body) {
        byte[] bytes = body.getBytes(StandardCharsets.UTF_8);
        return this.setBody(bytes);
    }

    @Nonnull
    public MockContext setBody(@Nonnull byte[] body) {
        this.setBody(Body.of((Context)this, (InputStream)new ByteArrayInputStream(body), (long)body.length));
        return this;
    }

    @Nonnull
    public MessageDecoder decoder(@Nonnull MediaType contentType) {
        return this.decoders.getOrDefault(contentType, MessageDecoder.UNSUPPORTED_MEDIA_TYPE);
    }

    public boolean isInIoThread() {
        return false;
    }

    @Nonnull
    public MockContext dispatch(@Nonnull Runnable action) {
        action.run();
        return this;
    }

    @Nonnull
    public MockContext dispatch(@Nonnull Executor executor, @Nonnull Runnable action) {
        action.run();
        return this;
    }

    @Nonnull
    public MockContext detach(@Nonnull Route.Handler next) throws Exception {
        next.apply((Context)this);
        return this;
    }

    @Nonnull
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Nonnull
    public MockContext removeResponseHeader(@Nonnull String name) {
        this.responseHeaders.remove(name);
        return this;
    }

    @Nullable
    public String getResponseHeader(@Nonnull String name) {
        Object value = this.responseHeaders.get(name);
        return value == null ? null : value.toString();
    }

    @Nonnull
    public MockContext setResponseHeader(@Nonnull String name, @Nonnull String value) {
        this.responseHeaders.put(name, value);
        return this;
    }

    @Nonnull
    public MockContext setResponseLength(long length) {
        this.response.setContentLength(length);
        return this;
    }

    public long getResponseLength() {
        return this.response.getContentLength();
    }

    @Nonnull
    public MockContext setResponseType(@Nonnull String contentType) {
        this.response.setContentType(MediaType.valueOf((String)contentType));
        return this;
    }

    @Nonnull
    public MockContext setResponseType(@Nonnull MediaType contentType, @Nullable Charset charset) {
        this.response.setContentType(contentType);
        return this;
    }

    @Nonnull
    public MockContext setResponseCode(int statusCode) {
        this.response.setStatusCode(StatusCode.valueOf((int)statusCode));
        return this;
    }

    @Nonnull
    public StatusCode getResponseCode() {
        return this.response.getStatusCode();
    }

    @Nonnull
    public MockContext render(@Nonnull Object result) {
        this.responseStarted = true;
        this.response.setResult(result);
        return this;
    }

    @Nonnull
    public MockResponse getResponse() {
        this.responseStarted = true;
        this.response.setHeaders(this.responseHeaders);
        return this.response;
    }

    @Nonnull
    public OutputStream responseStream() {
        this.responseStarted = true;
        ByteArrayOutputStream out = new ByteArrayOutputStream(16384);
        this.response.setResult(out);
        return out;
    }

    @Nonnull
    public Sender responseSender() {
        this.responseStarted = true;
        return new Sender(){

            public Sender write(@Nonnull byte[] data, @Nonnull Sender.Callback callback) {
                MockContext.this.response.setResult(data);
                callback.onComplete((Context)MockContext.this, null);
                return this;
            }

            public void close() {
                MockContext.this.listeners.run((Context)MockContext.this);
            }
        };
    }

    @Nonnull
    public String getHost() {
        return this.host;
    }

    @Nonnull
    public Context setHost(@Nonnull String host) {
        this.host = host;
        return this;
    }

    @Nonnull
    public String getRemoteAddress() {
        return this.remoteAddress;
    }

    @Nonnull
    public Context setRemoteAddress(@Nonnull String remoteAddress) {
        this.remoteAddress = remoteAddress;
        return this;
    }

    @Nonnull
    public String getProtocol() {
        return "HTTP/1.1";
    }

    @Nonnull
    public List<Certificate> getClientCertificates() {
        return new ArrayList<Certificate>();
    }

    @Nonnull
    public String getScheme() {
        return this.scheme;
    }

    @Nonnull
    public Context setScheme(@Nonnull String scheme) {
        this.scheme = scheme;
        return this;
    }

    @Nonnull
    public PrintWriter responseWriter(MediaType type, Charset charset) {
        this.responseStarted = true;
        PrintWriter writer = new PrintWriter(new StringWriter());
        this.response.setResult(writer).setContentType(type);
        return writer;
    }

    @Nonnull
    public MockContext send(@Nonnull String data, @Nonnull Charset charset) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(data.length());
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public MockContext send(@Nonnull byte[] data) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(data.length);
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public MockContext send(byte[] ... data) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(IntStream.range(0, data.length).map(i -> data[i].length).sum());
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public MockContext send(@Nonnull ByteBuffer data) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(data.remaining());
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull ByteBuffer[] data) {
        this.responseStarted = true;
        this.response.setResult(data).setContentLength(IntStream.range(0, data.length).map(i -> data[i].remaining()).sum());
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public MockContext send(InputStream input) {
        this.responseStarted = true;
        this.response.setResult(input);
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull FileDownload file) {
        this.responseStarted = true;
        this.response.setResult(file);
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public Context send(@Nonnull Path file) {
        this.responseStarted = true;
        this.response.setResult(file);
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public MockContext send(@Nonnull ReadableByteChannel channel) {
        this.responseStarted = true;
        this.response.setResult(channel);
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public MockContext send(@Nonnull FileChannel file) {
        this.responseStarted = true;
        this.response.setResult(file);
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public MockContext send(StatusCode statusCode) {
        this.responseStarted = true;
        this.response.setContentLength(0L).setStatusCode(statusCode);
        return this;
    }

    @Nonnull
    public MockContext sendError(@Nonnull Throwable cause) {
        return this.sendError(cause, this.router.errorCode(cause));
    }

    @Nonnull
    public MockContext sendError(@Nonnull Throwable cause, @Nonnull StatusCode code) {
        this.responseStarted = true;
        this.response.setResult(cause).setStatusCode(this.router.errorCode(cause));
        this.listeners.run((Context)this);
        return this;
    }

    @Nonnull
    public MockContext setDefaultResponseType(@Nonnull MediaType contentType) {
        this.response.setContentType(contentType);
        return this;
    }

    @Nonnull
    public MockContext setResponseCookie(@Nonnull Cookie cookie) {
        String setCookie = (String)this.response.getHeaders().get("Set-Cookie");
        setCookie = setCookie == null ? cookie.toCookieString() : setCookie + ";" + cookie.toCookieString();
        this.response.setHeader("Set-Cookie", setCookie);
        return this;
    }

    @Nonnull
    public MediaType getResponseType() {
        return this.response.getContentType();
    }

    @Nonnull
    public MockContext setResponseCode(@Nonnull StatusCode statusCode) {
        this.response.setStatusCode(statusCode);
        return this;
    }

    public boolean isResponseStarted() {
        return this.responseStarted;
    }

    public boolean getResetHeadersOnError() {
        return this.resetHeadersOnError;
    }

    public MockContext setResetHeadersOnError(boolean resetHeadersOnError) {
        this.resetHeadersOnError = resetHeadersOnError;
        return this;
    }

    @Nonnull
    public Context removeResponseHeaders() {
        this.responseHeaders.clear();
        return this;
    }

    @Nonnull
    public Router getRouter() {
        return this.router;
    }

    @Nonnull
    public MockContext setRouter(@Nonnull Router router) {
        this.router = router;
        return this;
    }

    @Nonnull
    public <T> T convert(@Nonnull ValueNode value, @Nonnull Class<T> type) {
        return (T)super.convert(value, type);
    }

    @Nonnull
    public MockContext upgrade(@Nonnull WebSocket.Initializer handler) {
        return this;
    }

    @Nonnull
    public Context upgrade(@Nonnull ServerSentEmitter.Handler handler) {
        return this;
    }

    @Nonnull
    public Context onComplete(@Nonnull Route.Complete task) {
        this.listeners.addListener(task);
        return this;
    }

    public String toString() {
        return this.method + " " + this.requestPath;
    }

    void setConsumer(Consumer<MockResponse> consumer) {
        this.consumer = consumer;
    }

    void setMockRouter(MockRouter mockRouter) {
        this.mockRouter = mockRouter;
    }
}

