/*
 * Decompiled with CFR 0.152.
 */
package io.jooby;

import io.jooby.MockWebSocketConfigurer;
import io.jooby.SneakyThrows;
import io.jooby.WebSocketCloseStatus;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class MockWebSocketClient {
    private MockWebSocketConfigurer configurer;
    private boolean open = true;
    private SneakyThrows.Consumer<Object> onMessageCallback;
    private SneakyThrows.Consumer2<Integer, String> onCloseCallback;
    private List<Runnable> actions = new ArrayList<Runnable>();
    private boolean initialized;

    MockWebSocketClient(MockWebSocketConfigurer configurer) {
        this.configurer = configurer;
    }

    public boolean isOpen() {
        return this.open;
    }

    public MockWebSocketClient send(@Nonnull Object message) {
        if (!this.isOpen()) {
            throw new IllegalStateException("Attempt to send a message on closed web socket");
        }
        this.configurer.fireOnMessage(message);
        return this;
    }

    public MockWebSocketClient close() {
        return this.close(1000);
    }

    public MockWebSocketClient close(int code) {
        return this.close(code, null);
    }

    public MockWebSocketClient close(int code, @Nullable String reason) {
        if (this.isOpen()) {
            this.open = false;
            if (this.initialized) {
                this.configurer.fireClose(WebSocketCloseStatus.valueOf((int)code).orElseGet(() -> new WebSocketCloseStatus(code, reason)));
            } else {
                this.actions.add(() -> this.close(code, reason));
            }
        }
        return this;
    }

    public MockWebSocketClient onMessage(SneakyThrows.Consumer<Object> callback) {
        this.onMessageCallback = callback;
        return this;
    }

    void fireMessage(Object message) {
        if (this.initialized) {
            if (this.onMessageCallback != null) {
                this.onMessageCallback.accept(message);
            }
        } else {
            this.actions.add(() -> this.fireMessage(message));
        }
    }

    void fireClose(WebSocketCloseStatus closeStatus) {
        this.open = false;
        if (this.initialized) {
            if (this.onCloseCallback != null) {
                this.onCloseCallback.accept((Object)closeStatus.getCode(), (Object)closeStatus.getReason());
            }
        } else {
            this.actions.add(() -> this.fireClose(closeStatus));
        }
    }

    void init() {
        this.initialized = true;
        for (Runnable action : this.actions) {
            action.run();
        }
        this.actions.clear();
        this.actions = null;
    }
}

