/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.undertow;

import io.undertow.protocols.alpn.ALPNProvider;
import javax.net.ssl.SSLEngine;
import org.conscrypt.Conscrypt;

public class ConscriptAlpnProvider
implements ALPNProvider {
    public boolean isEnabled(SSLEngine sslEngine) {
        return sslEngine.getClass().getName().startsWith("org.conscrypt.");
    }

    public SSLEngine setProtocols(SSLEngine engine, String[] protocols) {
        Impl.setProtocols(engine, protocols);
        return engine;
    }

    public String getSelectedProtocol(SSLEngine engine) {
        return Impl.getSelectedProtocol(engine);
    }

    public int getPriority() {
        return 400;
    }

    private static class Impl {
        private Impl() {
        }

        static SSLEngine setProtocols(SSLEngine engine, String[] protocols) {
            Conscrypt.setApplicationProtocols((SSLEngine)engine, (String[])protocols);
            return engine;
        }

        static String getSelectedProtocol(SSLEngine engine) {
            return Conscrypt.getApplicationProtocol((SSLEngine)engine);
        }
    }
}

