/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import io.jooby.FileUpload;
import io.jooby.SneakyThrows;
import io.undertow.server.handlers.form.FormData;
import io.undertow.util.Headers;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import javax.annotation.Nonnull;

public class UtowFileUpload
implements FileUpload {
    private final FormData.FormValue upload;
    private final String name;

    public UtowFileUpload(String name, FormData.FormValue upload) {
        this.name = name;
        this.upload = upload;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] bytes() {
        try (InputStream in = this.stream();){
            int nRead;
            ByteArrayOutputStream buffer = new ByteArrayOutputStream(16384);
            byte[] data = new byte[16384];
            while ((nRead = in.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            byte[] byArray = buffer.toByteArray();
            return byArray;
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public InputStream stream() {
        try {
            return this.upload.getFileItem().getInputStream();
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public String getFileName() {
        return this.upload.getFileName();
    }

    public String getContentType() {
        return this.upload.getHeaders().getFirst(Headers.CONTENT_TYPE);
    }

    public Path path() {
        return this.upload.getFileItem().getFile();
    }

    public long getFileSize() {
        try {
            return this.upload.getFileItem().getFileSize();
        }
        catch (IOException x) {
            return -1L;
        }
    }

    public void destroy() {
        try {
            this.upload.getFileItem().delete();
        }
        catch (IOException x) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    public String toString() {
        return this.getFileName();
    }
}

