/*
 * Decompiled with CFR 0.152.
 */
package io.jooby.internal.utow;

import com.typesafe.config.Config;
import io.jooby.Context;
import io.jooby.Server;
import io.jooby.SneakyThrows;
import io.jooby.WebSocket;
import io.jooby.WebSocketCloseStatus;
import io.jooby.WebSocketConfigurer;
import io.jooby.WebSocketMessage;
import io.jooby.internal.utow.UtowContext;
import io.undertow.websockets.core.AbstractReceiveListener;
import io.undertow.websockets.core.BufferedBinaryMessage;
import io.undertow.websockets.core.BufferedTextMessage;
import io.undertow.websockets.core.CloseMessage;
import io.undertow.websockets.core.WebSocketCallback;
import io.undertow.websockets.core.WebSocketChannel;
import io.undertow.websockets.core.WebSockets;
import java.io.Closeable;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nonnull;
import org.xnio.ChannelListener;
import org.xnio.IoUtils;
import org.xnio.Pooled;

public class UtowWebSocket
extends AbstractReceiveListener
implements WebSocketConfigurer,
WebSocket,
WebSocketCallback<Void> {
    private static final ConcurrentMap<String, List<WebSocket>> all = new ConcurrentHashMap<String, List<WebSocket>>();
    private final UtowContext ctx;
    private final WebSocketChannel channel;
    private final boolean dispatch;
    private WebSocket.OnConnect onConnectCallback;
    private WebSocket.OnMessage onMessageCallback;
    private AtomicReference<WebSocket.OnClose> onCloseCallback = new AtomicReference();
    private WebSocket.OnError onErrorCallback;
    private String key;
    private CountDownLatch ready = new CountDownLatch(1);
    private AtomicBoolean open = new AtomicBoolean(false);
    private int maxSize;

    public UtowWebSocket(UtowContext ctx, WebSocketChannel channel) {
        this.ctx = ctx;
        this.channel = channel;
        this.dispatch = !ctx.isInIoThread();
        this.key = ctx.getRoute().getPattern();
        Config conf = ctx.getRouter().getConfig();
        this.maxSize = conf.hasPath("websocket.maxSize") ? conf.getBytes("websocket.maxSize").intValue() : 131072;
    }

    protected long getMaxTextBufferSize() {
        return this.maxSize;
    }

    protected long getMaxBinaryBufferSize() {
        return this.maxSize;
    }

    @Nonnull
    public Context getContext() {
        return Context.readOnly((Context)this.ctx);
    }

    @Nonnull
    public List<WebSocket> getSessions() {
        List sessions = (List)all.get(this.key);
        if (sessions == null) {
            return Collections.emptyList();
        }
        ArrayList<WebSocket> result = new ArrayList<WebSocket>(sessions);
        result.remove((Object)this);
        return result;
    }

    public boolean isOpen() {
        return this.open.get() && this.channel.isOpen();
    }

    @Nonnull
    public WebSocket send(@Nonnull String message, boolean broadcast) {
        return this.send(message.getBytes(StandardCharsets.UTF_8), broadcast);
    }

    @Nonnull
    public WebSocket send(@Nonnull byte[] message, boolean broadcast) {
        if (broadcast) {
            for (WebSocket ws : all.getOrDefault(this.key, Collections.emptyList())) {
                ws.send(message, false);
            }
        } else if (this.isOpen()) {
            try {
                WebSockets.sendText((ByteBuffer)ByteBuffer.wrap(message), (WebSocketChannel)this.channel, (WebSocketCallback)this);
            }
            catch (Throwable x) {
                this.onError(this.channel, x);
            }
        } else {
            this.onError(this.channel, new IllegalStateException("Attempt to send a message on closed web socket"));
        }
        return this;
    }

    @Nonnull
    public WebSocket render(@Nonnull Object value, boolean broadcast) {
        if (broadcast) {
            for (WebSocket ws : all.getOrDefault(this.key, Collections.emptyList())) {
                ws.render(value, false);
            }
        } else {
            try {
                Context.websocket((Context)this.ctx, (WebSocket)this).render(value);
            }
            catch (Throwable x) {
                this.onError(this.channel, x);
            }
        }
        return this;
    }

    @Nonnull
    public WebSocket close(@Nonnull WebSocketCloseStatus closeStatus) {
        this.handleClose(closeStatus);
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onConnect(@Nonnull WebSocket.OnConnect callback) {
        this.onConnectCallback = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onMessage(@Nonnull WebSocket.OnMessage callback) {
        this.onMessageCallback = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onError(@Nonnull WebSocket.OnError callback) {
        this.onErrorCallback = callback;
        return this;
    }

    @Nonnull
    public WebSocketConfigurer onClose(@Nonnull WebSocket.OnClose callback) {
        this.onCloseCallback.set(callback);
        return this;
    }

    void fireConnect() {
        try {
            long timeout;
            this.open.set(true);
            this.addSession(this);
            Config conf = this.ctx.getRouter().getConfig();
            long l = timeout = conf.hasPath("websocket.idleTimeout") ? conf.getDuration("websocket.idleTimeout", TimeUnit.MILLISECONDS) : TimeUnit.MINUTES.toMillis(5L);
            if (timeout > 0L) {
                this.channel.setIdleTimeout(timeout);
            }
            if (this.onConnectCallback != null) {
                this.dispatch(this.webSocketTask(() -> this.onConnectCallback.onConnect((WebSocket)this), true));
            } else {
                this.ready.countDown();
            }
            this.channel.getReceiveSetter().set((ChannelListener)this);
            this.channel.resumeReceives();
        }
        catch (Throwable x) {
            this.onError(this.channel, x);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onFullBinaryMessage(WebSocketChannel channel, BufferedBinaryMessage message) throws IOException {
        this.waitForConnect();
        if (this.onMessageCallback != null) {
            Pooled data = message.getData();
            try {
                ByteBuffer buffer = WebSockets.mergeBuffers((ByteBuffer[])((ByteBuffer[])data.getResource()));
                this.dispatch(this.webSocketTask(() -> this.onMessageCallback.onMessage((WebSocket)this, WebSocketMessage.create((Context)this.getContext(), (byte[])this.toArray(buffer))), false));
            }
            finally {
                data.free();
            }
        }
    }

    private byte[] toArray(ByteBuffer buffer) {
        if (buffer.hasArray()) {
            return buffer.array();
        }
        byte[] bytes = new byte[buffer.remaining()];
        buffer.get(bytes);
        return bytes;
    }

    protected void onFullTextMessage(WebSocketChannel channel, BufferedTextMessage message) throws IOException {
        this.waitForConnect();
        if (this.onMessageCallback != null) {
            this.dispatch(this.webSocketTask(() -> this.onMessageCallback.onMessage((WebSocket)this, WebSocketMessage.create((Context)this.getContext(), (String)message.getData())), false));
        }
    }

    private void waitForConnect() {
        try {
            this.ready.await();
        }
        catch (InterruptedException x) {
            Thread.currentThread().interrupt();
        }
    }

    private void dispatch(Runnable runnable) {
        if (this.dispatch) {
            this.ctx.getRouter().getWorker().execute(runnable);
        } else {
            runnable.run();
        }
    }

    protected void onError(WebSocketChannel channel, Throwable x) {
        if ((Server.connectionLost((Throwable)x) || SneakyThrows.isFatal((Throwable)x)) && this.isOpen()) {
            this.handleClose(WebSocketCloseStatus.SERVER_ERROR);
        }
        if (this.onErrorCallback == null) {
            if (Server.connectionLost((Throwable)x)) {
                this.ctx.getRouter().getLog().debug("Websocket connection lost: {}", (Object)this.ctx.getRequestPath(), (Object)x);
            } else {
                this.ctx.getRouter().getLog().error("Websocket resulted in exception: {}", (Object)this.ctx.getRequestPath(), (Object)x);
            }
        } else {
            this.onErrorCallback.onError((WebSocket)this, x);
        }
        if (SneakyThrows.isFatal((Throwable)x)) {
            throw SneakyThrows.propagate((Throwable)x);
        }
    }

    protected void onCloseMessage(CloseMessage cm, WebSocketChannel channel) {
        if (this.isOpen()) {
            this.handleClose(WebSocketCloseStatus.valueOf((int)cm.getCode()).orElseGet(() -> new WebSocketCloseStatus(cm.getCode(), cm.getReason())));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleClose(WebSocketCloseStatus status) {
        WebSocket.OnClose callback = this.onCloseCallback.getAndSet(null);
        if (this.isOpen()) {
            this.open.set(false);
            WebSockets.sendClose((int)status.getCode(), (String)status.getReason(), (WebSocketChannel)this.channel, (WebSocketCallback)new WebSocketCallback<UtowWebSocket>(){

                public void onError(WebSocketChannel channel, UtowWebSocket ws, Throwable throwable) {
                    IoUtils.safeClose((Closeable)channel);
                    ws.onError(channel, throwable);
                }

                public void complete(WebSocketChannel channel, UtowWebSocket ws) {
                    IoUtils.safeClose((Closeable)channel);
                }
            }, (Object)((Object)this));
        }
        try {
            if (callback != null) {
                callback.onClose((WebSocket)this, status);
            }
        }
        catch (Throwable x) {
            this.onError(this.channel, x);
        }
        finally {
            this.removeSession(this);
        }
    }

    private void addSession(UtowWebSocket ws) {
        all.computeIfAbsent(ws.key, k -> new CopyOnWriteArrayList()).add(ws);
    }

    private void removeSession(UtowWebSocket ws) {
        List sockets = (List)all.get(ws.key);
        if (sockets != null) {
            sockets.remove((Object)ws);
        }
    }

    public void complete(WebSocketChannel channel, Void context) {
    }

    public void onError(WebSocketChannel channel, Void context, Throwable throwable) {
        this.ctx.getRouter().getLog().error("WebSocket.send resulted in exception", throwable);
    }

    private Runnable webSocketTask(Runnable runnable, boolean isInit) {
        return () -> {
            try {
                runnable.run();
            }
            catch (Throwable x) {
                this.onError(null, x);
            }
            finally {
                if (isInit) {
                    this.ready.countDown();
                }
            }
        };
    }
}

